/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Property_Function;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class Setter
extends Property_Function {
    private static final String SETTERCANNOTHAVERETURN = "Property setter's statement block cannot have a return statement";
    private final boolean shortForm;
    private Assignment_Statement assignment;
    private StatementBlock statementBlock;
    private FormalParameterList formalParameterList;

    public Setter(boolean isFinal, boolean isDeterministic, Assignment_Statement assignment) {
        super(false, isFinal, isDeterministic);
        this.shortForm = true;
        this.assignment = assignment;
        this.formalParameterList = null;
    }

    public Setter(boolean isFinal, boolean isDeterministic, StatementBlock statementBlock) {
        super(false, isFinal, isDeterministic);
        this.shortForm = false;
        this.statementBlock = statementBlock;
        this.formalParameterList = null;
    }

    public Setter(boolean isDeterministic) {
        super(true, false, isDeterministic);
        this.shortForm = false;
        this.statementBlock = null;
        this.formalParameterList = null;
    }

    @Override
    public boolean accept(ASTVisitor v) {
        if (this.formalParameterList != null && !this.formalParameterList.accept(v)) {
            return false;
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    public FormalParameter getFormalParameter() {
        if (this.formalParameterList == null) {
            // empty if block
        }
        return this.formalParameterList.getParameterByIndex(0);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Definition definition) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        super.check(timestamp, definition);
        Identifier identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, "value");
        identifier.setLocation(NULL_Location.INSTANCE);
        FormalParameter fp = new FormalParameter(TemplateRestriction.Restriction_type.TR_NONE, Assignment.Assignment_type.A_PAR_VAL_IN, (Type)definition.getType(timestamp), identifier, null, null);
        fp.setLocation(NULL_Location.INSTANCE);
        fp.setMyScope(this);
        ArrayList<FormalParameter> fplist = new ArrayList<FormalParameter>();
        fplist.add(fp);
        this.formalParameterList = new FormalParameterList(fplist);
        this.formalParameterList.setMyScope(this);
        fp.check(timestamp);
        if (!this.isAbstract) {
            if (this.shortForm) {
                this.assignment.setMyScope(this);
                this.assignment.check(timestamp);
            } else {
                this.statementBlock.setParentScope(this);
                this.statementBlock.check(timestamp);
                if (this.statementBlock.hasReturn(timestamp) != StatementBlock.ReturnStatus_type.RS_NO) {
                    this.statementBlock.getLocation().reportSemanticError(SETTERCANNOTHAVERETURN);
                }
            }
        }
    }

    @Override
    public boolean isInSetterScope() {
        return true;
    }

    @Override
    public Setter getScopeSetter() {
        return this;
    }
}

