/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.IndexedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Indexed_Template_List
extends TTCN3Template {
    private final IndexedTemplates indexedTemplates;
    private SequenceOf_Value asValue = null;

    public Indexed_Template_List(IndexedTemplates indexedTemplates) {
        this.indexedTemplates = indexedTemplates;
        indexedTemplates.setFullNameParent(this);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.INDEXED_TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous indexed assignment notation";
        }
        return "indexed assignment notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            IndexedTemplate indexedTemplate = this.indexedTemplates.getTemplateByIndex(i);
            builder.append(" [").append(indexedTemplate.getIndex().getValue().createStringRepresentation());
            builder.append("] := ");
            builder.append(indexedTemplate.getTemplate().createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
            if (template != child) continue;
            Value index = template.getIndex().getValue();
            return builder.append("[").append(index.createStringRepresentation()).append("]");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.indexedTemplates != null) {
            this.indexedTemplates.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.indexedTemplates.getTemplateByIndex(i).setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    public int getNofTemplates() {
        if (this.indexedTemplates == null) {
            return 0;
        }
        return this.indexedTemplates.getNofTemplates();
    }

    public IndexedTemplate getIndexedTemplateByIndex(int index) {
        return this.indexedTemplates.getTemplateByIndex(index);
    }

    @Override
    protected ITTCN3Template getReferencedArrayTemplate(CompilationTimeStamp timestamp, IValue arrayIndex, IReferenceChain referenceChain, boolean silent) {
        IValue indexValue = arrayIndex.setLoweridToReference(timestamp);
        if ((indexValue = indexValue.getValueRefdLast(timestamp, referenceChain)).getIsErroneous(timestamp)) {
            return null;
        }
        long index = 0L;
        if (!indexValue.isUnfoldable(timestamp)) {
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                if (!silent) {
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                }
                return null;
            }
        } else {
            return null;
        }
        index = ((Integer_Value)indexValue).getValue();
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (index >= 0L) break;
                if (!silent) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `sequence of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                }
                return null;
            }
            case TYPE_SET_OF: {
                if (index >= 0L) break;
                if (!silent) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `set of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                }
                return null;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)tempType).getDimension();
                dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (!dimension.getIsErroneous(timestamp)) {
                    if ((index -= dimension.getOffset()) >= 0L && index <= (long)this.getNofTemplates()) break;
                    if (!silent) {
                        arrayIndex.getLocation().reportSemanticError(MessageFormat.format("The index value {0} is outside the array indexable range", index + dimension.getOffset()));
                    }
                    return null;
                }
                return null;
            }
            default: {
                if (!silent) {
                    arrayIndex.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' cannot be indexed", tempType.getTypename()));
                }
                return null;
            }
        }
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            long tempIndex;
            IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
            IValue lastValue = template.getIndex().getValue();
            ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            lastValue = lastValue.getValueRefdLast(timestamp, chain);
            chain.release();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)lastValue.getValuetype()) || index != (tempIndex = ((Integer_Value)lastValue).getValue())) continue;
            TTCN3Template realTemplate = template.getTemplate();
            if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)realTemplate.getTemplatetype())) {
                if (this.baseTemplate != null) {
                    return this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain).getReferencedArrayTemplate(timestamp, indexValue, referenceChain, silent);
                }
                return null;
            }
            return realTemplate;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: {
                break;
            }
        }
        return null;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.indexedTemplates.getTemplateByIndex(i).getTemplate().isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        Values values = new Values(true);
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IndexedTemplate indexedTemplate = this.indexedTemplates.getTemplateByIndex(i);
            IndexedValue indexedValue = new IndexedValue(indexedTemplate.getIndex(), indexedTemplate.getTemplate().getValue());
            indexedValue.setLocation(indexedTemplate.getLocation());
            values.addIndexedValue(indexedValue);
        }
        this.asValue = new SequenceOf_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        this.asValue.setMyGovernor(this.getMyGovernor());
        return this.asValue;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.indexedTemplates.getTemplateByIndex(i).getTemplate().checkExpressionSelfReferenceTemplate(timestamp, lhs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template temp = this.indexedTemplates.getTemplateByIndex(i).getTemplate();
            if (temp == null) continue;
            temp.checkSpecificValue(timestamp, true);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.indexedTemplates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.getTemplate().checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.indexedTemplates.getTemplateByIndex(i).getTemplate().checkValueomitRestriction(timestamp, definitionName, true, usageLocation);
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.indexedTemplates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.indexedTemplates != null) {
            this.indexedTemplates.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return !(this.asValue != null ? !this.asValue.accept(v) : this.indexedTemplates != null && !this.indexedTemplates.accept(v));
    }

    @Override
    public void setGenNamePrefix(String prefix) {
        super.setGenNamePrefix(prefix);
        for (int i = 0; i < this.indexedTemplates.getNofTemplates(); ++i) {
            this.indexedTemplates.getTemplateByIndex(i).getTemplate().setGenNamePrefix(prefix);
        }
    }

    @Override
    public boolean needsTemporaryReference() {
        if (this.lengthRestriction != null || this.isIfpresent) {
            return true;
        }
        for (int i = 0; i < this.indexedTemplates.getNofTemplates(); ++i) {
            TTCN3Template template = this.indexedTemplates.getTemplateByIndex(i).getTemplate();
            if (template.getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_NOTUSED) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        return this.indexedTemplates.getNofTemplates() == 0;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        if (this.indexedTemplates.getNofTemplates() != 0) {
            ErrorReporter.INTERNAL_ERROR((String)("INTERNAL ERROR: Can not generate single expression for indexed template list `" + this.getFullName() + "''"));
            return new StringBuilder("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
        }
        aData.addBuiltinTypeImport("TitanNull_Type");
        if (this.myGovernor == null) {
            return new StringBuilder("TitanNull_Type.NULL_VALUE");
        }
        StringBuilder result = new StringBuilder();
        String genName = this.myGovernor.getGenNameTemplate(aData, result);
        result.append(MessageFormat.format("new {0}(TitanNull_Type.NULL_VALUE)", genName));
        return result;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        if (this.lengthRestriction == null && !this.isIfpresent && templateRestriction == TemplateRestriction.Restriction_type.TR_NONE && this.hasSingleExpression()) {
            expression.expression.append((CharSequence)this.getSingleExpression(aData, true));
            return;
        }
        if (this.asValue != null) {
            this.asValue.generateCodeExpression(aData, expression, true);
            return;
        }
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        String tempId = aData.getTemporaryVariableName();
        String genName = governor.getGenNameTemplate(aData, expression.expression);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", genName, tempId));
        this.setGenNameRecursive(genName);
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.asValue != null) {
            this.asValue.reArrangeInitCode(aData, source, usageModule);
            return;
        }
        for (int i = 0; i < this.indexedTemplates.getNofTemplates(); ++i) {
            this.indexedTemplates.getTemplateByIndex(i).getTemplate().reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        String ofTypeName;
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.asValue != null) {
            this.asValue.generateCodeInit(aData, source, name);
            return;
        }
        if (this.myGovernor == null) {
            return;
        }
        IType type = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        switch (type.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                ofTypeName = ((SequenceOf_Type)type).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_SET_OF: {
                ofTypeName = ((SetOf_Type)type).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_ARRAY: {
                ofTypeName = ((Array_Type)type).getElementType().getGenNameTemplate(aData, source);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing indexed template `" + this.getFullName() + "''"));
                return;
            }
        }
        if (this.indexedTemplates.getNofTemplates() == 0) {
            aData.addBuiltinTypeImport("TitanNull_Type");
            source.append(MessageFormat.format("{0}.operator_assign(TitanNull_Type.NULL_VALUE);\n", name));
        }
        for (int i = 0; i < this.indexedTemplates.getNofTemplates(); ++i) {
            IndexedTemplate indexedTemplate = this.indexedTemplates.getTemplateByIndex(i);
            String tempId = aData.getTemporaryVariableName();
            source.append("{\n");
            Value index = indexedTemplate.getIndex().getValue();
            if (IValue.Value_type.INTEGER_VALUE.equals((Object)index.getValuetype())) {
                source.append(MessageFormat.format("final {0} {1} = {2}.get_at({3});\n", ofTypeName, tempId, name, ((Integer_Value)index).getValue()));
            } else {
                String tempId2 = aData.getTemporaryVariableName();
                source.append(MessageFormat.format("final TitanInteger {0} = new TitanInteger();\n", tempId2));
                index.generateCodeInit(aData, source, tempId2);
                source.append(MessageFormat.format("final {0} {1} = {2}.get_at({3});\n", ofTypeName, tempId, name, tempId2));
            }
            indexedTemplate.getTemplate().generateCodeInit(aData, source, tempId);
            source.append("}\n");
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        for (int i = 0; i < this.indexedTemplates.getNofTemplates(); ++i) {
            this.indexedTemplates.getTemplateByIndex(i).getTemplate().setMyDefinition(definition);
        }
    }
}

