/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class CompField
extends ASTNode
implements IOutlineElement,
ILocateableNode,
IAppendableSyntax,
IIncrementallyUpdateable,
IReferencingElement {
    private static final String FULLNAMEPART = ".<defaultValue>";
    private Identifier name;
    private final Type type;
    private final boolean optional;
    private final Value defaultValue;
    private Location commentLocation = null;
    private Location location;

    public CompField(Identifier name, Type type, boolean optional, Value defaultValue) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.defaultValue = defaultValue;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_COMP_FIELD, this);
            type.setFullNameParent(this);
        }
        if (defaultValue != null) {
            defaultValue.setFullNameParent(this);
        }
        this.location = NULL_Location.INSTANCE;
    }

    public CompField newInstance() {
        return new CompField(this.name, this.type, this.optional, this.defaultValue);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        builder.append(".").append(this.name.getDisplayName());
        if (child == this.defaultValue) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public Object[] getOutlineChildren() {
        if (this.type == null) {
            return new Object[0];
        }
        return this.type.getOutlineChildren();
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.name.getDisplayName());
        text.append(" : ");
        text.append(this.type.getTypename());
        return text.toString();
    }

    @Override
    public String getOutlineIcon() {
        if (this.type != null) {
            return this.type.getOutlineIcon();
        }
        return "titan.gif";
    }

    @Override
    public int category() {
        if (this.type == null) {
            return 0;
        }
        return this.type.category();
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean hasDefault() {
        return this.defaultValue != null;
    }

    public Value getDefault() {
        return this.defaultValue;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.defaultValue != null) {
            this.defaultValue.setMyScope(scope);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.type == null) {
            return;
        }
        this.type.check(timestamp);
        this.type.checkEmbedded(timestamp, this.type.getLocation(), true, "embedded into another type");
        if (this.defaultValue == null) {
            return;
        }
        this.defaultValue.setMyGovernor(this.type);
        IType lastType = this.type.getTypeRefdLast(timestamp);
        IValue tempValue = lastType.checkThisValueRef(timestamp, this.defaultValue);
        lastType.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, false));
        this.defaultValue.setGenNameRecursive(this.type.getGenNameOwn() + "_defval_");
        this.defaultValue.setCodeSection(GovernedSimple.CodeSectionType.CS_PRE_INIT);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.optional) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(114);
        result.add(297);
        result.add(88);
        result.add(295);
        return result;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        return new ArrayList<Integer>(0);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            Location tempIdentifier;
            boolean enveloped = false;
            if (this.name != null && (reparser.envelopsDamage(tempIdentifier = this.name.getLocation()) || reparser.isExtending(tempIdentifier))) {
                reparser.extendDamagedRegion(tempIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parse();
                this.name = r.getIdentifier();
                if (result == 0) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.defaultValue != null) {
                if (enveloped) {
                    this.defaultValue.updateSyntax(reparser, false);
                    reparser.updateLocation(this.defaultValue.getLocation());
                } else if (reparser.envelopsDamage(this.defaultValue.getLocation())) {
                    this.defaultValue.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.defaultValue.getLocation());
                }
            }
            if (enveloped) {
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.name.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.defaultValue != null) {
            this.defaultValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.defaultValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.defaultValue != null) {
            this.defaultValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.defaultValue == null || this.defaultValue.accept(v);
    }

    @Override
    public Declaration getDeclaration() {
        INamedNode inamedNode = this.getNameParent();
        while (!(inamedNode instanceof Definition)) {
            if (inamedNode == null) {
                return null;
            }
            inamedNode = inamedNode.getNameParent();
        }
        Definition namedTemplList = (Definition)inamedNode;
        IType tempType = namedTemplList.getType(CompilationTimeStamp.getBaseTimestamp());
        if (tempType == null) {
            return null;
        }
        if ((tempType = tempType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) instanceof ITypeWithComponents) {
            Identifier resultId = ((ITypeWithComponents)((Object)tempType)).getComponentIdentifierByName(this.getIdentifier());
            return Declaration.createInstance(tempType.getDefiningAssignment(), resultId);
        }
        return null;
    }
}

