/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetTypeMessages;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawASTStruct;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.OmitValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.RecordSetCodeGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TTCN3_Set_Type
extends TTCN3_Set_Seq_Choice_BaseType
implements ISetTypeMessages {
    private static String strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);

    public TTCN3_Set_Type(CompFieldMap compFieldMap) {
        super(compFieldMap);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_TTCN3_SET;
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_SET;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SET: {
                ASN1_Set_Type tempType = (ASN1_Set_Type)temp;
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr("The number of fields in set/SET types must be the same");
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCfName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr("The optionality of fields in set/SET types must be the same");
                        return false;
                    }
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Type tempType = (TTCN3_Set_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.getNofComponents() != tempType.getNofComponents()) {
                    info.setErrorStr("The number of fields in set/SET types must be the same");
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    if (cf.isOptional() != tempTypeCf.isOptional()) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCompFieldName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName);
                        info.appendOp2Ref("." + tempTypeCompFieldName);
                        info.setOp1Type(cfType);
                        info.setOp2Type(tempTypeCfType);
                        info.setErrorStr("The optionality of fields in set/SET types must be the same");
                        return false;
                    }
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeCfType);
                    if (!(cfType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        String cfName = cf.getIdentifier().getDisplayName();
                        String tempTypeCfName = tempTypeCf.getIdentifier().getDisplayName();
                        info.appendOp1Ref("." + cfName + infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCfName + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SET_OF: {
                SetOf_Type tempType = (SetOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible set of/SET OF subtypes");
                    return false;
                }
                int nofComps = this.getNofComponents();
                if (nofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < nofComps; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(cfType, tempTypeOfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(cfType);
                    rChain.add(tempTypeOfType);
                    if (cfType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain)) continue;
                    info.appendOp1Ref("." + cf.getIdentifier().getDisplayName() + infoTemp.getOp1RefStr());
                    if (infoTemp.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr("union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types");
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                info.setErrorStr("set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types");
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "set.gif";
    }

    @Override
    public void checkConstructorName(String definitionName) {
        if (this.hasComponentWithName(definitionName)) {
            CompField field = this.getComponentByName(definitionName);
            field.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Sorry, but it is not supported for set types to have a field with a name (`{0}'') which exactly matches the name of the type definition.", field.getIdentifier().getDisplayName()));
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.getNofComponents();
            for (int i = 0; i < size; ++i) {
                CompField field = this.getComponentByIndex(i);
                Type type = field.getType();
                if (field.isOptional() || type == null) continue;
                referenceChain.markState();
                type.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                if (last.isAsn()) {
                    selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSet_T(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem, valueCheckingOptions.from_subtype, false);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (((SequenceOf_Value)last).isIndexed()) {
                    value.getLocation().reportSemanticError(MessageFormat.format("Indexed assignment notation cannot be used for set type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                SequenceOf_Value tempValue = (SequenceOf_Value)last;
                if (tempValue.getNofComponents() == 0) {
                    if (this.compFieldMap != null && this.compFieldMap.getComponentFieldMap(timestamp).isEmpty()) {
                        last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                        break;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format("A non-empty value was expected for type `{0}''", this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? "Value list notation cannot be used for SET type `{0}''" : "Value list notation cannot be used for set type `{0}''", this.getFullName()));
                value.setIsErroneous(true);
                break;
            }
            case SET_VALUE: {
                if (last.isAsn()) {
                    selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                    break;
                }
                selfReference = this.checkThisValueSet_T(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem, valueCheckingOptions.from_subtype, false);
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.SET_VALUE);
                selfReference = this.checkThisValueSet_A(timestamp, (Set_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(last.isAsn() ? "SET value was expected for type `{0}''" : "set value was expected for type `{0}''", this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSet_T(CompilationTimeStamp timestamp, Set_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem, boolean fromSubtype, boolean isValueListNotation) {
        value.removeGeneratedValues();
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        boolean localIncompleteAllowed = incompleteAllowed || fromSubtype && !isValueListNotation;
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!realComponents.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in set value for type `{1}''", namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Duplicated set field `{0}''", valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format("Field `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = realComponents.get(valueId.getName());
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            if (IValue.Value_type.NOTUSED_VALUE.equals((Object)componentValue.getValuetype())) {
                if (localIncompleteAllowed) continue;
                componentValue.getLocation().reportSemanticError("Not used symbol `-' is not allowed in this context");
                continue;
            }
            IValue tempValue = type.checkThisValueRef(timestamp, componentValue);
            selfReference |= type.checkThisValue(timestamp, tempValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, componentField.isOptional(), true, implicitOmit, strElem, fromSubtype));
        }
        if (!localIncompleteAllowed || implicitOmit || !"ignore".equals(strictConstantCheckingSeverity)) {
            int nofTypeComponents = realComponents.size();
            for (int i = 0; i < nofTypeComponents; ++i) {
                CompField field = this.compFieldMap.fields.get(i);
                Identifier id = field.getIdentifier();
                if (componentMap.containsKey(id.getName())) continue;
                if (field.isOptional() && implicitOmit) {
                    value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_TTCN, id.getDisplayName()), new Omit_Value(), false));
                    continue;
                }
                if (localIncompleteAllowed && "ignore".equals(strictConstantCheckingSeverity)) continue;
                value.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format("Field `{0}'' is missing from set value", id.getDisplayName()));
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueSet_A(CompilationTimeStamp timestamp, Set_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        HashMap<String, NamedValue> componentMap = new HashMap<String, NamedValue>();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        value.removeGeneratedValues();
        int nofValueComponents = value.getNofComponents();
        for (int i = 0; i < nofValueComponents; ++i) {
            NamedValue namedValue = value.getSequenceValueByIndex(i);
            Identifier valueId = namedValue.getName();
            if (!realComponents.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent component `{0}'' of SET type `{1}''", namedValue.getName().getDisplayName(), this.getTypename()));
                continue;
            }
            if (componentMap.containsKey(valueId.getName())) {
                namedValue.getLocation().reportSemanticError(MessageFormat.format("Duplicated SET component `{0}''", valueId.getDisplayName()));
                ((NamedValue)componentMap.get(valueId.getName())).getLocation().reportSingularSemanticError(MessageFormat.format("Component `{0}'' is already given here", valueId.getDisplayName()));
            } else {
                componentMap.put(valueId.getName(), namedValue);
            }
            CompField componentField = realComponents.get(valueId.getName());
            Type type = componentField.getType();
            IValue componentValue = namedValue.getValue();
            if (componentValue == null) continue;
            componentValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, componentValue);
            selfReference |= type.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(expectedValue, false, false, true, implicitOmit, strElem));
        }
        int nofTypeComponents = realComponents.size();
        for (int i = 0; i < nofTypeComponents; ++i) {
            CompField field = this.getComponentByIndex(i);
            Identifier id = field.getIdentifier();
            if (componentMap.containsKey(id.getName())) continue;
            if (field.isOptional() && implicitOmit) {
                value.addNamedValue(new NamedValue(new Identifier(Identifier.Identifier_type.ID_ASN, id.getDisplayName()), new Omit_Value(), false));
                continue;
            }
            if (field.isOptional() || field.hasDefault()) continue;
            value.getLocation().reportSemanticError(MessageFormat.format("Mandatory component `{0}'' is missing from SET value", id.getDisplayName()));
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case TEMPLATE_LIST: {
                if (((Template_List)template).getNofTemplates() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format("Value list notation is not allowed for set type `{0}''", this.getFullName()));
                    break;
                }
                if (this.getNofComponents() > 0) {
                    template.getLocation().reportSemanticError(MessageFormat.format("A non-empty set template was expected for type `{0}''", this.getFullName()));
                    break;
                }
                ITTCN3Template transformed = template.setTemplatetype(timestamp, ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST);
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)transformed, isModified, implicitOmit, lhs);
                break;
            }
            case NAMED_TEMPLATE_LIST: {
                selfReference = this.checkThisNamedTemplateList(timestamp, (Named_Template_List)template, isModified, implicitOmit, lhs);
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for set type `{1}''", template.getTemplateTypeName()));
            }
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError("Length restriction is not allowed for set type `{0}''");
        }
        return selfReference;
    }

    private boolean checkThisNamedTemplateList(CompilationTimeStamp timestamp, Named_Template_List templateList, boolean isModified, boolean implicitOmit, Assignment lhs) {
        int i;
        templateList.removeGeneratedValues();
        boolean selfReference = false;
        HashMap<String, NamedTemplate> componentMap = new HashMap<String, NamedTemplate>();
        int nofTypeComponents = this.getNofComponents();
        int nofTemplateComponents = templateList.getNofTemplates();
        Map<String, CompField> realComponents = this.compFieldMap.getComponentFieldMap(timestamp);
        for (i = 0; i < nofTemplateComponents; ++i) {
            NamedTemplate namedTemplate = templateList.getTemplateByIndex(i);
            Identifier identifier = namedTemplate.getName();
            String templateName = identifier.getName();
            if (realComponents.containsKey(templateName)) {
                if (componentMap.containsKey(templateName)) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format("Duplicate field `{0}'' in template", identifier.getDisplayName()));
                    ((NamedTemplate)componentMap.get(templateName)).getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' is already given here", identifier.getDisplayName()));
                } else {
                    componentMap.put(templateName, namedTemplate);
                }
                CompField componentField = this.getComponentByName(identifier.getName());
                Type type = componentField.getType();
                ITTCN3Template componentTemplate = namedTemplate.getTemplate();
                componentTemplate.setMyGovernor(type);
                componentTemplate = type.checkThisTemplateRef(timestamp, componentTemplate);
                boolean isOptional = componentField.isOptional();
                selfReference |= componentTemplate.checkThisTemplateGeneric(timestamp, type, isModified, isOptional, isOptional, true, implicitOmit, lhs);
                continue;
            }
            namedTemplate.getLocation().reportSemanticError(MessageFormat.format("Reference to non-existing field `{0}'' in set template for type `{1}''", identifier.getDisplayName(), this.getTypename()));
        }
        if (!(isModified || !implicitOmit && "ignore".equals(strictConstantCheckingSeverity))) {
            for (i = 0; i < nofTypeComponents; ++i) {
                Identifier identifier = this.getComponentIdentifierByIndex(i);
                if (componentMap.containsKey(identifier.getName())) continue;
                if (this.getComponentByIndex(i).isOptional() && implicitOmit) {
                    templateList.addNamedValue(new NamedTemplate(new Identifier(Identifier.Identifier_type.ID_TTCN, identifier.getDisplayName()), new OmitValue_Template(), false));
                    continue;
                }
                templateList.getLocation().reportConfigurableSemanticProblem(strictConstantCheckingSeverity, MessageFormat.format("Field `{0}'' is missing from template for set type `{1}''", identifier.getDisplayName(), this.getTypename()));
            }
        }
        return selfReference;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkSetSeqRawCodingAttributes(timestamp);
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            cf.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void forceRaw(CompilationTimeStamp timestamp) {
        if (this.rawAttribute == null) {
            this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
        }
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        if (this.rawLengthCalculated != null && !this.rawLengthCalculated.isLess(timestamp)) {
            return this.rawLength;
        }
        this.rawLengthCalculated = timestamp;
        this.rawLength = 0;
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            if (cf.isOptional()) {
                this.rawLength = -1;
                return this.rawLength;
            }
            Type t = cf.getType();
            int l = t.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getRawLength(timestamp);
            if (l == -1) {
                this.rawLength = -1;
                return this.rawLength;
            }
            if (t.rawAttribute != null && (t.rawAttribute.pointerto != null || t.rawAttribute.lengthto != null)) {
                this.rawLength = -1;
                return this.rawLength;
            }
            this.rawLength += l;
        }
        return this.rawLength;
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        this.checkSetSeqJson(timestamp);
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("set");
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "SET_ber_";
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String className = this.getGenNameOwn();
        String classReadableName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        HashMap<String, String> attributeRegistry = new HashMap<String, String>();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        ArrayList<RecordSetCodeGenerator.FieldInfo> namesList = new ArrayList<RecordSetCodeGenerator.FieldInfo>();
        boolean hasOptional = false;
        for (CompField compField : this.compFieldMap.fields) {
            boolean ofType;
            Type cfType = compField.getType();
            IType lastType = cfType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            switch (lastType.getTypetype()) {
                case TYPE_SET_OF: 
                case TYPE_SEQUENCE_OF: {
                    ofType = true;
                    break;
                }
                default: {
                    ofType = false;
                }
            }
            switch (cfType.getTypetype()) {
                case TYPE_TTCN3_SET: 
                case TYPE_SET_OF: 
                case TYPE_TTCN3_CHOICE: 
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_SEQUENCE_OF: 
                case TYPE_ARRAY: 
                case TYPE_TTCN3_ENUMERATED: {
                    if (cfType.generatesOwnClass(aData, source)) break;
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    break;
                }
                default: {
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                }
            }
            JsonAST jsonAttribute = cfType.getJsonAttribute();
            List<RawASTStruct.rawAST_coding_taglist> jsonChosen = this.convertJsonCodingAttributes(jsonAttribute, aData, source, lastType);
            RecordSetCodeGenerator.FieldInfo fi = new RecordSetCodeGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), compField.isOptional(), ofType, cfType.getClass().getSimpleName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAttribute != null ? jsonAttribute.metainfo_unbound : false, jsonAttribute != null ? jsonAttribute.parsed_default_value : null, jsonChosen, jsonAttribute != null ? jsonAttribute.alias : null, jsonAttribute != null ? jsonAttribute.omit_as_null : false);
            hasOptional |= compField.isOptional();
            namesList.add(fi);
        }
        for (CompField compField : this.compFieldMap.fields) {
            StringBuilder tempSource = aData.getCodeForType(compField.getType().getGenNameOwn());
            compField.getType().generateCode(aData, tempSource);
        }
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        RawASTStruct raw = this.convertRAWCodingAttributes(aData, source, hasRaw, namesList);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean jsonAsMapPossible = this.jsonAttribute != null ? this.jsonAttribute.as_map : false;
        RecordSetCodeGenerator.generateValueClass(aData, source, className, classReadableName, namesList, hasOptional, true, hasRaw, raw, hasJson, jsonAsValue, jsonAsMapPossible, localTypeDescriptor, localCodingHandler);
        RecordSetCodeGenerator.generateTemplateClass(aData, source, className, classReadableName, namesList, hasOptional, true);
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        if (beginIndex >= subreferences.size()) {
            return true;
        }
        ISubReference subReference = subreferences.get(beginIndex);
        if (!(subReference instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return true;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId.getName());
        if (compField.isOptional()) {
            return false;
        }
        return compField.getType().isPresentAnyvalueEmbeddedField(expression, subreferences, beginIndex + 1);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Seq_Choice_BaseType realFromType = (TTCN3_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionTTCNSetSeqToTTCNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_ASN1_SET: {
                ASN1_Set_Seq_Choice_BaseType realFromType = (ASN1_Set_Seq_Choice_BaseType)refdType;
                return this.generateConversionASNSetSeqToTTCNSetSeq(aData, realFromType, fromName, forValue, expression);
            }
        }
        expression.expression.append(MessageFormat.format("//FIXME conversion from {0} to {1} is not needed or nor supported yet\n", fromType.getTypename(), this.getTypename()));
        return fromName;
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("org.eclipse.titan.designer.reportStrictConstants".equals(property)) {
                        strictConstantCheckingSeverity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportStrictConstants", "warning", null);
                    }
                }
            });
        }
    }
}

