/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandler;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandlerComponent;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.ReferenceCollector;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.ReferencesProcessor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class AssignmentHandlerAFTRerences
extends ReferencesProcessor {
    public AssignmentHandlerAFTRerences(Assignment assignment) {
        super(assignment);
    }

    @Override
    public void check(AssignmentHandler assignmentHandler) {
        if (assignmentHandler instanceof AssignmentHandlerComponent) {
            this.checkIsInfected((AssignmentHandlerComponent)assignmentHandler);
        } else {
            this.checkIsInfected(assignmentHandler);
        }
        this.checkIsContagious(assignmentHandler);
    }

    private Set<String> computeIsInfected(Set<String> otherInfectedReferences) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> intersectionWithNonContagiousReferences = new HashSet<String>(this.getNonContagiousReferences());
        intersectionWithNonContagiousReferences.retainAll(otherInfectedReferences);
        HashSet<String> intersectionWithContagiousReferences = new HashSet<String>(this.getContagiousReferences());
        intersectionWithContagiousReferences.retainAll(otherInfectedReferences);
        result.addAll(intersectionWithNonContagiousReferences);
        result.addAll(intersectionWithContagiousReferences);
        return result;
    }

    public void checkIsInfected(AssignmentHandlerComponent other) {
        if (!other.getIsInfected()) {
            return;
        }
        String otherName = other.getAssignment().getIdentifier().getDisplayName();
        if (other.getAssignment().getLastTimeChecked() == null && this.isContagiousReferencesContains(otherName)) {
            this.setIsInfected(true);
            this.addInfectedReference(otherName);
            return;
        }
        Set<String> infectedReferences = this.computeIsInfected(other.getInfectedReferences());
        if (!infectedReferences.isEmpty() || this.isContagiousReferencesContains(otherName)) {
            this.setIsInfected(true);
            this.addReason("It uses " + otherName + "@" + other.getAssignment().getMyScope().getModuleScope().getIdentifier().getDisplayName() + " which is infected.");
        }
    }

    @Override
    public int visit(IVisitableNode node) {
        ASN1Assignment assignment;
        if (node instanceof ASN1Assignment && (assignment = (ASN1Assignment)node).getAssPard() != null) {
            return 1;
        }
        if (node instanceof StatementBlock) {
            ReferenceCollector referenceCollector = new ReferenceCollector();
            node.accept(referenceCollector);
            Set<Reference> references = referenceCollector.getReferences();
            this.addNonContagiousReferences(this.computeReferences(references));
            if (this.containsErroneousReference(references)) {
                this.setIsInfected(true);
            }
            return 1;
        }
        if (node instanceof Reference) {
            Identifier identifier = ((Reference)node).getId();
            if (identifier != null) {
                this.addContagiousReference(identifier.getDisplayName());
            }
            if (((Reference)node).getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                this.setIsInfected(true);
                this.setIsContagious(true);
                return 3;
            }
            Assignment assignment2 = ((Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
            if (assignment2 == null || assignment2.getIdentifier() == null || !assignment2.getIdentifier().equals(identifier)) {
                this.setIsInfected(true);
                this.setIsContagious(true);
                return 3;
            }
        }
        return 3;
    }
}

