/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer;

public final class DebugUtils {
    public static String getStackTrace(int depth) {
        int i;
        if (depth < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder("(");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int n = i = depth + 1 > stackTrace.length - 1 ? stackTrace.length - 1 : depth + 1;
        while (i > 1) {
            String[] classPath = stackTrace[i].getClassName().split("\\.");
            if (classPath.length > 0) {
                builder.append(classPath[classPath.length - 1]).append(':');
            }
            builder.append(stackTrace[i].getMethodName());
            if (i > 2) {
                builder.append(" -> ");
            }
            --i;
        }
        builder.append(')');
        return builder.toString();
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }
}

