/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.OutputAnalyzer;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.license.License;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.ui.progress.IProgressConstants;

public class TITANJob
extends WorkspaceJob {
    protected static final String ERROR = "error";
    protected static final String FAILED = " ...failed";
    protected static final String CHECK_PERMISSION = "When trying to execute the `{0}'' shell command an error occured.\nPossible reasons are:\n- the command does not exist\n- you have no right to execute the command\n- the error occured during executing the command\nand many more.\nPlease check the TITAN console to identify the problem.";
    protected static final String ERRORS_FOUND = "The execution of the `{0}'' command reported the following errors:\n{1}";
    protected static final String TTCN3_LICENSE_FILE_KEY = "TTCN3_LICENSE_FILE";
    protected static final String TTCN3_DIR_KEY = "TTCN3_DIR";
    protected static final String LD_LIBRARY_PATH_KEY = "LD_LIBRARY_PATH";
    protected static final String LIBRARY_SUB_DIR = "/lib";
    protected static final String SUCCESS = "Operation finished successfully.";
    protected static final String FAILURE = "Operation failed with return value: ";
    protected static final String SPACE = " ";
    protected static final String EMPTY_STRING = "";
    protected static final String CYGWIN = "No cygwin installation found.\nPlease make sure that cygwin is installed properly.";
    private final Map<String, IFile> files = new HashMap<String, IFile>();
    private final File workingDir;
    private final IProject project;
    private boolean removeCompilerMarkers = false;
    private boolean removeOnTheFlyMarkers = false;
    private final ConcurrentLinkedQueue<List<String>> commands;
    private final ConcurrentLinkedQueue<String> descriptions;
    private boolean foundErrors = false;
    private static boolean reportedNoCygwin = false;

    public TITANJob(String name, Map<String, IFile> files, File workingDir, IProject project) {
        super(name);
        this.files.putAll(files);
        this.workingDir = workingDir;
        this.project = project;
        this.commands = new ConcurrentLinkedQueue();
        this.descriptions = new ConcurrentLinkedQueue();
        this.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
    }

    public final void removeCompilerMarkers() {
        this.removeCompilerMarkers = true;
    }

    public final void removeOnTheFlyMarkers() {
        this.removeOnTheFlyMarkers = true;
    }

    public final void addCommand(List<String> command, String description) {
        if (command == null || description == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Wrong parameters to a TITANJob: `" + command + "', `" + description + "'"));
            return;
        }
        this.commands.add(command);
        this.descriptions.add(description);
    }

    protected void setEnvironmentalVariables(ProcessBuilder pb) {
        Map<String, String> env = pb.environment();
        String ttcn3Dir = CompilerVersionInformationCollector.getResolvedInstallationPath(false);
        if (License.isLicenseNeeded()) {
            env.put(TTCN3_LICENSE_FILE_KEY, LicenseValidator.getResolvedLicenseFilePath(false));
        }
        env.put(TTCN3_DIR_KEY, ttcn3Dir);
        String temp = env.get(LD_LIBRARY_PATH_KEY);
        if (temp == null) {
            env.put(LD_LIBRARY_PATH_KEY, ttcn3Dir + LIBRARY_SUB_DIR);
        } else {
            env.put(LD_LIBRARY_PATH_KEY, temp + ":" + ttcn3Dir + LIBRARY_SUB_DIR);
        }
    }

    protected List<String> getFinalCommand(List<String> actualCommand) {
        StringBuilder tempCommand = new StringBuilder();
        for (String c : actualCommand) {
            tempCommand.append(c).append(SPACE);
        }
        ArrayList<String> finalCommand = new ArrayList<String>();
        finalCommand.add("sh");
        finalCommand.add("-c");
        finalCommand.add(tempCommand.toString());
        return finalCommand;
    }

    public final boolean foundErrors() {
        return this.foundErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStatus runInWorkspace(IProgressMonitor monitor) {
        IProgressMonitor internalMonitor;
        Object object = internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        if (this.commands == null || this.descriptions == null || this.commands.size() != this.descriptions.size()) {
            return Status.CANCEL_STATUS;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        if (Cygwin.isMissingInOSWin32()) {
            if (!reportedNoCygwin) {
                ErrorReporter.logError((String)CYGWIN);
                ArrayList<String> al = new ArrayList<String>();
                al.add(CYGWIN);
                TITANJob.reportExecutionProblem(this.project, prefs, this.getName(), al, null, true);
                reportedNoCygwin = true;
            }
            return Status.CANCEL_STATUS;
        }
        internalMonitor.beginTask(this.getName(), this.commands.size());
        Activator.getDefault().pauseHandlingResourceChanges();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        this.setEnvironmentalVariables(pb);
        pb.directory(this.workingDir);
        pb.redirectErrorStream(true);
        Process proc = null;
        if (this.removeCompilerMarkers || this.removeOnTheFlyMarkers) {
            if (this.removeCompilerMarkers) {
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerErrorMarker", (IResource)this.project);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerWarningMarker", (IResource)this.project);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerInfoMarker", (IResource)this.project);
            }
            if (this.removeOnTheFlyMarkers) {
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)this.project);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)this.project);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", (IResource)this.project);
            }
            for (IFile file : this.files.values()) {
                if (this.removeCompilerMarkers) {
                    MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerErrorMarker", (IResource)file);
                    MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerWarningMarker", (IResource)file);
                    MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.compilerInfoMarker", (IResource)file);
                }
                if (!this.removeOnTheFlyMarkers) continue;
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)file);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)file);
                MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflyMixedMarker", (IResource)file);
            }
        }
        OutputAnalyzer analyzer = new OutputAnalyzer(this.files, this.project);
        while (!this.commands.isEmpty()) {
            if (internalMonitor.isCanceled()) {
                internalMonitor.done();
                analyzer.dispose();
                analyzer = null;
                this.clearBeforeFinish();
                return Status.CANCEL_STATUS;
            }
            String currentDescription = this.descriptions.poll();
            List<String> currentCommand = this.commands.poll();
            this.setName(currentDescription);
            List<String> finalCommand = this.getFinalCommand(currentCommand);
            StringBuilder builder = new StringBuilder();
            for (String c : finalCommand) {
                builder.append(c + SPACE);
            }
            TITANConsole.println(builder.toString());
            pb.command(finalCommand);
            try {
                proc = pb.start();
            }
            catch (IOException e) {
                TITANConsole.println("execution failed");
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TITANJob.reportExecutionProblem(this.project, prefs, this.getName(), finalCommand, null, false);
                this.foundErrors = true;
                internalMonitor.done();
                analyzer.dispose();
                analyzer = null;
                if (proc != null) {
                    proc.destroy();
                }
                this.clearBeforeFinish();
                return Status.CANCEL_STATUS;
            }
            BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            try {
                String line;
                while ((line = stdout.readLine()) != null) {
                    if (internalMonitor.isCanceled()) {
                        String c;
                        internalMonitor.done();
                        analyzer.dispose();
                        analyzer = null;
                        proc.destroy();
                        this.clearBeforeFinish();
                        c = Status.CANCEL_STATUS;
                        return c;
                    }
                    analyzer.parseTitanErrors(line);
                    TITANConsole.println(line);
                }
                int exitval = proc.waitFor();
                if (exitval == 0 && analyzer.hasProcessedErrorMessages()) {
                    exitval = analyzer.getExternalErrorCode();
                }
                if (exitval != 0) {
                    TITANConsole.println(FAILURE + exitval);
                    if (!analyzer.hasProcessedErrorMessages()) {
                        if (stderr.ready()) {
                            StringBuilder builder2 = new StringBuilder();
                            while ((line = stderr.readLine()) != null) {
                                builder2.append(line);
                            }
                            TITANJob.reportExecutionProblem(this.project, prefs, this.getName(), finalCommand, builder2.toString(), false);
                        } else {
                            TITANJob.reportExecutionProblem(this.project, prefs, this.getName(), finalCommand, null, false);
                        }
                    }
                    this.foundErrors = true;
                    internalMonitor.done();
                    analyzer.dispose();
                    analyzer = null;
                    proc.destroy();
                    this.clearBeforeFinish();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                TITANConsole.println(SUCCESS);
            }
            catch (IOException e) {
                TITANConsole.println("execution failed");
                ErrorReporter.logExceptionStackTrace((String)"execution failed", (Throwable)e);
            }
            catch (InterruptedException e) {
                TITANConsole.println("execution failed because of interruption");
                ErrorReporter.logExceptionStackTrace((String)"execution failed because of interruption", (Throwable)e);
            }
            finally {
                try {
                    stdout.close();
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                try {
                    stderr.close();
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
            internalMonitor.worked(1);
        }
        internalMonitor.done();
        analyzer.dispose();
        this.clearBeforeFinish();
        return Status.OK_STATUS;
    }

    private void clearBeforeFinish() {
        Activator.getDefault().resumeHandlingResourceChanges();
        if (this.removeCompilerMarkers || this.removeOnTheFlyMarkers) {
            MarkerHandler.removeAllMarkedMarkers((IResource)this.project);
        }
        if (this.project == null) {
            return;
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static void reportExecutionProblem(IProject project, IPreferencesService prefs, final String name, final List<String> command, final String errorOutput, final boolean cygwin) {
        boolean useMarker = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportProgramErrorWithMarker", false, null);
        if (useMarker && project != null) {
            TITANJob.createProblemMarker((IResource)project, name + FAILED);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StringBuilder builder = new StringBuilder();
                    for (String c : command) {
                        builder.append(c).append(TITANJob.SPACE);
                    }
                    if (errorOutput == null || errorOutput.length() == 0) {
                        if (cygwin) {
                            MessageDialog.openError(null, (String)(name + TITANJob.FAILED), (String)builder.toString());
                            ErrorReporter.logError((String)builder.toString());
                        } else {
                            MessageDialog.openError(null, (String)(name + TITANJob.FAILED), (String)MessageFormat.format(TITANJob.CHECK_PERMISSION, builder.toString()));
                            ErrorReporter.logError((String)MessageFormat.format(TITANJob.CHECK_PERMISSION, builder.toString()));
                        }
                    } else if (cygwin) {
                        MessageDialog.openError(null, (String)(name + TITANJob.FAILED), (String)builder.toString());
                        ErrorReporter.logError((String)builder.toString());
                    } else {
                        MessageDialog.openError(null, (String)(name + TITANJob.FAILED), (String)MessageFormat.format(TITANJob.ERRORS_FOUND, builder.toString(), errorOutput));
                        ErrorReporter.logError((String)MessageFormat.format(TITANJob.ERRORS_FOUND, builder.toString(), errorOutput));
                    }
                }
            });
        }
    }

    private static void createProblemMarker(IResource resource, String message) {
        Location location = new Location(resource);
        location.reportExternalProblem(message, 2, "org.eclipse.titan.designer.compilerErrorMarker");
    }
}

