/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.controls;

import java.text.MessageFormat;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.HoverProposal;
import org.eclipse.titan.designer.editors.controls.MarkerHoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class Ttcn3HoverInfoControl
extends AbstractInformationControl
implements IInformationControlCreator,
IInformationControlExtension2 {
    private static final String STATUS_TEXT = "Hover or press 'F2' to focus";
    private static final String SWITCHBUTTON_TEXT_PATTERN = "Click to switch to {0} view";
    private static final String SHOW_IN_DOCCOMMENT_VIEW = "Show in document comment view";
    private static final int scrollBarSize = 20;
    private static final int fMarginY = 5;
    private Browser browser;
    private StyledText textViewer;
    private ToolBarManager toolbar;
    private Composite fParent;
    private ToolItem switchButton;
    private ToolItem docCommentViewButton;
    private static int lastWidth = 400;
    private static int lastHeight = 200;
    private int toolbarHeight = 0;
    private int toolbarWidth = 0;
    private Ttcn3HoverContent content;
    private MarkerHoverContent markerContent;
    private HoverContentType actualType = HoverContentType.loadAsProperty();
    private boolean isProposalContent;
    private SelectionListener switchListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            switch (Ttcn3HoverInfoControl.this.actualType) {
                case INFO: {
                    Ttcn3HoverInfoControl.this.actualType = HoverContentType.SOURCE;
                    break;
                }
                case SOURCE: {
                    Ttcn3HoverInfoControl.this.actualType = HoverContentType.INFO;
                }
            }
            if (e.widget instanceof ToolItem) {
                ((ToolItem)e.widget).setText(Ttcn3HoverInfoControl.this.getButtonText());
                HoverContentType.storeAsProperty(Ttcn3HoverInfoControl.this.actualType);
                lastWidth = Ttcn3HoverInfoControl.this.getShell().getSize().x;
                lastHeight = Ttcn3HoverInfoControl.this.getShell().getSize().y;
                Ttcn3HoverInfoControl.this.handleTtcn3HoverContent(false);
                Ttcn3HoverInfoControl.this.toolbar.update(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener docCommentViewListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView");
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.titan.designer.editors.ttcn3editor.DocumentCommentView");
            if (view instanceof DocumentCommentView) {
                DocumentCommentView docView = (DocumentCommentView)view;
                docView.setContent(Ttcn3HoverInfoControl.this.content);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private FocusListener focusListenerToStoreSize = new FocusListener(){

        public void focusLost(FocusEvent e) {
            lastWidth = Ttcn3HoverInfoControl.this.getShell().getClientArea().width;
            lastHeight = Ttcn3HoverInfoControl.this.getShell().getClientArea().height - 5;
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private FocusListener focusListenerToDispose = new FocusListener(){

        public void focusLost(FocusEvent e) {
            Ttcn3HoverInfoControl.this.dispose();
        }

        public void focusGained(FocusEvent e) {
        }
    };

    public Ttcn3HoverInfoControl(Shell parentShell, String statusFieldText) {
        super(parentShell, statusFieldText);
        this.create();
    }

    public Ttcn3HoverInfoControl(Shell parentShell, String statusFieldText, ToolBarManager toolbar) {
        super(parentShell, toolbar);
        this.toolbar = toolbar;
        this.create();
    }

    public Ttcn3HoverInfoControl(Shell parentShell) {
        super(parentShell, true);
        this.create();
        this.actualType = HoverContentType.INFO;
        this.isProposalContent = true;
    }

    @Deprecated
    public void setInformation(String information) {
    }

    public boolean hasContents() {
        return this.content != null || this.markerContent != null;
    }

    protected void createContent(Composite parent) {
        this.fParent = parent;
        this.setStatusText(STATUS_TEXT);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                ToolBarManager toolbar = new ToolBarManager(8519936);
                return new Ttcn3HoverInfoControl(parent, EditorsUI.getTooltipAffordanceString(), toolbar);
            }
        };
    }

    public void setInput(Object input) {
        this.setInput(input, false);
    }

    public void setInput(Object input, boolean force) {
        if (input instanceof Ttcn3HoverContent) {
            this.content = (Ttcn3HoverContent)input;
            this.handleTtcn3HoverContent(force);
        }
        if (input instanceof MarkerHoverContent) {
            this.markerContent = (MarkerHoverContent)input;
            this.handleMarkerHoverContent();
        }
        if (input instanceof String) {
            this.content = new Ttcn3HoverContent();
            this.content.addContent(HoverContentType.INFO, input.toString());
            this.handleTtcn3HoverContent(force);
        }
    }

    private void handleTtcn3HoverContent(boolean force) {
        if (this.textViewer != null) {
            this.textViewer.setVisible(false);
        }
        if (this.browser == null) {
            try {
                this.browser = new Browser(this.fParent, 0);
            }
            catch (SWTError e) {
                ErrorReporter.INTERNAL_ERROR((String)("Could not instantiate hover window SWT Browser: " + e.getMessage()));
                return;
            }
        }
        this.addFocusListener(this.focusListenerToStoreSize);
        if (force) {
            this.addFocusListener(this.focusListenerToDispose);
        }
        String text = null;
        text = force && this.content.hasText(HoverContentType.SOURCE) ? this.content.getText(HoverContentType.SOURCE) : (force && this.content.hasText(HoverContentType.INFO) ? this.content.getText(HoverContentType.INFO) : this.content.getText(this.actualType));
        if (text != null) {
            this.browser.setText(text);
            this.browser.setVisible(true);
        }
        if (this.toolbar != null && !force) {
            this.toolbar.setStyle(256);
            ToolBar tb = this.toolbar.createControl(this.fParent);
            tb.setCursor(Display.getCurrent().getSystemCursor(21));
            switch (ColorManager.getColorTheme()) {
                case Dark: {
                    tb.setForeground(this.getShell().getDisplay().getSystemColor(1));
                    break;
                }
                default: {
                    tb.setForeground(this.getShell().getDisplay().getSystemColor(36));
                }
            }
            if (!this.isProposalContent && this.content != null) {
                if (this.docCommentViewButton == null) {
                    this.docCommentViewButton = new ToolItem(tb, 8519936);
                    this.docCommentViewButton.addSelectionListener(this.docCommentViewListener);
                }
                this.docCommentViewButton.setToolTipText(SHOW_IN_DOCCOMMENT_VIEW);
                this.docCommentViewButton.setImage(ImageCache.getImage("comment.png"));
                if (this.switchButton == null) {
                    this.switchButton = new ToolItem(tb, 0x804000);
                    this.switchButton.addSelectionListener(this.switchListener);
                }
                this.switchButton.setText(this.getButtonText());
                this.switchButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED"));
            }
        }
        this.setSizeConstraints(lastWidth, lastHeight);
        this.setSize(lastWidth, lastHeight);
    }

    private void handleMarkerHoverContent() {
        String markersText;
        if (this.browser != null) {
            this.browser.setVisible(false);
        }
        if (this.textViewer == null) {
            this.textViewer = new StyledText(this.fParent, 0);
            this.textViewer.setEditable(false);
            this.textViewer.setBackground(this.getShell().getBackground());
            this.textViewer.setFont(JFaceResources.getDialogFont());
        }
        if ((markersText = this.markerContent.getText()) != null) {
            this.textViewer.setText(markersText);
            this.textViewer.setVisible(true);
        }
        if (this.toolbar != null) {
            int nrOfProposals = this.markerContent.nrOfProposals();
            ToolBar tb = this.toolbar.createControl(this.fParent);
            for (int i = 0; i < nrOfProposals; ++i) {
                final HoverProposal prop = this.markerContent.getProposal(i);
                ToolItem button = new ToolItem(tb, 0x820000);
                button.setText(prop.getLabel());
                Image image = prop.getImage();
                if (image != null) {
                    button.setImage(image);
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        prop.run(null);
                        Ttcn3HoverInfoControl.this.dispose();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.toolbarHeight += button.getBounds().height;
                this.toolbarWidth = this.toolbarWidth < button.getBounds().width ? button.getBounds().width : this.toolbarWidth;
            }
        }
        this.setSizeConstraints(-1, -1);
        this.setSize(this.computeSizeHint());
    }

    public void setSize(int width, int height) {
        this.getShell().layout();
        if (this.toolbar != null && this.markerContent != null && this.markerContent.nrOfProposals() > 0) {
            this.getShell().setSize(Math.max(width, this.toolbarWidth), height + this.toolbarHeight - 20);
        } else {
            this.getShell().setSize(width, height);
        }
    }

    public void setSize(Point size) {
        this.setSize(size.x, size.y);
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        Point point = super.computeSizeConstraints(widthInChars, heightInChars);
        point.x = Math.max(point.x, lastWidth);
        point.y = Math.max(point.y, lastHeight);
        return point;
    }

    private String getButtonText() {
        return MessageFormat.format(SWITCHBUTTON_TEXT_PATTERN, new Object[]{this.actualType == HoverContentType.INFO ? HoverContentType.SOURCE : HoverContentType.INFO});
    }

    public IInformationControl createInformationControl(Shell parent) {
        return this;
    }
}

