/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchMatch;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchResult;

public class ReferenceSearchQuery
implements ISearchQuery {
    private final ReferenceSearchResult result = new ReferenceSearchResult(this);
    private final Module module;
    private final IProject project;
    private final ReferenceFinder referenceFinder;

    public ReferenceSearchQuery(ReferenceFinder rf, Module module, IProject project) {
        this.module = module;
        this.project = project;
        this.referenceFinder = rf;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.result.removeAll();
        Map<Module, List<ReferenceFinder.Hit>> map = this.referenceFinder.findAllReferences(this.module, this.project, monitor, false);
        for (Map.Entry<Module, List<ReferenceFinder.Hit>> entry : map.entrySet()) {
            IResource resource = entry.getKey().getLocation().getFile();
            if (!(resource instanceof IFile)) continue;
            for (ReferenceFinder.Hit hit : entry.getValue()) {
                this.result.addMatch(new ReferenceSearchMatch(hit.identifier));
            }
        }
        monitor.done();
        return new Status(0, "org.eclipse.titan.designer", 0, "Search done.", null);
    }

    public String getLabel() {
        return "TITAN Reference Search";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public String getSearchPattern() {
        return this.referenceFinder.getSearchName();
    }
}

