/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.ui.PlatformUI;

public class ContentCodeMining
extends LineContentCodeMining {
    protected String text;
    protected Image image;

    public ContentCodeMining(Position position, ICodeMiningProvider provider) {
        super(position, provider);
        this.text = "";
        this.image = null;
    }

    public ContentCodeMining(Position position, ICodeMiningProvider provider, String text) {
        super(position, provider);
        this.text = text;
        this.image = null;
    }

    public ContentCodeMining(Position position, ICodeMiningProvider provider, String text, Image image) {
        super(position, provider);
        this.text = text;
        this.image = image;
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.runAsync(() -> super.setLabel(this.text));
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        ColorManager.Theme theme = ColorManager.getColorTheme();
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (theme == ColorManager.Theme.Dark) {
            gc.setForeground(new Color((Device)display, 200, 200, 200));
        } else {
            gc.setForeground(new Color((Device)display, 50, 50, 50));
        }
        String title = this.getLabel() != null ? this.getLabel() : "<?>";
        Point extent = gc.stringExtent(title);
        extent.x += 20;
        if (this.image != null) {
            extent.x += this.image.getBounds().width;
            if (this.image.getBounds().height > extent.y) {
                extent.y = this.image.getBounds().height;
            }
        }
        FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
        fontData.setHeight(8);
        Font miningFont = new Font((Device)display, fontData);
        gc.setFont(miningFont);
        int leftmargin = this.getLeftMargin();
        if (this.image != null) {
            gc.drawImage(this.image, x + leftmargin, y + 4);
        }
        gc.drawString(title, this.image != null ? x + leftmargin + 20 : x + leftmargin + 10, y, true);
        miningFont.dispose();
        return extent;
    }

    protected int getLeftMargin() {
        return 0;
    }
}

