/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.FileNotFoundException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.designer.core.TITANNature;

public final class TITANProjectOpener {
    public static boolean check(IProject project) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        if (!TITANNature.hasTITANNature(project)) {
            return false;
        }
        return TITANNature.hasTITANBuilder(project) || TITANNature.hasTITANJavaBuilder(project);
    }

    public static IProject open(IPath path) throws CoreException, FileNotFoundException {
        IProject[] projects;
        if (path == null || path.isEmpty()) {
            return null;
        }
        String projectName = path.lastSegment();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        for (IProject project : projects = workspace.getRoot().getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        IPath toProjectFile = path.append(".project");
        if (!toProjectFile.isAbsolute()) {
            toProjectFile = workspace.getRoot().getLocation().append(toProjectFile);
        }
        if (!toProjectFile.toFile().exists()) {
            throw new FileNotFoundException("Project description file (.project) was not found on the specified path: `" + toProjectFile.toOSString() + "'");
        }
        IProjectDescription description = workspace.loadProjectDescription(toProjectFile);
        for (IProject project : projects) {
            if (!project.getName().equals(description.getName())) continue;
            return project;
        }
        IProject newProject = workspace.getRoot().getProject(description.getName());
        newProject.create(description, null);
        newProject.open(1, null);
        newProject.refreshLocal(2, null);
        return newProject;
    }

    public static IProject open(String pathString) throws CoreException, FileNotFoundException {
        return TITANProjectOpener.open((IPath)new Path(pathString));
    }
}

