/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;

class TITANProjectExportMainPage
extends WizardPage {
    private final IStructuredSelection selection;
    private Text projectFileText;
    private Button projectFileSelectionButton;
    private String projectFile = null;
    private IProject project = null;
    private final BasicProjectSelectorListener generalListener = new BasicProjectSelectorListener();

    public TITANProjectExportMainPage(String name, IStructuredSelection selection) {
        super(name);
        this.selection = selection;
    }

    public String getProjectFilePath() {
        return this.projectFile;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        pageComposite.setLayoutData((Object)data);
        this.check(this.projectFile);
        this.createProjectFileEditor(pageComposite);
        this.setControl((Control)pageComposite);
    }

    private boolean check(String filePath) {
        IPath projectFilePath;
        this.project = null;
        if (this.selection == null) {
            this.setErrorMessage("A project must be selected for the export wizard to work.");
            return false;
        }
        if (this.selection.size() != 1) {
            this.setErrorMessage("Exactly 1 project has to be selected");
            return false;
        }
        List selectionList = this.selection.toList();
        if (!(selectionList.get(0) instanceof IProject)) {
            this.setErrorMessage("A project has to be selected");
            return false;
        }
        this.project = (IProject)selectionList.get(0);
        if (filePath != null && !(projectFilePath = Path.fromOSString((String)filePath)).isValidPath(filePath)) {
            this.setErrorMessage("The provided file path does not seem to be valid on this platform");
            return false;
        }
        return true;
    }

    protected void createProjectFileEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Target project file:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectFileText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectFileText.setLayoutData((Object)gd);
        this.projectFileText.setFont(font);
        this.projectFileText.addModifyListener((ModifyListener)this.generalListener);
        if (this.project != null) {
            this.projectFileText.setText(this.project.getName() + ".tpd");
            try {
                String loadLocation = this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"));
                if (loadLocation != null) {
                    URI projectFileURI = new URI(loadLocation);
                    IPath projectFilePath = URIUtil.toPath((URI)projectFileURI);
                    if (projectFilePath != null) {
                        this.projectFileText.setText(projectFilePath.toString());
                    }
                } else if (this.project.getLocation() != null) {
                    this.projectFileText.setText(this.project.getLocation().append(this.project.getName() + ".tpd").toOSString());
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            catch (URISyntaxException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        this.projectFileSelectionButton = new Button((Composite)group, 8);
        this.projectFileSelectionButton.setText("Browse..");
        this.projectFileSelectionButton.setLayoutData((Object)new GridData());
        this.projectFileSelectionButton.addSelectionListener((SelectionListener)this.generalListener);
    }

    protected void handleProjectFileButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell());
        Path path = new Path(this.projectFileText.getText());
        dialog.setFileName(path.lastSegment());
        dialog.setFilterExtensions(new String[]{"*.tpd"});
        final String file = dialog.open();
        if (file != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TITANProjectExportMainPage.this.projectFileText.setText(file);
                }
            });
        }
        if (this.check(file)) {
            this.projectFile = file;
        }
    }

    protected void handleProjectFileModified() {
        String temp = this.projectFileText.getText();
        if (this.check(temp)) {
            this.projectFile = temp;
        }
    }

    protected class BasicProjectSelectorListener
    implements ModifyListener,
    SelectionListener {
        protected BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source == TITANProjectExportMainPage.this.projectFileText) {
                TITANProjectExportMainPage.this.handleProjectFileModified();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == TITANProjectExportMainPage.this.projectFileSelectionButton) {
                TITANProjectExportMainPage.this.handleProjectFileButtonSelected();
            }
        }
    }
}

