/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.graphics.ImageCache;
import org.eclipse.titan.common.log.format.LogFormatter;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TitanURIUtil;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public final class FormatLog
extends AbstractHandler
implements IWorkbenchWindowActionDelegate {
    private List<IFile> files = new ArrayList<IFile>();

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
        this.files.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus internalFormatter(IProgressMonitor monitor, IFile file, URI targetPath, IFile[] targetFiles) {
        ResourceUtils.refreshResources(Arrays.asList(file));
        File source = new File(file.getLocationURI());
        long fileSize = source.length();
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        internalMonitor.beginTask("formatting " + file.getName(), (int)(fileSize / 65536L));
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(source);
            inChannel = fileInputStream.getChannel();
            outChannel = this.openOutputFile(targetPath);
            new LogFormatter().format(internalMonitor, inChannel, outChannel);
        }
        catch (IOException e) {
            Status status;
            try {
                ErrorReporter.logExceptionStackTrace("Error while formatting log file: " + file.getLocation().toOSString(), e);
                String message = e.getMessage() == null ? "" : e.getMessage();
                status = new Status(4, "org.eclipse.titan.common", 0, message, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream, outChannel);
                throw throwable;
            }
            IOUtils.closeQuietly(fileInputStream, outChannel);
            return status;
        }
        IOUtils.closeQuietly(fileInputStream, outChannel);
        if (targetFiles != null) {
            ResourceUtils.refreshResources(Arrays.asList(targetFiles));
        }
        internalMonitor.done();
        return Status.OK_STATUS;
    }

    private FileChannel openOutputFile(URI targetPath) throws FileNotFoundException {
        FileOutputStream outfile = null;
        try {
            outfile = new FileOutputStream(new File(targetPath), false);
        }
        catch (FileNotFoundException e) {
            String message = "Error while opening " + targetPath + " for writing";
            ErrorReporter.logExceptionStackTrace(message, e);
            throw new FileNotFoundException(message);
        }
        return outfile.getChannel();
    }

    public void run(IAction action) {
        this.doFormat();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = SelectionUtils.getAccessibleFilesFromSelection(selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = iwPage.getSelection();
        this.files = SelectionUtils.getAccessibleFilesFromSelection(selection);
        this.doFormat();
        return null;
    }

    public void formatFiles(List<IFile> files) {
        for (IFile file : files) {
            URI targetPath = FormatLog.getTargetPath(file.getLocationURI());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] targetFiles = root.findFilesForLocationURI(targetPath);
            this.internalFormatter(null, file, targetPath, targetFiles);
        }
    }

    private static URI getTargetPath(URI original) {
        String originalFileName = URIUtil.lastSegment((URI)URIUtil.removeFileExtension((URI)original));
        URI path = TitanURIUtil.removeLastSegment(original);
        String newFilename = originalFileName + "_formatted.log";
        return URIUtil.append((URI)path, (String)newFilename);
    }

    private void doFormat() {
        for (final IFile file : this.files) {
            final URI targetPath = FormatLog.getTargetPath(file.getLocationURI());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            final IFile[] targetFiles = root.findFilesForLocationURI(targetPath);
            WorkspaceJob saveJob = new WorkspaceJob("Formatting log file"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    return FormatLog.this.internalFormatter(monitor, file, targetPath, targetFiles);
                }
            };
            saveJob.setRule(this.createRuleFromResources(file, targetFiles));
            saveJob.setPriority(30);
            saveJob.setUser(true);
            saveJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            saveJob.schedule();
        }
    }

    private ISchedulingRule createRuleFromResources(IFile file, IFile[] targetFiles) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule1 = ruleFactory.createRule((IResource)file);
        ISchedulingRule combinedRule = MultiRule.combine((ISchedulingRule)rule1, null);
        for (IFile targetFile : targetFiles) {
            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)targetFile), (ISchedulingRule)combinedRule);
        }
        return combinedRule;
    }
}

