/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionRefactoring;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveFunctionActionFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.performMoveFunction();
        return null;
    }

    public void run(IAction action) {
        this.performMoveFunction();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void performMoveFunction() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        Set<IProject> projsToUpdate = Utils.findAllProjectsInSelection(structSelection);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "Move function");
        Activator.getDefault().pauseHandlingResourceChanges();
        MoveFunctionRefactoring refactoring = new MoveFunctionRefactoring(structSelection, new MoveFunctionRefactoring.MoveFunctionSettings());
        MoveFunctionWizard wiz = new MoveFunctionWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        try {
            operation.run(targetEditor == null ? null : targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"MoveFunctionActionFromBrowser: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
    }
}

