/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.testset;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.tabpages.testset.TestCaseTreeElement;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeElement;

public final class TestcasesLabelProvider
extends LabelProvider {
    private final Set<String> availableTestcases = new HashSet<String>();
    private final Set<String> availableControlparts = new HashSet<String>();

    public void addTestcases(List<String> testcases) {
        this.availableTestcases.addAll(testcases);
    }

    public void addControlParts(List<String> controlparts) {
        this.availableControlparts.addAll(controlparts);
    }

    public Image getImage(Object element) {
        if (element instanceof TestsetTreeElement) {
            List<ITreeLeaf> temp = ((TestsetTreeElement)element).children();
            for (ITreeLeaf aTemp : temp) {
                String name = aTemp.name();
                if (!this.availableTestcases.contains(name) && !this.availableControlparts.contains(name)) continue;
                return ImageCache.getImage("testset.gif");
            }
            return ImageCache.getImage("erroneous.gif");
        }
        if (element instanceof TestCaseTreeElement) {
            String name = ((TestCaseTreeElement)element).name();
            if (this.availableTestcases.contains(name) || this.availableControlparts.contains(name)) {
                return ImageCache.getImage("testcase.gif");
            }
            return ImageCache.getImage("erroneous.gif");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof TreeLeaf) {
            return ((TreeLeaf)element).name();
        }
        return super.getText(element);
    }
}

