/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.layouts;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.RadiusGraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.common.logging.ErrorReporter;

public class TitaniumISOMLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    private int maxEpoch = 2000;
    private final AtomicInteger epoch = new AtomicInteger(1);
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    protected GraphElementAccessor<V, E> elementAccessor = new RadiusGraphElementAccessor();
    private double coolingFactor;
    private final List<V> queue = new ArrayList<V>();
    private final Map<V, ISOMVertexData> isomVertexData = new HashMap<V, ISOMVertexData>();

    public TitaniumISOMLayout(Graph<V, E> g) {
        super(g);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxEpoch = maxIterations;
    }

    public void initialize() {
        this.setInitializer((Function)new RandomLocationTransformer(this.getSize()));
        this.epoch.set(1);
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    public synchronized void step() {
        if (this.epoch.get() < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
        }
    }

    private synchronized void adjust() {
        Point2D.Double tempXYD = new Point2D.Double();
        ((Point2D)tempXYD).setLocation(10.0 + Math.random() * this.getSize().getWidth(), 10.0 + Math.random() * this.getSize().getHeight());
        Object winner = this.elementAccessor.getVertex((Layout)this, ((Point2D)tempXYD).getX(), ((Point2D)tempXYD).getY());
        try {
            for (Object v : this.getGraph().getVertices()) {
                ISOMVertexData ivd = this.getISOMVertexData(v);
                ivd.distance = 0;
                ivd.visited = false;
            }
        }
        catch (ConcurrentModificationException cme) {
            ErrorReporter.logExceptionStackTrace((String)"Error while adjusting vertex data", (Throwable)cme);
        }
        this.adjustVertex(winner, tempXYD);
    }

    private synchronized void updateParameters() {
        this.epoch.incrementAndGet();
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch.get() / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch.get() % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustVertex(V v, Point2D tempXYD) {
        this.queue.clear();
        ISOMVertexData ivd = this.getISOMVertexData(v);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(v);
        while (!this.queue.isEmpty()) {
            V current = this.queue.remove(this.queue.size() - 1);
            ISOMVertexData currData = this.getISOMVertexData(current);
            Point2D currXYData = this.apply(current);
            double dx = tempXYD.getX() - currXYData.getX();
            double dy = tempXYD.getY() - currXYData.getY();
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            currXYData.setLocation(currXYData.getX() + factor * dx, currXYData.getY() + factor * dy);
            if (currData.distance >= this.radius) continue;
            Collection s = this.getGraph().getNeighbors(current);
            try {
                for (Object child : s) {
                    ISOMVertexData childData = this.getISOMVertexData(child);
                    if (childData == null || childData.visited) continue;
                    childData.visited = true;
                    childData.distance = currData.distance + 1;
                    this.queue.add(child);
                }
            }
            catch (ConcurrentModificationException cme) {
                ErrorReporter.logExceptionStackTrace((String)"Error while adjusting vertex data", (Throwable)cme);
            }
        }
    }

    protected ISOMVertexData getISOMVertexData(V v) {
        ISOMVertexData temp = this.isomVertexData.get(v);
        if (temp == null) {
            temp = new ISOMVertexData();
            this.isomVertexData.put((ISOMVertexData)v, temp);
        }
        return temp;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean done() {
        return this.epoch.get() >= this.maxEpoch;
    }

    public void reset() {
        this.epoch.set(0);
    }

    private static class ISOMVertexData {
        private int distance = 0;
        private boolean visited = false;

        protected ISOMVertexData() {
        }
    }
}

