/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ModuleName {
    private ModuleName() {
        throw new AssertionError((Object)"Noninstantiable");
    }

    public static class InGroup
    extends Base {
        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (node instanceof Group) {
                Group group = (Group)node;
                Identifier identifier = group.getIdentifier();
                TTCN3Module module = group.getModule();
                if (module == null) {
                    return;
                }
                Identifier moduleID = module.getIdentifier();
                this.check(identifier, moduleID, "group", problems);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Group.class);
            return ret;
        }
    }

    public static class InDef
    extends Base {
        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (node instanceof Definition && !(node instanceof FormalParameter)) {
                Definition s = (Definition)node;
                Identifier identifier = s.getIdentifier();
                Identifier moduleID = s.getMyScope().getModuleScope().getIdentifier();
                this.check(identifier, moduleID, s.getDescription(), problems);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Definition.class);
            return ret;
        }
    }

    public static abstract class Base
    extends BaseModuleCodeSmellSpotter {
        private static final String REPORT = "The name {1} of the {0} contains the module name {2} it is located in";

        public Base() {
            super(CodeSmellType.MODULENAME_IN_DEFINITION);
        }

        @Override
        public abstract List<Class<? extends IVisitableNode>> getStartNode();

        protected void check(Identifier identifier, Identifier moduleID, String description, BaseCodeSmellSpotter.Problems problems) {
            String displayName = identifier.getDisplayName();
            if (displayName.contains(moduleID.getDisplayName())) {
                String msg = MessageFormat.format(REPORT, description, displayName, moduleID.getDisplayName());
                problems.report(identifier.getLocation(), msg);
            }
        }
    }
}

