/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnusedImportsProject
extends BaseProjectCodeSmellSpotter {
    public UnusedImportsProject() {
        super(CodeSmellType.UNUSED_IMPORT);
    }

    @Override
    protected void process(IProject project, BaseCodeSmellSpotter.Problems problems) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleName : new TreeSet(knownModuleNames)) {
            Module module = projectSourceParser.getModuleByName(moduleName);
            modules.add(module);
        }
        HashSet setOfImportedModules = new HashSet();
        for (Module module : modules) {
            setOfImportedModules.clear();
            setOfImportedModules.addAll(module.getImportedModules());
            ImportsCheck check = new ImportsCheck();
            module.accept((ASTVisitor)check);
            setOfImportedModules.removeAll(check.getModules());
            if (module instanceof TTCN3Module) {
                for (ImportModule mod : ((TTCN3Module)module).getImports()) {
                    Identifier importIdentifier = mod.getIdentifier();
                    for (Module m : setOfImportedModules) {
                        if (!m.getIdentifier().equals((Object)importIdentifier)) continue;
                        problems.report(importIdentifier.getLocation(), "Possibly unused importation");
                    }
                }
                continue;
            }
            ModuleImportsCheck importsCheck = new ModuleImportsCheck();
            module.accept((ASTVisitor)importsCheck);
            for (ModuleImportation im : importsCheck.getImports()) {
                Identifier importIdentifier = im.getIdentifier();
                for (Module m : setOfImportedModules) {
                    if (!m.getIdentifier().equals((Object)importIdentifier)) continue;
                    problems.report(importIdentifier.getLocation(), "Possibly unused importation");
                }
            }
        }
    }

    class ModuleImportsCheck
    extends ASTVisitor {
        private final Set<ModuleImportation> setOfModules = new HashSet<ModuleImportation>();

        public ModuleImportsCheck() {
            this.setOfModules.clear();
        }

        public Set<ModuleImportation> getImports() {
            return this.setOfModules;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof ModuleImportation) {
                ModuleImportation mod = (ModuleImportation)node;
                this.setOfModules.add(mod);
            }
            return 3;
        }
    }

    class ImportsCheck
    extends ASTVisitor {
        private final Set<Module> setOfModules = new HashSet<Module>();

        public ImportsCheck() {
            this.setOfModules.clear();
        }

        public Set<Module> getModules() {
            return this.setOfModules;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                Reference reference = (Reference)node;
                this.handleReference(reference);
                return 3;
            }
            if (node instanceof Def_FunctionBase) {
                Type type = ((Def_FunctionBase)node).getType(CompilationTimeStamp.getBaseTimestamp());
                if (type == null || type.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 3;
                }
                if (type instanceof Referenced_Type) {
                    Reference reference = ((Referenced_Type)type).getReference();
                    this.handleReference(reference);
                }
            }
            return 3;
        }

        private void handleReference(Reference reference) {
            Scope scope;
            if (reference.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                return;
            }
            Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
            if (assignment != null && (scope = assignment.getMyScope()) != null) {
                this.setOfModules.add(scope.getModuleScope());
            }
        }
    }
}

