/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml.impl;

import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DOMParserWithPosition
extends DOMParser {
    public static final String START_LINE = "startLine";
    public static final String START_COLUMN = "startColumn";
    public static final String END_LINE = "endLine";
    public static final String END_COLUMN = "endColumn";
    private static boolean NotIncludeIgnorableWhiteSpaces = false;
    private XMLLocator locator;

    public DOMParserWithPosition() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
    }

    public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
        super.startElement(elementQName, attrList, augs);
        Node node = this.getCurrentNode();
        if (node != null) {
            node.setUserData(START_LINE, new Integer(this.locator.getLineNumber()), null);
            node.setUserData(START_COLUMN, new Integer(this.locator.getColumnNumber()), null);
        }
    }

    public void endElement(QName elementQName, Augmentations augs) throws XNIException {
        super.endElement(elementQName, augs);
        Node node = this.getCurrentNode();
        if (node != null) {
            node.setUserData(END_LINE, new Integer(this.locator.getLineNumber()), null);
            node.setUserData(END_COLUMN, new Integer(this.locator.getColumnNumber()), null);
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.locator = locator;
        Node node = this.getCurrentNode();
        if (node != null) {
            node.setUserData(START_LINE, new Integer(locator.getLineNumber()), null);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        super.endDocument(augs);
        Node node = this.getCurrentNode();
        if (node != null) {
            node.setUserData(START_LINE, new Integer(this.locator.getLineNumber()), null);
        }
    }

    private Node getCurrentNode() {
        try {
            return (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException ex) {
            System.err.println("except" + ex);
            return null;
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (!NotIncludeIgnorableWhiteSpaces) {
            super.ignorableWhitespace(text, augs);
        }
    }

    public static Integer getNodeLocation(Node node, String locationId, Integer defaultValue) {
        if (node != null && node.getUserData(locationId) instanceof Integer) {
            return (Integer)node.getUserData(locationId);
        }
        return defaultValue;
    }

    public static Integer getNodeStartLine(Node node, Integer defaultValue) {
        return DOMParserWithPosition.getNodeLocation(node, START_LINE, defaultValue);
    }

    public static Integer getNodeStartColumn(Node node, Integer defaultValue) {
        return DOMParserWithPosition.getNodeLocation(node, START_COLUMN, defaultValue);
    }

    public static Integer getNodeEndLine(Node node, Integer defaultValue) {
        return DOMParserWithPosition.getNodeLocation(node, END_LINE, defaultValue);
    }

    public static Integer getNodeEndColumn(Node node, Integer defaultValue) {
        return DOMParserWithPosition.getNodeLocation(node, END_COLUMN, defaultValue);
    }
}

