// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/container/v1/cluster_service.proto

package container

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Allowed Network Policy providers.
type NetworkPolicy_Provider int32

const (
	// Not set
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	// Tigera (Calico Felix).
	NetworkPolicy_CALICO NetworkPolicy_Provider = 1
)

var NetworkPolicy_Provider_name = map[int32]string{
	0: "PROVIDER_UNSPECIFIED",
	1: "CALICO",
}

var NetworkPolicy_Provider_value = map[string]int32{
	"PROVIDER_UNSPECIFIED": 0,
	"CALICO":               1,
}

func (x NetworkPolicy_Provider) String() string {
	return proto.EnumName(NetworkPolicy_Provider_name, int32(x))
}

func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{11, 0}
}

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
	// The DEGRADED state indicates the cluster requires user action to restore
	// full functionality. Details can be found in the `statusMessage` field.
	Cluster_DEGRADED Cluster_Status = 6
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "ERROR",
	6: "DEGRADED",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"ERROR":              5,
	"DEGRADED":           6,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{13, 0}
}

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

var Operation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
	4: "ABORTING",
}

var Operation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PENDING":            1,
	"RUNNING":            2,
	"DONE":               3,
	"ABORTING":           4,
}

func (x Operation_Status) String() string {
	return proto.EnumName(Operation_Status_name, int32(x))
}

func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{15, 0}
}

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// Set node pool management.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// Automatic node pool repair.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Automatic node upgrade.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Set labels.
	Operation_SET_LABELS Operation_Type = 12
	// Set/generate master auth materials
	Operation_SET_MASTER_AUTH Operation_Type = 13
	// Set node pool size.
	Operation_SET_NODE_POOL_SIZE Operation_Type = 14
	// Updates network policy for a cluster.
	Operation_SET_NETWORK_POLICY Operation_Type = 15
	// Set the maintenance policy.
	Operation_SET_MAINTENANCE_POLICY Operation_Type = 16
)

var Operation_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "CREATE_CLUSTER",
	2:  "DELETE_CLUSTER",
	3:  "UPGRADE_MASTER",
	4:  "UPGRADE_NODES",
	5:  "REPAIR_CLUSTER",
	6:  "UPDATE_CLUSTER",
	7:  "CREATE_NODE_POOL",
	8:  "DELETE_NODE_POOL",
	9:  "SET_NODE_POOL_MANAGEMENT",
	10: "AUTO_REPAIR_NODES",
	11: "AUTO_UPGRADE_NODES",
	12: "SET_LABELS",
	13: "SET_MASTER_AUTH",
	14: "SET_NODE_POOL_SIZE",
	15: "SET_NETWORK_POLICY",
	16: "SET_MAINTENANCE_POLICY",
}

var Operation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":         0,
	"CREATE_CLUSTER":           1,
	"DELETE_CLUSTER":           2,
	"UPGRADE_MASTER":           3,
	"UPGRADE_NODES":            4,
	"REPAIR_CLUSTER":           5,
	"UPDATE_CLUSTER":           6,
	"CREATE_NODE_POOL":         7,
	"DELETE_NODE_POOL":         8,
	"SET_NODE_POOL_MANAGEMENT": 9,
	"AUTO_REPAIR_NODES":        10,
	"AUTO_UPGRADE_NODES":       11,
	"SET_LABELS":               12,
	"SET_MASTER_AUTH":          13,
	"SET_NODE_POOL_SIZE":       14,
	"SET_NETWORK_POLICY":       15,
	"SET_MAINTENANCE_POLICY":   16,
}

func (x Operation_Type) String() string {
	return proto.EnumName(Operation_Type_name, int32(x))
}

func (Operation_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{15, 1}
}

// Operation type: what type update to perform.
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out.
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
	// Set the username.  If an empty username is provided, basic authentication
	// is disabled for the cluster.  If a non-empty username is provided, basic
	// authentication is enabled, with either a provided password or a generated
	// one.
	SetMasterAuthRequest_SET_USERNAME SetMasterAuthRequest_Action = 3
)

var SetMasterAuthRequest_Action_name = map[int32]string{
	0: "UNKNOWN",
	1: "SET_PASSWORD",
	2: "GENERATE_PASSWORD",
	3: "SET_USERNAME",
}

var SetMasterAuthRequest_Action_value = map[string]int32{
	"UNKNOWN":           0,
	"SET_PASSWORD":      1,
	"GENERATE_PASSWORD": 2,
	"SET_USERNAME":      3,
}

func (x SetMasterAuthRequest_Action) String() string {
	return proto.EnumName(SetMasterAuthRequest_Action_name, int32(x))
}

func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{26, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

var NodePool_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RUNNING_WITH_ERROR",
	4: "RECONCILING",
	5: "STOPPING",
	6: "ERROR",
}

var NodePool_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RUNNING_WITH_ERROR": 3,
	"RECONCILING":        4,
	"STOPPING":           5,
	"ERROR":              6,
}

func (x NodePool_Status) String() string {
	return proto.EnumName(NodePool_Status_name, int32(x))
}

func (NodePool_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{40, 0}
}

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	// The name of a Google Compute Engine [machine
	// type](/compute/docs/machine-types) (e.g.
	// `n1-standard-1`).
	//
	// If unspecified, the default machine type is
	// `n1-standard-1`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container Registry](/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs. If
	// no Service Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the reserved keys:
	//  "cluster-location"
	//  "cluster-name"
	//  "cluster-uid"
	//  "configure-sh"
	//  "enable-os-login"
	//  "gci-update-strategy"
	//  "gci-ensure-gke-docker"
	//  "instance-template"
	//  "kube-env"
	//  "startup-script"
	//  "user-data"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependant upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// information about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard' or 'pd-ssd')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,12,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// <code>minCpuPlatform: &quot;Intel Haswell&quot;</code> or
	// <code>minCpuPlatform: &quot;Intel Sandy Bridge&quot;</code>. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	MinCpuPlatform       string   `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeConfig) Reset()         { *m = NodeConfig{} }
func (m *NodeConfig) String() string { return proto.CompactTextString(m) }
func (*NodeConfig) ProtoMessage()    {}
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{0}
}

func (m *NodeConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeConfig.Unmarshal(m, b)
}
func (m *NodeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeConfig.Marshal(b, m, deterministic)
}
func (m *NodeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeConfig.Merge(m, src)
}
func (m *NodeConfig) XXX_Size() int {
	return xxx_messageInfo_NodeConfig.Size(m)
}
func (m *NodeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NodeConfig proto.InternalMessageInfo

func (m *NodeConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *NodeConfig) GetDiskSizeGb() int32 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *NodeConfig) GetOauthScopes() []string {
	if m != nil {
		return m.OauthScopes
	}
	return nil
}

func (m *NodeConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *NodeConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeConfig) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *NodeConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NodeConfig) GetLocalSsdCount() int32 {
	if m != nil {
		return m.LocalSsdCount
	}
	return 0
}

func (m *NodeConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *NodeConfig) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

func (m *NodeConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

func (m *NodeConfig) GetDiskType() string {
	if m != nil {
		return m.DiskType
	}
	return ""
}

func (m *NodeConfig) GetMinCpuPlatform() string {
	if m != nil {
		return m.MinCpuPlatform
	}
	return ""
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, you can disable basic authentication by
	// providing an empty username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Configuration for client certificate authentication on the cluster. For
	// clusters before v1.12, if no configuration is specified, a client
	// certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `protobuf:"bytes,3,opt,name=client_certificate_config,json=clientCertificateConfig,proto3" json:"client_certificate_config,omitempty"`
	// [Output only] Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey            string   `protobuf:"bytes,102,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterAuth) Reset()         { *m = MasterAuth{} }
func (m *MasterAuth) String() string { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()    {}
func (*MasterAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{1}
}

func (m *MasterAuth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuth.Unmarshal(m, b)
}
func (m *MasterAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuth.Marshal(b, m, deterministic)
}
func (m *MasterAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuth.Merge(m, src)
}
func (m *MasterAuth) XXX_Size() int {
	return xxx_messageInfo_MasterAuth.Size(m)
}
func (m *MasterAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuth.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuth proto.InternalMessageInfo

func (m *MasterAuth) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *MasterAuth) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *MasterAuth) GetClientCertificateConfig() *ClientCertificateConfig {
	if m != nil {
		return m.ClientCertificateConfig
	}
	return nil
}

func (m *MasterAuth) GetClusterCaCertificate() string {
	if m != nil {
		return m.ClusterCaCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientKey() string {
	if m != nil {
		return m.ClientKey
	}
	return ""
}

// Configuration for client certificates on the cluster.
type ClientCertificateConfig struct {
	// Issue a client certificate.
	IssueClientCertificate bool     `protobuf:"varint,1,opt,name=issue_client_certificate,json=issueClientCertificate,proto3" json:"issue_client_certificate,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ClientCertificateConfig) Reset()         { *m = ClientCertificateConfig{} }
func (m *ClientCertificateConfig) String() string { return proto.CompactTextString(m) }
func (*ClientCertificateConfig) ProtoMessage()    {}
func (*ClientCertificateConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{2}
}

func (m *ClientCertificateConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientCertificateConfig.Unmarshal(m, b)
}
func (m *ClientCertificateConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientCertificateConfig.Marshal(b, m, deterministic)
}
func (m *ClientCertificateConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientCertificateConfig.Merge(m, src)
}
func (m *ClientCertificateConfig) XXX_Size() int {
	return xxx_messageInfo_ClientCertificateConfig.Size(m)
}
func (m *ClientCertificateConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientCertificateConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClientCertificateConfig proto.InternalMessageInfo

func (m *ClientCertificateConfig) GetIssueClientCertificate() bool {
	if m != nil {
		return m.IssueClientCertificate
	}
	return false
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing,proto3" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling,proto3" json:"horizontal_pod_autoscaling,omitempty"`
	// Configuration for the Kubernetes Dashboard.
	KubernetesDashboard *KubernetesDashboard `protobuf:"bytes,3,opt,name=kubernetes_dashboard,json=kubernetesDashboard,proto3" json:"kubernetes_dashboard,omitempty"`
	// Configuration for NetworkPolicy. This only tracks whether the addon
	// is enabled or not on the Master, it does not track whether network policy
	// is enabled for the nodes.
	NetworkPolicyConfig  *NetworkPolicyConfig `protobuf:"bytes,4,opt,name=network_policy_config,json=networkPolicyConfig,proto3" json:"network_policy_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *AddonsConfig) Reset()         { *m = AddonsConfig{} }
func (m *AddonsConfig) String() string { return proto.CompactTextString(m) }
func (*AddonsConfig) ProtoMessage()    {}
func (*AddonsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{3}
}

func (m *AddonsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddonsConfig.Unmarshal(m, b)
}
func (m *AddonsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddonsConfig.Marshal(b, m, deterministic)
}
func (m *AddonsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddonsConfig.Merge(m, src)
}
func (m *AddonsConfig) XXX_Size() int {
	return xxx_messageInfo_AddonsConfig.Size(m)
}
func (m *AddonsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AddonsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AddonsConfig proto.InternalMessageInfo

func (m *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if m != nil {
		return m.HttpLoadBalancing
	}
	return nil
}

func (m *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if m != nil {
		return m.HorizontalPodAutoscaling
	}
	return nil
}

func (m *AddonsConfig) GetKubernetesDashboard() *KubernetesDashboard {
	if m != nil {
		return m.KubernetesDashboard
	}
	return nil
}

func (m *AddonsConfig) GetNetworkPolicyConfig() *NetworkPolicyConfig {
	if m != nil {
		return m.NetworkPolicyConfig
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HttpLoadBalancing) Reset()         { *m = HttpLoadBalancing{} }
func (m *HttpLoadBalancing) String() string { return proto.CompactTextString(m) }
func (*HttpLoadBalancing) ProtoMessage()    {}
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{4}
}

func (m *HttpLoadBalancing) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HttpLoadBalancing.Unmarshal(m, b)
}
func (m *HttpLoadBalancing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HttpLoadBalancing.Marshal(b, m, deterministic)
}
func (m *HttpLoadBalancing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpLoadBalancing.Merge(m, src)
}
func (m *HttpLoadBalancing) XXX_Size() int {
	return xxx_messageInfo_HttpLoadBalancing.Size(m)
}
func (m *HttpLoadBalancing) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpLoadBalancing.DiscardUnknown(m)
}

var xxx_messageInfo_HttpLoadBalancing proto.InternalMessageInfo

func (m *HttpLoadBalancing) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that a Heapster pod is running in the cluster,
	// which is also used by the Cloud Monitoring service.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HorizontalPodAutoscaling) Reset()         { *m = HorizontalPodAutoscaling{} }
func (m *HorizontalPodAutoscaling) String() string { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaling) ProtoMessage()    {}
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{5}
}

func (m *HorizontalPodAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HorizontalPodAutoscaling.Unmarshal(m, b)
}
func (m *HorizontalPodAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HorizontalPodAutoscaling.Marshal(b, m, deterministic)
}
func (m *HorizontalPodAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HorizontalPodAutoscaling.Merge(m, src)
}
func (m *HorizontalPodAutoscaling) XXX_Size() int {
	return xxx_messageInfo_HorizontalPodAutoscaling.Size(m)
}
func (m *HorizontalPodAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_HorizontalPodAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_HorizontalPodAutoscaling proto.InternalMessageInfo

func (m *HorizontalPodAutoscaling) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	// Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KubernetesDashboard) Reset()         { *m = KubernetesDashboard{} }
func (m *KubernetesDashboard) String() string { return proto.CompactTextString(m) }
func (*KubernetesDashboard) ProtoMessage()    {}
func (*KubernetesDashboard) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{6}
}

func (m *KubernetesDashboard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KubernetesDashboard.Unmarshal(m, b)
}
func (m *KubernetesDashboard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KubernetesDashboard.Marshal(b, m, deterministic)
}
func (m *KubernetesDashboard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubernetesDashboard.Merge(m, src)
}
func (m *KubernetesDashboard) XXX_Size() int {
	return xxx_messageInfo_KubernetesDashboard.Size(m)
}
func (m *KubernetesDashboard) XXX_DiscardUnknown() {
	xxx_messageInfo_KubernetesDashboard.DiscardUnknown(m)
}

var xxx_messageInfo_KubernetesDashboard proto.InternalMessageInfo

func (m *KubernetesDashboard) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for NetworkPolicy. This only tracks whether the addon
// is enabled or not on the Master, it does not track whether network policy
// is enabled for the nodes.
type NetworkPolicyConfig struct {
	// Whether NetworkPolicy is enabled for this cluster.
	Disabled             bool     `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkPolicyConfig) Reset()         { *m = NetworkPolicyConfig{} }
func (m *NetworkPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyConfig) ProtoMessage()    {}
func (*NetworkPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{7}
}

func (m *NetworkPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkPolicyConfig.Unmarshal(m, b)
}
func (m *NetworkPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkPolicyConfig.Marshal(b, m, deterministic)
}
func (m *NetworkPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyConfig.Merge(m, src)
}
func (m *NetworkPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_NetworkPolicyConfig.Size(m)
}
func (m *NetworkPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyConfig proto.InternalMessageInfo

func (m *NetworkPolicyConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for private clusters.
type PrivateClusterConfig struct {
	// Whether nodes have internal IP addresses only. If enabled, all nodes are
	// given only RFC 1918 private addresses and communicate with the master via
	// private networking.
	EnablePrivateNodes bool `protobuf:"varint,1,opt,name=enable_private_nodes,json=enablePrivateNodes,proto3" json:"enable_private_nodes,omitempty"`
	// Whether the master's internal IP address is used as the cluster endpoint.
	EnablePrivateEndpoint bool `protobuf:"varint,2,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// The IP range in CIDR notation to use for the hosted master network. This
	// range will be used for assigning internal IP addresses to the master or
	// set of masters, as well as the ILB VIP. This range must not overlap with
	// any other ranges in use within the cluster's network.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Output only. The internal IP address of this cluster's master endpoint.
	PrivateEndpoint string `protobuf:"bytes,4,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Output only. The external IP address of this cluster's master endpoint.
	PublicEndpoint       string   `protobuf:"bytes,5,opt,name=public_endpoint,json=publicEndpoint,proto3" json:"public_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrivateClusterConfig) Reset()         { *m = PrivateClusterConfig{} }
func (m *PrivateClusterConfig) String() string { return proto.CompactTextString(m) }
func (*PrivateClusterConfig) ProtoMessage()    {}
func (*PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{8}
}

func (m *PrivateClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrivateClusterConfig.Unmarshal(m, b)
}
func (m *PrivateClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrivateClusterConfig.Marshal(b, m, deterministic)
}
func (m *PrivateClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrivateClusterConfig.Merge(m, src)
}
func (m *PrivateClusterConfig) XXX_Size() int {
	return xxx_messageInfo_PrivateClusterConfig.Size(m)
}
func (m *PrivateClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PrivateClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PrivateClusterConfig proto.InternalMessageInfo

func (m *PrivateClusterConfig) GetEnablePrivateNodes() bool {
	if m != nil {
		return m.EnablePrivateNodes
	}
	return false
}

func (m *PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if m != nil {
		return m.EnablePrivateEndpoint
	}
	return false
}

func (m *PrivateClusterConfig) GetMasterIpv4CidrBlock() string {
	if m != nil {
		return m.MasterIpv4CidrBlock
	}
	return ""
}

func (m *PrivateClusterConfig) GetPrivateEndpoint() string {
	if m != nil {
		return m.PrivateEndpoint
	}
	return ""
}

func (m *PrivateClusterConfig) GetPublicEndpoint() string {
	if m != nil {
		return m.PublicEndpoint
	}
	return ""
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	// Whether or not master authorized networks is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// cidr_blocks define up to 10 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks           []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *MasterAuthorizedNetworksConfig) Reset()         { *m = MasterAuthorizedNetworksConfig{} }
func (m *MasterAuthorizedNetworksConfig) String() string { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig) ProtoMessage()    {}
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{9}
}

func (m *MasterAuthorizedNetworksConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Unmarshal(m, b)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Marshal(b, m, deterministic)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuthorizedNetworksConfig.Merge(m, src)
}
func (m *MasterAuthorizedNetworksConfig) XXX_Size() int {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig.Size(m)
}
func (m *MasterAuthorizedNetworksConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuthorizedNetworksConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuthorizedNetworksConfig proto.InternalMessageInfo

func (m *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if m != nil {
		return m.CidrBlocks
	}
	return nil
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	// display_name is an optional field for users to identify CIDR blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// cidr_block must be specified in CIDR notation.
	CidrBlock            string   `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*m = MasterAuthorizedNetworksConfig_CidrBlock{}
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) String() string { return proto.CompactTextString(m) }
func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage()    {}
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{9, 0}
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Unmarshal(m, b)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Marshal(b, m, deterministic)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Merge(m, src)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_Size() int {
	return xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.Size(m)
}
func (m *MasterAuthorizedNetworksConfig_CidrBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuthorizedNetworksConfig_CidrBlock proto.InternalMessageInfo

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if m != nil {
		return m.CidrBlock
	}
	return ""
}

// Configuration for the legacy Attribute Based Access Control authorization
// mode.
type LegacyAbac struct {
	// Whether the ABAC authorizer is enabled for this cluster. When enabled,
	// identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those
	// provided by the RBAC configuration or IAM.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LegacyAbac) Reset()         { *m = LegacyAbac{} }
func (m *LegacyAbac) String() string { return proto.CompactTextString(m) }
func (*LegacyAbac) ProtoMessage()    {}
func (*LegacyAbac) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{10}
}

func (m *LegacyAbac) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LegacyAbac.Unmarshal(m, b)
}
func (m *LegacyAbac) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LegacyAbac.Marshal(b, m, deterministic)
}
func (m *LegacyAbac) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LegacyAbac.Merge(m, src)
}
func (m *LegacyAbac) XXX_Size() int {
	return xxx_messageInfo_LegacyAbac.Size(m)
}
func (m *LegacyAbac) XXX_DiscardUnknown() {
	xxx_messageInfo_LegacyAbac.DiscardUnknown(m)
}

var xxx_messageInfo_LegacyAbac proto.InternalMessageInfo

func (m *LegacyAbac) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	// The selected network policy provider.
	Provider NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.container.v1.NetworkPolicy_Provider" json:"provider,omitempty"`
	// Whether network policy is enabled on the cluster.
	Enabled              bool     `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkPolicy) Reset()         { *m = NetworkPolicy{} }
func (m *NetworkPolicy) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicy) ProtoMessage()    {}
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{11}
}

func (m *NetworkPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkPolicy.Unmarshal(m, b)
}
func (m *NetworkPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkPolicy.Marshal(b, m, deterministic)
}
func (m *NetworkPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicy.Merge(m, src)
}
func (m *NetworkPolicy) XXX_Size() int {
	return xxx_messageInfo_NetworkPolicy.Size(m)
}
func (m *NetworkPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicy proto.InternalMessageInfo

func (m *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if m != nil {
		return m.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

func (m *NetworkPolicy) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Configuration for controlling how IPs are allocated in the cluster.
type IPAllocationPolicy struct {
	// Whether alias IPs will be used for pod IPs in the cluster.
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases,proto3" json:"use_ip_aliases,omitempty"`
	// Whether a new subnetwork will be created automatically for the cluster.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `protobuf:"varint,2,opt,name=create_subnetwork,json=createSubnetwork,proto3" json:"create_subnetwork,omitempty"`
	// A custom subnetwork name to be used if `create_subnetwork` is true.  If
	// this field is empty, then an automatic name will be chosen for the new
	// subnetwork.
	SubnetworkName string `protobuf:"bytes,3,opt,name=subnetwork_name,json=subnetworkName,proto3" json:"subnetwork_name,omitempty"`
	// This field is deprecated, use cluster_ipv4_cidr_block.
	ClusterIpv4Cidr string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// This field is deprecated, use node_ipv4_cidr_block.
	NodeIpv4Cidr string `protobuf:"bytes,5,opt,name=node_ipv4_cidr,json=nodeIpv4Cidr,proto3" json:"node_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// This field is deprecated, use services_ipv4_cidr_block.
	ServicesIpv4Cidr string `protobuf:"bytes,6,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"` // Deprecated: Do not use.
	// The name of the secondary range to be used for the cluster CIDR
	// block.  The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases is true and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `protobuf:"bytes,7,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName,proto3" json:"cluster_secondary_range_name,omitempty"`
	// The name of the secondary range to be used as for the services
	// CIDR block.  The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases is true and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `protobuf:"bytes,8,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName,proto3" json:"services_secondary_range_name,omitempty"`
	// The IP address range for the cluster pod IPs. If this field is set, then
	// `cluster.cluster_ipv4_cidr` must be left blank.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3" json:"cluster_ipv4_cidr_block,omitempty"`
	// The IP address range of the instance IPs in this cluster.
	//
	// This is applicable only if `create_subnetwork` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	NodeIpv4CidrBlock string `protobuf:"bytes,10,opt,name=node_ipv4_cidr_block,json=nodeIpv4CidrBlock,proto3" json:"node_ipv4_cidr_block,omitempty"`
	// The IP address range of the services IPs in this cluster. If blank, a range
	// will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string   `protobuf:"bytes,11,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock,proto3" json:"services_ipv4_cidr_block,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *IPAllocationPolicy) Reset()         { *m = IPAllocationPolicy{} }
func (m *IPAllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*IPAllocationPolicy) ProtoMessage()    {}
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{12}
}

func (m *IPAllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IPAllocationPolicy.Unmarshal(m, b)
}
func (m *IPAllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IPAllocationPolicy.Marshal(b, m, deterministic)
}
func (m *IPAllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAllocationPolicy.Merge(m, src)
}
func (m *IPAllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_IPAllocationPolicy.Size(m)
}
func (m *IPAllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_IPAllocationPolicy proto.InternalMessageInfo

func (m *IPAllocationPolicy) GetUseIpAliases() bool {
	if m != nil {
		return m.UseIpAliases
	}
	return false
}

func (m *IPAllocationPolicy) GetCreateSubnetwork() bool {
	if m != nil {
		return m.CreateSubnetwork
	}
	return false
}

func (m *IPAllocationPolicy) GetSubnetworkName() string {
	if m != nil {
		return m.SubnetworkName
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetNodeIpv4Cidr() string {
	if m != nil {
		return m.NodeIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *IPAllocationPolicy) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if m != nil {
		return m.ClusterSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if m != nil {
		return m.ServicesSecondaryRangeName
	}
	return ""
}

func (m *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if m != nil {
		return m.ClusterIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetNodeIpv4CidrBlock() string {
	if m != nil {
		return m.NodeIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if m != nil {
		return m.ServicesIpv4CidrBlock
	}
	return ""
}

// A Google Kubernetes Engine cluster.
type Cluster struct {
	// The name of this cluster. The name must be unique within this project
	// and zone, and can be up to 40 characters with the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// See `nodeConfig` for the description of its properties.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool.
	//
	// If unspecified, the defaults are used.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth,proto3" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com` - the Google Cloud Logging service.
	// * `none` - no logs will be exported from the cluster.
	// * if left as an empty string,`logging.googleapis.com` will be used.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
	// * `none` - no metrics will be exported from the cluster.
	// * if left as an empty string, `monitoring.googleapis.com` will be used.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// cluster is connected. If left unspecified, the `default` network
	// will be used.
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](/compute/docs/subnetworks) to which the
	// cluster is connected.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1alpha1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha,proto3" json:"enable_kubernetes_alpha,omitempty"`
	// The resource labels for the cluster to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,15,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `protobuf:"bytes,16,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `protobuf:"bytes,18,opt,name=legacy_abac,json=legacyAbac,proto3" json:"legacy_abac,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,19,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,20,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// The configuration options for master authorized networks feature.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,22,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
	// Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,23,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Configuration for cluster networking.
	NetworkConfig *NetworkConfig `protobuf:"bytes,27,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Configuration for private cluster.
	PrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,37,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,101,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "","-": picks the default Kubernetes version
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion,proto3" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion,proto3" json:"current_master_version,omitempty"`
	// [Output only] Deprecated, use
	// [NodePool.version](/kubernetes-engine/docs/reference/rest/v1/projects.zones.clusters.nodePool)
	// instead. The current version of the node software components. If they are
	// currently at multiple versions because they're in the process of being
	// upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion,proto3" json:"current_node_version,omitempty"` // Deprecated: Do not use.
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,proto3,enum=google.container.v1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// cluster, if available.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize,proto3" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// Deprecated. Use node_pools.instance_group_urls.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"` // Deprecated: Do not use.
	// [Output only] The number of nodes currently in the cluster.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount,proto3" json:"current_node_count,omitempty"`
	// [Output only] The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location             string   `protobuf:"bytes,114,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{13}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *Cluster) GetNodeConfig() *NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Cluster) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Cluster) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *Cluster) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *Cluster) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *Cluster) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *Cluster) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *Cluster) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

func (m *Cluster) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Cluster) GetEnableKubernetesAlpha() bool {
	if m != nil {
		return m.EnableKubernetesAlpha
	}
	return false
}

func (m *Cluster) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *Cluster) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *Cluster) GetLegacyAbac() *LegacyAbac {
	if m != nil {
		return m.LegacyAbac
	}
	return nil
}

func (m *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if m != nil {
		return m.IpAllocationPolicy
	}
	return nil
}

func (m *Cluster) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *Cluster) GetNetworkConfig() *NetworkConfig {
	if m != nil {
		return m.NetworkConfig
	}
	return nil
}

func (m *Cluster) GetPrivateClusterConfig() *PrivateClusterConfig {
	if m != nil {
		return m.PrivateClusterConfig
	}
	return nil
}

func (m *Cluster) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Cluster) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Cluster) GetInitialClusterVersion() string {
	if m != nil {
		return m.InitialClusterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentMasterVersion() string {
	if m != nil {
		return m.CurrentMasterVersion
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetCurrentNodeVersion() string {
	if m != nil {
		return m.CurrentNodeVersion
	}
	return ""
}

func (m *Cluster) GetCreateTime() string {
	if m != nil {
		return m.CreateTime
	}
	return ""
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

func (m *Cluster) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Cluster) GetNodeIpv4CidrSize() int32 {
	if m != nil {
		return m.NodeIpv4CidrSize
	}
	return 0
}

func (m *Cluster) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (m *Cluster) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *Cluster) GetCurrentNodeCount() int32 {
	if m != nil {
		return m.CurrentNodeCount
	}
	return 0
}

func (m *Cluster) GetExpireTime() string {
	if m != nil {
		return m.ExpireTime
	}
	return ""
}

func (m *Cluster) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	// The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion,proto3" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService,proto3" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig,proto3" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family" or
	// "desired_node_pool_autoscaling" is specified and there is more than one
	// node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId,proto3" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType,proto3" json:"desired_image_type,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling,proto3" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations,proto3" json:"desired_locations,omitempty"`
	// The desired configuration options for master authorized networks feature.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,12,opt,name=desired_master_authorized_networks_config,json=desiredMasterAuthorizedNetworksConfig,proto3" json:"desired_master_authorized_networks_config,omitempty"`
	// The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	DesiredMasterVersion string   `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion,proto3" json:"desired_master_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterUpdate) Reset()         { *m = ClusterUpdate{} }
func (m *ClusterUpdate) String() string { return proto.CompactTextString(m) }
func (*ClusterUpdate) ProtoMessage()    {}
func (*ClusterUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{14}
}

func (m *ClusterUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterUpdate.Unmarshal(m, b)
}
func (m *ClusterUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterUpdate.Marshal(b, m, deterministic)
}
func (m *ClusterUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterUpdate.Merge(m, src)
}
func (m *ClusterUpdate) XXX_Size() int {
	return xxx_messageInfo_ClusterUpdate.Size(m)
}
func (m *ClusterUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterUpdate proto.InternalMessageInfo

func (m *ClusterUpdate) GetDesiredNodeVersion() string {
	if m != nil {
		return m.DesiredNodeVersion
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredMonitoringService() string {
	if m != nil {
		return m.DesiredMonitoringService
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.DesiredAddonsConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredNodePoolId() string {
	if m != nil {
		return m.DesiredNodePoolId
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredImageType() string {
	if m != nil {
		return m.DesiredImageType
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.DesiredNodePoolAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredLocations() []string {
	if m != nil {
		return m.DesiredLocations
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if m != nil {
		return m.DesiredMasterAuthorizedNetworksConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterVersion() string {
	if m != nil {
		return m.DesiredMasterVersion
	}
	return ""
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation
	// is taking place.
	// This field is deprecated, use location instead.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.container.v1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,proto3,enum=google.container.v1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail,proto3" json:"detail,omitempty"`
	// If an error has occurred, a textual description of the error.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/regions-zones/regions-zones#available) or
	// [region](/compute/docs/regions-zones/regions-zones#available) in which
	// the cluster resides.
	Location string `protobuf:"bytes,9,opt,name=location,proto3" json:"location,omitempty"`
	// [Output only] The time the operation started, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `protobuf:"bytes,10,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] The time the operation completed, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime              string   `protobuf:"bytes,11,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{15}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *Operation) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Operation) GetOperationType() Operation_Type {
	if m != nil {
		return m.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (m *Operation) GetStatus() Operation_Status {
	if m != nil {
		return m.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (m *Operation) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *Operation) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Operation) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Operation) GetTargetLink() string {
	if m != nil {
		return m.TargetLink
	}
	return ""
}

func (m *Operation) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Operation) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *Operation) GetEndTime() string {
	if m != nil {
		return m.EndTime
	}
	return ""
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// A [cluster
	// resource](/container-engine/reference/rest/v1/projects.zones.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The parent (project and location) where the cluster will be created.
	// Specified in the format 'projects/*/locations/*'.
	Parent               string   `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{16}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to retrieve.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{17}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{18}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateNodePoolRequests update a node pool's image and/or version.
type UpdateNodePoolRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	NodeVersion string `protobuf:"bytes,5,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// The desired image type for the node pool.
	ImageType string `protobuf:"bytes,6,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to
	// update. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNodePoolRequest) Reset()         { *m = UpdateNodePoolRequest{} }
func (m *UpdateNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNodePoolRequest) ProtoMessage()    {}
func (*UpdateNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{19}
}

func (m *UpdateNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNodePoolRequest.Unmarshal(m, b)
}
func (m *UpdateNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNodePoolRequest.Merge(m, src)
}
func (m *UpdateNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNodePoolRequest.Size(m)
}
func (m *UpdateNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetNodeVersion() string {
	if m != nil {
		return m.NodeVersion
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *UpdateNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,5,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to set
	// autoscaler settings. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolAutoscalingRequest) Reset()         { *m = SetNodePoolAutoscalingRequest{} }
func (m *SetNodePoolAutoscalingRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolAutoscalingRequest) ProtoMessage()    {}
func (*SetNodePoolAutoscalingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{20}
}

func (m *SetNodePoolAutoscalingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Unmarshal(m, b)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolAutoscalingRequest.Merge(m, src)
}
func (m *SetNodePoolAutoscalingRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolAutoscalingRequest.Size(m)
}
func (m *SetNodePoolAutoscalingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolAutoscalingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolAutoscalingRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolAutoscalingRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolAutoscalingRequest) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *SetNodePoolAutoscalingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLoggingServiceRequest sets the logging service of a cluster.
type SetLoggingServiceRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The logging service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "logging.googleapis.com" - the Google Cloud Logging service
	// * "none" - no metrics will be exported from the cluster
	LoggingService string `protobuf:"bytes,4,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLoggingServiceRequest) Reset()         { *m = SetLoggingServiceRequest{} }
func (m *SetLoggingServiceRequest) String() string { return proto.CompactTextString(m) }
func (*SetLoggingServiceRequest) ProtoMessage()    {}
func (*SetLoggingServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{21}
}

func (m *SetLoggingServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLoggingServiceRequest.Unmarshal(m, b)
}
func (m *SetLoggingServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLoggingServiceRequest.Marshal(b, m, deterministic)
}
func (m *SetLoggingServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLoggingServiceRequest.Merge(m, src)
}
func (m *SetLoggingServiceRequest) XXX_Size() int {
	return xxx_messageInfo_SetLoggingServiceRequest.Size(m)
}
func (m *SetLoggingServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLoggingServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLoggingServiceRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLoggingServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLoggingServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *SetLoggingServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMonitoringServiceRequest sets the monitoring service of a cluster.
type SetMonitoringServiceRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	MonitoringService string `protobuf:"bytes,4,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set monitoring.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMonitoringServiceRequest) Reset()         { *m = SetMonitoringServiceRequest{} }
func (m *SetMonitoringServiceRequest) String() string { return proto.CompactTextString(m) }
func (*SetMonitoringServiceRequest) ProtoMessage()    {}
func (*SetMonitoringServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{22}
}

func (m *SetMonitoringServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMonitoringServiceRequest.Unmarshal(m, b)
}
func (m *SetMonitoringServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMonitoringServiceRequest.Marshal(b, m, deterministic)
}
func (m *SetMonitoringServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMonitoringServiceRequest.Merge(m, src)
}
func (m *SetMonitoringServiceRequest) XXX_Size() int {
	return xxx_messageInfo_SetMonitoringServiceRequest.Size(m)
}
func (m *SetMonitoringServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMonitoringServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMonitoringServiceRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMonitoringServiceRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *SetMonitoringServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetAddonsConfigRequest sets the addons associated with the cluster.
type SetAddonsConfigRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The desired configurations for the various addons available to run in the
	// cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,4,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetAddonsConfigRequest) Reset()         { *m = SetAddonsConfigRequest{} }
func (m *SetAddonsConfigRequest) String() string { return proto.CompactTextString(m) }
func (*SetAddonsConfigRequest) ProtoMessage()    {}
func (*SetAddonsConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{23}
}

func (m *SetAddonsConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetAddonsConfigRequest.Unmarshal(m, b)
}
func (m *SetAddonsConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetAddonsConfigRequest.Marshal(b, m, deterministic)
}
func (m *SetAddonsConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetAddonsConfigRequest.Merge(m, src)
}
func (m *SetAddonsConfigRequest) XXX_Size() int {
	return xxx_messageInfo_SetAddonsConfigRequest.Size(m)
}
func (m *SetAddonsConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetAddonsConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetAddonsConfigRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetAddonsConfigRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetAddonsConfigRequest) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *SetAddonsConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The desired list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	Locations []string `protobuf:"bytes,4,rep,name=locations,proto3" json:"locations,omitempty"`
	// The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLocationsRequest) Reset()         { *m = SetLocationsRequest{} }
func (m *SetLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*SetLocationsRequest) ProtoMessage()    {}
func (*SetLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{24}
}

func (m *SetLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLocationsRequest.Unmarshal(m, b)
}
func (m *SetLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLocationsRequest.Marshal(b, m, deterministic)
}
func (m *SetLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLocationsRequest.Merge(m, src)
}
func (m *SetLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_SetLocationsRequest.Size(m)
}
func (m *SetLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLocationsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLocationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLocationsRequest) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *SetLocationsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	MasterVersion string `protobuf:"bytes,4,opt,name=master_version,json=masterVersion,proto3" json:"master_version,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateMasterRequest) Reset()         { *m = UpdateMasterRequest{} }
func (m *UpdateMasterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateMasterRequest) ProtoMessage()    {}
func (*UpdateMasterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{25}
}

func (m *UpdateMasterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMasterRequest.Unmarshal(m, b)
}
func (m *UpdateMasterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMasterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateMasterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMasterRequest.Merge(m, src)
}
func (m *UpdateMasterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateMasterRequest.Size(m)
}
func (m *UpdateMasterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMasterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMasterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *UpdateMasterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateMasterRequest) GetMasterVersion() string {
	if m != nil {
		return m.MasterVersion
	}
	return ""
}

func (m *UpdateMasterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The exact form of action to be taken on the master auth.
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,proto3,enum=google.container.v1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMasterAuthRequest) Reset()         { *m = SetMasterAuthRequest{} }
func (m *SetMasterAuthRequest) String() string { return proto.CompactTextString(m) }
func (*SetMasterAuthRequest) ProtoMessage()    {}
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{26}
}

func (m *SetMasterAuthRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMasterAuthRequest.Unmarshal(m, b)
}
func (m *SetMasterAuthRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMasterAuthRequest.Marshal(b, m, deterministic)
}
func (m *SetMasterAuthRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMasterAuthRequest.Merge(m, src)
}
func (m *SetMasterAuthRequest) XXX_Size() int {
	return xxx_messageInfo_SetMasterAuthRequest.Size(m)
}
func (m *SetMasterAuthRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMasterAuthRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMasterAuthRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetMasterAuthRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if m != nil {
		return m.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (m *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *SetMasterAuthRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to delete.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster) of the cluster to delete.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{27}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides, or "-" for all zones.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The parent (project and location) where the clusters will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent               string   `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{28}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListClustersRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones         []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{29}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, operation id) of the operation to get.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOperationRequest) Reset()         { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()    {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{30}
}

func (m *GetOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOperationRequest.Unmarshal(m, b)
}
func (m *GetOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOperationRequest.Marshal(b, m, deterministic)
}
func (m *GetOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOperationRequest.Merge(m, src)
}
func (m *GetOperationRequest) XXX_Size() int {
	return xxx_messageInfo_GetOperationRequest.Size(m)
}
func (m *GetOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOperationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *GetOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) to return operations for, or `-` for
	// all zones. This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The parent (project and location) where the operations will be listed.
	// Specified in the format 'projects/*/locations/*'.
	// Location "-" matches all zones and all regions.
	Parent               string   `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsRequest) Reset()         { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()    {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{31}
}

func (m *ListOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsRequest.Unmarshal(m, b)
}
func (m *ListOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsRequest.Merge(m, src)
}
func (m *ListOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListOperationsRequest.Size(m)
}
func (m *ListOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListOperationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListOperationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListOperationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, operation id) of the operation to cancel.
	// Specified in the format 'projects/*/locations/*/operations/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelOperationRequest) Reset()         { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()    {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{32}
}

func (m *CancelOperationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelOperationRequest.Unmarshal(m, b)
}
func (m *CancelOperationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelOperationRequest.Marshal(b, m, deterministic)
}
func (m *CancelOperationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelOperationRequest.Merge(m, src)
}
func (m *CancelOperationRequest) XXX_Size() int {
	return xxx_messageInfo_CancelOperationRequest.Size(m)
}
func (m *CancelOperationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelOperationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelOperationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CancelOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CancelOperationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones         []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOperationsResponse) Reset()         { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()    {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{33}
}

func (m *ListOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOperationsResponse.Unmarshal(m, b)
}
func (m *ListOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOperationsResponse.Merge(m, src)
}
func (m *ListOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListOperationsResponse.Size(m)
}
func (m *ListOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOperationsResponse proto.InternalMessageInfo

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListOperationsResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// Gets the current Kubernetes Engine service configuration.
type GetServerConfigRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) to return operations for.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// The name (project and location) of the server config to get
	// Specified in the format 'projects/*/locations/*'.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServerConfigRequest) Reset()         { *m = GetServerConfigRequest{} }
func (m *GetServerConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetServerConfigRequest) ProtoMessage()    {}
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{34}
}

func (m *GetServerConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServerConfigRequest.Unmarshal(m, b)
}
func (m *GetServerConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServerConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetServerConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServerConfigRequest.Merge(m, src)
}
func (m *GetServerConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetServerConfigRequest.Size(m)
}
func (m *GetServerConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServerConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServerConfigRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetServerConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetServerConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetServerConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Kubernetes Engine service configuration.
type ServerConfig struct {
	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion,proto3" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions,proto3" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType,proto3" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes,proto3" json:"valid_image_types,omitempty"`
	// List of valid master versions.
	ValidMasterVersions  []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions,proto3" json:"valid_master_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerConfig) Reset()         { *m = ServerConfig{} }
func (m *ServerConfig) String() string { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()    {}
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{35}
}

func (m *ServerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerConfig.Unmarshal(m, b)
}
func (m *ServerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerConfig.Marshal(b, m, deterministic)
}
func (m *ServerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerConfig.Merge(m, src)
}
func (m *ServerConfig) XXX_Size() int {
	return xxx_messageInfo_ServerConfig.Size(m)
}
func (m *ServerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ServerConfig proto.InternalMessageInfo

func (m *ServerConfig) GetDefaultClusterVersion() string {
	if m != nil {
		return m.DefaultClusterVersion
	}
	return ""
}

func (m *ServerConfig) GetValidNodeVersions() []string {
	if m != nil {
		return m.ValidNodeVersions
	}
	return nil
}

func (m *ServerConfig) GetDefaultImageType() string {
	if m != nil {
		return m.DefaultImageType
	}
	return ""
}

func (m *ServerConfig) GetValidImageTypes() []string {
	if m != nil {
		return m.ValidImageTypes
	}
	return nil
}

func (m *ServerConfig) GetValidMasterVersions() []string {
	if m != nil {
		return m.ValidMasterVersions
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool,proto3" json:"node_pool,omitempty"`
	// The parent (project, location, cluster id) where the node pool will be
	// created. Specified in the format
	// 'projects/*/locations/*/clusters/*'.
	Parent               string   `protobuf:"bytes,6,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNodePoolRequest) Reset()         { *m = CreateNodePoolRequest{} }
func (m *CreateNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNodePoolRequest) ProtoMessage()    {}
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{36}
}

func (m *CreateNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNodePoolRequest.Unmarshal(m, b)
}
func (m *CreateNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *CreateNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNodePoolRequest.Merge(m, src)
}
func (m *CreateNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNodePoolRequest.Size(m)
}
func (m *CreateNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CreateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetNodePool() *NodePool {
	if m != nil {
		return m.NodePool
	}
	return nil
}

func (m *CreateNodePoolRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to delete.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node pool to
	// delete. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNodePoolRequest) Reset()         { *m = DeleteNodePoolRequest{} }
func (m *DeleteNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNodePoolRequest) ProtoMessage()    {}
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{37}
}

func (m *DeleteNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNodePoolRequest.Unmarshal(m, b)
}
func (m *DeleteNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNodePoolRequest.Merge(m, src)
}
func (m *DeleteNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNodePoolRequest.Size(m)
}
func (m *DeleteNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *DeleteNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the parent field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The parent (project, location, cluster id) where the node pools will be
	// listed. Specified in the format 'projects/*/locations/*/clusters/*'.
	Parent               string   `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodePoolsRequest) Reset()         { *m = ListNodePoolsRequest{} }
func (m *ListNodePoolsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNodePoolsRequest) ProtoMessage()    {}
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{38}
}

func (m *ListNodePoolsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodePoolsRequest.Unmarshal(m, b)
}
func (m *ListNodePoolsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodePoolsRequest.Marshal(b, m, deterministic)
}
func (m *ListNodePoolsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodePoolsRequest.Merge(m, src)
}
func (m *ListNodePoolsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNodePoolsRequest.Size(m)
}
func (m *ListNodePoolsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodePoolsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodePoolsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListNodePoolsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListNodePoolsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node pool to
	// get. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNodePoolRequest) Reset()         { *m = GetNodePoolRequest{} }
func (m *GetNodePoolRequest) String() string { return proto.CompactTextString(m) }
func (*GetNodePoolRequest) ProtoMessage()    {}
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{39}
}

func (m *GetNodePoolRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNodePoolRequest.Unmarshal(m, b)
}
func (m *GetNodePoolRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNodePoolRequest.Marshal(b, m, deterministic)
}
func (m *GetNodePoolRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNodePoolRequest.Merge(m, src)
}
func (m *GetNodePoolRequest) XXX_Size() int {
	return xxx_messageInfo_GetNodePoolRequest.Size(m)
}
func (m *GetNodePoolRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNodePoolRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNodePoolRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *GetNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *GetNodePoolRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The version of the Kubernetes of this node.
	Version string `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	// [Output only] The resource URLs of the [managed instance
	// groups](/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with this node pool.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// [Output only] The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,proto3,enum=google.container.v1.NodePool_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// node pool instance, if available.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management           *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *NodePool) Reset()         { *m = NodePool{} }
func (m *NodePool) String() string { return proto.CompactTextString(m) }
func (*NodePool) ProtoMessage()    {}
func (*NodePool) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{40}
}

func (m *NodePool) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePool.Unmarshal(m, b)
}
func (m *NodePool) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePool.Marshal(b, m, deterministic)
}
func (m *NodePool) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePool.Merge(m, src)
}
func (m *NodePool) XXX_Size() int {
	return xxx_messageInfo_NodePool.Size(m)
}
func (m *NodePool) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePool.DiscardUnknown(m)
}

var xxx_messageInfo_NodePool proto.InternalMessageInfo

func (m *NodePool) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodePool) GetConfig() *NodeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NodePool) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *NodePool) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *NodePool) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *NodePool) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *NodePool) GetStatus() NodePool_Status {
	if m != nil {
		return m.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

func (m *NodePool) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *NodePool) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	// A flag that specifies whether node auto-upgrade is enabled for the node
	// pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
	// up to date with the latest release version of Kubernetes.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// A flag that specifies whether the node auto-repair is enabled for the node
	// pool. If enabled, the nodes in this node pool will be monitored and, if
	// they fail health checks too many times, an automatic repair action will be
	// triggered.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions       *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions,proto3" json:"upgrade_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NodeManagement) Reset()         { *m = NodeManagement{} }
func (m *NodeManagement) String() string { return proto.CompactTextString(m) }
func (*NodeManagement) ProtoMessage()    {}
func (*NodeManagement) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{41}
}

func (m *NodeManagement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeManagement.Unmarshal(m, b)
}
func (m *NodeManagement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeManagement.Marshal(b, m, deterministic)
}
func (m *NodeManagement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeManagement.Merge(m, src)
}
func (m *NodeManagement) XXX_Size() int {
	return xxx_messageInfo_NodeManagement.Size(m)
}
func (m *NodeManagement) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeManagement.DiscardUnknown(m)
}

var xxx_messageInfo_NodeManagement proto.InternalMessageInfo

func (m *NodeManagement) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *NodeManagement) GetAutoRepair() bool {
	if m != nil {
		return m.AutoRepair
	}
	return false
}

func (m *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if m != nil {
		return m.UpgradeOptions
	}
	return nil
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	// [Output only] This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime,proto3" json:"auto_upgrade_start_time,omitempty"`
	// [Output only] This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoUpgradeOptions) Reset()         { *m = AutoUpgradeOptions{} }
func (m *AutoUpgradeOptions) String() string { return proto.CompactTextString(m) }
func (*AutoUpgradeOptions) ProtoMessage()    {}
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{42}
}

func (m *AutoUpgradeOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoUpgradeOptions.Unmarshal(m, b)
}
func (m *AutoUpgradeOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoUpgradeOptions.Marshal(b, m, deterministic)
}
func (m *AutoUpgradeOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoUpgradeOptions.Merge(m, src)
}
func (m *AutoUpgradeOptions) XXX_Size() int {
	return xxx_messageInfo_AutoUpgradeOptions.Size(m)
}
func (m *AutoUpgradeOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoUpgradeOptions.DiscardUnknown(m)
}

var xxx_messageInfo_AutoUpgradeOptions proto.InternalMessageInfo

func (m *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if m != nil {
		return m.AutoUpgradeStartTime
	}
	return ""
}

func (m *AutoUpgradeOptions) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// MaintenancePolicy defines the maintenance policy to be used for the cluster.
type MaintenancePolicy struct {
	// Specifies the maintenance window in which maintenance may be performed.
	Window               *MaintenanceWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MaintenancePolicy) Reset()         { *m = MaintenancePolicy{} }
func (m *MaintenancePolicy) String() string { return proto.CompactTextString(m) }
func (*MaintenancePolicy) ProtoMessage()    {}
func (*MaintenancePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{43}
}

func (m *MaintenancePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MaintenancePolicy.Unmarshal(m, b)
}
func (m *MaintenancePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MaintenancePolicy.Marshal(b, m, deterministic)
}
func (m *MaintenancePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaintenancePolicy.Merge(m, src)
}
func (m *MaintenancePolicy) XXX_Size() int {
	return xxx_messageInfo_MaintenancePolicy.Size(m)
}
func (m *MaintenancePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MaintenancePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MaintenancePolicy proto.InternalMessageInfo

func (m *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if m != nil {
		return m.Window
	}
	return nil
}

// MaintenanceWindow defines the maintenance window to be used for the cluster.
type MaintenanceWindow struct {
	// Types that are valid to be assigned to Policy:
	//	*MaintenanceWindow_DailyMaintenanceWindow
	Policy               isMaintenanceWindow_Policy `protobuf_oneof:"policy"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *MaintenanceWindow) Reset()         { *m = MaintenanceWindow{} }
func (m *MaintenanceWindow) String() string { return proto.CompactTextString(m) }
func (*MaintenanceWindow) ProtoMessage()    {}
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{44}
}

func (m *MaintenanceWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MaintenanceWindow.Unmarshal(m, b)
}
func (m *MaintenanceWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MaintenanceWindow.Marshal(b, m, deterministic)
}
func (m *MaintenanceWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MaintenanceWindow.Merge(m, src)
}
func (m *MaintenanceWindow) XXX_Size() int {
	return xxx_messageInfo_MaintenanceWindow.Size(m)
}
func (m *MaintenanceWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_MaintenanceWindow.DiscardUnknown(m)
}

var xxx_messageInfo_MaintenanceWindow proto.InternalMessageInfo

type isMaintenanceWindow_Policy interface {
	isMaintenanceWindow_Policy()
}

type MaintenanceWindow_DailyMaintenanceWindow struct {
	DailyMaintenanceWindow *DailyMaintenanceWindow `protobuf:"bytes,2,opt,name=daily_maintenance_window,json=dailyMaintenanceWindow,proto3,oneof"`
}

func (*MaintenanceWindow_DailyMaintenanceWindow) isMaintenanceWindow_Policy() {}

func (m *MaintenanceWindow) GetPolicy() isMaintenanceWindow_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *MaintenanceWindow) GetDailyMaintenanceWindow() *DailyMaintenanceWindow {
	if x, ok := m.GetPolicy().(*MaintenanceWindow_DailyMaintenanceWindow); ok {
		return x.DailyMaintenanceWindow
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MaintenanceWindow) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MaintenanceWindow_DailyMaintenanceWindow)(nil),
	}
}

// Time window specified for daily maintenance operations.
type DailyMaintenanceWindow struct {
	// Time within the maintenance window to start the maintenance operations.
	// Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
	// format "HH:MM”, where HH : [00-23] and MM : [00-59] GMT.
	StartTime string `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] Duration of the time window, automatically chosen to be
	// smallest possible in the given scenario.
	// Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
	// format "PTnHnMnS".
	Duration             string   `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DailyMaintenanceWindow) Reset()         { *m = DailyMaintenanceWindow{} }
func (m *DailyMaintenanceWindow) String() string { return proto.CompactTextString(m) }
func (*DailyMaintenanceWindow) ProtoMessage()    {}
func (*DailyMaintenanceWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{45}
}

func (m *DailyMaintenanceWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DailyMaintenanceWindow.Unmarshal(m, b)
}
func (m *DailyMaintenanceWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DailyMaintenanceWindow.Marshal(b, m, deterministic)
}
func (m *DailyMaintenanceWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DailyMaintenanceWindow.Merge(m, src)
}
func (m *DailyMaintenanceWindow) XXX_Size() int {
	return xxx_messageInfo_DailyMaintenanceWindow.Size(m)
}
func (m *DailyMaintenanceWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_DailyMaintenanceWindow.DiscardUnknown(m)
}

var xxx_messageInfo_DailyMaintenanceWindow proto.InternalMessageInfo

func (m *DailyMaintenanceWindow) GetStartTime() string {
	if m != nil {
		return m.StartTime
	}
	return ""
}

func (m *DailyMaintenanceWindow) GetDuration() string {
	if m != nil {
		return m.Duration
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// management properties. Specified in the format
	// 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolManagementRequest) Reset()         { *m = SetNodePoolManagementRequest{} }
func (m *SetNodePoolManagementRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolManagementRequest) ProtoMessage()    {}
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{46}
}

func (m *SetNodePoolManagementRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolManagementRequest.Unmarshal(m, b)
}
func (m *SetNodePoolManagementRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolManagementRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolManagementRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolManagementRequest.Merge(m, src)
}
func (m *SetNodePoolManagementRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolManagementRequest.Size(m)
}
func (m *SetNodePoolManagementRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolManagementRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolManagementRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolManagementRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

func (m *SetNodePoolManagementRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetNodePoolSizeRequest sets the size a node
// pool.
type SetNodePoolSizeRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The desired node count for the pool.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// size.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNodePoolSizeRequest) Reset()         { *m = SetNodePoolSizeRequest{} }
func (m *SetNodePoolSizeRequest) String() string { return proto.CompactTextString(m) }
func (*SetNodePoolSizeRequest) ProtoMessage()    {}
func (*SetNodePoolSizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{47}
}

func (m *SetNodePoolSizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNodePoolSizeRequest.Unmarshal(m, b)
}
func (m *SetNodePoolSizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNodePoolSizeRequest.Marshal(b, m, deterministic)
}
func (m *SetNodePoolSizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNodePoolSizeRequest.Merge(m, src)
}
func (m *SetNodePoolSizeRequest) XXX_Size() int {
	return xxx_messageInfo_SetNodePoolSizeRequest.Size(m)
}
func (m *SetNodePoolSizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNodePoolSizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNodePoolSizeRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNodePoolSizeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolSizeRequest) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *SetNodePoolSizeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to rollback.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the node pool to rollback.
	// This field has been deprecated and replaced by the name field.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster, node pool id) of the node poll to
	// rollback upgrade.
	// Specified in the format 'projects/*/locations/*/clusters/*/nodePools/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackNodePoolUpgradeRequest) Reset()         { *m = RollbackNodePoolUpgradeRequest{} }
func (m *RollbackNodePoolUpgradeRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackNodePoolUpgradeRequest) ProtoMessage()    {}
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{48}
}

func (m *RollbackNodePoolUpgradeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Unmarshal(m, b)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Marshal(b, m, deterministic)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackNodePoolUpgradeRequest.Merge(m, src)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackNodePoolUpgradeRequest.Size(m)
}
func (m *RollbackNodePoolUpgradeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackNodePoolUpgradeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackNodePoolUpgradeRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (m *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	// A list of node pools for a cluster.
	NodePools            []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ListNodePoolsResponse) Reset()         { *m = ListNodePoolsResponse{} }
func (m *ListNodePoolsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNodePoolsResponse) ProtoMessage()    {}
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{49}
}

func (m *ListNodePoolsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodePoolsResponse.Unmarshal(m, b)
}
func (m *ListNodePoolsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodePoolsResponse.Marshal(b, m, deterministic)
}
func (m *ListNodePoolsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodePoolsResponse.Merge(m, src)
}
func (m *ListNodePoolsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNodePoolsResponse.Size(m)
}
func (m *ListNodePoolsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodePoolsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodePoolsResponse proto.InternalMessageInfo

func (m *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum number of nodes in the NodePool. Must be >= 1 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the NodePool. Must be >= min_node_count. There
	// has to enough quota to scale up the cluster.
	MaxNodeCount         int32    `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodePoolAutoscaling) Reset()         { *m = NodePoolAutoscaling{} }
func (m *NodePoolAutoscaling) String() string { return proto.CompactTextString(m) }
func (*NodePoolAutoscaling) ProtoMessage()    {}
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{50}
}

func (m *NodePoolAutoscaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePoolAutoscaling.Unmarshal(m, b)
}
func (m *NodePoolAutoscaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePoolAutoscaling.Marshal(b, m, deterministic)
}
func (m *NodePoolAutoscaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePoolAutoscaling.Merge(m, src)
}
func (m *NodePoolAutoscaling) XXX_Size() int {
	return xxx_messageInfo_NodePoolAutoscaling.Size(m)
}
func (m *NodePoolAutoscaling) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePoolAutoscaling.DiscardUnknown(m)
}

var xxx_messageInfo_NodePoolAutoscaling proto.InternalMessageInfo

func (m *NodePoolAutoscaling) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if m != nil {
		return m.MinNodeCount
	}
	return 0
}

func (m *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if m != nil {
		return m.MaxNodeCount
	}
	return 0
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Kubernetes Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a <code>get()</code> request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// The name (project, location, cluster id) of the cluster to set labels.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLabelsRequest) Reset()         { *m = SetLabelsRequest{} }
func (m *SetLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*SetLabelsRequest) ProtoMessage()    {}
func (*SetLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{51}
}

func (m *SetLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLabelsRequest.Unmarshal(m, b)
}
func (m *SetLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLabelsRequest.Marshal(b, m, deterministic)
}
func (m *SetLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLabelsRequest.Merge(m, src)
}
func (m *SetLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_SetLabelsRequest.Size(m)
}
func (m *SetLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLabelsRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLabelsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLabelsRequest) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *SetLabelsRequest) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *SetLabelsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name (project, location, cluster id) of the cluster to set legacy abac.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetLegacyAbacRequest) Reset()         { *m = SetLegacyAbacRequest{} }
func (m *SetLegacyAbacRequest) String() string { return proto.CompactTextString(m) }
func (*SetLegacyAbacRequest) ProtoMessage()    {}
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{52}
}

func (m *SetLegacyAbacRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetLegacyAbacRequest.Unmarshal(m, b)
}
func (m *SetLegacyAbacRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetLegacyAbacRequest.Marshal(b, m, deterministic)
}
func (m *SetLegacyAbacRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetLegacyAbacRequest.Merge(m, src)
}
func (m *SetLegacyAbacRequest) XXX_Size() int {
	return xxx_messageInfo_SetLegacyAbacRequest.Size(m)
}
func (m *SetLegacyAbacRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetLegacyAbacRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetLegacyAbacRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetLegacyAbacRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *SetLegacyAbacRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster id) of the cluster to start IP
	// rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to rotate credentials during IP rotation.
	RotateCredentials    bool     `protobuf:"varint,7,opt,name=rotate_credentials,json=rotateCredentials,proto3" json:"rotate_credentials,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartIPRotationRequest) Reset()         { *m = StartIPRotationRequest{} }
func (m *StartIPRotationRequest) String() string { return proto.CompactTextString(m) }
func (*StartIPRotationRequest) ProtoMessage()    {}
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{53}
}

func (m *StartIPRotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartIPRotationRequest.Unmarshal(m, b)
}
func (m *StartIPRotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartIPRotationRequest.Marshal(b, m, deterministic)
}
func (m *StartIPRotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartIPRotationRequest.Merge(m, src)
}
func (m *StartIPRotationRequest) XXX_Size() int {
	return xxx_messageInfo_StartIPRotationRequest.Size(m)
}
func (m *StartIPRotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartIPRotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartIPRotationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *StartIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StartIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *StartIPRotationRequest) GetRotateCredentials() bool {
	if m != nil {
		return m.RotateCredentials
	}
	return false
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// The name (project, location, cluster id) of the cluster to complete IP
	// rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompleteIPRotationRequest) Reset()         { *m = CompleteIPRotationRequest{} }
func (m *CompleteIPRotationRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteIPRotationRequest) ProtoMessage()    {}
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{54}
}

func (m *CompleteIPRotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteIPRotationRequest.Unmarshal(m, b)
}
func (m *CompleteIPRotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteIPRotationRequest.Marshal(b, m, deterministic)
}
func (m *CompleteIPRotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteIPRotationRequest.Merge(m, src)
}
func (m *CompleteIPRotationRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteIPRotationRequest.Size(m)
}
func (m *CompleteIPRotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteIPRotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteIPRotationRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *CompleteIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// AcceleratorConfig represents a Hardware Accelerator request.
type AcceleratorConfig struct {
	// The number of the accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	// The accelerator type resource name. List of supported accelerators
	// [here](/compute/docs/gpus/#Introduction)
	AcceleratorType      string   `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceleratorConfig) Reset()         { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()    {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{55}
}

func (m *AcceleratorConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceleratorConfig.Unmarshal(m, b)
}
func (m *AcceleratorConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceleratorConfig.Marshal(b, m, deterministic)
}
func (m *AcceleratorConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceleratorConfig.Merge(m, src)
}
func (m *AcceleratorConfig) XXX_Size() int {
	return xxx_messageInfo_AcceleratorConfig.Size(m)
}
func (m *AcceleratorConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceleratorConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AcceleratorConfig proto.InternalMessageInfo

func (m *AcceleratorConfig) GetAcceleratorCount() int64 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

func (m *AcceleratorConfig) GetAcceleratorType() string {
	if m != nil {
		return m.AcceleratorType
	}
	return ""
}

// SetNetworkPolicyRequest enables/disables network policy for a cluster.
type SetNetworkPolicyRequest struct {
	// Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	// This field has been deprecated and replaced by the name field.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"` // Deprecated: Do not use.
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"` // Deprecated: Do not use.
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set networking
	// policy. Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetNetworkPolicyRequest) Reset()         { *m = SetNetworkPolicyRequest{} }
func (m *SetNetworkPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*SetNetworkPolicyRequest) ProtoMessage()    {}
func (*SetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{56}
}

func (m *SetNetworkPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetNetworkPolicyRequest.Unmarshal(m, b)
}
func (m *SetNetworkPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetNetworkPolicyRequest.Marshal(b, m, deterministic)
}
func (m *SetNetworkPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetNetworkPolicyRequest.Merge(m, src)
}
func (m *SetNetworkPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_SetNetworkPolicyRequest.Size(m)
}
func (m *SetNetworkPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetNetworkPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetNetworkPolicyRequest proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (m *SetNetworkPolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *SetNetworkPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maintenance policy to be set for the cluster. An empty field
	// clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,4,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set maintenance
	// policy.
	// Specified in the format 'projects/*/locations/*/clusters/*'.
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMaintenancePolicyRequest) Reset()         { *m = SetMaintenancePolicyRequest{} }
func (m *SetMaintenancePolicyRequest) String() string { return proto.CompactTextString(m) }
func (*SetMaintenancePolicyRequest) ProtoMessage()    {}
func (*SetMaintenancePolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{57}
}

func (m *SetMaintenancePolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Unmarshal(m, b)
}
func (m *SetMaintenancePolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Marshal(b, m, deterministic)
}
func (m *SetMaintenancePolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMaintenancePolicyRequest.Merge(m, src)
}
func (m *SetMaintenancePolicyRequest) XXX_Size() int {
	return xxx_messageInfo_SetMaintenancePolicyRequest.Size(m)
}
func (m *SetMaintenancePolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMaintenancePolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMaintenancePolicyRequest proto.InternalMessageInfo

func (m *SetMaintenancePolicyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMaintenancePolicyRequest) GetMaintenancePolicy() *MaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *SetMaintenancePolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// NetworkConfig reports the relative names of network & subnetwork.
type NetworkConfig struct {
	// Output only. The relative name of the Google Compute Engine
	// [network][google.container.v1.NetworkConfig.network](/compute/docs/networks-and-firewalls#networks) to which
	// the cluster is connected.
	// Example: projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The relative name of the Google Compute Engine
	// [subnetwork](/compute/docs/vpc) to which the cluster is connected.
	// Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork           string   `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkConfig) Reset()         { *m = NetworkConfig{} }
func (m *NetworkConfig) String() string { return proto.CompactTextString(m) }
func (*NetworkConfig) ProtoMessage()    {}
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c7f18b1699f357a, []int{58}
}

func (m *NetworkConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkConfig.Unmarshal(m, b)
}
func (m *NetworkConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkConfig.Marshal(b, m, deterministic)
}
func (m *NetworkConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConfig.Merge(m, src)
}
func (m *NetworkConfig) XXX_Size() int {
	return xxx_messageInfo_NetworkConfig.Size(m)
}
func (m *NetworkConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConfig proto.InternalMessageInfo

func (m *NetworkConfig) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *NetworkConfig) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.container.v1.NetworkPolicy_Provider", NetworkPolicy_Provider_name, NetworkPolicy_Provider_value)
	proto.RegisterEnum("google.container.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Status", Operation_Status_name, Operation_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Type", Operation_Type_name, Operation_Type_value)
	proto.RegisterEnum("google.container.v1.SetMasterAuthRequest_Action", SetMasterAuthRequest_Action_name, SetMasterAuthRequest_Action_value)
	proto.RegisterEnum("google.container.v1.NodePool_Status", NodePool_Status_name, NodePool_Status_value)
	proto.RegisterType((*NodeConfig)(nil), "google.container.v1.NodeConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1.NodeConfig.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1.NodeConfig.MetadataEntry")
	proto.RegisterType((*MasterAuth)(nil), "google.container.v1.MasterAuth")
	proto.RegisterType((*ClientCertificateConfig)(nil), "google.container.v1.ClientCertificateConfig")
	proto.RegisterType((*AddonsConfig)(nil), "google.container.v1.AddonsConfig")
	proto.RegisterType((*HttpLoadBalancing)(nil), "google.container.v1.HttpLoadBalancing")
	proto.RegisterType((*HorizontalPodAutoscaling)(nil), "google.container.v1.HorizontalPodAutoscaling")
	proto.RegisterType((*KubernetesDashboard)(nil), "google.container.v1.KubernetesDashboard")
	proto.RegisterType((*NetworkPolicyConfig)(nil), "google.container.v1.NetworkPolicyConfig")
	proto.RegisterType((*PrivateClusterConfig)(nil), "google.container.v1.PrivateClusterConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig)(nil), "google.container.v1.MasterAuthorizedNetworksConfig")
	proto.RegisterType((*MasterAuthorizedNetworksConfig_CidrBlock)(nil), "google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock")
	proto.RegisterType((*LegacyAbac)(nil), "google.container.v1.LegacyAbac")
	proto.RegisterType((*NetworkPolicy)(nil), "google.container.v1.NetworkPolicy")
	proto.RegisterType((*IPAllocationPolicy)(nil), "google.container.v1.IPAllocationPolicy")
	proto.RegisterType((*Cluster)(nil), "google.container.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1.Cluster.ResourceLabelsEntry")
	proto.RegisterType((*ClusterUpdate)(nil), "google.container.v1.ClusterUpdate")
	proto.RegisterType((*Operation)(nil), "google.container.v1.Operation")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.container.v1.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.container.v1.GetClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.container.v1.UpdateClusterRequest")
	proto.RegisterType((*UpdateNodePoolRequest)(nil), "google.container.v1.UpdateNodePoolRequest")
	proto.RegisterType((*SetNodePoolAutoscalingRequest)(nil), "google.container.v1.SetNodePoolAutoscalingRequest")
	proto.RegisterType((*SetLoggingServiceRequest)(nil), "google.container.v1.SetLoggingServiceRequest")
	proto.RegisterType((*SetMonitoringServiceRequest)(nil), "google.container.v1.SetMonitoringServiceRequest")
	proto.RegisterType((*SetAddonsConfigRequest)(nil), "google.container.v1.SetAddonsConfigRequest")
	proto.RegisterType((*SetLocationsRequest)(nil), "google.container.v1.SetLocationsRequest")
	proto.RegisterType((*UpdateMasterRequest)(nil), "google.container.v1.UpdateMasterRequest")
	proto.RegisterType((*SetMasterAuthRequest)(nil), "google.container.v1.SetMasterAuthRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.container.v1.DeleteClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.container.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.container.v1.ListClustersResponse")
	proto.RegisterType((*GetOperationRequest)(nil), "google.container.v1.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.container.v1.ListOperationsRequest")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.container.v1.CancelOperationRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.container.v1.ListOperationsResponse")
	proto.RegisterType((*GetServerConfigRequest)(nil), "google.container.v1.GetServerConfigRequest")
	proto.RegisterType((*ServerConfig)(nil), "google.container.v1.ServerConfig")
	proto.RegisterType((*CreateNodePoolRequest)(nil), "google.container.v1.CreateNodePoolRequest")
	proto.RegisterType((*DeleteNodePoolRequest)(nil), "google.container.v1.DeleteNodePoolRequest")
	proto.RegisterType((*ListNodePoolsRequest)(nil), "google.container.v1.ListNodePoolsRequest")
	proto.RegisterType((*GetNodePoolRequest)(nil), "google.container.v1.GetNodePoolRequest")
	proto.RegisterType((*NodePool)(nil), "google.container.v1.NodePool")
	proto.RegisterType((*NodeManagement)(nil), "google.container.v1.NodeManagement")
	proto.RegisterType((*AutoUpgradeOptions)(nil), "google.container.v1.AutoUpgradeOptions")
	proto.RegisterType((*MaintenancePolicy)(nil), "google.container.v1.MaintenancePolicy")
	proto.RegisterType((*MaintenanceWindow)(nil), "google.container.v1.MaintenanceWindow")
	proto.RegisterType((*DailyMaintenanceWindow)(nil), "google.container.v1.DailyMaintenanceWindow")
	proto.RegisterType((*SetNodePoolManagementRequest)(nil), "google.container.v1.SetNodePoolManagementRequest")
	proto.RegisterType((*SetNodePoolSizeRequest)(nil), "google.container.v1.SetNodePoolSizeRequest")
	proto.RegisterType((*RollbackNodePoolUpgradeRequest)(nil), "google.container.v1.RollbackNodePoolUpgradeRequest")
	proto.RegisterType((*ListNodePoolsResponse)(nil), "google.container.v1.ListNodePoolsResponse")
	proto.RegisterType((*NodePoolAutoscaling)(nil), "google.container.v1.NodePoolAutoscaling")
	proto.RegisterType((*SetLabelsRequest)(nil), "google.container.v1.SetLabelsRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.container.v1.SetLabelsRequest.ResourceLabelsEntry")
	proto.RegisterType((*SetLegacyAbacRequest)(nil), "google.container.v1.SetLegacyAbacRequest")
	proto.RegisterType((*StartIPRotationRequest)(nil), "google.container.v1.StartIPRotationRequest")
	proto.RegisterType((*CompleteIPRotationRequest)(nil), "google.container.v1.CompleteIPRotationRequest")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.container.v1.AcceleratorConfig")
	proto.RegisterType((*SetNetworkPolicyRequest)(nil), "google.container.v1.SetNetworkPolicyRequest")
	proto.RegisterType((*SetMaintenancePolicyRequest)(nil), "google.container.v1.SetMaintenancePolicyRequest")
	proto.RegisterType((*NetworkConfig)(nil), "google.container.v1.NetworkConfig")
}

func init() {
	proto.RegisterFile("google/container/v1/cluster_service.proto", fileDescriptor_1c7f18b1699f357a)
}

var fileDescriptor_1c7f18b1699f357a = []byte{
	// 5271 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x3c, 0x6d, 0x8c, 0x24, 0xd7,
	0x51, 0xe9, 0xd9, 0xd9, 0xd9, 0x9d, 0x9a, 0xd9, 0xd9, 0xd9, 0xb7, 0x1f, 0x37, 0x1e, 0xdf, 0xd9,
	0x77, 0x1d, 0x9f, 0x7d, 0xb7, 0xb6, 0x77, 0x7c, 0xe7, 0xef, 0xf3, 0xd9, 0xf1, 0xdc, 0xec, 0x78,
	0x6f, 0x7c, 0xfb, 0x31, 0xe9, 0xd9, 0xbd, 0x93, 0x0f, 0x93, 0x56, 0xef, 0x4c, 0xdf, 0x6c, 0x7b,
	0x7b, 0xba, 0x3b, 0xdd, 0x3d, 0x67, 0xef, 0x9d, 0x0e, 0xf1, 0x91, 0x04, 0x83, 0x63, 0x93, 0x90,
	0x04, 0xa4, 0xf0, 0x21, 0x02, 0x24, 0x28, 0x01, 0x41, 0x88, 0x88, 0x04, 0x02, 0x21, 0x21, 0xf1,
	0x83, 0x00, 0x12, 0x08, 0x90, 0x85, 0x90, 0xf8, 0x87, 0x10, 0x41, 0x42, 0x22, 0xc0, 0x1f, 0x04,
	0x88, 0xe8, 0x7d, 0x74, 0xf7, 0xeb, 0x99, 0xee, 0x99, 0x9d, 0xdd, 0xbb, 0xcd, 0xfd, 0xba, 0xed,
	0x7a, 0xaf, 0xde, 0xab, 0xaa, 0x57, 0xaf, 0xaa, 0x5e, 0x55, 0xcd, 0xc1, 0xd9, 0xb6, 0x69, 0xb6,
	0x75, 0xb5, 0xd4, 0x34, 0x0d, 0x57, 0xd1, 0x0c, 0xd5, 0x2e, 0xdd, 0x3c, 0x57, 0x6a, 0xea, 0x5d,
	0xc7, 0x55, 0x6d, 0xd9, 0x51, 0xed, 0x9b, 0x5a, 0x53, 0x5d, 0xb2, 0x6c, 0xd3, 0x35, 0xd1, 0x2c,
	0x9d, 0xba, 0xe4, 0x4f, 0x5d, 0xba, 0x79, 0xae, 0x78, 0x9c, 0xe1, 0x2b, 0x96, 0x56, 0x52, 0x0c,
	0xc3, 0x74, 0x15, 0x57, 0x33, 0x0d, 0x87, 0xa2, 0x14, 0x1f, 0x64, 0xa3, 0xe4, 0x6b, 0xbb, 0x7b,
	0xa3, 0xa4, 0x76, 0x2c, 0x77, 0x8f, 0x0e, 0x8a, 0xdf, 0x1e, 0x07, 0x58, 0x37, 0x5b, 0x6a, 0xc5,
	0x34, 0x6e, 0x68, 0x6d, 0x74, 0x0a, 0xb2, 0x1d, 0xa5, 0xb9, 0xa3, 0x19, 0xaa, 0xec, 0xee, 0x59,
	0x6a, 0x41, 0x38, 0x29, 0x9c, 0x49, 0x4b, 0x19, 0x06, 0xdb, 0xdc, 0xb3, 0x54, 0x74, 0x12, 0xb2,
	0x2d, 0xcd, 0xd9, 0x95, 0x1d, 0xed, 0x96, 0x2a, 0xb7, 0xb7, 0x0b, 0x89, 0x93, 0xc2, 0x99, 0x71,
	0x09, 0x30, 0xac, 0xa1, 0xdd, 0x52, 0x57, 0xb6, 0xf1, 0x22, 0xa6, 0xd2, 0x75, 0x77, 0x64, 0xa7,
	0x69, 0x5a, 0xaa, 0x53, 0x18, 0x3b, 0x39, 0x86, 0x17, 0x21, 0xb0, 0x06, 0x01, 0xa1, 0xc7, 0x60,
	0x9a, 0xf1, 0x25, 0x2b, 0xcd, 0xa6, 0xd9, 0x35, 0xdc, 0x42, 0x9a, 0x6c, 0x95, 0x63, 0xe0, 0x32,
	0x85, 0xa2, 0x1a, 0x4c, 0x76, 0x54, 0x57, 0x69, 0x29, 0xae, 0x52, 0x48, 0x9e, 0x1c, 0x3b, 0x93,
	0x39, 0xff, 0xe4, 0x52, 0x84, 0x08, 0x96, 0x02, 0x1e, 0x96, 0xd6, 0xd8, 0xfc, 0xaa, 0xe1, 0xda,
	0x7b, 0x92, 0x8f, 0x8e, 0x4e, 0x00, 0x68, 0x1d, 0xa5, 0xcd, 0x38, 0x1b, 0x27, 0xdb, 0xa5, 0x09,
	0x84, 0xf0, 0x55, 0x81, 0x94, 0xae, 0x6c, 0xab, 0xba, 0x53, 0x48, 0x91, 0x7d, 0x1e, 0x1f, 0xb6,
	0xcf, 0x2a, 0x99, 0x4d, 0x77, 0x61, 0xa8, 0xe8, 0x51, 0x98, 0xd6, 0xcd, 0xa6, 0xa2, 0xcb, 0x8e,
	0xd3, 0x92, 0x29, 0x5f, 0x13, 0x44, 0x3e, 0x53, 0x04, 0xdc, 0x70, 0x5a, 0x15, 0xc2, 0x16, 0x82,
	0xa4, 0xab, 0xb4, 0x9d, 0xc2, 0x24, 0x11, 0x0d, 0xf9, 0x1b, 0x9d, 0x84, 0x8c, 0x65, 0xab, 0xf8,
	0x70, 0xb4, 0x6d, 0x5d, 0x2d, 0xc0, 0x49, 0xe1, 0xcc, 0xa4, 0xc4, 0x83, 0xd0, 0xeb, 0x90, 0x55,
	0x9a, 0x4d, 0x55, 0x57, 0x6d, 0xc5, 0x35, 0x6d, 0xa7, 0x90, 0x21, 0x84, 0x3e, 0x1a, 0x49, 0x68,
	0x39, 0x98, 0x48, 0xe9, 0x95, 0x42, 0xb8, 0xe8, 0x41, 0x48, 0x93, 0x63, 0x24, 0xc2, 0xc8, 0x12,
	0x61, 0x4c, 0x62, 0x00, 0x91, 0xc5, 0x19, 0xc8, 0x77, 0x34, 0x43, 0x6e, 0x5a, 0x5d, 0xd9, 0xd2,
	0x15, 0xf7, 0x86, 0x69, 0x77, 0x0a, 0x53, 0xf4, 0x7c, 0x3a, 0x9a, 0x51, 0xb1, 0xba, 0x75, 0x06,
	0x2d, 0xbe, 0x04, 0x53, 0x21, 0x79, 0xa3, 0x3c, 0x8c, 0xed, 0xaa, 0x7b, 0x4c, 0x71, 0xf0, 0x9f,
	0x68, 0x0e, 0xc6, 0x6f, 0x2a, 0x7a, 0x57, 0x25, 0x9a, 0x92, 0x96, 0xe8, 0xc7, 0x85, 0xc4, 0x0b,
	0x42, 0xf1, 0x45, 0xc8, 0x70, 0x42, 0x1c, 0x05, 0x55, 0xfc, 0x56, 0x02, 0x60, 0x4d, 0xc1, 0x17,
	0xa4, 0xdc, 0x75, 0x77, 0x50, 0x11, 0x26, 0xbb, 0x8e, 0x6a, 0x1b, 0x4a, 0xc7, 0xd3, 0x59, 0xff,
	0x1b, 0x8f, 0x59, 0x8a, 0xe3, 0xbc, 0x6d, 0xda, 0x2d, 0xb6, 0x8e, 0xff, 0x8d, 0x76, 0xe0, 0x81,
	0xa6, 0xae, 0xa9, 0x86, 0x2b, 0x37, 0x55, 0xdb, 0xd5, 0x6e, 0x68, 0x4d, 0xc5, 0x55, 0xe5, 0x26,
	0x11, 0x58, 0x61, 0xec, 0xa4, 0x70, 0x26, 0x73, 0xfe, 0x89, 0x48, 0xf1, 0x56, 0x08, 0x56, 0x25,
	0x40, 0x62, 0x42, 0x3e, 0xd6, 0x8c, 0x1e, 0x40, 0xcf, 0xc0, 0x82, 0x77, 0xa3, 0x9b, 0x0a, 0xbf,
	0x5b, 0xa1, 0x45, 0x68, 0x9a, 0x63, 0xa3, 0x15, 0x85, 0xc3, 0x45, 0x4f, 0x02, 0xea, 0xa7, 0xaf,
	0xa0, 0x12, 0x8c, 0x99, 0xbe, 0xad, 0xb0, 0x8a, 0xb3, 0xe9, 0x58, 0x90, 0x37, 0xa8, 0x8a, 0x53,
	0xc8, 0x15, 0x75, 0x4f, 0x6c, 0xc0, 0xb1, 0x18, 0xba, 0xd1, 0x0b, 0x50, 0xd0, 0x1c, 0xa7, 0xab,
	0xca, 0x11, 0xdb, 0x09, 0x44, 0x13, 0x17, 0xc8, 0x78, 0x1f, 0xbe, 0xf8, 0xc1, 0x18, 0x64, 0xcb,
	0xad, 0x96, 0x69, 0x38, 0x6c, 0xa9, 0xab, 0x30, 0xbb, 0xe3, 0xba, 0x96, 0xac, 0x9b, 0x4a, 0x4b,
	0xde, 0x56, 0x74, 0xc5, 0x68, 0x6a, 0x46, 0x9b, 0xac, 0x12, 0xa7, 0xac, 0x97, 0x5d, 0xd7, 0x5a,
	0x35, 0x95, 0xd6, 0x25, 0x6f, 0xb6, 0x34, 0xb3, 0xd3, 0x0b, 0x42, 0xbb, 0x50, 0xdc, 0x31, 0x6d,
	0xed, 0x16, 0x46, 0xd4, 0x65, 0xcb, 0x6c, 0xc9, 0x4a, 0xd7, 0x35, 0x9d, 0xa6, 0xa2, 0xe3, 0xe5,
	0x13, 0x64, 0xf9, 0x68, 0xe3, 0x70, 0xd9, 0x47, 0xab, 0x9b, 0xad, 0x72, 0x80, 0x24, 0x15, 0x76,
	0x62, 0x46, 0xd0, 0x0f, 0xc1, 0xdc, 0x6e, 0x77, 0x5b, 0xb5, 0x0d, 0xd5, 0x55, 0x1d, 0xb9, 0xa5,
	0x38, 0x3b, 0xdb, 0xa6, 0x62, 0xb7, 0x98, 0x4e, 0x9c, 0x89, 0xdc, 0xe6, 0x8a, 0x8f, 0xb0, 0xec,
	0xcd, 0x97, 0x66, 0x77, 0xfb, 0x81, 0xe8, 0x4d, 0x98, 0x37, 0x54, 0xf7, 0x6d, 0xd3, 0xde, 0x95,
	0x2d, 0x53, 0xd7, 0x9a, 0x7b, 0x9e, 0xc6, 0x25, 0x07, 0xac, 0xbe, 0x4e, 0x31, 0xea, 0x04, 0x81,
	0x69, 0xdb, 0xac, 0xd1, 0x0f, 0x14, 0x4b, 0x30, 0xd3, 0x27, 0x4f, 0x7c, 0x09, 0x5a, 0x9a, 0xa3,
	0x6c, 0xeb, 0x6a, 0x8b, 0x9d, 0xa7, 0xff, 0x2d, 0x3e, 0x07, 0x85, 0x38, 0x09, 0x0d, 0xc4, 0x3b,
	0x07, 0xb3, 0x11, 0x2c, 0x0f, 0x43, 0x89, 0xe0, 0x63, 0x20, 0xca, 0x4f, 0x25, 0x60, 0xae, 0x6e,
	0x6b, 0x37, 0xb1, 0xae, 0xb2, 0x2b, 0x42, 0x91, 0x9e, 0x82, 0x39, 0xd5, 0xc0, 0x73, 0x64, 0x8b,
	0x0e, 0xcb, 0x86, 0xd9, 0x52, 0x1d, 0xb6, 0x00, 0xa2, 0x63, 0x0c, 0x13, 0x9b, 0x6d, 0x07, 0x3d,
	0x07, 0xc7, 0x7a, 0x30, 0x54, 0xa3, 0x65, 0x99, 0x9a, 0xe1, 0x12, 0xf5, 0x99, 0x94, 0xe6, 0x43,
	0x48, 0x55, 0x36, 0x88, 0x9e, 0x86, 0x85, 0x0e, 0xb1, 0x35, 0xb2, 0x66, 0xdd, 0x7c, 0x46, 0x6e,
	0x6a, 0x2d, 0x5b, 0xde, 0xd6, 0xcd, 0xe6, 0x2e, 0x51, 0x87, 0xb4, 0x34, 0x4b, 0x47, 0x6b, 0xd6,
	0xcd, 0x67, 0x2a, 0x5a, 0xcb, 0xbe, 0x84, 0x87, 0xd0, 0x59, 0xc8, 0xf7, 0xed, 0x92, 0x24, 0xd3,
	0xa7, 0xad, 0x9e, 0xf5, 0x1f, 0x83, 0x69, 0xab, 0xbb, 0xad, 0x6b, 0xcd, 0x60, 0x26, 0x75, 0x4f,
	0x39, 0x0a, 0xf6, 0x26, 0x8a, 0xdf, 0x15, 0xe0, 0xa1, 0xc0, 0xea, 0xe1, 0x33, 0x53, 0x5b, 0x4c,
	0x9e, 0xde, 0xed, 0x2b, 0xc0, 0x04, 0x65, 0xc2, 0x93, 0xa4, 0xf7, 0x89, 0x3e, 0x01, 0x99, 0x80,
	0x72, 0xa7, 0x90, 0x20, 0xce, 0xe3, 0xe5, 0x48, 0x5d, 0x1b, 0xbc, 0xc7, 0x92, 0xcf, 0xa4, 0x04,
	0x4d, 0xef, 0x4f, 0xa7, 0xb8, 0x06, 0xe9, 0x80, 0xfb, 0x53, 0x24, 0x4a, 0xb0, 0x74, 0x65, 0x4f,
	0xe6, 0x8c, 0x72, 0x86, 0xc1, 0xd6, 0xb1, 0x5d, 0xc6, 0xc6, 0x2a, 0x90, 0x64, 0x82, 0x19, 0x2b,
	0x6f, 0x05, 0xf1, 0x51, 0x80, 0x55, 0xb5, 0xad, 0x34, 0xf7, 0xca, 0xdb, 0x4a, 0x33, 0x9e, 0x2d,
	0xf1, 0xd7, 0x05, 0x98, 0x0a, 0xe9, 0x14, 0x5a, 0x81, 0x49, 0xcb, 0x36, 0x6f, 0x6a, 0x2d, 0xd5,
	0x26, 0x93, 0x73, 0x71, 0xbe, 0x9c, 0xc7, 0x5a, 0xaa, 0x33, 0x14, 0xc9, 0x47, 0xe6, 0x37, 0x4d,
	0x84, 0x37, 0x7d, 0x0a, 0x26, 0xeb, 0xc1, 0xac, 0xb9, 0xba, 0xb4, 0x71, 0xb5, 0xb6, 0x5c, 0x95,
	0xe4, 0xad, 0xf5, 0x46, 0xbd, 0x5a, 0xa9, 0xbd, 0x56, 0xab, 0x2e, 0xe7, 0x3f, 0x82, 0x00, 0x52,
	0x95, 0xf2, 0x6a, 0xad, 0xb2, 0x91, 0x17, 0xc4, 0x3f, 0x49, 0x02, 0xaa, 0xd5, 0xcb, 0x3a, 0x8e,
	0x03, 0x70, 0x74, 0xc6, 0x68, 0x7d, 0x04, 0x72, 0x5d, 0x47, 0x95, 0x35, 0x4b, 0x56, 0x74, 0x4d,
	0x71, 0x7c, 0xf5, 0xcd, 0x76, 0x1d, 0xb5, 0x66, 0x95, 0x29, 0x0c, 0x3d, 0x0e, 0x33, 0x4d, 0x5b,
	0xc5, 0xaa, 0xe4, 0x74, 0xb7, 0xd9, 0x9d, 0x67, 0x24, 0xe5, 0xe9, 0x40, 0xc3, 0x87, 0x93, 0xd8,
	0xca, 0xff, 0xa2, 0xd2, 0x1f, 0x63, 0xb1, 0x95, 0x0f, 0x26, 0x07, 0xb0, 0x04, 0x33, 0x9e, 0x4b,
	0xf2, 0xf5, 0x9a, 0xaa, 0xe8, 0xa5, 0x44, 0x41, 0x90, 0xa6, 0xd9, 0xa0, 0xa7, 0xd6, 0xe8, 0x0c,
	0xe4, 0xf0, 0x0d, 0xe3, 0x26, 0x8f, 0xfb, 0x93, 0xb3, 0x78, 0xc4, 0x9f, 0xf9, 0x14, 0x20, 0x16,
	0xc7, 0x39, 0xdc, 0xec, 0x94, 0x3f, 0x3b, 0xef, 0x8d, 0xfa, 0x18, 0x1f, 0x83, 0xe3, 0x41, 0xc0,
	0xdb, 0x34, 0x8d, 0x96, 0x62, 0xef, 0xc9, 0xb6, 0x62, 0xb4, 0x55, 0xca, 0xc1, 0x04, 0xe1, 0xe0,
	0x01, 0x36, 0xa7, 0xe1, 0x4d, 0x91, 0xf0, 0x0c, 0xc2, 0x4c, 0x19, 0x4e, 0xf8, 0x5b, 0x46, 0xae,
	0x30, 0x49, 0x56, 0x28, 0x7a, 0x93, 0x22, 0x96, 0x78, 0x16, 0x8e, 0xf5, 0xc9, 0x83, 0x69, 0x67,
	0x3a, 0xe4, 0xa3, 0xc3, 0x17, 0xbd, 0x04, 0x73, 0x61, 0xb1, 0x30, 0x1c, 0xa0, 0x5e, 0x9a, 0x17,
	0x0c, 0x45, 0x78, 0x1e, 0x0a, 0xfd, 0xd2, 0x61, 0x48, 0x19, 0x82, 0x34, 0xdf, 0x2b, 0x1f, 0x7a,
	0x25, 0xbe, 0x39, 0x03, 0x13, 0xcc, 0x06, 0xe2, 0x08, 0x92, 0xbb, 0x58, 0xe4, 0x6f, 0x1c, 0x41,
	0xb6, 0x54, 0xa7, 0x69, 0x6b, 0x16, 0xd6, 0x30, 0x76, 0xa5, 0x78, 0x10, 0x7a, 0x02, 0x90, 0x66,
	0x68, 0xae, 0xa6, 0xe8, 0xc4, 0x58, 0xb2, 0x10, 0x75, 0x8c, 0x84, 0xa8, 0x79, 0x36, 0x42, 0x43,
	0x5c, 0x1c, 0xa5, 0xbe, 0x0a, 0x19, 0x36, 0x8b, 0xf3, 0x4e, 0x0f, 0x0f, 0x89, 0x8b, 0x25, 0x30,
	0x82, 0xf7, 0xc4, 0xab, 0x90, 0x61, 0x96, 0x13, 0x07, 0xff, 0x44, 0x5f, 0xe2, 0x56, 0x08, 0x6c,
	0x8e, 0x04, 0x9d, 0x20, 0xb2, 0x7b, 0x0c, 0x47, 0xd4, 0xed, 0xb6, 0x66, 0xb4, 0xbd, 0x97, 0x10,
	0xd5, 0x23, 0x29, 0xc7, 0xc0, 0x0d, 0x0a, 0xc5, 0xa1, 0x52, 0xc7, 0x34, 0x34, 0xd7, 0xb4, 0xf9,
	0xb9, 0x54, 0x6f, 0x66, 0x82, 0x11, 0x6f, 0x7a, 0x01, 0x26, 0xbc, 0x8b, 0x44, 0x35, 0xc3, 0xfb,
	0x44, 0x8b, 0x51, 0xd7, 0x82, 0x2a, 0x40, 0xdf, 0x95, 0x78, 0x0d, 0xa6, 0x14, 0x12, 0xfb, 0x78,
	0x32, 0x02, 0xc2, 0xe1, 0xa9, 0xe8, 0x90, 0x9c, 0x8b, 0x92, 0xa4, 0xac, 0xc2, 0xc7, 0x4c, 0x0f,
	0x01, 0x70, 0x37, 0x9b, 0x2a, 0x01, 0x07, 0x41, 0x17, 0x81, 0x48, 0x55, 0xb6, 0x4c, 0x53, 0x77,
	0x0a, 0x59, 0x62, 0xba, 0x4f, 0xc4, 0x1e, 0x44, 0xdd, 0x34, 0x75, 0x29, 0x6d, 0xb0, 0xbf, 0x1c,
	0x74, 0x1c, 0xd2, 0x9e, 0xd9, 0x71, 0x0a, 0x53, 0xe4, 0xc9, 0x11, 0x00, 0x38, 0xaf, 0xc8, 0x45,
	0x3c, 0x8a, 0x6e, 0xed, 0x28, 0x85, 0x1c, 0xef, 0x15, 0x03, 0x5f, 0x5f, 0xc6, 0x83, 0xe8, 0x0d,
	0x98, 0xb6, 0x55, 0xc7, 0xec, 0xda, 0x4d, 0x55, 0x66, 0x2f, 0xa7, 0x69, 0x42, 0xd8, 0x53, 0x31,
	0x11, 0x33, 0x11, 0xdd, 0x92, 0xc4, 0x70, 0xf8, 0xe7, 0x53, 0xce, 0x0e, 0x01, 0xb1, 0xbd, 0x23,
	0x2b, 0xca, 0x37, 0x34, 0xa3, 0xad, 0xda, 0x96, 0x8d, 0x5d, 0x62, 0x9e, 0x48, 0x25, 0x4f, 0x06,
	0x5e, 0x0b, 0xe0, 0x58, 0xc7, 0x74, 0xe2, 0x28, 0x64, 0x65, 0x5b, 0x69, 0x16, 0xd0, 0x00, 0x1d,
	0x0b, 0x1c, 0x8a, 0x04, 0x7a, 0xe0, 0x5c, 0x6a, 0x90, 0x0b, 0xc7, 0x63, 0x85, 0x59, 0xb2, 0x88,
	0x38, 0xdc, 0x6d, 0x48, 0x53, 0xa1, 0x10, 0x0c, 0xbd, 0x01, 0x73, 0xc4, 0x96, 0x7b, 0xe2, 0xf5,
	0x16, 0x9c, 0x23, 0x0b, 0x3e, 0x16, 0xb9, 0x60, 0xbf, 0x5b, 0x90, 0x90, 0x66, 0xf5, 0xb9, 0x8a,
	0x1f, 0x81, 0x53, 0xdc, 0x5d, 0xa2, 0x8e, 0x59, 0x66, 0xbb, 0xfb, 0xfa, 0xb7, 0x40, 0xf6, 0x79,
	0xfa, 0x00, 0x5e, 0x5d, 0x7a, 0xa8, 0x33, 0x38, 0xb2, 0xd8, 0x02, 0xd4, 0x51, 0x34, 0xc3, 0x55,
	0x0d, 0xc5, 0x68, 0xaa, 0x1e, 0x63, 0xc7, 0x06, 0x84, 0xf5, 0x6b, 0xc1, 0x74, 0xc6, 0xd7, 0x4c,
	0xa7, 0x17, 0xc4, 0x0b, 0x9f, 0xf1, 0xf0, 0xe0, 0x70, 0xe1, 0x33, 0x92, 0x3d, 0xe1, 0x33, 0x0a,
	0x65, 0x58, 0xf0, 0x42, 0x2e, 0xff, 0xad, 0x45, 0x97, 0x3c, 0x4d, 0x96, 0x3c, 0x1b, 0xb9, 0x64,
	0x54, 0x70, 0x29, 0xcd, 0x59, 0x51, 0x21, 0xe7, 0x83, 0x90, 0x76, 0x54, 0xfd, 0x86, 0xac, 0x6b,
	0xc6, 0x2e, 0x7b, 0xb7, 0x4d, 0x62, 0xc0, 0xaa, 0x66, 0xec, 0xa2, 0x05, 0x48, 0xde, 0x32, 0x0d,
	0xf6, 0x3a, 0x23, 0x6e, 0x8e, 0x7c, 0xe3, 0xe0, 0xd6, 0x0f, 0xeb, 0xe8, 0x93, 0xcc, 0xff, 0xc6,
	0x77, 0xcf, 0xb3, 0xc7, 0x1e, 0xc5, 0x37, 0x55, 0xdb, 0xc1, 0xd6, 0xbb, 0x4d, 0x3d, 0x01, 0x1b,
	0x66, 0x74, 0x5c, 0xa5, 0x83, 0xe4, 0x35, 0xd9, 0xb5, 0x6d, 0xfc, 0x52, 0x63, 0x3a, 0xe1, 0xa1,
	0xed, 0x30, 0x4f, 0x45, 0x47, 0xe9, 0x91, 0x07, 0x58, 0x1e, 0x9c, 0x5a, 0x7f, 0x0f, 0x47, 0xf3,
	0x29, 0x46, 0x6c, 0x1c, 0x5b, 0x11, 0x0f, 0xeb, 0x61, 0xc8, 0xb0, 0xe0, 0xc3, 0xd5, 0x3a, 0x6a,
	0xe1, 0x2d, 0x6a, 0x9c, 0x28, 0x68, 0x53, 0xeb, 0xa8, 0xe8, 0x25, 0x48, 0x39, 0xae, 0xe2, 0x76,
	0x9d, 0xc2, 0x2e, 0x89, 0xb6, 0x3e, 0x3a, 0xf0, 0xfe, 0x37, 0xc8, 0x54, 0x89, 0xa1, 0xa0, 0xd3,
	0x90, 0xa3, 0x7f, 0xc9, 0x1d, 0xd5, 0x71, 0x94, 0xb6, 0x5a, 0xd0, 0xc9, 0x06, 0x53, 0x14, 0xba,
	0x46, 0x81, 0xe8, 0x49, 0x98, 0xed, 0x71, 0xb2, 0x8e, 0x76, 0x4b, 0x2d, 0x74, 0xa8, 0xe7, 0xe2,
	0x7d, 0x6c, 0x43, 0xbb, 0xa5, 0x62, 0x3f, 0x17, 0x11, 0x80, 0x18, 0xd4, 0x82, 0xf4, 0x05, 0x1f,
	0xe7, 0x61, 0x56, 0x33, 0x1c, 0x97, 0xa8, 0x75, 0xdb, 0x36, 0xbb, 0x96, 0xdc, 0xb5, 0x75, 0xa7,
	0x60, 0x62, 0x4b, 0x49, 0xc4, 0x32, 0xe3, 0x0d, 0xaf, 0xe0, 0xd1, 0x2d, 0x5b, 0x77, 0xf0, 0x0e,
	0x21, 0x59, 0x52, 0x4f, 0x6a, 0x51, 0x7a, 0x38, 0x29, 0x52, 0x4f, 0xfa, 0x30, 0x64, 0xd4, 0x77,
	0x2c, 0xcd, 0x66, 0x32, 0xfc, 0x24, 0x95, 0x21, 0x05, 0x11, 0x19, 0x16, 0x61, 0xd2, 0xbb, 0xee,
	0x05, 0x9b, 0x2a, 0x89, 0xf7, 0x5d, 0x2c, 0xc3, 0x6c, 0x84, 0xd1, 0x1c, 0x29, 0x5d, 0xf2, 0x36,
	0xa4, 0xa8, 0xdc, 0xd1, 0x02, 0xa0, 0xc6, 0x66, 0x79, 0x73, 0xab, 0xd1, 0x13, 0xab, 0xe6, 0x21,
	0x4b, 0xa2, 0xd8, 0x46, 0x6d, 0x63, 0xbd, 0xb6, 0xbe, 0x92, 0x17, 0x50, 0x06, 0x26, 0xa4, 0xad,
	0x75, 0xf2, 0x91, 0x40, 0xd3, 0x90, 0x91, 0xaa, 0x95, 0x8d, 0xf5, 0x4a, 0x6d, 0x15, 0x03, 0xc6,
	0x50, 0x16, 0x26, 0x1b, 0x9b, 0x1b, 0xf5, 0x3a, 0xfe, 0x4a, 0xa2, 0x34, 0x8c, 0x57, 0x25, 0x69,
	0x43, 0xca, 0x8f, 0xe3, 0x81, 0xe5, 0xea, 0x8a, 0x54, 0x5e, 0xae, 0x2e, 0xe7, 0x53, 0xe2, 0x97,
	0xc6, 0x61, 0x8a, 0x9d, 0xfc, 0x96, 0xd5, 0x52, 0x5c, 0x15, 0x3f, 0xdb, 0x5a, 0xaa, 0xa3, 0xd9,
	0xd8, 0x78, 0xf1, 0x4a, 0x48, 0xdf, 0x46, 0x88, 0x8d, 0xf1, 0x0a, 0x78, 0x11, 0x8a, 0x1e, 0x46,
	0x84, 0x87, 0xa7, 0x2f, 0xa5, 0x02, 0x9b, 0xb1, 0xd6, 0xe7, 0xe8, 0xb7, 0x60, 0xde, 0xc3, 0x0e,
	0xbb, 0xea, 0xd4, 0x7e, 0x5d, 0xf5, 0x2c, 0xc3, 0x0f, 0x65, 0x39, 0x4a, 0x3d, 0x6c, 0x60, 0xcf,
	0x2c, 0x6b, 0x2d, 0x2f, 0xe0, 0xe0, 0xd8, 0xc0, 0x3e, 0xb8, 0xd6, 0xc2, 0x0a, 0xe3, 0x21, 0x70,
	0x69, 0x48, 0x1a, 0x7b, 0xe4, 0xd9, 0x48, 0xcd, 0xcf, 0x46, 0xee, 0xc2, 0x89, 0xfe, 0xe5, 0xf9,
	0x7c, 0x47, 0x7a, 0x50, 0xaa, 0x80, 0xed, 0xca, 0xa7, 0x3a, 0x8a, 0x3d, 0x14, 0xf1, 0x8f, 0xfc,
	0xc7, 0xc1, 0xa3, 0x57, 0x0e, 0xe2, 0x04, 0x20, 0x71, 0x82, 0x47, 0xd9, 0xaa, 0x1f, 0x2e, 0xbc,
	0x2f, 0xc0, 0x59, 0xff, 0x38, 0x86, 0xfa, 0xa3, 0xec, 0xc1, 0xfd, 0xd1, 0x69, 0xef, 0x48, 0x07,
	0xbb, 0xa5, 0x67, 0x60, 0xa1, 0x87, 0x1c, 0x4f, 0xa3, 0x58, 0x62, 0x2d, 0xb4, 0x0c, 0xd3, 0x29,
	0xf1, 0xbb, 0x29, 0x48, 0x6f, 0x58, 0xaa, 0x4d, 0x98, 0x8a, 0x0c, 0xa6, 0x3d, 0x73, 0x9e, 0xe8,
	0x31, 0xe7, 0xaf, 0x43, 0xce, 0xf4, 0x10, 0xe9, 0x19, 0x8e, 0x0d, 0xb0, 0x7a, 0xfe, 0x1e, 0x4b,
	0xf8, 0x58, 0xa5, 0x29, 0x1f, 0x95, 0x9c, 0xf2, 0xcb, 0xbe, 0xe5, 0x4c, 0x92, 0x35, 0x4e, 0x0f,
	0x59, 0xa3, 0xc7, 0x76, 0x2e, 0x40, 0xaa, 0xa5, 0xba, 0x8a, 0xa6, 0x33, 0x35, 0x62, 0x5f, 0x11,
	0x36, 0x75, 0x3c, 0xca, 0xa6, 0x86, 0xbc, 0x59, 0xaa, 0xc7, 0x9b, 0x3d, 0x0c, 0x19, 0x57, 0xb1,
	0xdb, 0xaa, 0x4b, 0x87, 0xa9, 0x5a, 0x03, 0x05, 0x91, 0x09, 0xbc, 0xc5, 0x4a, 0x87, 0x2d, 0x16,
	0x7e, 0xda, 0x3b, 0xae, 0x62, 0xbb, 0xd4, 0xda, 0xd1, 0x87, 0x50, 0x9a, 0x40, 0x88, 0xb1, 0x7b,
	0x80, 0x78, 0x44, 0x3a, 0x48, 0x63, 0xdd, 0x09, 0xd5, 0x68, 0xe1, 0x21, 0x51, 0x1a, 0x6a, 0xa8,
	0x32, 0x30, 0x51, 0xaf, 0xae, 0x2f, 0x47, 0xd8, 0xa8, 0x49, 0x48, 0x2e, 0x6f, 0xac, 0x57, 0xa9,
	0x71, 0x2a, 0x5f, 0xda, 0x90, 0x36, 0x89, 0x71, 0x12, 0xff, 0x2f, 0x01, 0x49, 0x22, 0xee, 0x39,
	0xc8, 0x6f, 0xbe, 0x51, 0xaf, 0xf6, 0x2c, 0x88, 0x20, 0x57, 0x91, 0xaa, 0xe5, 0xcd, 0xaa, 0x5c,
	0x59, 0xdd, 0x6a, 0x6c, 0x56, 0xa5, 0xbc, 0x80, 0x61, 0xcb, 0xd5, 0xd5, 0x2a, 0x07, 0x4b, 0x60,
	0xd8, 0x56, 0x9d, 0x18, 0x36, 0x79, 0xad, 0x4c, 0x60, 0x63, 0x68, 0x06, 0xa6, 0x3c, 0xd8, 0xfa,
	0xc6, 0x72, 0xb5, 0x91, 0x4f, 0xe2, 0x69, 0x52, 0xb5, 0x5e, 0xae, 0x49, 0x3e, 0xea, 0x38, 0x45,
	0x5d, 0xe6, 0xb7, 0x48, 0x61, 0x62, 0xd8, 0xb6, 0x18, 0x53, 0xae, 0x6f, 0x6c, 0xac, 0xe6, 0x27,
	0x30, 0x94, 0x6d, 0x1c, 0x40, 0x27, 0xd1, 0x71, 0x28, 0x34, 0xaa, 0x9b, 0x01, 0x48, 0x5e, 0x2b,
	0xaf, 0x97, 0x57, 0xaa, 0x6b, 0xd5, 0xf5, 0xcd, 0x7c, 0x1a, 0xcd, 0xc3, 0x4c, 0x79, 0x6b, 0x73,
	0x43, 0x66, 0xdb, 0x52, 0x42, 0x00, 0x0b, 0x90, 0x80, 0xc3, 0x04, 0x66, 0x50, 0x0e, 0x00, 0x2f,
	0xb6, 0x5a, 0xbe, 0x54, 0x5d, 0x6d, 0xe4, 0xb3, 0x68, 0x16, 0xa6, 0xf1, 0x37, 0xe5, 0x49, 0x2e,
	0x6f, 0x6d, 0x5e, 0xce, 0x4f, 0x11, 0xe9, 0x87, 0x76, 0x6c, 0xd4, 0xae, 0x57, 0xf3, 0x39, 0x1f,
	0x5e, 0xdd, 0xbc, 0xb6, 0x21, 0x5d, 0x91, 0xeb, 0x1b, 0xab, 0xb5, 0xca, 0x1b, 0xf9, 0x69, 0x54,
	0x84, 0x05, 0xba, 0x48, 0x6d, 0x7d, 0xb3, 0xba, 0x5e, 0x5e, 0xaf, 0x54, 0xbd, 0xb1, 0xbc, 0xf8,
	0x15, 0x01, 0xe6, 0x2a, 0x24, 0x5c, 0x60, 0x9e, 0x40, 0x52, 0x3f, 0xd9, 0x55, 0x1d, 0x17, 0x9d,
	0x02, 0xb0, 0x6c, 0xf3, 0x2d, 0xb5, 0xe9, 0x62, 0xcb, 0x29, 0xf8, 0x17, 0x2d, 0xcd, 0xa0, 0xb5,
	0x56, 0xec, 0x2d, 0x7c, 0x0e, 0x26, 0x58, 0xc0, 0xc4, 0x52, 0xb2, 0xc7, 0x07, 0x05, 0x1d, 0x92,
	0x37, 0x19, 0x5f, 0x19, 0x4b, 0xc1, 0xbe, 0x99, 0x5d, 0x09, 0xf6, 0x25, 0x7e, 0x5a, 0x80, 0x99,
	0x15, 0xd5, 0xbd, 0x7b, 0x04, 0x9e, 0x02, 0xf0, 0x5f, 0x91, 0x34, 0x6d, 0xcc, 0x50, 0xbd, 0x27,
	0x64, 0xcb, 0xb7, 0x3a, 0xe3, 0x81, 0xd5, 0x11, 0xff, 0x54, 0x80, 0x39, 0xea, 0x28, 0x8f, 0x94,
	0x94, 0x0b, 0x90, 0xea, 0x92, 0x5d, 0xd9, 0x23, 0x5f, 0x1c, 0x24, 0x4d, 0x4a, 0x9f, 0xc4, 0x30,
	0x22, 0xd9, 0xf8, 0x9e, 0x00, 0xf3, 0x74, 0x9a, 0xff, 0x1e, 0x3d, 0x12, 0x3e, 0x1e, 0x81, 0x6c,
	0xc8, 0x1b, 0x07, 0xd9, 0x2c, 0x30, 0x02, 0x57, 0x7c, 0x8a, 0xcd, 0xf2, 0x1c, 0x05, 0xa5, 0x9c,
	0xe4, 0x3a, 0xbc, 0x98, 0x23, 0x5c, 0x2c, 0x4c, 0xf5, 0x16, 0x0b, 0x3d, 0x9e, 0x27, 0x39, 0x9e,
	0x7f, 0x22, 0x01, 0x27, 0x1a, 0xaa, 0x1b, 0xe5, 0x7c, 0xef, 0x23, 0xde, 0x5f, 0x87, 0x0c, 0x1f,
	0x46, 0x8c, 0x8f, 0x18, 0x46, 0xf0, 0xc8, 0xbe, 0x14, 0x52, 0x9c, 0x14, 0x7e, 0x57, 0x80, 0x42,
	0x43, 0x75, 0x57, 0x43, 0xc9, 0x99, 0x11, 0x04, 0x80, 0x78, 0x01, 0xec, 0x9f, 0xf9, 0x88, 0x34,
	0x51, 0x32, 0x32, 0x4d, 0x14, 0xa5, 0xad, 0x7f, 0x2c, 0xc0, 0x83, 0x0d, 0xd5, 0xed, 0x8b, 0x1d,
	0x8f, 0xe6, 0xdc, 0xa2, 0x13, 0x57, 0xc9, 0xb8, 0xc4, 0x55, 0x94, 0xd0, 0xff, 0x46, 0x80, 0x85,
	0x86, 0xea, 0x86, 0xa2, 0xd6, 0x23, 0xa1, 0xbd, 0x2f, 0xff, 0x95, 0x3c, 0x58, 0xfe, 0x2b, 0x8a,
	0xa9, 0xaf, 0x0a, 0x30, 0x4b, 0x34, 0x89, 0x45, 0x9e, 0x47, 0xc3, 0x51, 0x28, 0x57, 0x96, 0xec,
	0xcd, 0x95, 0x45, 0xd1, 0xf9, 0xdb, 0x02, 0xcc, 0x52, 0x5b, 0x47, 0x43, 0xcc, 0xa3, 0xa1, 0xf3,
	0x34, 0xe4, 0x7a, 0xc2, 0x5d, 0xaa, 0x31, 0x53, 0x9d, 0xd0, 0x93, 0xdf, 0x23, 0x78, 0x82, 0x23,
	0xf8, 0x1f, 0x13, 0x30, 0x87, 0xd5, 0x3d, 0x48, 0xb8, 0x1e, 0x09, 0xc5, 0x97, 0x21, 0xa5, 0x34,
	0x5d, 0x8f, 0xd2, 0x5c, 0x4c, 0x9a, 0x30, 0x8a, 0xb0, 0xa5, 0x32, 0xc1, 0x93, 0x18, 0x3e, 0x7a,
	0xde, 0xf7, 0x56, 0xfb, 0x4c, 0x28, 0xf7, 0xba, 0x2a, 0x5e, 0x1a, 0x75, 0x48, 0xd1, 0xe5, 0x71,
	0x30, 0xb9, 0xb5, 0x7e, 0x65, 0x7d, 0xe3, 0xda, 0x3a, 0x7d, 0x0f, 0xe3, 0x80, 0xa6, 0x5e, 0x6e,
	0x34, 0xae, 0x6d, 0x48, 0xcb, 0x79, 0x01, 0x87, 0x59, 0x2b, 0xd5, 0xf5, 0xaa, 0x84, 0x43, 0x36,
	0x1f, 0x9c, 0xf0, 0x26, 0x6e, 0x35, 0xaa, 0xd2, 0x7a, 0x79, 0xad, 0x9a, 0x1f, 0x13, 0xdf, 0x15,
	0x60, 0x6e, 0x59, 0xd5, 0xd5, 0x23, 0xf6, 0xe1, 0x1e, 0x73, 0x49, 0x8e, 0xb9, 0x1d, 0x98, 0x5d,
	0xd5, 0x1c, 0x2f, 0xac, 0xb9, 0x1b, 0x57, 0x28, 0x08, 0xa0, 0x92, 0xa1, 0x00, 0xaa, 0x0b, 0x73,
	0xe1, 0x9d, 0x1c, 0xcb, 0x34, 0x1c, 0x15, 0xbd, 0x00, 0x93, 0x8c, 0x44, 0xa7, 0x20, 0x90, 0xf4,
	0xf0, 0xe0, 0x48, 0xcd, 0x9f, 0x8d, 0x3e, 0x0a, 0x53, 0x1d, 0xcd, 0x71, 0xb0, 0x51, 0xc4, 0x3b,
	0xd3, 0x8a, 0x65, 0x5a, 0xca, 0x32, 0xe0, 0x75, 0x0c, 0x13, 0xdf, 0x13, 0x60, 0x76, 0x45, 0x75,
	0xfd, 0x27, 0xd2, 0x5d, 0xe0, 0xf0, 0x34, 0x64, 0x83, 0x07, 0x5e, 0x48, 0xd8, 0x19, 0x1f, 0x1e,
	0x13, 0xbd, 0xbd, 0x05, 0xf3, 0x58, 0x08, 0x3e, 0x35, 0xf7, 0x52, 0xe0, 0x1f, 0x08, 0xb0, 0x50,
	0x51, 0x8c, 0xa6, 0xaa, 0xff, 0x00, 0x99, 0xe7, 0x75, 0xed, 0x0e, 0x2c, 0xf4, 0x32, 0xcf, 0x74,
	0xe0, 0x15, 0x00, 0x1f, 0xd9, 0xd3, 0x82, 0x87, 0x06, 0x3f, 0x75, 0x25, 0x0e, 0x63, 0x7f, 0x9a,
	0xd0, 0x86, 0x85, 0x15, 0xd5, 0xc5, 0x5e, 0xd2, 0x4f, 0xe2, 0x1e, 0x5e, 0x1c, 0x51, 0x7c, 0x7e,
	0x2a, 0x01, 0x59, 0x7e, 0x1b, 0xf4, 0x1c, 0x1c, 0x6b, 0xa9, 0x37, 0x94, 0xae, 0xee, 0xf6, 0x25,
	0x71, 0x69, 0x42, 0x61, 0x9e, 0x0d, 0xf7, 0x24, 0x71, 0x97, 0x60, 0xf6, 0xa6, 0xa2, 0x6b, 0xe1,
	0x3c, 0x98, 0xd7, 0x2e, 0x37, 0x43, 0x86, 0xb8, 0x34, 0x98, 0x43, 0x33, 0x48, 0x74, 0x1f, 0x2e,
	0x36, 0x4d, 0x7a, 0x19, 0x24, 0x32, 0x12, 0x64, 0x90, 0x16, 0x81, 0x2e, 0xc1, 0xcd, 0x75, 0x0a,
	0xe3, 0x64, 0xed, 0x69, 0x32, 0xe0, 0x4f, 0x75, 0xd0, 0x79, 0x98, 0xa7, 0x73, 0xc3, 0x2e, 0x85,
	0xb6, 0xc2, 0xa5, 0x25, 0x4a, 0x66, 0x28, 0x81, 0xe2, 0x88, 0xdf, 0x11, 0x60, 0x9e, 0xbe, 0xea,
	0x8e, 0x36, 0xc4, 0xbf, 0x00, 0x69, 0x3f, 0xcc, 0x65, 0xe1, 0xc6, 0x90, 0x4a, 0xd8, 0xa4, 0x17,
	0xfe, 0x72, 0x77, 0x29, 0x15, 0xba, 0x4b, 0xbf, 0x23, 0xc0, 0x3c, 0xb5, 0xd8, 0xf7, 0xe3, 0x73,
	0x25, 0x2a, 0xe8, 0xf8, 0xac, 0x40, 0xed, 0xad, 0x47, 0xef, 0x11, 0x45, 0x47, 0x71, 0xcf, 0xe7,
	0xdf, 0x12, 0x00, 0xad, 0x04, 0x6f, 0x9f, 0xfb, 0x5d, 0x7a, 0xff, 0x9c, 0x84, 0x49, 0x8f, 0xd6,
	0xc8, 0xe4, 0xdf, 0xf3, 0x90, 0x62, 0x01, 0x6d, 0x62, 0x7f, 0x45, 0x6f, 0x36, 0x7d, 0xc4, 0x02,
	0xfb, 0xc0, 0x7a, 0x52, 0x01, 0x26, 0x3c, 0x33, 0x42, 0x1b, 0xfe, 0xbc, 0x4f, 0x6c, 0x38, 0xa2,
	0xea, 0x15, 0x37, 0xa8, 0xe1, 0xe8, 0xaf, 0x55, 0x5c, 0xf4, 0xd3, 0x8c, 0x6d, 0x12, 0x79, 0x3d,
	0x32, 0xf0, 0xbe, 0x0c, 0xaf, 0xd0, 0xec, 0x44, 0x65, 0x13, 0x7b, 0x1e, 0x96, 0xc9, 0xc3, 0x3c,
	0x2c, 0x2b, 0x00, 0x1d, 0xc5, 0x50, 0xda, 0x6a, 0xc7, 0x53, 0xb5, 0x4c, 0x4c, 0x7e, 0x15, 0x2f,
	0xb5, 0xe6, 0x4f, 0x95, 0x38, 0x34, 0xf1, 0xc7, 0x84, 0xc3, 0x16, 0x3d, 0x16, 0x00, 0xb1, 0x0f,
	0xf9, 0x5a, 0x6d, 0xf3, 0xb2, 0x4c, 0x4b, 0x1c, 0x63, 0xbd, 0xc5, 0x90, 0x64, 0xa8, 0x18, 0x32,
	0x1e, 0x14, 0x43, 0x52, 0xe2, 0xd7, 0x04, 0xc8, 0x85, 0x49, 0x44, 0xa7, 0x20, 0x8b, 0x59, 0x95,
	0xbb, 0x56, 0xdb, 0x56, 0x5a, 0x5e, 0x77, 0x25, 0x61, 0x7f, 0x8b, 0x82, 0xd0, 0xc3, 0x54, 0x94,
	0xb2, 0xad, 0x5a, 0x8a, 0x66, 0xb3, 0x46, 0x1f, 0xc0, 0x20, 0x89, 0x40, 0x50, 0x1d, 0xa6, 0x19,
	0xba, 0x6c, 0x5a, 0x5e, 0xba, 0x3e, 0xbe, 0xc0, 0x5c, 0x0e, 0xd6, 0xde, 0xa0, 0xd3, 0xa5, 0x5c,
	0x37, 0xf4, 0x2d, 0x76, 0x00, 0xf5, 0xcf, 0x42, 0xcf, 0xc2, 0x31, 0x9e, 0x56, 0x99, 0x4b, 0xea,
	0xd2, 0xdb, 0x32, 0xc7, 0x91, 0xdd, 0xf0, 0xf3, 0xbb, 0x43, 0xfb, 0x50, 0xc4, 0x06, 0xcc, 0xf4,
	0x15, 0x87, 0xd1, 0x2b, 0x90, 0x7a, 0x5b, 0x33, 0x5a, 0xe6, 0xdb, 0x03, 0x7b, 0x45, 0x39, 0xbc,
	0x6b, 0x64, 0xb6, 0xc4, 0xb0, 0xc4, 0xcf, 0x08, 0xa1, 0x55, 0xe9, 0x28, 0x6a, 0x43, 0xa1, 0xa5,
	0x68, 0xfa, 0x9e, 0xcc, 0x17, 0xaf, 0xd9, 0x3e, 0xf4, 0x72, 0x47, 0x77, 0x87, 0x2d, 0x63, 0xa4,
	0xbe, 0xe5, 0x2e, 0x7f, 0x44, 0x5a, 0x68, 0x45, 0x8e, 0x5c, 0x9a, 0x84, 0x14, 0xad, 0x89, 0x8b,
	0x0d, 0x58, 0x88, 0xc6, 0xee, 0x49, 0x8c, 0x27, 0x7a, 0x13, 0xe3, 0x45, 0x98, 0x6c, 0x75, 0x69,
	0xd4, 0xc3, 0x7a, 0xb6, 0xfc, 0x6f, 0xf1, 0x7f, 0x04, 0x38, 0xce, 0xa5, 0x97, 0x38, 0xa5, 0xbf,
	0x8f, 0x8c, 0xed, 0xdd, 0xb8, 0xb8, 0x91, 0xaf, 0xb4, 0xbf, 0xa2, 0x19, 0x0e, 0x8f, 0xfb, 0x86,
	0x76, 0x4b, 0xbd, 0x9f, 0xf8, 0x3e, 0xc1, 0xfa, 0x73, 0xa8, 0xb9, 0x1f, 0x27, 0xe6, 0x3e, 0x6d,
	0xf8, 0x76, 0x3e, 0x8a, 0xa3, 0xdf, 0x17, 0xe0, 0x21, 0xc9, 0xd4, 0xf5, 0x6d, 0xa5, 0xb9, 0xeb,
	0xb1, 0xc5, 0x6e, 0xd2, 0xfd, 0xee, 0x3e, 0xb7, 0xe8, 0x33, 0x87, 0x8b, 0x3d, 0x58, 0xa0, 0x1f,
	0x6e, 0x53, 0x12, 0x46, 0x6b, 0x53, 0x12, 0x6f, 0xc3, 0x6c, 0x54, 0x75, 0x32, 0xbe, 0xa3, 0xf5,
	0x11, 0xc8, 0x75, 0x34, 0x83, 0x77, 0xb4, 0xf4, 0xc7, 0x28, 0xd9, 0x8e, 0x66, 0x04, 0x4e, 0x16,
	0xcf, 0x52, 0xde, 0xe9, 0x77, 0xc7, 0xd9, 0x8e, 0xf2, 0x8e, 0x3f, 0x4b, 0xfc, 0xfb, 0x04, 0xe4,
	0x1b, 0xaa, 0x4b, 0x0b, 0xec, 0x47, 0x73, 0x00, 0xdb, 0xfd, 0x0d, 0x54, 0xf4, 0x27, 0x2e, 0x2f,
	0xc6, 0x65, 0x46, 0x42, 0xd4, 0x1d, 0xbc, 0x93, 0x6a, 0x3c, 0xa6, 0x93, 0x2a, 0x42, 0x4d, 0xef,
	0x46, 0xf3, 0xc1, 0xaf, 0x0a, 0x24, 0xdf, 0xc4, 0x35, 0x5f, 0x1d, 0x89, 0x78, 0x39, 0xbd, 0x49,
	0x86, 0xf5, 0x26, 0x4a, 0xa7, 0xff, 0x00, 0x1b, 0x18, 0x6c, 0x88, 0x6b, 0x75, 0x89, 0xfd, 0x80,
	0xea, 0x68, 0xd3, 0x36, 0x1c, 0x31, 0xe8, 0x49, 0x40, 0x36, 0x26, 0x42, 0x95, 0x9b, 0xb6, 0xda,
	0x52, 0x0d, 0x1c, 0x35, 0x3a, 0xe4, 0x58, 0x26, 0xa5, 0x19, 0x3a, 0x52, 0x09, 0x06, 0xc4, 0xf7,
	0x05, 0x78, 0xa0, 0x62, 0x76, 0x2c, 0xfc, 0x80, 0xf9, 0x41, 0x91, 0xcf, 0x9b, 0xb6, 0x5d, 0x98,
	0xe9, 0xfb, 0xf9, 0x11, 0xd6, 0x44, 0xee, 0x07, 0x48, 0xec, 0x26, 0x62, 0x6a, 0xc6, 0xa4, 0xbc,
	0xc2, 0xcf, 0xc6, 0x77, 0xf6, 0x2c, 0xf0, 0x30, 0xfa, 0xd0, 0xa5, 0x7a, 0x35, 0xcd, 0xc1, 0xf1,
	0xe3, 0x55, 0xfc, 0x50, 0x80, 0x63, 0xd8, 0x33, 0x84, 0xba, 0xf2, 0x8e, 0x84, 0xf5, 0xfe, 0xb6,
	0xc1, 0xe4, 0x41, 0xdb, 0x06, 0xa3, 0x34, 0xf2, 0x1f, 0x58, 0x55, 0xa2, 0xaf, 0x89, 0x8e, 0x31,
	0x77, 0xa2, 0x9f, 0xb9, 0x61, 0x85, 0x94, 0x13, 0xfd, 0x4c, 0xf1, 0x0c, 0x45, 0x77, 0xf8, 0x25,
	0x0f, 0xdb, 0xe1, 0x17, 0x95, 0x29, 0xab, 0xf9, 0x4d, 0xfb, 0xc1, 0xef, 0x16, 0xbc, 0xf6, 0x57,
	0x21, 0xdc, 0x8f, 0x1b, 0xee, 0x8d, 0x4d, 0xf4, 0xf6, 0xc6, 0x9e, 0xff, 0x8b, 0x17, 0x21, 0xc7,
	0x32, 0x2b, 0x34, 0xa0, 0xb0, 0xd1, 0x5f, 0x0a, 0x90, 0xe5, 0xb3, 0x91, 0x28, 0xfa, 0x1d, 0x12,
	0x91, 0x1a, 0x2d, 0x9e, 0xdd, 0xc7, 0x4c, 0xea, 0xed, 0xc4, 0xf6, 0x8f, 0xff, 0xed, 0x3f, 0x7d,
	0x21, 0xa1, 0xa0, 0x27, 0x4a, 0x37, 0xcf, 0x95, 0x6e, 0xd3, 0x97, 0xf0, 0xcb, 0xec, 0x00, 0x9c,
	0xd2, 0x62, 0xc9, 0x2f, 0x1b, 0x94, 0x16, 0xef, 0x78, 0x3f, 0xe7, 0x74, 0xae, 0x9f, 0x43, 0x25,
	0x3c, 0xdf, 0x9f, 0x77, 0x3b, 0x38, 0xc4, 0x3b, 0x25, 0x92, 0xde, 0x2a, 0xdd, 0xc6, 0xff, 0x04,
	0x28, 0xe8, 0xcf, 0x04, 0x80, 0xa0, 0x38, 0x8d, 0xa2, 0x8f, 0xa2, 0xaf, 0x7a, 0x5d, 0x1c, 0x98,
	0x68, 0x15, 0x5d, 0x42, 0xbd, 0xc1, 0xa8, 0xc7, 0x87, 0x12, 0x43, 0xbb, 0x4f, 0x47, 0x69, 0xf1,
	0xce, 0xf5, 0x57, 0xd0, 0xc5, 0x11, 0xa9, 0x2f, 0xdd, 0x0e, 0x54, 0xee, 0x0e, 0xfa, 0x8e, 0x00,
	0x53, 0xa1, 0x5e, 0x00, 0x14, 0x2d, 0xf0, 0xa8, 0x7e, 0x81, 0xe2, 0x90, 0x9c, 0xa1, 0xd8, 0x21,
	0x2c, 0xb5, 0xc5, 0x91, 0x0e, 0xe4, 0x82, 0xb0, 0x78, 0xfd, 0x19, 0x71, 0xd4, 0x33, 0xb9, 0x20,
	0x2c, 0xa2, 0x0f, 0x05, 0x98, 0x0a, 0xd5, 0xea, 0x63, 0x78, 0x89, 0xaa, 0xe7, 0x0f, 0xe5, 0xe5,
	0x16, 0xe1, 0xc5, 0x2d, 0x8e, 0x74, 0x3c, 0x98, 0x97, 0x72, 0xf1, 0x50, 0x27, 0x84, 0x19, 0xfb,
	0x4c, 0x02, 0x72, 0xe1, 0xea, 0x3d, 0x5a, 0x1c, 0xc0, 0x59, 0x4f, 0xd6, 0x67, 0x28, 0x6b, 0xbf,
	0x21, 0x10, 0xde, 0x7e, 0x45, 0x28, 0xbe, 0x30, 0x02, 0x73, 0x25, 0x3f, 0x50, 0x64, 0x8c, 0x2a,
	0xe2, 0x9b, 0x87, 0x61, 0x94, 0x5b, 0xef, 0x36, 0x1f, 0x07, 0xdf, 0x29, 0xd1, 0x62, 0x11, 0x16,
	0xc4, 0x37, 0x12, 0xa1, 0x57, 0x07, 0x1f, 0x95, 0x9e, 0x8f, 0x8b, 0xd1, 0xe2, 0xeb, 0xff, 0x43,
	0x05, 0xf3, 0x87, 0x54, 0x30, 0xbf, 0x27, 0x88, 0x2b, 0x07, 0x16, 0x8c, 0xa3, 0xba, 0xdc, 0xce,
	0x58, 0x4e, 0x37, 0x44, 0xe5, 0xde, 0xc8, 0x49, 0x09, 0xed, 0x83, 0xfe, 0x53, 0x80, 0x99, 0xbe,
	0xca, 0x3f, 0x7a, 0x32, 0x36, 0x96, 0x8d, 0xea, 0x10, 0x18, 0x2a, 0xa2, 0x0f, 0xa8, 0x88, 0x7e,
	0x52, 0x10, 0x9f, 0x1f, 0xe9, 0x62, 0x38, 0xfe, 0x86, 0x58, 0x24, 0x35, 0x71, 0xf9, 0x50, 0x22,
	0xd1, 0xfd, 0xa5, 0xd0, 0xff, 0xd3, 0xe0, 0xb6, 0xbf, 0xef, 0x34, 0xbe, 0xbc, 0x19, 0xd3, 0x66,
	0x30, 0x94, 0xf7, 0x2f, 0x52, 0xde, 0xdf, 0x17, 0xc4, 0x0b, 0xa3, 0xf2, 0x1e, 0xec, 0x89, 0xd9,
	0x5f, 0xa5, 0xfa, 0x75, 0x60, 0xf6, 0x3b, 0xfc, 0x6a, 0xe8, 0xdf, 0x04, 0x98, 0xee, 0x69, 0x3e,
	0x40, 0x8f, 0xc7, 0x31, 0x1f, 0xd1, 0xa2, 0x30, 0x94, 0xef, 0xcf, 0x52, 0xbe, 0x3f, 0x2d, 0x88,
	0xcf, 0x8d, 0xca, 0x37, 0xdd, 0x0e, 0xf3, 0x7c, 0x59, 0xac, 0x1c, 0x8a, 0x67, 0xc5, 0x5b, 0x09,
	0xf3, 0x9b, 0xe5, 0xfb, 0x12, 0x62, 0x82, 0x8b, 0x88, 0xd6, 0x85, 0xa1, 0x9c, 0xfe, 0x2c, 0xe5,
	0xf4, 0x3d, 0x41, 0x7c, 0x71, 0x74, 0xed, 0x66, 0x43, 0x98, 0xd9, 0x2b, 0xe2, 0x6b, 0x87, 0xd4,
	0xef, 0x60, 0x31, 0xf4, 0xaf, 0x02, 0x64, 0xf9, 0xfe, 0x86, 0x18, 0x7e, 0x23, 0x5a, 0x20, 0x86,
	0xf2, 0xfb, 0x33, 0x94, 0xdf, 0x77, 0x47, 0xe5, 0xb7, 0xcb, 0xed, 0x75, 0x37, 0x0e, 0xb7, 0xe3,
	0xad, 0x84, 0xfe, 0x4b, 0x80, 0xa9, 0x50, 0x0b, 0x42, 0x8c, 0x4f, 0x8f, 0x6a, 0x53, 0x18, 0xca,
	0xee, 0xcf, 0x53, 0x76, 0x3f, 0x77, 0x90, 0x0b, 0xec, 0x6f, 0x86, 0xf9, 0xdd, 0x10, 0x5f, 0x3f,
	0x94, 0x8f, 0xef, 0x5d, 0x10, 0xfd, 0xb5, 0x00, 0x53, 0xa1, 0x96, 0x85, 0x18, 0xb6, 0xa3, 0xda,
	0x1a, 0x86, 0xb2, 0xcd, 0x22, 0xcd, 0xc5, 0x11, 0x23, 0xcd, 0xc5, 0xc3, 0x45, 0x9a, 0x1f, 0x0a,
	0x90, 0x0b, 0xd7, 0xa3, 0x63, 0x82, 0x98, 0xc8, 0x8a, 0x7d, 0xf1, 0xf1, 0x7d, 0xcd, 0x65, 0x2f,
	0x81, 0x5d, 0xc2, 0xa1, 0x8a, 0x96, 0xf6, 0x13, 0x78, 0x06, 0x85, 0xed, 0xeb, 0x4f, 0xa3, 0x73,
	0xfb, 0xe4, 0x91, 0xab, 0x86, 0xff, 0x9d, 0x00, 0x59, 0xbe, 0xe5, 0x21, 0xe6, 0x3e, 0x46, 0x74,
	0x45, 0xec, 0x37, 0xe8, 0x64, 0x7c, 0x0c, 0x3a, 0xa9, 0x80, 0x1e, 0x7c, 0x56, 0x97, 0xd0, 0xab,
	0x23, 0xf3, 0x51, 0xba, 0xcd, 0x37, 0x1a, 0xdc, 0x41, 0xff, 0x22, 0xc0, 0x74, 0x4f, 0x3f, 0x43,
	0x8c, 0x1b, 0x89, 0xee, 0x7a, 0x28, 0x2e, 0x78, 0x93, 0xbd, 0xff, 0xe8, 0x66, 0xa9, 0xda, 0xb1,
	0xdc, 0x3d, 0xce, 0xc8, 0x3c, 0x3b, 0x1a, 0x5b, 0x17, 0x9a, 0x64, 0xa3, 0xd1, 0x3c, 0x66, 0x2c,
	0x83, 0xc1, 0x6a, 0xf8, 0xb6, 0x4d, 0xf7, 0xf4, 0x2a, 0xc4, 0xb0, 0x1a, 0xdd, 0xd1, 0x50, 0x3c,
	0x15, 0x63, 0x93, 0x82, 0x99, 0xde, 0x5b, 0x68, 0xf8, 0x51, 0xde, 0x29, 0x39, 0x1c, 0xde, 0xf5,
	0x67, 0xd1, 0xd3, 0xfb, 0xe4, 0x94, 0xa2, 0xb1, 0xba, 0x27, 0xb6, 0x9b, 0xa1, 0x9c, 0x30, 0x8a,
	0x7f, 0x48, 0xf7, 0xd6, 0xac, 0x8b, 0x8b, 0xfb, 0x99, 0xca, 0xae, 0xda, 0x7b, 0xf4, 0x34, 0x3f,
	0x25, 0xa0, 0x17, 0x86, 0x5f, 0x36, 0xde, 0xa0, 0x04, 0x71, 0xec, 0xf5, 0xcb, 0xe8, 0xb5, 0xbb,
	0x13, 0x11, 0xa3, 0xff, 0x10, 0x20, 0xc3, 0xd5, 0xbd, 0xd1, 0x63, 0x71, 0xa7, 0xd8, 0xfb, 0x46,
	0x1a, 0x9c, 0x15, 0x17, 0xbf, 0x4c, 0xb9, 0xfc, 0x82, 0xc7, 0xe5, 0x01, 0x5e, 0x02, 0xd7, 0xaf,
	0xa1, 0xad, 0x7b, 0x12, 0xf7, 0xa3, 0x7f, 0x17, 0x20, 0x17, 0xee, 0xfc, 0x88, 0xb1, 0xac, 0x91,
	0xed, 0x21, 0x43, 0x8d, 0xd0, 0xe7, 0x29, 0xef, 0x3f, 0x2d, 0x88, 0x07, 0x3e, 0xe1, 0xbb, 0x11,
	0x03, 0xf1, 0x8b, 0xa1, 0xff, 0x16, 0x20, 0x17, 0x6e, 0x10, 0x89, 0x61, 0x39, 0xb2, 0x8b, 0x64,
	0x28, 0xcb, 0xfe, 0x71, 0x2f, 0x1e, 0xe2, 0xb8, 0x17, 0xef, 0xd1, 0x71, 0xff, 0x5a, 0x02, 0x8e,
	0xc5, 0x14, 0xaa, 0x50, 0xf4, 0x0f, 0xbb, 0x06, 0x97, 0xb5, 0x86, 0x4a, 0xe3, 0x5b, 0x54, 0x1a,
	0xbf, 0x29, 0x88, 0xe5, 0x03, 0x3f, 0x83, 0x6d, 0x46, 0x02, 0xd6, 0x84, 0xa6, 0xf8, 0x89, 0x7b,
	0x22, 0x19, 0x7e, 0x13, 0xf4, 0xf5, 0x04, 0xcc, 0x47, 0x96, 0x67, 0xd1, 0xb9, 0x61, 0x99, 0x82,
	0xbe, 0x52, 0xee, 0x50, 0x09, 0xfd, 0x11, 0x95, 0xd0, 0xb7, 0x05, 0xaa, 0xe3, 0x07, 0x4d, 0x14,
	0x04, 0x1b, 0x63, 0x31, 0xed, 0x88, 0xcd, 0x7b, 0x93, 0x27, 0xe8, 0xdd, 0x09, 0x7d, 0x4f, 0x80,
	0xb4, 0x5f, 0xcd, 0x42, 0xa7, 0xf7, 0x55, 0xed, 0x1a, 0x2a, 0x93, 0x5f, 0xa4, 0x32, 0xf9, 0x92,
	0x20, 0xbe, 0x32, 0x6a, 0x70, 0x1d, 0x2e, 0x70, 0x61, 0x59, 0xd4, 0xc5, 0x2b, 0x87, 0x92, 0x85,
	0xdd, 0xbb, 0x22, 0xe6, 0x79, 0x2a, 0x54, 0x04, 0x8b, 0x7f, 0x58, 0xf4, 0x15, 0xca, 0xee, 0x65,
	0x66, 0x20, 0xd8, 0xec, 0x6e, 0x64, 0x06, 0x74, 0x7e, 0x35, 0xf4, 0xbf, 0x02, 0x4c, 0xf7, 0xd4,
	0xd4, 0xe2, 0x32, 0x03, 0x91, 0x95, 0xb7, 0xa1, 0x7c, 0xff, 0x02, 0xe5, 0xfb, 0x8b, 0x82, 0x78,
	0x71, 0x34, 0xbe, 0xc9, 0x76, 0x96, 0xb7, 0x1d, 0xe6, 0xfc, 0xe3, 0xe2, 0xea, 0xe1, 0x9e, 0x54,
	0x7d, 0x4b, 0xa2, 0x77, 0x13, 0x80, 0xfa, 0xcb, 0x72, 0x68, 0x29, 0xda, 0x57, 0xc6, 0xd5, 0xef,
	0x86, 0x0a, 0xe1, 0x2b, 0x54, 0x08, 0x5f, 0x16, 0xc4, 0x8f, 0x8d, 0x24, 0x84, 0xa6, 0xb7, 0x63,
	0x48, 0x0e, 0x9b, 0xe2, 0xc6, 0xa1, 0xe4, 0x10, 0xb9, 0x2a, 0xfa, 0x7c, 0x82, 0xe4, 0x88, 0xf8,
	0xf6, 0x8d, 0xf8, 0x1c, 0x51, 0x44, 0x93, 0xc7, 0x50, 0x21, 0x7c, 0x93, 0x0a, 0xe1, 0xeb, 0x82,
	0xf8, 0xea, 0x61, 0x2c, 0x22, 0xde, 0x12, 0x4b, 0x61, 0x5b, 0xfc, 0xe1, 0x7b, 0x66, 0x0b, 0xd9,
	0x1e, 0xe8, 0x47, 0x69, 0xc7, 0x41, 0xf8, 0xff, 0xae, 0x7a, 0x22, 0x56, 0x28, 0x11, 0xf5, 0xcd,
	0xa1, 0x52, 0xf9, 0x25, 0x2a, 0x95, 0x9f, 0x13, 0xc4, 0x97, 0x47, 0xb5, 0x0b, 0xa1, 0xfd, 0xb0,
	0x48, 0x24, 0x71, 0xed, 0xb0, 0x39, 0x87, 0xde, 0x35, 0xd1, 0xe7, 0xbc, 0x5f, 0xa2, 0xf4, 0x96,
	0x0c, 0x07, 0xfc, 0x36, 0x24, 0xba, 0x1a, 0x3a, 0x54, 0x14, 0x5f, 0xa5, 0xa2, 0xf8, 0xe5, 0xd1,
	0x82, 0x0a, 0xe6, 0x26, 0x7b, 0xf6, 0xc4, 0xe2, 0xb8, 0x2a, 0x7e, 0xfc, 0xf0, 0x29, 0x98, 0xfe,
	0x75, 0x2f, 0x7d, 0x4d, 0x80, 0x63, 0x4d, 0xb3, 0x13, 0xc5, 0xcd, 0xa5, 0xd9, 0x8a, 0xf7, 0xdf,
	0x5f, 0x91, 0xbc, 0x71, 0x1d, 0xbf, 0x73, 0xeb, 0xc2, 0xf5, 0x8b, 0x6c, 0x6e, 0xdb, 0xd4, 0x15,
	0xa3, 0xbd, 0x64, 0xda, 0xed, 0x52, 0x5b, 0x35, 0xc8, 0x2b, 0xb8, 0x44, 0x87, 0x14, 0x4b, 0x73,
	0x42, 0xff, 0xbb, 0xec, 0x4b, 0xfe, 0xc7, 0x37, 0x12, 0x0f, 0xac, 0x50, 0xf4, 0x8a, 0x6e, 0x76,
	0x5b, 0x4b, 0x15, 0x7f, 0xc3, 0xab, 0xe7, 0xfe, 0xdc, 0x1b, 0x7b, 0x93, 0x8c, 0xbd, 0xe9, 0x8f,
	0xbd, 0x79, 0xf5, 0xdc, 0x76, 0x8a, 0x6c, 0xf0, 0xf4, 0xf7, 0x03, 0x00, 0x00, 0xff, 0xff, 0x61,
	0xea, 0xa4, 0xfb, 0xbd, 0x56, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ClusterManagerClient is the client API for ClusterManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the version and/or image type for a specific node pool.
	UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the autoscaling settings for a specific node pool.
	SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the locations for a specific cluster.
	SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password for a specific cluster.
	// This can be either via password generation or explicitly set the password.
	SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns configuration info about the Kubernetes Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables/Disables Network Policy for a cluster.
	SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error)
}

type clusterManagerClient struct {
	cc *grpc.ClientConn
}

func NewClusterManagerClient(cc *grpc.ClientConn) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/UpdateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetNodePoolAutoscaling", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLoggingService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetMonitoringService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetAddonsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/UpdateMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetMasterAuth", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/GetOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/CancelOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/GetServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/ListNodePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/GetNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/CreateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/DeleteNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/RollbackNodePoolUpgrade", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetNodePoolManagement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLegacyAbac", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/StartIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/CompleteIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetNodePoolSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1.ClusterManager/SetMaintenancePolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterManagerServer is the server API for ClusterManager service.
type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Updates the version and/or image type for a specific node pool.
	UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*Operation, error)
	// Sets the autoscaling settings for a specific node pool.
	SetNodePoolAutoscaling(context.Context, *SetNodePoolAutoscalingRequest) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(context.Context, *SetLoggingServiceRequest) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(context.Context, *SetMonitoringServiceRequest) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(context.Context, *SetAddonsConfigRequest) (*Operation, error)
	// Sets the locations for a specific cluster.
	SetLocations(context.Context, *SetLocationsRequest) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(context.Context, *UpdateMasterRequest) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password for a specific cluster.
	// This can be either via password generation or explicitly set the password.
	SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(context.Context, *CancelOperationRequest) (*empty.Empty, error)
	// Returns configuration info about the Kubernetes Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(context.Context, *SetLabelsRequest) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(context.Context, *SetNodePoolSizeRequest) (*Operation, error)
	// Enables/Disables Network Policy for a cluster.
	SetNetworkPolicy(context.Context, *SetNetworkPolicyRequest) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(context.Context, *SetMaintenancePolicyRequest) (*Operation, error)
}

// UnimplementedClusterManagerServer can be embedded to have forward compatible implementations.
type UnimplementedClusterManagerServer struct {
}

func (*UnimplementedClusterManagerServer) ListClusters(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedClusterManagerServer) GetCluster(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClusterManagerServer) CreateCluster(ctx context.Context, req *CreateClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateCluster(ctx context.Context, req *UpdateClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateNodePool(ctx context.Context, req *UpdateNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolAutoscaling(ctx context.Context, req *SetNodePoolAutoscalingRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolAutoscaling not implemented")
}
func (*UnimplementedClusterManagerServer) SetLoggingService(ctx context.Context, req *SetLoggingServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLoggingService not implemented")
}
func (*UnimplementedClusterManagerServer) SetMonitoringService(ctx context.Context, req *SetMonitoringServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMonitoringService not implemented")
}
func (*UnimplementedClusterManagerServer) SetAddonsConfig(ctx context.Context, req *SetAddonsConfigRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAddonsConfig not implemented")
}
func (*UnimplementedClusterManagerServer) SetLocations(ctx context.Context, req *SetLocationsRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLocations not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateMaster(ctx context.Context, req *UpdateMasterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMaster not implemented")
}
func (*UnimplementedClusterManagerServer) SetMasterAuth(ctx context.Context, req *SetMasterAuthRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMasterAuth not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteCluster(ctx context.Context, req *DeleteClusterRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClusterManagerServer) ListOperations(ctx context.Context, req *ListOperationsRequest) (*ListOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterManagerServer) GetOperation(ctx context.Context, req *GetOperationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperation not implemented")
}
func (*UnimplementedClusterManagerServer) CancelOperation(ctx context.Context, req *CancelOperationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelOperation not implemented")
}
func (*UnimplementedClusterManagerServer) GetServerConfig(ctx context.Context, req *GetServerConfigRequest) (*ServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerConfig not implemented")
}
func (*UnimplementedClusterManagerServer) ListNodePools(ctx context.Context, req *ListNodePoolsRequest) (*ListNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodePools not implemented")
}
func (*UnimplementedClusterManagerServer) GetNodePool(ctx context.Context, req *GetNodePoolRequest) (*NodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) CreateNodePool(ctx context.Context, req *CreateNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteNodePool(ctx context.Context, req *DeleteNodePoolRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) RollbackNodePoolUpgrade(ctx context.Context, req *RollbackNodePoolUpgradeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackNodePoolUpgrade not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolManagement(ctx context.Context, req *SetNodePoolManagementRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolManagement not implemented")
}
func (*UnimplementedClusterManagerServer) SetLabels(ctx context.Context, req *SetLabelsRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (*UnimplementedClusterManagerServer) SetLegacyAbac(ctx context.Context, req *SetLegacyAbacRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLegacyAbac not implemented")
}
func (*UnimplementedClusterManagerServer) StartIPRotation(ctx context.Context, req *StartIPRotationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) CompleteIPRotation(ctx context.Context, req *CompleteIPRotationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolSize(ctx context.Context, req *SetNodePoolSizeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodePoolSize not implemented")
}
func (*UnimplementedClusterManagerServer) SetNetworkPolicy(ctx context.Context, req *SetNetworkPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNetworkPolicy not implemented")
}
func (*UnimplementedClusterManagerServer) SetMaintenancePolicy(ctx context.Context, req *SetMaintenancePolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMaintenancePolicy not implemented")
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/UpdateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, req.(*UpdateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolAutoscaling_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolAutoscalingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetNodePoolAutoscaling",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, req.(*SetNodePoolAutoscalingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLoggingService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLoggingServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLoggingService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, req.(*SetLoggingServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMonitoringService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMonitoringServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetMonitoringService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, req.(*SetMonitoringServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetAddonsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAddonsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetAddonsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, req.(*SetAddonsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLocations(ctx, req.(*SetLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/UpdateMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, req.(*UpdateMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMasterAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMasterAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetMasterAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, req.(*SetMasterAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CreateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/DeleteNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_RollbackNodePoolUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackNodePoolUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/RollbackNodePoolUpgrade",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, req.(*RollbackNodePoolUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolManagement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolManagementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetNodePoolManagement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, req.(*SetNodePoolManagementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLabels(ctx, req.(*SetLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLegacyAbac_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLegacyAbacRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLegacyAbac",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, req.(*SetLegacyAbacRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_StartIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/StartIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, req.(*StartIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CompleteIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CompleteIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, req.(*CompleteIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetNodePoolSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, req.(*SetNodePoolSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, req.(*SetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMaintenancePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMaintenancePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetMaintenancePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, req.(*SetMaintenancePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "UpdateNodePool",
			Handler:    _ClusterManager_UpdateNodePool_Handler,
		},
		{
			MethodName: "SetNodePoolAutoscaling",
			Handler:    _ClusterManager_SetNodePoolAutoscaling_Handler,
		},
		{
			MethodName: "SetLoggingService",
			Handler:    _ClusterManager_SetLoggingService_Handler,
		},
		{
			MethodName: "SetMonitoringService",
			Handler:    _ClusterManager_SetMonitoringService_Handler,
		},
		{
			MethodName: "SetAddonsConfig",
			Handler:    _ClusterManager_SetAddonsConfig_Handler,
		},
		{
			MethodName: "SetLocations",
			Handler:    _ClusterManager_SetLocations_Handler,
		},
		{
			MethodName: "UpdateMaster",
			Handler:    _ClusterManager_UpdateMaster_Handler,
		},
		{
			MethodName: "SetMasterAuth",
			Handler:    _ClusterManager_SetMasterAuth_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _ClusterManager_CancelOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _ClusterManager_ListNodePools_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _ClusterManager_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _ClusterManager_CreateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _ClusterManager_DeleteNodePool_Handler,
		},
		{
			MethodName: "RollbackNodePoolUpgrade",
			Handler:    _ClusterManager_RollbackNodePoolUpgrade_Handler,
		},
		{
			MethodName: "SetNodePoolManagement",
			Handler:    _ClusterManager_SetNodePoolManagement_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ClusterManager_SetLabels_Handler,
		},
		{
			MethodName: "SetLegacyAbac",
			Handler:    _ClusterManager_SetLegacyAbac_Handler,
		},
		{
			MethodName: "StartIPRotation",
			Handler:    _ClusterManager_StartIPRotation_Handler,
		},
		{
			MethodName: "CompleteIPRotation",
			Handler:    _ClusterManager_CompleteIPRotation_Handler,
		},
		{
			MethodName: "SetNodePoolSize",
			Handler:    _ClusterManager_SetNodePoolSize_Handler,
		},
		{
			MethodName: "SetNetworkPolicy",
			Handler:    _ClusterManager_SetNetworkPolicy_Handler,
		},
		{
			MethodName: "SetMaintenancePolicy",
			Handler:    _ClusterManager_SetMaintenancePolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/container/v1/cluster_service.proto",
}
