/* $Id: fips.c,v 1.2 2002/12/16 23:45:02 kravietz Exp $
 *
 * Code for FIPS randomness testing ripped from intel-rngd.
 * Copyright by Philipp Rumpf.
 */

#include <string.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "fips.h"

static int poker[16], runs[12];
static int ones, rlength = -1, current_bit, longrun;

/*
 * rng_fips_test_store - store 8 bits of entropy in FIPS
 * 			 internal test data pool
 */
static void
rng_fips_test_store (int rng_data)
{
  int j;
  static int last_bit = 0;
  poker[rng_data >> 4]++;
  poker[rng_data & 15]++;

  /* Note in the loop below rlength is always one less than the actual
     run length. This makes things easier. */
  for (j = 7; j >= 0; j--)
    {
      ones += current_bit = (rng_data & 1 << j) >> j;
      if (current_bit != last_bit)
	{

	  /* If runlength is 1-6 count it in correct bucket. 0's go in
	     runs[0-5] 1's go in runs[6-11] hence the 6*current_bit below */
	  if (rlength < 5)
	    {
	      runs[rlength + (6 * current_bit)]++;
	    }
	  else
	    {
	      runs[5 + (6 * current_bit)]++;
	    }

	  /* Check if we just failed longrun test */
	  if (rlength >= 33)
	    longrun = 1;
	  rlength = 0;

	  /* flip the current run type */
	  last_bit = current_bit;
	}
      else
	{
	  rlength++;
	}
    }
}


/*
 * now that we have some data, run a FIPS test
 */
int rng_run_fips_test (unsigned char *buf)
{
  int i, j;
  int rng_test = 0;
  for (i = 0; i < FIPS_THRESHOLD; i++)
    {
      rng_fips_test_store (buf[i]);
    }

  /* add in the last (possibly incomplete) run */
  if (rlength < 5)
    runs[rlength + (6 * current_bit)]++;

  else
    {
      runs[5 + (6 * current_bit)]++;
      if (rlength >= 33)
	rng_test |= 8;
    }
  if (longrun)
    {
      rng_test |= 8;
      longrun = 0;
    }

  /* Ones test */
  if ((ones >= 10346) || (ones <= 9654))
    rng_test |= 1;

  /* Poker calcs */
  for (i = 0, j = 0; i < 16; i++)
    j += poker[i] * poker[i];
  if ((j >= 1580457) || (j <= 1562821))
    rng_test |= 2;
  if ((runs[0] < 2267) || (runs[0] > 2733) ||
      (runs[1] < 1079) || (runs[1] > 1421) ||
      (runs[2] < 502) || (runs[2] > 748) ||
      (runs[3] < 223) || (runs[3] > 402) ||
      (runs[4] < 90) || (runs[4] > 223) ||
      (runs[5] < 90) || (runs[5] > 223) ||
      (runs[6] < 2267) || (runs[6] > 2733) ||
      (runs[7] < 1079) || (runs[7] > 1421) ||
      (runs[8] < 502) || (runs[8] > 748) ||
      (runs[9] < 223) || (runs[9] > 402) ||
      (runs[10] < 90) || (runs[10] > 223) ||
      (runs[11] < 90) || (runs[11] > 223))
    {
      rng_test |= 4;
    }
  rng_test = !rng_test;

  /* finally, clear out FIPS variables for start of next run */
  memset (poker, 0, sizeof (poker));
  memset (runs, 0, sizeof (runs));
  ones = 0;
  rlength = -1;
  current_bit = 0;
  return rng_test;
}
