/* $Id: xp_icmp_echo.c,v 1.2 2002/02/07 17:14:20 mixter Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"

rpack_t *send_icmpecho_req(struct sockaddr_in to) {
    
    return(send_icmpecho_var_req( to, IP_DF));
}

rpack_t *send_icmpecho_var_req(struct sockaddr_in to, int bits) {

    int sndsock;
    int res;
    struct ip *ip;
    struct icmp *icmp;
    unsigned char *pack, *recv_pack;
    int on = 1;
    int packlen;
    rpack_t *retval = NULL;

    sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
    setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on, sizeof(on));

    packlen = sizeof(struct ip) + sizeof(struct icmp) + DATA_SIZE;

    pack = (unsigned char *)calloc( packlen, 1);

    ip = (struct ip *)pack;
    icmp = (struct icmp *)(pack + sizeof(struct ip));
    
    ip->ip_p     = IPPROTO_ICMP;
    ip->ip_dst   = to.sin_addr;
    ip->ip_len   = packlen;
    ip->ip_ttl   = 250;
    ip->ip_v     = IP_VERSION;
    ip->ip_hl    = sizeof(struct ip) >> 2;
#ifdef __linux__
    ip->ip_off   = htons((unsigned short) (bits));
#else
    ip->ip_off   = (unsigned short) bits;
#endif    
    ip->ip_tos  = 6; /* ! */
    ip->ip_id   = rand();

    icmp->icmp_type = ICMP_ECHO;
    icmp->icmp_code = 123; /* ! */
    icmp->icmp_seq = rand();
    icmp->icmp_id = rand();
    icmp->icmp_cksum = in_cksum((unsigned short *)icmp,
                                DATA_SIZE + sizeof(struct icmp));
    if (icmp->icmp_cksum == 0)
        icmp->icmp_cksum = 0xffff;
   
#ifdef EBUG
    fprintf(stderr,"TEST: ICMP echo request to %s ",
                                            inet_ntoa(to.sin_addr));
#endif
    
   res = sendto(sndsock, (void *)pack, packlen,
                0, (struct sockaddr *)&to, sizeof(struct sockaddr));

   if (res <0) {
       perror("sendto:");
       close(sndsock);
       free(pack);
       return NULL;
   }
#ifdef EBUG
   fprintf(stderr,"[%d bytes] sent, waiting for reponse.\n", res);
#endif

   recv_pack = read_icmp(&res, ICMP_ECHOREPLY, -1);

   if (recv_pack == NULL || (unsigned)res < sizeof(ip) + 8) {
#ifdef EBUG
       fprintf(stderr,"Receive timeout. Quitting..\n");
#endif
       close(sndsock);
       free(pack);
       return NULL;
   }


   retval=(rpack_t *)calloc(sizeof(rpack_t), 1);

   retval->packsize = res;

   retval->pkt = (char *)calloc(res, 1);
   memcpy((void *)retval->pkt, (void *)recv_pack, res);

   
#ifdef DEBUG
   fprintf(stderr,"Received %d bytes packet.\n", res);
   hexdump(recv_pack, res);
   fprintf(stderr,"\n----\n");
   //hexdump(retval->pkt, res);
#endif    
 
   retval->ip = (struct ip *)retval->pkt;
 /* sanity checks */

#ifdef DEBUG
    fprintf(stderr, "hlen: %d\nlen: %d\n", retval->ip->ip_hl<<2, htons(retval->ip->ip_len));
#endif    
    
   if ((unsigned)res < sizeof(struct ip)      ||
       (retval->ip->ip_hl << 2) > (unsigned)res ||
       ntohs(retval->ip->ip_len) > (unsigned)res ) {
#ifdef EBUG
       fprintf(stderr,"Received maliformed packet!\n");
#endif
       close(sndsock);
       free(pack);
       free(retval->pkt);
       free(retval);
       return NULL;
   }

   retval->icmp = (struct icmp *)(retval->pkt + (retval->ip->ip_hl<<2));

#ifdef DEBUG
   fprintf(stderr,"type: %d code: %d\n", retval->icmp->icmp_type, retval->icmp->icmp_code);
#endif   
          
/*    if (rcv_icmp->icmp_type != ICMP_ECHOREPLY) { 
       fprintf(stderr, "Received datagram is not ICMP echo reply\n");
       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }
*/

   close(sndsock);
   free(pack);
   return retval;

}

int wait_icmp(int sock, struct sockaddr_in *from, unsigned char *pack,
int packlen) {

    struct timeval wait;
    fd_set fds;
    int fromlen = sizeof(*from);
    ssize_t cc=0;

    wait.tv_sec=DEF_TIMEOUT;
    wait.tv_usec=0;

    FD_ZERO(&fds);
    FD_SET(sock, &fds);


   if (select(sock+1, &fds, (fd_set *)0, (fd_set *)0, &wait) > 0)
            cc=recvfrom(sock, (char *)pack, packlen, 0,
                        (struct sockaddr *)from, (socklen_t *)&fromlen);

#ifdef DEBUG   
   //if(cc>0) 
       //hexdump((void *)pack, cc);
#endif       
   return((int)cc);
}

