/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2024 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/******************************************************************************
 * Generated from Khronos SPIR-V machine-readable JSON grammar.
 *
 * Copyright (c) 2014-2024 The Khronos Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and/or associated documentation files (the "Materials"),
 * to deal in the Materials without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Materials, and to permit persons to whom the
 * Materials are furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Materials.
 *
 * MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
 * STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
 * HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/
 *
 * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
 * IN THE MATERIALS.
 ******************************************************************************/

// This file is autogenerated with gen_spirv_code.py - any changes will be overwritten next time
// that script is run.
// $ ./gen_spirv_code.py

// We need to disable clang-format since this file is programmatically generated
// clang-format off

#include "spirv_gen.h"
#include "os/os_specific.h"
#include "common/formatting.h"
#include "spirv_op_helpers.h"

template <>
rdcstr DoStringise(const rdcspv::ImageOperands &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::ImageOperands);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(Bias);
    STRINGISE_BITFIELD_CLASS_BIT(Lod);
    STRINGISE_BITFIELD_CLASS_BIT(Grad);
    STRINGISE_BITFIELD_CLASS_BIT(ConstOffset);
    STRINGISE_BITFIELD_CLASS_BIT(Offset);
    STRINGISE_BITFIELD_CLASS_BIT(ConstOffsets);
    STRINGISE_BITFIELD_CLASS_BIT(Sample);
    STRINGISE_BITFIELD_CLASS_BIT(MinLod);
    STRINGISE_BITFIELD_CLASS_BIT(MakeTexelAvailable);
    STRINGISE_BITFIELD_CLASS_BIT(MakeTexelVisible);
    STRINGISE_BITFIELD_CLASS_BIT(NonPrivateTexel);
    STRINGISE_BITFIELD_CLASS_BIT(VolatileTexel);
    STRINGISE_BITFIELD_CLASS_BIT(SignExtend);
    STRINGISE_BITFIELD_CLASS_BIT(ZeroExtend);
    STRINGISE_BITFIELD_CLASS_BIT(Nontemporal);
    STRINGISE_BITFIELD_CLASS_BIT(Offsets);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FPFastMathMode &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::FPFastMathMode);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(NotNaN);
    STRINGISE_BITFIELD_CLASS_BIT(NotInf);
    STRINGISE_BITFIELD_CLASS_BIT(NSZ);
    STRINGISE_BITFIELD_CLASS_BIT(AllowRecip);
    STRINGISE_BITFIELD_CLASS_BIT(Fast);
    STRINGISE_BITFIELD_CLASS_BIT(AllowContract);
    STRINGISE_BITFIELD_CLASS_BIT(AllowReassoc);
    STRINGISE_BITFIELD_CLASS_BIT(AllowTransform);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::SelectionControl &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::SelectionControl);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(Flatten);
    STRINGISE_BITFIELD_CLASS_BIT(DontFlatten);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::LoopControl &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::LoopControl);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(Unroll);
    STRINGISE_BITFIELD_CLASS_BIT(DontUnroll);
    STRINGISE_BITFIELD_CLASS_BIT(DependencyInfinite);
    STRINGISE_BITFIELD_CLASS_BIT(DependencyLength);
    STRINGISE_BITFIELD_CLASS_BIT(MinIterations);
    STRINGISE_BITFIELD_CLASS_BIT(MaxIterations);
    STRINGISE_BITFIELD_CLASS_BIT(IterationMultiple);
    STRINGISE_BITFIELD_CLASS_BIT(PeelCount);
    STRINGISE_BITFIELD_CLASS_BIT(PartialCount);
    STRINGISE_BITFIELD_CLASS_BIT(InitiationIntervalINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(MaxConcurrencyINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(DependencyArrayINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(PipelineEnableINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(LoopCoalesceINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(MaxInterleavingINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(SpeculatedIterationsINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(NoFusionINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(LoopCountINTEL);
    STRINGISE_BITFIELD_CLASS_BIT(MaxReinvocationDelayINTEL);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FunctionControl &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::FunctionControl);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(Inline);
    STRINGISE_BITFIELD_CLASS_BIT(DontInline);
    STRINGISE_BITFIELD_CLASS_BIT(Pure);
    STRINGISE_BITFIELD_CLASS_BIT(Const);
    STRINGISE_BITFIELD_CLASS_BIT(OptNoneINTEL);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::MemorySemantics &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::MemorySemantics);
  {
    STRINGISE_BITFIELD_CLASS_BIT(Relaxed);
    STRINGISE_BITFIELD_CLASS_BIT(Acquire);
    STRINGISE_BITFIELD_CLASS_BIT(Release);
    STRINGISE_BITFIELD_CLASS_BIT(AcquireRelease);
    STRINGISE_BITFIELD_CLASS_BIT(SequentiallyConsistent);
    STRINGISE_BITFIELD_CLASS_BIT(UniformMemory);
    STRINGISE_BITFIELD_CLASS_BIT(SubgroupMemory);
    STRINGISE_BITFIELD_CLASS_BIT(WorkgroupMemory);
    STRINGISE_BITFIELD_CLASS_BIT(CrossWorkgroupMemory);
    STRINGISE_BITFIELD_CLASS_BIT(AtomicCounterMemory);
    STRINGISE_BITFIELD_CLASS_BIT(ImageMemory);
    STRINGISE_BITFIELD_CLASS_BIT(OutputMemory);
    STRINGISE_BITFIELD_CLASS_BIT(MakeAvailable);
    STRINGISE_BITFIELD_CLASS_BIT(MakeVisible);
    STRINGISE_BITFIELD_CLASS_BIT(Volatile);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::MemoryAccess &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::MemoryAccess);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(Volatile);
    STRINGISE_BITFIELD_CLASS_BIT(Aligned);
    STRINGISE_BITFIELD_CLASS_BIT(Nontemporal);
    STRINGISE_BITFIELD_CLASS_BIT(MakePointerAvailable);
    STRINGISE_BITFIELD_CLASS_BIT(MakePointerVisible);
    STRINGISE_BITFIELD_CLASS_BIT(NonPrivatePointer);
    STRINGISE_BITFIELD_CLASS_BIT(AliasScopeINTELMask);
    STRINGISE_BITFIELD_CLASS_BIT(NoAliasINTELMask);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::KernelProfilingInfo &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::KernelProfilingInfo);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(CmdExecTime);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::RayFlags &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::RayFlags);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(NoneKHR);

    STRINGISE_BITFIELD_CLASS_BIT(OpaqueKHR);
    STRINGISE_BITFIELD_CLASS_BIT(NoOpaqueKHR);
    STRINGISE_BITFIELD_CLASS_BIT(TerminateOnFirstHitKHR);
    STRINGISE_BITFIELD_CLASS_BIT(SkipClosestHitShaderKHR);
    STRINGISE_BITFIELD_CLASS_BIT(CullBackFacingTrianglesKHR);
    STRINGISE_BITFIELD_CLASS_BIT(CullFrontFacingTrianglesKHR);
    STRINGISE_BITFIELD_CLASS_BIT(CullOpaqueKHR);
    STRINGISE_BITFIELD_CLASS_BIT(CullNoOpaqueKHR);
    STRINGISE_BITFIELD_CLASS_BIT(SkipTrianglesKHR);
    STRINGISE_BITFIELD_CLASS_BIT(SkipAABBsKHR);
    STRINGISE_BITFIELD_CLASS_BIT(ForceOpacityMicromap2StateEXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FragmentShadingRate &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::FragmentShadingRate);
  {
    STRINGISE_BITFIELD_CLASS_BIT(Vertical2Pixels);
    STRINGISE_BITFIELD_CLASS_BIT(Vertical4Pixels);
    STRINGISE_BITFIELD_CLASS_BIT(Horizontal2Pixels);
    STRINGISE_BITFIELD_CLASS_BIT(Horizontal4Pixels);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::RawAccessChainOperands &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::RawAccessChainOperands);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(None);

    STRINGISE_BITFIELD_CLASS_BIT(RobustnessPerComponentNV);
    STRINGISE_BITFIELD_CLASS_BIT(RobustnessPerElementNV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::SourceLanguage &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::SourceLanguage);
  {
    STRINGISE_ENUM_CLASS(Unknown);
    STRINGISE_ENUM_CLASS(ESSL);
    STRINGISE_ENUM_CLASS(GLSL);
    STRINGISE_ENUM_CLASS(OpenCL_C);
    STRINGISE_ENUM_CLASS(OpenCL_CPP);
    STRINGISE_ENUM_CLASS(HLSL);
    STRINGISE_ENUM_CLASS(CPP_for_OpenCL);
    STRINGISE_ENUM_CLASS(SYCL);
    STRINGISE_ENUM_CLASS(HERO_C);
    STRINGISE_ENUM_CLASS(NZSL);
    STRINGISE_ENUM_CLASS(WGSL);
    STRINGISE_ENUM_CLASS(Slang);
    STRINGISE_ENUM_CLASS(Zig);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ExecutionModel &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ExecutionModel);
  {
    STRINGISE_ENUM_CLASS(Vertex);
    STRINGISE_ENUM_CLASS(TessellationControl);
    STRINGISE_ENUM_CLASS(TessellationEvaluation);
    STRINGISE_ENUM_CLASS(Geometry);
    STRINGISE_ENUM_CLASS(Fragment);
    STRINGISE_ENUM_CLASS(GLCompute);
    STRINGISE_ENUM_CLASS(Kernel);
    STRINGISE_ENUM_CLASS(RayGenerationKHR);
    STRINGISE_ENUM_CLASS(IntersectionKHR);
    STRINGISE_ENUM_CLASS(AnyHitKHR);
    STRINGISE_ENUM_CLASS(ClosestHitKHR);
    STRINGISE_ENUM_CLASS(MissKHR);
    STRINGISE_ENUM_CLASS(CallableKHR);
    STRINGISE_ENUM_CLASS(TaskEXT);
    STRINGISE_ENUM_CLASS(MeshEXT);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::AddressingModel &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::AddressingModel);
  {
    STRINGISE_ENUM_CLASS(Logical);
    STRINGISE_ENUM_CLASS(Physical32);
    STRINGISE_ENUM_CLASS(Physical64);
    STRINGISE_ENUM_CLASS(PhysicalStorageBuffer64);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::MemoryModel &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::MemoryModel);
  {
    STRINGISE_ENUM_CLASS(Simple);
    STRINGISE_ENUM_CLASS(GLSL450);
    STRINGISE_ENUM_CLASS(OpenCL);
    STRINGISE_ENUM_CLASS(Vulkan);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ExecutionMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ExecutionMode);
  {
    STRINGISE_ENUM_CLASS(Invocations);
    STRINGISE_ENUM_CLASS(SpacingEqual);
    STRINGISE_ENUM_CLASS(SpacingFractionalEven);
    STRINGISE_ENUM_CLASS(SpacingFractionalOdd);
    STRINGISE_ENUM_CLASS(VertexOrderCw);
    STRINGISE_ENUM_CLASS(VertexOrderCcw);
    STRINGISE_ENUM_CLASS(PixelCenterInteger);
    STRINGISE_ENUM_CLASS(OriginUpperLeft);
    STRINGISE_ENUM_CLASS(OriginLowerLeft);
    STRINGISE_ENUM_CLASS(EarlyFragmentTests);
    STRINGISE_ENUM_CLASS(PointMode);
    STRINGISE_ENUM_CLASS(Xfb);
    STRINGISE_ENUM_CLASS(DepthReplacing);
    STRINGISE_ENUM_CLASS(DepthGreater);
    STRINGISE_ENUM_CLASS(DepthLess);
    STRINGISE_ENUM_CLASS(DepthUnchanged);
    STRINGISE_ENUM_CLASS(LocalSize);
    STRINGISE_ENUM_CLASS(LocalSizeHint);
    STRINGISE_ENUM_CLASS(InputPoints);
    STRINGISE_ENUM_CLASS(InputLines);
    STRINGISE_ENUM_CLASS(InputLinesAdjacency);
    STRINGISE_ENUM_CLASS(Triangles);
    STRINGISE_ENUM_CLASS(InputTrianglesAdjacency);
    STRINGISE_ENUM_CLASS(Quads);
    STRINGISE_ENUM_CLASS(Isolines);
    STRINGISE_ENUM_CLASS(OutputVertices);
    STRINGISE_ENUM_CLASS(OutputPoints);
    STRINGISE_ENUM_CLASS(OutputLineStrip);
    STRINGISE_ENUM_CLASS(OutputTriangleStrip);
    STRINGISE_ENUM_CLASS(VecTypeHint);
    STRINGISE_ENUM_CLASS(ContractionOff);
    STRINGISE_ENUM_CLASS(Initializer);
    STRINGISE_ENUM_CLASS(Finalizer);
    STRINGISE_ENUM_CLASS(SubgroupSize);
    STRINGISE_ENUM_CLASS(SubgroupsPerWorkgroup);
    STRINGISE_ENUM_CLASS(SubgroupsPerWorkgroupId);
    STRINGISE_ENUM_CLASS(LocalSizeId);
    STRINGISE_ENUM_CLASS(LocalSizeHintId);
    STRINGISE_ENUM_CLASS(NonCoherentColorAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(NonCoherentDepthAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(NonCoherentStencilAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(SubgroupUniformControlFlowKHR);
    STRINGISE_ENUM_CLASS(PostDepthCoverage);
    STRINGISE_ENUM_CLASS(DenormPreserve);
    STRINGISE_ENUM_CLASS(DenormFlushToZero);
    STRINGISE_ENUM_CLASS(SignedZeroInfNanPreserve);
    STRINGISE_ENUM_CLASS(RoundingModeRTE);
    STRINGISE_ENUM_CLASS(RoundingModeRTZ);
    STRINGISE_ENUM_CLASS(EarlyAndLateFragmentTestsAMD);
    STRINGISE_ENUM_CLASS(StencilRefReplacingEXT);
    STRINGISE_ENUM_CLASS(CoalescingAMDX);
    STRINGISE_ENUM_CLASS(MaxNodeRecursionAMDX);
    STRINGISE_ENUM_CLASS(StaticNumWorkgroupsAMDX);
    STRINGISE_ENUM_CLASS(ShaderIndexAMDX);
    STRINGISE_ENUM_CLASS(MaxNumWorkgroupsAMDX);
    STRINGISE_ENUM_CLASS(StencilRefUnchangedFrontAMD);
    STRINGISE_ENUM_CLASS(StencilRefGreaterFrontAMD);
    STRINGISE_ENUM_CLASS(StencilRefLessFrontAMD);
    STRINGISE_ENUM_CLASS(StencilRefUnchangedBackAMD);
    STRINGISE_ENUM_CLASS(StencilRefGreaterBackAMD);
    STRINGISE_ENUM_CLASS(StencilRefLessBackAMD);
    STRINGISE_ENUM_CLASS(QuadDerivativesKHR);
    STRINGISE_ENUM_CLASS(RequireFullQuadsKHR);
    STRINGISE_ENUM_CLASS(OutputLinesEXT);
    STRINGISE_ENUM_CLASS(OutputPrimitivesEXT);
    STRINGISE_ENUM_CLASS(DerivativeGroupQuadsNV);
    STRINGISE_ENUM_CLASS(DerivativeGroupLinearNV);
    STRINGISE_ENUM_CLASS(OutputTrianglesEXT);
    STRINGISE_ENUM_CLASS(PixelInterlockOrderedEXT);
    STRINGISE_ENUM_CLASS(PixelInterlockUnorderedEXT);
    STRINGISE_ENUM_CLASS(SampleInterlockOrderedEXT);
    STRINGISE_ENUM_CLASS(SampleInterlockUnorderedEXT);
    STRINGISE_ENUM_CLASS(ShadingRateInterlockOrderedEXT);
    STRINGISE_ENUM_CLASS(ShadingRateInterlockUnorderedEXT);
    STRINGISE_ENUM_CLASS(SharedLocalMemorySizeINTEL);
    STRINGISE_ENUM_CLASS(RoundingModeRTPINTEL);
    STRINGISE_ENUM_CLASS(RoundingModeRTNINTEL);
    STRINGISE_ENUM_CLASS(FloatingPointModeALTINTEL);
    STRINGISE_ENUM_CLASS(FloatingPointModeIEEEINTEL);
    STRINGISE_ENUM_CLASS(MaxWorkgroupSizeINTEL);
    STRINGISE_ENUM_CLASS(MaxWorkDimINTEL);
    STRINGISE_ENUM_CLASS(NoGlobalOffsetINTEL);
    STRINGISE_ENUM_CLASS(NumSIMDWorkitemsINTEL);
    STRINGISE_ENUM_CLASS(SchedulerTargetFmaxMhzINTEL);
    STRINGISE_ENUM_CLASS(MaximallyReconvergesKHR);
    STRINGISE_ENUM_CLASS(FPFastMathDefault);
    STRINGISE_ENUM_CLASS(StreamingInterfaceINTEL);
    STRINGISE_ENUM_CLASS(RegisterMapInterfaceINTEL);
    STRINGISE_ENUM_CLASS(NamedBarrierCountINTEL);
    STRINGISE_ENUM_CLASS(MaximumRegistersINTEL);
    STRINGISE_ENUM_CLASS(MaximumRegistersIdINTEL);
    STRINGISE_ENUM_CLASS(NamedMaximumRegistersINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::StorageClass &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::StorageClass);
  {
    STRINGISE_ENUM_CLASS(UniformConstant);
    STRINGISE_ENUM_CLASS(Input);
    STRINGISE_ENUM_CLASS(Uniform);
    STRINGISE_ENUM_CLASS(Output);
    STRINGISE_ENUM_CLASS(Workgroup);
    STRINGISE_ENUM_CLASS(CrossWorkgroup);
    STRINGISE_ENUM_CLASS(Private);
    STRINGISE_ENUM_CLASS(Function);
    STRINGISE_ENUM_CLASS(Generic);
    STRINGISE_ENUM_CLASS(PushConstant);
    STRINGISE_ENUM_CLASS(AtomicCounter);
    STRINGISE_ENUM_CLASS(Image);
    STRINGISE_ENUM_CLASS(StorageBuffer);
    STRINGISE_ENUM_CLASS(TileImageEXT);
    STRINGISE_ENUM_CLASS(NodePayloadAMDX);
    STRINGISE_ENUM_CLASS(NodeOutputPayloadAMDX);
    STRINGISE_ENUM_CLASS(CallableDataKHR);
    STRINGISE_ENUM_CLASS(IncomingCallableDataKHR);
    STRINGISE_ENUM_CLASS(RayPayloadKHR);
    STRINGISE_ENUM_CLASS(HitAttributeKHR);
    STRINGISE_ENUM_CLASS(IncomingRayPayloadKHR);
    STRINGISE_ENUM_CLASS(ShaderRecordBufferKHR);
    STRINGISE_ENUM_CLASS(PhysicalStorageBuffer);
    STRINGISE_ENUM_CLASS(HitObjectAttributeNV);
    STRINGISE_ENUM_CLASS(TaskPayloadWorkgroupEXT);
    STRINGISE_ENUM_CLASS(CodeSectionINTEL);
    STRINGISE_ENUM_CLASS(DeviceOnlyINTEL);
    STRINGISE_ENUM_CLASS(HostOnlyINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Dim &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Dim);
  {
    STRINGISE_ENUM_CLASS_NAMED(_1D, "1D");
    STRINGISE_ENUM_CLASS_NAMED(_2D, "2D");
    STRINGISE_ENUM_CLASS_NAMED(_3D, "3D");
    STRINGISE_ENUM_CLASS(Cube);
    STRINGISE_ENUM_CLASS(Rect);
    STRINGISE_ENUM_CLASS(Buffer);
    STRINGISE_ENUM_CLASS(SubpassData);
    STRINGISE_ENUM_CLASS(TileImageDataEXT);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::SamplerAddressingMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::SamplerAddressingMode);
  {
    STRINGISE_ENUM_CLASS(None);
    STRINGISE_ENUM_CLASS(ClampToEdge);
    STRINGISE_ENUM_CLASS(Clamp);
    STRINGISE_ENUM_CLASS(Repeat);
    STRINGISE_ENUM_CLASS(RepeatMirrored);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::SamplerFilterMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::SamplerFilterMode);
  {
    STRINGISE_ENUM_CLASS(Nearest);
    STRINGISE_ENUM_CLASS(Linear);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ImageFormat &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ImageFormat);
  {
    STRINGISE_ENUM_CLASS(Unknown);
    STRINGISE_ENUM_CLASS(Rgba32f);
    STRINGISE_ENUM_CLASS(Rgba16f);
    STRINGISE_ENUM_CLASS(R32f);
    STRINGISE_ENUM_CLASS(Rgba8);
    STRINGISE_ENUM_CLASS(Rgba8Snorm);
    STRINGISE_ENUM_CLASS(Rg32f);
    STRINGISE_ENUM_CLASS(Rg16f);
    STRINGISE_ENUM_CLASS(R11fG11fB10f);
    STRINGISE_ENUM_CLASS(R16f);
    STRINGISE_ENUM_CLASS(Rgba16);
    STRINGISE_ENUM_CLASS(Rgb10A2);
    STRINGISE_ENUM_CLASS(Rg16);
    STRINGISE_ENUM_CLASS(Rg8);
    STRINGISE_ENUM_CLASS(R16);
    STRINGISE_ENUM_CLASS(R8);
    STRINGISE_ENUM_CLASS(Rgba16Snorm);
    STRINGISE_ENUM_CLASS(Rg16Snorm);
    STRINGISE_ENUM_CLASS(Rg8Snorm);
    STRINGISE_ENUM_CLASS(R16Snorm);
    STRINGISE_ENUM_CLASS(R8Snorm);
    STRINGISE_ENUM_CLASS(Rgba32i);
    STRINGISE_ENUM_CLASS(Rgba16i);
    STRINGISE_ENUM_CLASS(Rgba8i);
    STRINGISE_ENUM_CLASS(R32i);
    STRINGISE_ENUM_CLASS(Rg32i);
    STRINGISE_ENUM_CLASS(Rg16i);
    STRINGISE_ENUM_CLASS(Rg8i);
    STRINGISE_ENUM_CLASS(R16i);
    STRINGISE_ENUM_CLASS(R8i);
    STRINGISE_ENUM_CLASS(Rgba32ui);
    STRINGISE_ENUM_CLASS(Rgba16ui);
    STRINGISE_ENUM_CLASS(Rgba8ui);
    STRINGISE_ENUM_CLASS(R32ui);
    STRINGISE_ENUM_CLASS(Rgb10a2ui);
    STRINGISE_ENUM_CLASS(Rg32ui);
    STRINGISE_ENUM_CLASS(Rg16ui);
    STRINGISE_ENUM_CLASS(Rg8ui);
    STRINGISE_ENUM_CLASS(R16ui);
    STRINGISE_ENUM_CLASS(R8ui);
    STRINGISE_ENUM_CLASS(R64ui);
    STRINGISE_ENUM_CLASS(R64i);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ImageChannelOrder &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ImageChannelOrder);
  {
    STRINGISE_ENUM_CLASS(R);
    STRINGISE_ENUM_CLASS(A);
    STRINGISE_ENUM_CLASS(RG);
    STRINGISE_ENUM_CLASS(RA);
    STRINGISE_ENUM_CLASS(RGB);
    STRINGISE_ENUM_CLASS(RGBA);
    STRINGISE_ENUM_CLASS(BGRA);
    STRINGISE_ENUM_CLASS(ARGB);
    STRINGISE_ENUM_CLASS(Intensity);
    STRINGISE_ENUM_CLASS(Luminance);
    STRINGISE_ENUM_CLASS(Rx);
    STRINGISE_ENUM_CLASS(RGx);
    STRINGISE_ENUM_CLASS(RGBx);
    STRINGISE_ENUM_CLASS(Depth);
    STRINGISE_ENUM_CLASS(DepthStencil);
    STRINGISE_ENUM_CLASS(sRGB);
    STRINGISE_ENUM_CLASS(sRGBx);
    STRINGISE_ENUM_CLASS(sRGBA);
    STRINGISE_ENUM_CLASS(sBGRA);
    STRINGISE_ENUM_CLASS(ABGR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ImageChannelDataType &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ImageChannelDataType);
  {
    STRINGISE_ENUM_CLASS(SnormInt8);
    STRINGISE_ENUM_CLASS(SnormInt16);
    STRINGISE_ENUM_CLASS(UnormInt8);
    STRINGISE_ENUM_CLASS(UnormInt16);
    STRINGISE_ENUM_CLASS(UnormShort565);
    STRINGISE_ENUM_CLASS(UnormShort555);
    STRINGISE_ENUM_CLASS(UnormInt101010);
    STRINGISE_ENUM_CLASS(SignedInt8);
    STRINGISE_ENUM_CLASS(SignedInt16);
    STRINGISE_ENUM_CLASS(SignedInt32);
    STRINGISE_ENUM_CLASS(UnsignedInt8);
    STRINGISE_ENUM_CLASS(UnsignedInt16);
    STRINGISE_ENUM_CLASS(UnsignedInt32);
    STRINGISE_ENUM_CLASS(HalfFloat);
    STRINGISE_ENUM_CLASS(Float);
    STRINGISE_ENUM_CLASS(UnormInt24);
    STRINGISE_ENUM_CLASS(UnormInt101010_2);
    STRINGISE_ENUM_CLASS(UnsignedIntRaw10EXT);
    STRINGISE_ENUM_CLASS(UnsignedIntRaw12EXT);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FPRoundingMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::FPRoundingMode);
  {
    STRINGISE_ENUM_CLASS(RTE);
    STRINGISE_ENUM_CLASS(RTZ);
    STRINGISE_ENUM_CLASS(RTP);
    STRINGISE_ENUM_CLASS(RTN);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FPDenormMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::FPDenormMode);
  {
    STRINGISE_ENUM_CLASS(Preserve);
    STRINGISE_ENUM_CLASS(FlushToZero);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::QuantizationModes &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::QuantizationModes);
  {
    STRINGISE_ENUM_CLASS(TRN);
    STRINGISE_ENUM_CLASS(TRN_ZERO);
    STRINGISE_ENUM_CLASS(RND);
    STRINGISE_ENUM_CLASS(RND_ZERO);
    STRINGISE_ENUM_CLASS(RND_INF);
    STRINGISE_ENUM_CLASS(RND_MIN_INF);
    STRINGISE_ENUM_CLASS(RND_CONV);
    STRINGISE_ENUM_CLASS(RND_CONV_ODD);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FPOperationMode &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::FPOperationMode);
  {
    STRINGISE_ENUM_CLASS(IEEE);
    STRINGISE_ENUM_CLASS(ALT);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::OverflowModes &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::OverflowModes);
  {
    STRINGISE_ENUM_CLASS(WRAP);
    STRINGISE_ENUM_CLASS(SAT);
    STRINGISE_ENUM_CLASS(SAT_ZERO);
    STRINGISE_ENUM_CLASS(SAT_SYM);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::LinkageType &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::LinkageType);
  {
    STRINGISE_ENUM_CLASS(Export);
    STRINGISE_ENUM_CLASS(Import);
    STRINGISE_ENUM_CLASS(LinkOnceODR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::AccessQualifier &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::AccessQualifier);
  {
    STRINGISE_ENUM_CLASS(ReadOnly);
    STRINGISE_ENUM_CLASS(WriteOnly);
    STRINGISE_ENUM_CLASS(ReadWrite);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::HostAccessQualifier &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::HostAccessQualifier);
  {
    STRINGISE_ENUM_CLASS(NoneINTEL);
    STRINGISE_ENUM_CLASS(ReadINTEL);
    STRINGISE_ENUM_CLASS(WriteINTEL);
    STRINGISE_ENUM_CLASS(ReadWriteINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::FunctionParameterAttribute &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::FunctionParameterAttribute);
  {
    STRINGISE_ENUM_CLASS(Zext);
    STRINGISE_ENUM_CLASS(Sext);
    STRINGISE_ENUM_CLASS(ByVal);
    STRINGISE_ENUM_CLASS(Sret);
    STRINGISE_ENUM_CLASS(NoAlias);
    STRINGISE_ENUM_CLASS(NoCapture);
    STRINGISE_ENUM_CLASS(NoWrite);
    STRINGISE_ENUM_CLASS(NoReadWrite);
    STRINGISE_ENUM_CLASS(RuntimeAlignedINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Decoration &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Decoration);
  {
    STRINGISE_ENUM_CLASS(RelaxedPrecision);
    STRINGISE_ENUM_CLASS(SpecId);
    STRINGISE_ENUM_CLASS(Block);
    STRINGISE_ENUM_CLASS(BufferBlock);
    STRINGISE_ENUM_CLASS(RowMajor);
    STRINGISE_ENUM_CLASS(ColMajor);
    STRINGISE_ENUM_CLASS(ArrayStride);
    STRINGISE_ENUM_CLASS(MatrixStride);
    STRINGISE_ENUM_CLASS(GLSLShared);
    STRINGISE_ENUM_CLASS(GLSLPacked);
    STRINGISE_ENUM_CLASS(CPacked);
    STRINGISE_ENUM_CLASS(BuiltIn);
    STRINGISE_ENUM_CLASS(NoPerspective);
    STRINGISE_ENUM_CLASS(Flat);
    STRINGISE_ENUM_CLASS(Patch);
    STRINGISE_ENUM_CLASS(Centroid);
    STRINGISE_ENUM_CLASS(Sample);
    STRINGISE_ENUM_CLASS(Invariant);
    STRINGISE_ENUM_CLASS(Restrict);
    STRINGISE_ENUM_CLASS(Aliased);
    STRINGISE_ENUM_CLASS(Volatile);
    STRINGISE_ENUM_CLASS(Constant);
    STRINGISE_ENUM_CLASS(Coherent);
    STRINGISE_ENUM_CLASS(NonWritable);
    STRINGISE_ENUM_CLASS(NonReadable);
    STRINGISE_ENUM_CLASS(Uniform);
    STRINGISE_ENUM_CLASS(UniformId);
    STRINGISE_ENUM_CLASS(SaturatedConversion);
    STRINGISE_ENUM_CLASS(Stream);
    STRINGISE_ENUM_CLASS(Location);
    STRINGISE_ENUM_CLASS(Component);
    STRINGISE_ENUM_CLASS(Index);
    STRINGISE_ENUM_CLASS(Binding);
    STRINGISE_ENUM_CLASS(DescriptorSet);
    STRINGISE_ENUM_CLASS(Offset);
    STRINGISE_ENUM_CLASS(XfbBuffer);
    STRINGISE_ENUM_CLASS(XfbStride);
    STRINGISE_ENUM_CLASS(FuncParamAttr);
    STRINGISE_ENUM_CLASS(FPRoundingMode);
    STRINGISE_ENUM_CLASS(FPFastMathMode);
    STRINGISE_ENUM_CLASS(LinkageAttributes);
    STRINGISE_ENUM_CLASS(NoContraction);
    STRINGISE_ENUM_CLASS(InputAttachmentIndex);
    STRINGISE_ENUM_CLASS(Alignment);
    STRINGISE_ENUM_CLASS(MaxByteOffset);
    STRINGISE_ENUM_CLASS(AlignmentId);
    STRINGISE_ENUM_CLASS(MaxByteOffsetId);
    STRINGISE_ENUM_CLASS(NoSignedWrap);
    STRINGISE_ENUM_CLASS(NoUnsignedWrap);
    STRINGISE_ENUM_CLASS(WeightTextureQCOM);
    STRINGISE_ENUM_CLASS(BlockMatchTextureQCOM);
    STRINGISE_ENUM_CLASS(BlockMatchSamplerQCOM);
    STRINGISE_ENUM_CLASS(ExplicitInterpAMD);
    STRINGISE_ENUM_CLASS(NodeSharesPayloadLimitsWithAMDX);
    STRINGISE_ENUM_CLASS(NodeMaxPayloadsAMDX);
    STRINGISE_ENUM_CLASS(TrackFinishWritingAMDX);
    STRINGISE_ENUM_CLASS(PayloadNodeNameAMDX);
    STRINGISE_ENUM_CLASS(OverrideCoverageNV);
    STRINGISE_ENUM_CLASS(PassthroughNV);
    STRINGISE_ENUM_CLASS(ViewportRelativeNV);
    STRINGISE_ENUM_CLASS(SecondaryViewportRelativeNV);
    STRINGISE_ENUM_CLASS(PerPrimitiveEXT);
    STRINGISE_ENUM_CLASS(PerViewNV);
    STRINGISE_ENUM_CLASS(PerTaskNV);
    STRINGISE_ENUM_CLASS(PerVertexKHR);
    STRINGISE_ENUM_CLASS(NonUniform);
    STRINGISE_ENUM_CLASS(RestrictPointer);
    STRINGISE_ENUM_CLASS(AliasedPointer);
    STRINGISE_ENUM_CLASS(HitObjectShaderRecordBufferNV);
    STRINGISE_ENUM_CLASS(BindlessSamplerNV);
    STRINGISE_ENUM_CLASS(BindlessImageNV);
    STRINGISE_ENUM_CLASS(BoundSamplerNV);
    STRINGISE_ENUM_CLASS(BoundImageNV);
    STRINGISE_ENUM_CLASS(SIMTCallINTEL);
    STRINGISE_ENUM_CLASS(ReferencedIndirectlyINTEL);
    STRINGISE_ENUM_CLASS(ClobberINTEL);
    STRINGISE_ENUM_CLASS(SideEffectsINTEL);
    STRINGISE_ENUM_CLASS(VectorComputeVariableINTEL);
    STRINGISE_ENUM_CLASS(FuncParamIOKindINTEL);
    STRINGISE_ENUM_CLASS(VectorComputeFunctionINTEL);
    STRINGISE_ENUM_CLASS(StackCallINTEL);
    STRINGISE_ENUM_CLASS(GlobalVariableOffsetINTEL);
    STRINGISE_ENUM_CLASS(CounterBuffer);
    STRINGISE_ENUM_CLASS(UserSemantic);
    STRINGISE_ENUM_CLASS(UserTypeGOOGLE);
    STRINGISE_ENUM_CLASS(FunctionRoundingModeINTEL);
    STRINGISE_ENUM_CLASS(FunctionDenormModeINTEL);
    STRINGISE_ENUM_CLASS(RegisterINTEL);
    STRINGISE_ENUM_CLASS(MemoryINTEL);
    STRINGISE_ENUM_CLASS(NumbanksINTEL);
    STRINGISE_ENUM_CLASS(BankwidthINTEL);
    STRINGISE_ENUM_CLASS(MaxPrivateCopiesINTEL);
    STRINGISE_ENUM_CLASS(SinglepumpINTEL);
    STRINGISE_ENUM_CLASS(DoublepumpINTEL);
    STRINGISE_ENUM_CLASS(MaxReplicatesINTEL);
    STRINGISE_ENUM_CLASS(SimpleDualPortINTEL);
    STRINGISE_ENUM_CLASS(MergeINTEL);
    STRINGISE_ENUM_CLASS(BankBitsINTEL);
    STRINGISE_ENUM_CLASS(ForcePow2DepthINTEL);
    STRINGISE_ENUM_CLASS(StridesizeINTEL);
    STRINGISE_ENUM_CLASS(WordsizeINTEL);
    STRINGISE_ENUM_CLASS(TrueDualPortINTEL);
    STRINGISE_ENUM_CLASS(BurstCoalesceINTEL);
    STRINGISE_ENUM_CLASS(CacheSizeINTEL);
    STRINGISE_ENUM_CLASS(DontStaticallyCoalesceINTEL);
    STRINGISE_ENUM_CLASS(PrefetchINTEL);
    STRINGISE_ENUM_CLASS(StallEnableINTEL);
    STRINGISE_ENUM_CLASS(FuseLoopsInFunctionINTEL);
    STRINGISE_ENUM_CLASS(MathOpDSPModeINTEL);
    STRINGISE_ENUM_CLASS(AliasScopeINTEL);
    STRINGISE_ENUM_CLASS(NoAliasINTEL);
    STRINGISE_ENUM_CLASS(InitiationIntervalINTEL);
    STRINGISE_ENUM_CLASS(MaxConcurrencyINTEL);
    STRINGISE_ENUM_CLASS(PipelineEnableINTEL);
    STRINGISE_ENUM_CLASS(BufferLocationINTEL);
    STRINGISE_ENUM_CLASS(IOPipeStorageINTEL);
    STRINGISE_ENUM_CLASS(FunctionFloatingPointModeINTEL);
    STRINGISE_ENUM_CLASS(SingleElementVectorINTEL);
    STRINGISE_ENUM_CLASS(VectorComputeCallableFunctionINTEL);
    STRINGISE_ENUM_CLASS(MediaBlockIOINTEL);
    STRINGISE_ENUM_CLASS(StallFreeINTEL);
    STRINGISE_ENUM_CLASS(FPMaxErrorDecorationINTEL);
    STRINGISE_ENUM_CLASS(LatencyControlLabelINTEL);
    STRINGISE_ENUM_CLASS(LatencyControlConstraintINTEL);
    STRINGISE_ENUM_CLASS(ConduitKernelArgumentINTEL);
    STRINGISE_ENUM_CLASS(RegisterMapKernelArgumentINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceAddressWidthINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceDataWidthINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceLatencyINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceReadWriteModeINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceMaxBurstINTEL);
    STRINGISE_ENUM_CLASS(MMHostInterfaceWaitRequestINTEL);
    STRINGISE_ENUM_CLASS(StableKernelArgumentINTEL);
    STRINGISE_ENUM_CLASS(HostAccessINTEL);
    STRINGISE_ENUM_CLASS(InitModeINTEL);
    STRINGISE_ENUM_CLASS(ImplementInRegisterMapINTEL);
    STRINGISE_ENUM_CLASS(CacheControlLoadINTEL);
    STRINGISE_ENUM_CLASS(CacheControlStoreINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::BuiltIn &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::BuiltIn);
  {
    STRINGISE_ENUM_CLASS(Position);
    STRINGISE_ENUM_CLASS(PointSize);
    STRINGISE_ENUM_CLASS(ClipDistance);
    STRINGISE_ENUM_CLASS(CullDistance);
    STRINGISE_ENUM_CLASS(VertexId);
    STRINGISE_ENUM_CLASS(InstanceId);
    STRINGISE_ENUM_CLASS(PrimitiveId);
    STRINGISE_ENUM_CLASS(InvocationId);
    STRINGISE_ENUM_CLASS(Layer);
    STRINGISE_ENUM_CLASS(ViewportIndex);
    STRINGISE_ENUM_CLASS(TessLevelOuter);
    STRINGISE_ENUM_CLASS(TessLevelInner);
    STRINGISE_ENUM_CLASS(TessCoord);
    STRINGISE_ENUM_CLASS(PatchVertices);
    STRINGISE_ENUM_CLASS(FragCoord);
    STRINGISE_ENUM_CLASS(PointCoord);
    STRINGISE_ENUM_CLASS(FrontFacing);
    STRINGISE_ENUM_CLASS(SampleId);
    STRINGISE_ENUM_CLASS(SamplePosition);
    STRINGISE_ENUM_CLASS(SampleMask);
    STRINGISE_ENUM_CLASS(FragDepth);
    STRINGISE_ENUM_CLASS(HelperInvocation);
    STRINGISE_ENUM_CLASS(NumWorkgroups);
    STRINGISE_ENUM_CLASS(WorkgroupSize);
    STRINGISE_ENUM_CLASS(WorkgroupId);
    STRINGISE_ENUM_CLASS(LocalInvocationId);
    STRINGISE_ENUM_CLASS(GlobalInvocationId);
    STRINGISE_ENUM_CLASS(LocalInvocationIndex);
    STRINGISE_ENUM_CLASS(WorkDim);
    STRINGISE_ENUM_CLASS(GlobalSize);
    STRINGISE_ENUM_CLASS(EnqueuedWorkgroupSize);
    STRINGISE_ENUM_CLASS(GlobalOffset);
    STRINGISE_ENUM_CLASS(GlobalLinearId);
    STRINGISE_ENUM_CLASS(SubgroupSize);
    STRINGISE_ENUM_CLASS(SubgroupMaxSize);
    STRINGISE_ENUM_CLASS(NumSubgroups);
    STRINGISE_ENUM_CLASS(NumEnqueuedSubgroups);
    STRINGISE_ENUM_CLASS(SubgroupId);
    STRINGISE_ENUM_CLASS(SubgroupLocalInvocationId);
    STRINGISE_ENUM_CLASS(VertexIndex);
    STRINGISE_ENUM_CLASS(InstanceIndex);
    STRINGISE_ENUM_CLASS(CoreIDARM);
    STRINGISE_ENUM_CLASS(CoreCountARM);
    STRINGISE_ENUM_CLASS(CoreMaxIDARM);
    STRINGISE_ENUM_CLASS(WarpIDARM);
    STRINGISE_ENUM_CLASS(WarpMaxIDARM);
    STRINGISE_ENUM_CLASS(SubgroupEqMask);
    STRINGISE_ENUM_CLASS(SubgroupGeMask);
    STRINGISE_ENUM_CLASS(SubgroupGtMask);
    STRINGISE_ENUM_CLASS(SubgroupLeMask);
    STRINGISE_ENUM_CLASS(SubgroupLtMask);
    STRINGISE_ENUM_CLASS(BaseVertex);
    STRINGISE_ENUM_CLASS(BaseInstance);
    STRINGISE_ENUM_CLASS(DrawIndex);
    STRINGISE_ENUM_CLASS(PrimitiveShadingRateKHR);
    STRINGISE_ENUM_CLASS(DeviceIndex);
    STRINGISE_ENUM_CLASS(ViewIndex);
    STRINGISE_ENUM_CLASS(ShadingRateKHR);
    STRINGISE_ENUM_CLASS(BaryCoordNoPerspCentroidAMD);
    STRINGISE_ENUM_CLASS(BaryCoordNoPerspSampleAMD);
    STRINGISE_ENUM_CLASS(BaryCoordSmoothAMD);
    STRINGISE_ENUM_CLASS(BaryCoordSmoothCentroidAMD);
    STRINGISE_ENUM_CLASS(BaryCoordSmoothSampleAMD);
    STRINGISE_ENUM_CLASS(BaryCoordPullModelAMD);
    STRINGISE_ENUM_CLASS(FragStencilRefEXT);
    STRINGISE_ENUM_CLASS(CoalescedInputCountAMDX);
    STRINGISE_ENUM_CLASS(ShaderIndexAMDX);
    STRINGISE_ENUM_CLASS(ViewportMaskNV);
    STRINGISE_ENUM_CLASS(SecondaryPositionNV);
    STRINGISE_ENUM_CLASS(SecondaryViewportMaskNV);
    STRINGISE_ENUM_CLASS(PositionPerViewNV);
    STRINGISE_ENUM_CLASS(ViewportMaskPerViewNV);
    STRINGISE_ENUM_CLASS(FullyCoveredEXT);
    STRINGISE_ENUM_CLASS(TaskCountNV);
    STRINGISE_ENUM_CLASS(PrimitiveCountNV);
    STRINGISE_ENUM_CLASS(PrimitiveIndicesNV);
    STRINGISE_ENUM_CLASS(ClipDistancePerViewNV);
    STRINGISE_ENUM_CLASS(CullDistancePerViewNV);
    STRINGISE_ENUM_CLASS(LayerPerViewNV);
    STRINGISE_ENUM_CLASS(MeshViewCountNV);
    STRINGISE_ENUM_CLASS(MeshViewIndicesNV);
    STRINGISE_ENUM_CLASS(BaryCoordKHR);
    STRINGISE_ENUM_CLASS(BaryCoordNoPerspKHR);
    STRINGISE_ENUM_CLASS(FragSizeEXT);
    STRINGISE_ENUM_CLASS(FragInvocationCountEXT);
    STRINGISE_ENUM_CLASS(PrimitivePointIndicesEXT);
    STRINGISE_ENUM_CLASS(PrimitiveLineIndicesEXT);
    STRINGISE_ENUM_CLASS(PrimitiveTriangleIndicesEXT);
    STRINGISE_ENUM_CLASS(CullPrimitiveEXT);
    STRINGISE_ENUM_CLASS(LaunchIdKHR);
    STRINGISE_ENUM_CLASS(LaunchSizeKHR);
    STRINGISE_ENUM_CLASS(WorldRayOriginKHR);
    STRINGISE_ENUM_CLASS(WorldRayDirectionKHR);
    STRINGISE_ENUM_CLASS(ObjectRayOriginKHR);
    STRINGISE_ENUM_CLASS(ObjectRayDirectionKHR);
    STRINGISE_ENUM_CLASS(RayTminKHR);
    STRINGISE_ENUM_CLASS(RayTmaxKHR);
    STRINGISE_ENUM_CLASS(InstanceCustomIndexKHR);
    STRINGISE_ENUM_CLASS(ObjectToWorldKHR);
    STRINGISE_ENUM_CLASS(WorldToObjectKHR);
    STRINGISE_ENUM_CLASS(HitTNV);
    STRINGISE_ENUM_CLASS(HitKindKHR);
    STRINGISE_ENUM_CLASS(CurrentRayTimeNV);
    STRINGISE_ENUM_CLASS(HitTriangleVertexPositionsKHR);
    STRINGISE_ENUM_CLASS(HitMicroTriangleVertexPositionsNV);
    STRINGISE_ENUM_CLASS(HitMicroTriangleVertexBarycentricsNV);
    STRINGISE_ENUM_CLASS(IncomingRayFlagsKHR);
    STRINGISE_ENUM_CLASS(RayGeometryIndexKHR);
    STRINGISE_ENUM_CLASS(WarpsPerSMNV);
    STRINGISE_ENUM_CLASS(SMCountNV);
    STRINGISE_ENUM_CLASS(WarpIDNV);
    STRINGISE_ENUM_CLASS(SMIDNV);
    STRINGISE_ENUM_CLASS(HitKindFrontFacingMicroTriangleNV);
    STRINGISE_ENUM_CLASS(HitKindBackFacingMicroTriangleNV);
    STRINGISE_ENUM_CLASS(CullMaskKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Scope &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Scope);
  {
    STRINGISE_ENUM_CLASS(CrossDevice);
    STRINGISE_ENUM_CLASS(Device);
    STRINGISE_ENUM_CLASS(Workgroup);
    STRINGISE_ENUM_CLASS(Subgroup);
    STRINGISE_ENUM_CLASS(Invocation);
    STRINGISE_ENUM_CLASS(QueueFamily);
    STRINGISE_ENUM_CLASS(ShaderCallKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::GroupOperation &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::GroupOperation);
  {
    STRINGISE_ENUM_CLASS(Reduce);
    STRINGISE_ENUM_CLASS(InclusiveScan);
    STRINGISE_ENUM_CLASS(ExclusiveScan);
    STRINGISE_ENUM_CLASS(ClusteredReduce);
    STRINGISE_ENUM_CLASS(PartitionedReduceNV);
    STRINGISE_ENUM_CLASS(PartitionedInclusiveScanNV);
    STRINGISE_ENUM_CLASS(PartitionedExclusiveScanNV);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::KernelEnqueueFlags &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::KernelEnqueueFlags);
  {
    STRINGISE_ENUM_CLASS(NoWait);
    STRINGISE_ENUM_CLASS(WaitKernel);
    STRINGISE_ENUM_CLASS(WaitWorkGroup);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Capability &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Capability);
  {
    STRINGISE_ENUM_CLASS(Matrix);
    STRINGISE_ENUM_CLASS(Shader);
    STRINGISE_ENUM_CLASS(Geometry);
    STRINGISE_ENUM_CLASS(Tessellation);
    STRINGISE_ENUM_CLASS(Addresses);
    STRINGISE_ENUM_CLASS(Linkage);
    STRINGISE_ENUM_CLASS(Kernel);
    STRINGISE_ENUM_CLASS(Vector16);
    STRINGISE_ENUM_CLASS(Float16Buffer);
    STRINGISE_ENUM_CLASS(Float16);
    STRINGISE_ENUM_CLASS(Float64);
    STRINGISE_ENUM_CLASS(Int64);
    STRINGISE_ENUM_CLASS(Int64Atomics);
    STRINGISE_ENUM_CLASS(ImageBasic);
    STRINGISE_ENUM_CLASS(ImageReadWrite);
    STRINGISE_ENUM_CLASS(ImageMipmap);
    STRINGISE_ENUM_CLASS(Pipes);
    STRINGISE_ENUM_CLASS(Groups);
    STRINGISE_ENUM_CLASS(DeviceEnqueue);
    STRINGISE_ENUM_CLASS(LiteralSampler);
    STRINGISE_ENUM_CLASS(AtomicStorage);
    STRINGISE_ENUM_CLASS(Int16);
    STRINGISE_ENUM_CLASS(TessellationPointSize);
    STRINGISE_ENUM_CLASS(GeometryPointSize);
    STRINGISE_ENUM_CLASS(ImageGatherExtended);
    STRINGISE_ENUM_CLASS(StorageImageMultisample);
    STRINGISE_ENUM_CLASS(UniformBufferArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(SampledImageArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(StorageBufferArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(StorageImageArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(ClipDistance);
    STRINGISE_ENUM_CLASS(CullDistance);
    STRINGISE_ENUM_CLASS(ImageCubeArray);
    STRINGISE_ENUM_CLASS(SampleRateShading);
    STRINGISE_ENUM_CLASS(ImageRect);
    STRINGISE_ENUM_CLASS(SampledRect);
    STRINGISE_ENUM_CLASS(GenericPointer);
    STRINGISE_ENUM_CLASS(Int8);
    STRINGISE_ENUM_CLASS(InputAttachment);
    STRINGISE_ENUM_CLASS(SparseResidency);
    STRINGISE_ENUM_CLASS(MinLod);
    STRINGISE_ENUM_CLASS(Sampled1D);
    STRINGISE_ENUM_CLASS(Image1D);
    STRINGISE_ENUM_CLASS(SampledCubeArray);
    STRINGISE_ENUM_CLASS(SampledBuffer);
    STRINGISE_ENUM_CLASS(ImageBuffer);
    STRINGISE_ENUM_CLASS(ImageMSArray);
    STRINGISE_ENUM_CLASS(StorageImageExtendedFormats);
    STRINGISE_ENUM_CLASS(ImageQuery);
    STRINGISE_ENUM_CLASS(DerivativeControl);
    STRINGISE_ENUM_CLASS(InterpolationFunction);
    STRINGISE_ENUM_CLASS(TransformFeedback);
    STRINGISE_ENUM_CLASS(GeometryStreams);
    STRINGISE_ENUM_CLASS(StorageImageReadWithoutFormat);
    STRINGISE_ENUM_CLASS(StorageImageWriteWithoutFormat);
    STRINGISE_ENUM_CLASS(MultiViewport);
    STRINGISE_ENUM_CLASS(SubgroupDispatch);
    STRINGISE_ENUM_CLASS(NamedBarrier);
    STRINGISE_ENUM_CLASS(PipeStorage);
    STRINGISE_ENUM_CLASS(GroupNonUniform);
    STRINGISE_ENUM_CLASS(GroupNonUniformVote);
    STRINGISE_ENUM_CLASS(GroupNonUniformArithmetic);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallot);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffle);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffleRelative);
    STRINGISE_ENUM_CLASS(GroupNonUniformClustered);
    STRINGISE_ENUM_CLASS(GroupNonUniformQuad);
    STRINGISE_ENUM_CLASS(ShaderLayer);
    STRINGISE_ENUM_CLASS(ShaderViewportIndex);
    STRINGISE_ENUM_CLASS(UniformDecoration);
    STRINGISE_ENUM_CLASS(CoreBuiltinsARM);
    STRINGISE_ENUM_CLASS(TileImageColorReadAccessEXT);
    STRINGISE_ENUM_CLASS(TileImageDepthReadAccessEXT);
    STRINGISE_ENUM_CLASS(TileImageStencilReadAccessEXT);
    STRINGISE_ENUM_CLASS(CooperativeMatrixLayoutsARM);
    STRINGISE_ENUM_CLASS(FragmentShadingRateKHR);
    STRINGISE_ENUM_CLASS(SubgroupBallotKHR);
    STRINGISE_ENUM_CLASS(DrawParameters);
    STRINGISE_ENUM_CLASS(WorkgroupMemoryExplicitLayoutKHR);
    STRINGISE_ENUM_CLASS(WorkgroupMemoryExplicitLayout8BitAccessKHR);
    STRINGISE_ENUM_CLASS(WorkgroupMemoryExplicitLayout16BitAccessKHR);
    STRINGISE_ENUM_CLASS(SubgroupVoteKHR);
    STRINGISE_ENUM_CLASS(StorageBuffer16BitAccess);
    STRINGISE_ENUM_CLASS(UniformAndStorageBuffer16BitAccess);
    STRINGISE_ENUM_CLASS(StoragePushConstant16);
    STRINGISE_ENUM_CLASS(StorageInputOutput16);
    STRINGISE_ENUM_CLASS(DeviceGroup);
    STRINGISE_ENUM_CLASS(MultiView);
    STRINGISE_ENUM_CLASS(VariablePointersStorageBuffer);
    STRINGISE_ENUM_CLASS(VariablePointers);
    STRINGISE_ENUM_CLASS(AtomicStorageOps);
    STRINGISE_ENUM_CLASS(SampleMaskPostDepthCoverage);
    STRINGISE_ENUM_CLASS(StorageBuffer8BitAccess);
    STRINGISE_ENUM_CLASS(UniformAndStorageBuffer8BitAccess);
    STRINGISE_ENUM_CLASS(StoragePushConstant8);
    STRINGISE_ENUM_CLASS(DenormPreserve);
    STRINGISE_ENUM_CLASS(DenormFlushToZero);
    STRINGISE_ENUM_CLASS(SignedZeroInfNanPreserve);
    STRINGISE_ENUM_CLASS(RoundingModeRTE);
    STRINGISE_ENUM_CLASS(RoundingModeRTZ);
    STRINGISE_ENUM_CLASS(RayQueryProvisionalKHR);
    STRINGISE_ENUM_CLASS(RayQueryKHR);
    STRINGISE_ENUM_CLASS(RayTraversalPrimitiveCullingKHR);
    STRINGISE_ENUM_CLASS(RayTracingKHR);
    STRINGISE_ENUM_CLASS(TextureSampleWeightedQCOM);
    STRINGISE_ENUM_CLASS(TextureBoxFilterQCOM);
    STRINGISE_ENUM_CLASS(TextureBlockMatchQCOM);
    STRINGISE_ENUM_CLASS(TextureBlockMatch2QCOM);
    STRINGISE_ENUM_CLASS(Float16ImageAMD);
    STRINGISE_ENUM_CLASS(ImageGatherBiasLodAMD);
    STRINGISE_ENUM_CLASS(FragmentMaskAMD);
    STRINGISE_ENUM_CLASS(StencilExportEXT);
    STRINGISE_ENUM_CLASS(ImageReadWriteLodAMD);
    STRINGISE_ENUM_CLASS(Int64ImageEXT);
    STRINGISE_ENUM_CLASS(ShaderClockKHR);
    STRINGISE_ENUM_CLASS(ShaderEnqueueAMDX);
    STRINGISE_ENUM_CLASS(QuadControlKHR);
    STRINGISE_ENUM_CLASS(SampleMaskOverrideCoverageNV);
    STRINGISE_ENUM_CLASS(GeometryShaderPassthroughNV);
    STRINGISE_ENUM_CLASS(ShaderViewportIndexLayerEXT);
    STRINGISE_ENUM_CLASS(ShaderViewportMaskNV);
    STRINGISE_ENUM_CLASS(ShaderStereoViewNV);
    STRINGISE_ENUM_CLASS(PerViewAttributesNV);
    STRINGISE_ENUM_CLASS(FragmentFullyCoveredEXT);
    STRINGISE_ENUM_CLASS(ImageFootprintNV);
    STRINGISE_ENUM_CLASS(MeshShadingEXT);
    STRINGISE_ENUM_CLASS(FragmentBarycentricKHR);
    STRINGISE_ENUM_CLASS(ComputeDerivativeGroupQuadsNV);
    STRINGISE_ENUM_CLASS(FragmentDensityEXT);
    STRINGISE_ENUM_CLASS(GroupNonUniformPartitionedNV);
    STRINGISE_ENUM_CLASS(ShaderNonUniform);
    STRINGISE_ENUM_CLASS(RuntimeDescriptorArray);
    STRINGISE_ENUM_CLASS(InputAttachmentArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(UniformTexelBufferArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(StorageTexelBufferArrayDynamicIndexing);
    STRINGISE_ENUM_CLASS(UniformBufferArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(SampledImageArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(StorageBufferArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(StorageImageArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(InputAttachmentArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(UniformTexelBufferArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(StorageTexelBufferArrayNonUniformIndexing);
    STRINGISE_ENUM_CLASS(RayTracingPositionFetchKHR);
    STRINGISE_ENUM_CLASS(RayTracingMotionBlurNV);
    STRINGISE_ENUM_CLASS(VulkanMemoryModel);
    STRINGISE_ENUM_CLASS(VulkanMemoryModelDeviceScope);
    STRINGISE_ENUM_CLASS(PhysicalStorageBufferAddresses);
    STRINGISE_ENUM_CLASS(ComputeDerivativeGroupLinearNV);
    STRINGISE_ENUM_CLASS(RayTracingProvisionalKHR);
    STRINGISE_ENUM_CLASS(FragmentShaderSampleInterlockEXT);
    STRINGISE_ENUM_CLASS(FragmentShaderShadingRateInterlockEXT);
    STRINGISE_ENUM_CLASS(ShaderSMBuiltinsNV);
    STRINGISE_ENUM_CLASS(FragmentShaderPixelInterlockEXT);
    STRINGISE_ENUM_CLASS(DemoteToHelperInvocation);
    STRINGISE_ENUM_CLASS(DisplacementMicromapNV);
    STRINGISE_ENUM_CLASS(RayTracingOpacityMicromapEXT);
    STRINGISE_ENUM_CLASS(ShaderInvocationReorderNV);
    STRINGISE_ENUM_CLASS(BindlessTextureNV);
    STRINGISE_ENUM_CLASS(RayQueryPositionFetchKHR);
    STRINGISE_ENUM_CLASS(AtomicFloat16VectorNV);
    STRINGISE_ENUM_CLASS(RayTracingDisplacementMicromapNV);
    STRINGISE_ENUM_CLASS(RawAccessChainsNV);
    STRINGISE_ENUM_CLASS(SubgroupShuffleINTEL);
    STRINGISE_ENUM_CLASS(SubgroupBufferBlockIOINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageBlockIOINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageMediaBlockIOINTEL);
    STRINGISE_ENUM_CLASS(RoundToInfinityINTEL);
    STRINGISE_ENUM_CLASS(FloatingPointModeINTEL);
    STRINGISE_ENUM_CLASS(IntegerFunctions2INTEL);
    STRINGISE_ENUM_CLASS(FunctionPointersINTEL);
    STRINGISE_ENUM_CLASS(IndirectReferencesINTEL);
    STRINGISE_ENUM_CLASS(AsmINTEL);
    STRINGISE_ENUM_CLASS(AtomicFloat32MinMaxEXT);
    STRINGISE_ENUM_CLASS(AtomicFloat64MinMaxEXT);
    STRINGISE_ENUM_CLASS(AtomicFloat16MinMaxEXT);
    STRINGISE_ENUM_CLASS(VectorComputeINTEL);
    STRINGISE_ENUM_CLASS(VectorAnyINTEL);
    STRINGISE_ENUM_CLASS(ExpectAssumeKHR);
    STRINGISE_ENUM_CLASS(SubgroupAvcMotionEstimationINTEL);
    STRINGISE_ENUM_CLASS(SubgroupAvcMotionEstimationIntraINTEL);
    STRINGISE_ENUM_CLASS(SubgroupAvcMotionEstimationChromaINTEL);
    STRINGISE_ENUM_CLASS(VariableLengthArrayINTEL);
    STRINGISE_ENUM_CLASS(FunctionFloatControlINTEL);
    STRINGISE_ENUM_CLASS(FPGAMemoryAttributesINTEL);
    STRINGISE_ENUM_CLASS(FPFastMathModeINTEL);
    STRINGISE_ENUM_CLASS(ArbitraryPrecisionIntegersINTEL);
    STRINGISE_ENUM_CLASS(ArbitraryPrecisionFloatingPointINTEL);
    STRINGISE_ENUM_CLASS(UnstructuredLoopControlsINTEL);
    STRINGISE_ENUM_CLASS(FPGALoopControlsINTEL);
    STRINGISE_ENUM_CLASS(KernelAttributesINTEL);
    STRINGISE_ENUM_CLASS(FPGAKernelAttributesINTEL);
    STRINGISE_ENUM_CLASS(FPGAMemoryAccessesINTEL);
    STRINGISE_ENUM_CLASS(FPGAClusterAttributesINTEL);
    STRINGISE_ENUM_CLASS(LoopFuseINTEL);
    STRINGISE_ENUM_CLASS(FPGADSPControlINTEL);
    STRINGISE_ENUM_CLASS(MemoryAccessAliasingINTEL);
    STRINGISE_ENUM_CLASS(FPGAInvocationPipeliningAttributesINTEL);
    STRINGISE_ENUM_CLASS(FPGABufferLocationINTEL);
    STRINGISE_ENUM_CLASS(ArbitraryPrecisionFixedPointINTEL);
    STRINGISE_ENUM_CLASS(USMStorageClassesINTEL);
    STRINGISE_ENUM_CLASS(RuntimeAlignedAttributeINTEL);
    STRINGISE_ENUM_CLASS(IOPipesINTEL);
    STRINGISE_ENUM_CLASS(BlockingPipesINTEL);
    STRINGISE_ENUM_CLASS(FPGARegINTEL);
    STRINGISE_ENUM_CLASS(DotProductInputAll);
    STRINGISE_ENUM_CLASS(DotProductInput4x8Bit);
    STRINGISE_ENUM_CLASS(DotProductInput4x8BitPacked);
    STRINGISE_ENUM_CLASS(DotProduct);
    STRINGISE_ENUM_CLASS(RayCullMaskKHR);
    STRINGISE_ENUM_CLASS(CooperativeMatrixKHR);
    STRINGISE_ENUM_CLASS(ReplicatedCompositesEXT);
    STRINGISE_ENUM_CLASS(BitInstructions);
    STRINGISE_ENUM_CLASS(GroupNonUniformRotateKHR);
    STRINGISE_ENUM_CLASS(FloatControls2);
    STRINGISE_ENUM_CLASS(AtomicFloat32AddEXT);
    STRINGISE_ENUM_CLASS(AtomicFloat64AddEXT);
    STRINGISE_ENUM_CLASS(LongCompositesINTEL);
    STRINGISE_ENUM_CLASS(OptNoneINTEL);
    STRINGISE_ENUM_CLASS(AtomicFloat16AddEXT);
    STRINGISE_ENUM_CLASS(DebugInfoModuleINTEL);
    STRINGISE_ENUM_CLASS(BFloat16ConversionINTEL);
    STRINGISE_ENUM_CLASS(SplitBarrierINTEL);
    STRINGISE_ENUM_CLASS(FPGAClusterAttributesV2INTEL);
    STRINGISE_ENUM_CLASS(FPGAKernelAttributesv2INTEL);
    STRINGISE_ENUM_CLASS(FPMaxErrorINTEL);
    STRINGISE_ENUM_CLASS(FPGALatencyControlINTEL);
    STRINGISE_ENUM_CLASS(FPGAArgumentInterfacesINTEL);
    STRINGISE_ENUM_CLASS(GlobalVariableHostAccessINTEL);
    STRINGISE_ENUM_CLASS(GlobalVariableFPGADecorationsINTEL);
    STRINGISE_ENUM_CLASS(GroupUniformArithmeticKHR);
    STRINGISE_ENUM_CLASS(MaskedGatherScatterINTEL);
    STRINGISE_ENUM_CLASS(CacheControlsINTEL);
    STRINGISE_ENUM_CLASS(RegisterLimitsINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::RayQueryIntersection &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::RayQueryIntersection);
  {
    STRINGISE_ENUM_CLASS(RayQueryCandidateIntersectionKHR);
    STRINGISE_ENUM_CLASS(RayQueryCommittedIntersectionKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::RayQueryCommittedIntersectionType &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::RayQueryCommittedIntersectionType);
  {
    STRINGISE_ENUM_CLASS(RayQueryCommittedIntersectionNoneKHR);
    STRINGISE_ENUM_CLASS(RayQueryCommittedIntersectionTriangleKHR);
    STRINGISE_ENUM_CLASS(RayQueryCommittedIntersectionGeneratedKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::RayQueryCandidateIntersectionType &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::RayQueryCandidateIntersectionType);
  {
    STRINGISE_ENUM_CLASS(RayQueryCandidateIntersectionTriangleKHR);
    STRINGISE_ENUM_CLASS(RayQueryCandidateIntersectionAABBKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::PackedVectorFormat &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::PackedVectorFormat);
  {
    STRINGISE_ENUM_CLASS(PackedVectorFormat4x8Bit);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::CooperativeMatrixOperands &el)
{
  BEGIN_BITFIELD_STRINGISE(rdcspv::CooperativeMatrixOperands);
  {
    STRINGISE_BITFIELD_CLASS_VALUE(NoneKHR);

    STRINGISE_BITFIELD_CLASS_BIT(MatrixASignedComponentsKHR);
    STRINGISE_BITFIELD_CLASS_BIT(MatrixBSignedComponentsKHR);
    STRINGISE_BITFIELD_CLASS_BIT(MatrixCSignedComponentsKHR);
    STRINGISE_BITFIELD_CLASS_BIT(MatrixResultSignedComponentsKHR);
    STRINGISE_BITFIELD_CLASS_BIT(SaturatingAccumulationKHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::CooperativeMatrixLayout &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::CooperativeMatrixLayout);
  {
    STRINGISE_ENUM_CLASS(RowMajorKHR);
    STRINGISE_ENUM_CLASS(ColumnMajorKHR);
    STRINGISE_ENUM_CLASS(RowBlockedInterleavedARM);
    STRINGISE_ENUM_CLASS(ColumnBlockedInterleavedARM);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::CooperativeMatrixUse &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::CooperativeMatrixUse);
  {
    STRINGISE_ENUM_CLASS(MatrixAKHR);
    STRINGISE_ENUM_CLASS(MatrixBKHR);
    STRINGISE_ENUM_CLASS(MatrixAccumulatorKHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::InitializationModeQualifier &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::InitializationModeQualifier);
  {
    STRINGISE_ENUM_CLASS(InitOnDeviceReprogramINTEL);
    STRINGISE_ENUM_CLASS(InitOnDeviceResetINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::LoadCacheControl &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::LoadCacheControl);
  {
    STRINGISE_ENUM_CLASS(UncachedINTEL);
    STRINGISE_ENUM_CLASS(CachedINTEL);
    STRINGISE_ENUM_CLASS(StreamingINTEL);
    STRINGISE_ENUM_CLASS(InvalidateAfterReadINTEL);
    STRINGISE_ENUM_CLASS(ConstCachedINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::StoreCacheControl &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::StoreCacheControl);
  {
    STRINGISE_ENUM_CLASS(UncachedINTEL);
    STRINGISE_ENUM_CLASS(WriteThroughINTEL);
    STRINGISE_ENUM_CLASS(WriteBackINTEL);
    STRINGISE_ENUM_CLASS(StreamingINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::NamedMaximumNumberOfRegisters &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::NamedMaximumNumberOfRegisters);
  {
    STRINGISE_ENUM_CLASS(AutoINTEL);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Op &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Op);
  {
    STRINGISE_ENUM_CLASS(Nop);
    STRINGISE_ENUM_CLASS(Undef);
    STRINGISE_ENUM_CLASS(SourceContinued);
    STRINGISE_ENUM_CLASS(Source);
    STRINGISE_ENUM_CLASS(SourceExtension);
    STRINGISE_ENUM_CLASS(Name);
    STRINGISE_ENUM_CLASS(MemberName);
    STRINGISE_ENUM_CLASS(String);
    STRINGISE_ENUM_CLASS(Line);
    STRINGISE_ENUM_CLASS(Extension);
    STRINGISE_ENUM_CLASS(ExtInstImport);
    STRINGISE_ENUM_CLASS(ExtInst);
    STRINGISE_ENUM_CLASS(MemoryModel);
    STRINGISE_ENUM_CLASS(EntryPoint);
    STRINGISE_ENUM_CLASS(ExecutionMode);
    STRINGISE_ENUM_CLASS(Capability);
    STRINGISE_ENUM_CLASS(TypeVoid);
    STRINGISE_ENUM_CLASS(TypeBool);
    STRINGISE_ENUM_CLASS(TypeInt);
    STRINGISE_ENUM_CLASS(TypeFloat);
    STRINGISE_ENUM_CLASS(TypeVector);
    STRINGISE_ENUM_CLASS(TypeMatrix);
    STRINGISE_ENUM_CLASS(TypeImage);
    STRINGISE_ENUM_CLASS(TypeSampler);
    STRINGISE_ENUM_CLASS(TypeSampledImage);
    STRINGISE_ENUM_CLASS(TypeArray);
    STRINGISE_ENUM_CLASS(TypeRuntimeArray);
    STRINGISE_ENUM_CLASS(TypeStruct);
    STRINGISE_ENUM_CLASS(TypeOpaque);
    STRINGISE_ENUM_CLASS(TypePointer);
    STRINGISE_ENUM_CLASS(TypeFunction);
    STRINGISE_ENUM_CLASS(TypeEvent);
    STRINGISE_ENUM_CLASS(TypeDeviceEvent);
    STRINGISE_ENUM_CLASS(TypeReserveId);
    STRINGISE_ENUM_CLASS(TypeQueue);
    STRINGISE_ENUM_CLASS(TypePipe);
    STRINGISE_ENUM_CLASS(TypeForwardPointer);
    STRINGISE_ENUM_CLASS(ConstantTrue);
    STRINGISE_ENUM_CLASS(ConstantFalse);
    STRINGISE_ENUM_CLASS(Constant);
    STRINGISE_ENUM_CLASS(ConstantComposite);
    STRINGISE_ENUM_CLASS(ConstantSampler);
    STRINGISE_ENUM_CLASS(ConstantNull);
    STRINGISE_ENUM_CLASS(SpecConstantTrue);
    STRINGISE_ENUM_CLASS(SpecConstantFalse);
    STRINGISE_ENUM_CLASS(SpecConstant);
    STRINGISE_ENUM_CLASS(SpecConstantComposite);
    STRINGISE_ENUM_CLASS(SpecConstantOp);
    STRINGISE_ENUM_CLASS(Function);
    STRINGISE_ENUM_CLASS(FunctionParameter);
    STRINGISE_ENUM_CLASS(FunctionEnd);
    STRINGISE_ENUM_CLASS(FunctionCall);
    STRINGISE_ENUM_CLASS(Variable);
    STRINGISE_ENUM_CLASS(ImageTexelPointer);
    STRINGISE_ENUM_CLASS(Load);
    STRINGISE_ENUM_CLASS(Store);
    STRINGISE_ENUM_CLASS(CopyMemory);
    STRINGISE_ENUM_CLASS(CopyMemorySized);
    STRINGISE_ENUM_CLASS(AccessChain);
    STRINGISE_ENUM_CLASS(InBoundsAccessChain);
    STRINGISE_ENUM_CLASS(PtrAccessChain);
    STRINGISE_ENUM_CLASS(ArrayLength);
    STRINGISE_ENUM_CLASS(GenericPtrMemSemantics);
    STRINGISE_ENUM_CLASS(InBoundsPtrAccessChain);
    STRINGISE_ENUM_CLASS(Decorate);
    STRINGISE_ENUM_CLASS(MemberDecorate);
    STRINGISE_ENUM_CLASS(DecorationGroup);
    STRINGISE_ENUM_CLASS(GroupDecorate);
    STRINGISE_ENUM_CLASS(GroupMemberDecorate);
    STRINGISE_ENUM_CLASS(VectorExtractDynamic);
    STRINGISE_ENUM_CLASS(VectorInsertDynamic);
    STRINGISE_ENUM_CLASS(VectorShuffle);
    STRINGISE_ENUM_CLASS(CompositeConstruct);
    STRINGISE_ENUM_CLASS(CompositeExtract);
    STRINGISE_ENUM_CLASS(CompositeInsert);
    STRINGISE_ENUM_CLASS(CopyObject);
    STRINGISE_ENUM_CLASS(Transpose);
    STRINGISE_ENUM_CLASS(SampledImage);
    STRINGISE_ENUM_CLASS(ImageSampleImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleDrefImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleDrefExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleProjImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleProjExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleProjDrefImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSampleProjDrefExplicitLod);
    STRINGISE_ENUM_CLASS(ImageFetch);
    STRINGISE_ENUM_CLASS(ImageGather);
    STRINGISE_ENUM_CLASS(ImageDrefGather);
    STRINGISE_ENUM_CLASS(ImageRead);
    STRINGISE_ENUM_CLASS(ImageWrite);
    STRINGISE_ENUM_CLASS(Image);
    STRINGISE_ENUM_CLASS(ImageQueryFormat);
    STRINGISE_ENUM_CLASS(ImageQueryOrder);
    STRINGISE_ENUM_CLASS(ImageQuerySizeLod);
    STRINGISE_ENUM_CLASS(ImageQuerySize);
    STRINGISE_ENUM_CLASS(ImageQueryLod);
    STRINGISE_ENUM_CLASS(ImageQueryLevels);
    STRINGISE_ENUM_CLASS(ImageQuerySamples);
    STRINGISE_ENUM_CLASS(ConvertFToU);
    STRINGISE_ENUM_CLASS(ConvertFToS);
    STRINGISE_ENUM_CLASS(ConvertSToF);
    STRINGISE_ENUM_CLASS(ConvertUToF);
    STRINGISE_ENUM_CLASS(UConvert);
    STRINGISE_ENUM_CLASS(SConvert);
    STRINGISE_ENUM_CLASS(FConvert);
    STRINGISE_ENUM_CLASS(QuantizeToF16);
    STRINGISE_ENUM_CLASS(ConvertPtrToU);
    STRINGISE_ENUM_CLASS(SatConvertSToU);
    STRINGISE_ENUM_CLASS(SatConvertUToS);
    STRINGISE_ENUM_CLASS(ConvertUToPtr);
    STRINGISE_ENUM_CLASS(PtrCastToGeneric);
    STRINGISE_ENUM_CLASS(GenericCastToPtr);
    STRINGISE_ENUM_CLASS(GenericCastToPtrExplicit);
    STRINGISE_ENUM_CLASS(Bitcast);
    STRINGISE_ENUM_CLASS(SNegate);
    STRINGISE_ENUM_CLASS(FNegate);
    STRINGISE_ENUM_CLASS(IAdd);
    STRINGISE_ENUM_CLASS(FAdd);
    STRINGISE_ENUM_CLASS(ISub);
    STRINGISE_ENUM_CLASS(FSub);
    STRINGISE_ENUM_CLASS(IMul);
    STRINGISE_ENUM_CLASS(FMul);
    STRINGISE_ENUM_CLASS(UDiv);
    STRINGISE_ENUM_CLASS(SDiv);
    STRINGISE_ENUM_CLASS(FDiv);
    STRINGISE_ENUM_CLASS(UMod);
    STRINGISE_ENUM_CLASS(SRem);
    STRINGISE_ENUM_CLASS(SMod);
    STRINGISE_ENUM_CLASS(FRem);
    STRINGISE_ENUM_CLASS(FMod);
    STRINGISE_ENUM_CLASS(VectorTimesScalar);
    STRINGISE_ENUM_CLASS(MatrixTimesScalar);
    STRINGISE_ENUM_CLASS(VectorTimesMatrix);
    STRINGISE_ENUM_CLASS(MatrixTimesVector);
    STRINGISE_ENUM_CLASS(MatrixTimesMatrix);
    STRINGISE_ENUM_CLASS(OuterProduct);
    STRINGISE_ENUM_CLASS(Dot);
    STRINGISE_ENUM_CLASS(IAddCarry);
    STRINGISE_ENUM_CLASS(ISubBorrow);
    STRINGISE_ENUM_CLASS(UMulExtended);
    STRINGISE_ENUM_CLASS(SMulExtended);
    STRINGISE_ENUM_CLASS(Any);
    STRINGISE_ENUM_CLASS(All);
    STRINGISE_ENUM_CLASS(IsNan);
    STRINGISE_ENUM_CLASS(IsInf);
    STRINGISE_ENUM_CLASS(IsFinite);
    STRINGISE_ENUM_CLASS(IsNormal);
    STRINGISE_ENUM_CLASS(SignBitSet);
    STRINGISE_ENUM_CLASS(LessOrGreater);
    STRINGISE_ENUM_CLASS(Ordered);
    STRINGISE_ENUM_CLASS(Unordered);
    STRINGISE_ENUM_CLASS(LogicalEqual);
    STRINGISE_ENUM_CLASS(LogicalNotEqual);
    STRINGISE_ENUM_CLASS(LogicalOr);
    STRINGISE_ENUM_CLASS(LogicalAnd);
    STRINGISE_ENUM_CLASS(LogicalNot);
    STRINGISE_ENUM_CLASS(Select);
    STRINGISE_ENUM_CLASS(IEqual);
    STRINGISE_ENUM_CLASS(INotEqual);
    STRINGISE_ENUM_CLASS(UGreaterThan);
    STRINGISE_ENUM_CLASS(SGreaterThan);
    STRINGISE_ENUM_CLASS(UGreaterThanEqual);
    STRINGISE_ENUM_CLASS(SGreaterThanEqual);
    STRINGISE_ENUM_CLASS(ULessThan);
    STRINGISE_ENUM_CLASS(SLessThan);
    STRINGISE_ENUM_CLASS(ULessThanEqual);
    STRINGISE_ENUM_CLASS(SLessThanEqual);
    STRINGISE_ENUM_CLASS(FOrdEqual);
    STRINGISE_ENUM_CLASS(FUnordEqual);
    STRINGISE_ENUM_CLASS(FOrdNotEqual);
    STRINGISE_ENUM_CLASS(FUnordNotEqual);
    STRINGISE_ENUM_CLASS(FOrdLessThan);
    STRINGISE_ENUM_CLASS(FUnordLessThan);
    STRINGISE_ENUM_CLASS(FOrdGreaterThan);
    STRINGISE_ENUM_CLASS(FUnordGreaterThan);
    STRINGISE_ENUM_CLASS(FOrdLessThanEqual);
    STRINGISE_ENUM_CLASS(FUnordLessThanEqual);
    STRINGISE_ENUM_CLASS(FOrdGreaterThanEqual);
    STRINGISE_ENUM_CLASS(FUnordGreaterThanEqual);
    STRINGISE_ENUM_CLASS(ShiftRightLogical);
    STRINGISE_ENUM_CLASS(ShiftRightArithmetic);
    STRINGISE_ENUM_CLASS(ShiftLeftLogical);
    STRINGISE_ENUM_CLASS(BitwiseOr);
    STRINGISE_ENUM_CLASS(BitwiseXor);
    STRINGISE_ENUM_CLASS(BitwiseAnd);
    STRINGISE_ENUM_CLASS(Not);
    STRINGISE_ENUM_CLASS(BitFieldInsert);
    STRINGISE_ENUM_CLASS(BitFieldSExtract);
    STRINGISE_ENUM_CLASS(BitFieldUExtract);
    STRINGISE_ENUM_CLASS(BitReverse);
    STRINGISE_ENUM_CLASS(BitCount);
    STRINGISE_ENUM_CLASS(DPdx);
    STRINGISE_ENUM_CLASS(DPdy);
    STRINGISE_ENUM_CLASS(Fwidth);
    STRINGISE_ENUM_CLASS(DPdxFine);
    STRINGISE_ENUM_CLASS(DPdyFine);
    STRINGISE_ENUM_CLASS(FwidthFine);
    STRINGISE_ENUM_CLASS(DPdxCoarse);
    STRINGISE_ENUM_CLASS(DPdyCoarse);
    STRINGISE_ENUM_CLASS(FwidthCoarse);
    STRINGISE_ENUM_CLASS(EmitVertex);
    STRINGISE_ENUM_CLASS(EndPrimitive);
    STRINGISE_ENUM_CLASS(EmitStreamVertex);
    STRINGISE_ENUM_CLASS(EndStreamPrimitive);
    STRINGISE_ENUM_CLASS(ControlBarrier);
    STRINGISE_ENUM_CLASS(MemoryBarrier);
    STRINGISE_ENUM_CLASS(AtomicLoad);
    STRINGISE_ENUM_CLASS(AtomicStore);
    STRINGISE_ENUM_CLASS(AtomicExchange);
    STRINGISE_ENUM_CLASS(AtomicCompareExchange);
    STRINGISE_ENUM_CLASS(AtomicCompareExchangeWeak);
    STRINGISE_ENUM_CLASS(AtomicIIncrement);
    STRINGISE_ENUM_CLASS(AtomicIDecrement);
    STRINGISE_ENUM_CLASS(AtomicIAdd);
    STRINGISE_ENUM_CLASS(AtomicISub);
    STRINGISE_ENUM_CLASS(AtomicSMin);
    STRINGISE_ENUM_CLASS(AtomicUMin);
    STRINGISE_ENUM_CLASS(AtomicSMax);
    STRINGISE_ENUM_CLASS(AtomicUMax);
    STRINGISE_ENUM_CLASS(AtomicAnd);
    STRINGISE_ENUM_CLASS(AtomicOr);
    STRINGISE_ENUM_CLASS(AtomicXor);
    STRINGISE_ENUM_CLASS(Phi);
    STRINGISE_ENUM_CLASS(LoopMerge);
    STRINGISE_ENUM_CLASS(SelectionMerge);
    STRINGISE_ENUM_CLASS(Label);
    STRINGISE_ENUM_CLASS(Branch);
    STRINGISE_ENUM_CLASS(BranchConditional);
    STRINGISE_ENUM_CLASS(Switch);
    STRINGISE_ENUM_CLASS(Kill);
    STRINGISE_ENUM_CLASS(Return);
    STRINGISE_ENUM_CLASS(ReturnValue);
    STRINGISE_ENUM_CLASS(Unreachable);
    STRINGISE_ENUM_CLASS(LifetimeStart);
    STRINGISE_ENUM_CLASS(LifetimeStop);
    STRINGISE_ENUM_CLASS(GroupAsyncCopy);
    STRINGISE_ENUM_CLASS(GroupWaitEvents);
    STRINGISE_ENUM_CLASS(GroupAll);
    STRINGISE_ENUM_CLASS(GroupAny);
    STRINGISE_ENUM_CLASS(GroupBroadcast);
    STRINGISE_ENUM_CLASS(GroupIAdd);
    STRINGISE_ENUM_CLASS(GroupFAdd);
    STRINGISE_ENUM_CLASS(GroupFMin);
    STRINGISE_ENUM_CLASS(GroupUMin);
    STRINGISE_ENUM_CLASS(GroupSMin);
    STRINGISE_ENUM_CLASS(GroupFMax);
    STRINGISE_ENUM_CLASS(GroupUMax);
    STRINGISE_ENUM_CLASS(GroupSMax);
    STRINGISE_ENUM_CLASS(ReadPipe);
    STRINGISE_ENUM_CLASS(WritePipe);
    STRINGISE_ENUM_CLASS(ReservedReadPipe);
    STRINGISE_ENUM_CLASS(ReservedWritePipe);
    STRINGISE_ENUM_CLASS(ReserveReadPipePackets);
    STRINGISE_ENUM_CLASS(ReserveWritePipePackets);
    STRINGISE_ENUM_CLASS(CommitReadPipe);
    STRINGISE_ENUM_CLASS(CommitWritePipe);
    STRINGISE_ENUM_CLASS(IsValidReserveId);
    STRINGISE_ENUM_CLASS(GetNumPipePackets);
    STRINGISE_ENUM_CLASS(GetMaxPipePackets);
    STRINGISE_ENUM_CLASS(GroupReserveReadPipePackets);
    STRINGISE_ENUM_CLASS(GroupReserveWritePipePackets);
    STRINGISE_ENUM_CLASS(GroupCommitReadPipe);
    STRINGISE_ENUM_CLASS(GroupCommitWritePipe);
    STRINGISE_ENUM_CLASS(EnqueueMarker);
    STRINGISE_ENUM_CLASS(EnqueueKernel);
    STRINGISE_ENUM_CLASS(GetKernelNDrangeSubGroupCount);
    STRINGISE_ENUM_CLASS(GetKernelNDrangeMaxSubGroupSize);
    STRINGISE_ENUM_CLASS(GetKernelWorkGroupSize);
    STRINGISE_ENUM_CLASS(GetKernelPreferredWorkGroupSizeMultiple);
    STRINGISE_ENUM_CLASS(RetainEvent);
    STRINGISE_ENUM_CLASS(ReleaseEvent);
    STRINGISE_ENUM_CLASS(CreateUserEvent);
    STRINGISE_ENUM_CLASS(IsValidEvent);
    STRINGISE_ENUM_CLASS(SetUserEventStatus);
    STRINGISE_ENUM_CLASS(CaptureEventProfilingInfo);
    STRINGISE_ENUM_CLASS(GetDefaultQueue);
    STRINGISE_ENUM_CLASS(BuildNDRange);
    STRINGISE_ENUM_CLASS(ImageSparseSampleImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleDrefImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleDrefExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleProjImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleProjExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleProjDrefImplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseSampleProjDrefExplicitLod);
    STRINGISE_ENUM_CLASS(ImageSparseFetch);
    STRINGISE_ENUM_CLASS(ImageSparseGather);
    STRINGISE_ENUM_CLASS(ImageSparseDrefGather);
    STRINGISE_ENUM_CLASS(ImageSparseTexelsResident);
    STRINGISE_ENUM_CLASS(NoLine);
    STRINGISE_ENUM_CLASS(AtomicFlagTestAndSet);
    STRINGISE_ENUM_CLASS(AtomicFlagClear);
    STRINGISE_ENUM_CLASS(ImageSparseRead);
    STRINGISE_ENUM_CLASS(SizeOf);
    STRINGISE_ENUM_CLASS(TypePipeStorage);
    STRINGISE_ENUM_CLASS(ConstantPipeStorage);
    STRINGISE_ENUM_CLASS(CreatePipeFromPipeStorage);
    STRINGISE_ENUM_CLASS(GetKernelLocalSizeForSubgroupCount);
    STRINGISE_ENUM_CLASS(GetKernelMaxNumSubgroups);
    STRINGISE_ENUM_CLASS(TypeNamedBarrier);
    STRINGISE_ENUM_CLASS(NamedBarrierInitialize);
    STRINGISE_ENUM_CLASS(MemoryNamedBarrier);
    STRINGISE_ENUM_CLASS(ModuleProcessed);
    STRINGISE_ENUM_CLASS(ExecutionModeId);
    STRINGISE_ENUM_CLASS(DecorateId);
    STRINGISE_ENUM_CLASS(GroupNonUniformElect);
    STRINGISE_ENUM_CLASS(GroupNonUniformAll);
    STRINGISE_ENUM_CLASS(GroupNonUniformAny);
    STRINGISE_ENUM_CLASS(GroupNonUniformAllEqual);
    STRINGISE_ENUM_CLASS(GroupNonUniformBroadcast);
    STRINGISE_ENUM_CLASS(GroupNonUniformBroadcastFirst);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallot);
    STRINGISE_ENUM_CLASS(GroupNonUniformInverseBallot);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallotBitExtract);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallotBitCount);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallotFindLSB);
    STRINGISE_ENUM_CLASS(GroupNonUniformBallotFindMSB);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffle);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffleXor);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffleUp);
    STRINGISE_ENUM_CLASS(GroupNonUniformShuffleDown);
    STRINGISE_ENUM_CLASS(GroupNonUniformIAdd);
    STRINGISE_ENUM_CLASS(GroupNonUniformFAdd);
    STRINGISE_ENUM_CLASS(GroupNonUniformIMul);
    STRINGISE_ENUM_CLASS(GroupNonUniformFMul);
    STRINGISE_ENUM_CLASS(GroupNonUniformSMin);
    STRINGISE_ENUM_CLASS(GroupNonUniformUMin);
    STRINGISE_ENUM_CLASS(GroupNonUniformFMin);
    STRINGISE_ENUM_CLASS(GroupNonUniformSMax);
    STRINGISE_ENUM_CLASS(GroupNonUniformUMax);
    STRINGISE_ENUM_CLASS(GroupNonUniformFMax);
    STRINGISE_ENUM_CLASS(GroupNonUniformBitwiseAnd);
    STRINGISE_ENUM_CLASS(GroupNonUniformBitwiseOr);
    STRINGISE_ENUM_CLASS(GroupNonUniformBitwiseXor);
    STRINGISE_ENUM_CLASS(GroupNonUniformLogicalAnd);
    STRINGISE_ENUM_CLASS(GroupNonUniformLogicalOr);
    STRINGISE_ENUM_CLASS(GroupNonUniformLogicalXor);
    STRINGISE_ENUM_CLASS(GroupNonUniformQuadBroadcast);
    STRINGISE_ENUM_CLASS(GroupNonUniformQuadSwap);
    STRINGISE_ENUM_CLASS(CopyLogical);
    STRINGISE_ENUM_CLASS(PtrEqual);
    STRINGISE_ENUM_CLASS(PtrNotEqual);
    STRINGISE_ENUM_CLASS(PtrDiff);
    STRINGISE_ENUM_CLASS(ColorAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(DepthAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(StencilAttachmentReadEXT);
    STRINGISE_ENUM_CLASS(TerminateInvocation);
    STRINGISE_ENUM_CLASS(SubgroupBallotKHR);
    STRINGISE_ENUM_CLASS(SubgroupFirstInvocationKHR);
    STRINGISE_ENUM_CLASS(SubgroupAllKHR);
    STRINGISE_ENUM_CLASS(SubgroupAnyKHR);
    STRINGISE_ENUM_CLASS(SubgroupAllEqualKHR);
    STRINGISE_ENUM_CLASS(GroupNonUniformRotateKHR);
    STRINGISE_ENUM_CLASS(SubgroupReadInvocationKHR);
    STRINGISE_ENUM_CLASS(ExtInstWithForwardRefsKHR);
    STRINGISE_ENUM_CLASS(TraceRayKHR);
    STRINGISE_ENUM_CLASS(ExecuteCallableKHR);
    STRINGISE_ENUM_CLASS(ConvertUToAccelerationStructureKHR);
    STRINGISE_ENUM_CLASS(IgnoreIntersectionKHR);
    STRINGISE_ENUM_CLASS(TerminateRayKHR);
    STRINGISE_ENUM_CLASS(SDot);
    STRINGISE_ENUM_CLASS(UDot);
    STRINGISE_ENUM_CLASS(SUDot);
    STRINGISE_ENUM_CLASS(SDotAccSat);
    STRINGISE_ENUM_CLASS(UDotAccSat);
    STRINGISE_ENUM_CLASS(SUDotAccSat);
    STRINGISE_ENUM_CLASS(TypeCooperativeMatrixKHR);
    STRINGISE_ENUM_CLASS(CooperativeMatrixLoadKHR);
    STRINGISE_ENUM_CLASS(CooperativeMatrixStoreKHR);
    STRINGISE_ENUM_CLASS(CooperativeMatrixMulAddKHR);
    STRINGISE_ENUM_CLASS(CooperativeMatrixLengthKHR);
    STRINGISE_ENUM_CLASS(ConstantCompositeReplicateEXT);
    STRINGISE_ENUM_CLASS(SpecConstantCompositeReplicateEXT);
    STRINGISE_ENUM_CLASS(CompositeConstructReplicateEXT);
    STRINGISE_ENUM_CLASS(TypeRayQueryKHR);
    STRINGISE_ENUM_CLASS(RayQueryInitializeKHR);
    STRINGISE_ENUM_CLASS(RayQueryTerminateKHR);
    STRINGISE_ENUM_CLASS(RayQueryGenerateIntersectionKHR);
    STRINGISE_ENUM_CLASS(RayQueryConfirmIntersectionKHR);
    STRINGISE_ENUM_CLASS(RayQueryProceedKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionTypeKHR);
    STRINGISE_ENUM_CLASS(ImageSampleWeightedQCOM);
    STRINGISE_ENUM_CLASS(ImageBoxFilterQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchSSDQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchSADQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchWindowSSDQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchWindowSADQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchGatherSSDQCOM);
    STRINGISE_ENUM_CLASS(ImageBlockMatchGatherSADQCOM);
    STRINGISE_ENUM_CLASS(GroupIAddNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupFAddNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupFMinNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupUMinNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupSMinNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupFMaxNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupUMaxNonUniformAMD);
    STRINGISE_ENUM_CLASS(GroupSMaxNonUniformAMD);
    STRINGISE_ENUM_CLASS(FragmentMaskFetchAMD);
    STRINGISE_ENUM_CLASS(FragmentFetchAMD);
    STRINGISE_ENUM_CLASS(ReadClockKHR);
    STRINGISE_ENUM_CLASS(FinalizeNodePayloadsAMDX);
    STRINGISE_ENUM_CLASS(FinishWritingNodePayloadAMDX);
    STRINGISE_ENUM_CLASS(InitializeNodePayloadsAMDX);
    STRINGISE_ENUM_CLASS(GroupNonUniformQuadAllKHR);
    STRINGISE_ENUM_CLASS(GroupNonUniformQuadAnyKHR);
    STRINGISE_ENUM_CLASS(HitObjectRecordHitMotionNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordHitWithIndexMotionNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordMissMotionNV);
    STRINGISE_ENUM_CLASS(HitObjectGetWorldToObjectNV);
    STRINGISE_ENUM_CLASS(HitObjectGetObjectToWorldNV);
    STRINGISE_ENUM_CLASS(HitObjectGetObjectRayDirectionNV);
    STRINGISE_ENUM_CLASS(HitObjectGetObjectRayOriginNV);
    STRINGISE_ENUM_CLASS(HitObjectTraceRayMotionNV);
    STRINGISE_ENUM_CLASS(HitObjectGetShaderRecordBufferHandleNV);
    STRINGISE_ENUM_CLASS(HitObjectGetShaderBindingTableRecordIndexNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordEmptyNV);
    STRINGISE_ENUM_CLASS(HitObjectTraceRayNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordHitNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordHitWithIndexNV);
    STRINGISE_ENUM_CLASS(HitObjectRecordMissNV);
    STRINGISE_ENUM_CLASS(HitObjectExecuteShaderNV);
    STRINGISE_ENUM_CLASS(HitObjectGetCurrentTimeNV);
    STRINGISE_ENUM_CLASS(HitObjectGetAttributesNV);
    STRINGISE_ENUM_CLASS(HitObjectGetHitKindNV);
    STRINGISE_ENUM_CLASS(HitObjectGetPrimitiveIndexNV);
    STRINGISE_ENUM_CLASS(HitObjectGetGeometryIndexNV);
    STRINGISE_ENUM_CLASS(HitObjectGetInstanceIdNV);
    STRINGISE_ENUM_CLASS(HitObjectGetInstanceCustomIndexNV);
    STRINGISE_ENUM_CLASS(HitObjectGetWorldRayDirectionNV);
    STRINGISE_ENUM_CLASS(HitObjectGetWorldRayOriginNV);
    STRINGISE_ENUM_CLASS(HitObjectGetRayTMaxNV);
    STRINGISE_ENUM_CLASS(HitObjectGetRayTMinNV);
    STRINGISE_ENUM_CLASS(HitObjectIsEmptyNV);
    STRINGISE_ENUM_CLASS(HitObjectIsHitNV);
    STRINGISE_ENUM_CLASS(HitObjectIsMissNV);
    STRINGISE_ENUM_CLASS(ReorderThreadWithHitObjectNV);
    STRINGISE_ENUM_CLASS(ReorderThreadWithHintNV);
    STRINGISE_ENUM_CLASS(TypeHitObjectNV);
    STRINGISE_ENUM_CLASS(ImageSampleFootprintNV);
    STRINGISE_ENUM_CLASS(EmitMeshTasksEXT);
    STRINGISE_ENUM_CLASS(SetMeshOutputsEXT);
    STRINGISE_ENUM_CLASS(GroupNonUniformPartitionNV);
    STRINGISE_ENUM_CLASS(WritePackedPrimitiveIndices4x8NV);
    STRINGISE_ENUM_CLASS(FetchMicroTriangleVertexPositionNV);
    STRINGISE_ENUM_CLASS(FetchMicroTriangleVertexBarycentricNV);
    STRINGISE_ENUM_CLASS(ReportIntersectionKHR);
    STRINGISE_ENUM_CLASS(IgnoreIntersectionNV);
    STRINGISE_ENUM_CLASS(TerminateRayNV);
    STRINGISE_ENUM_CLASS(TraceNV);
    STRINGISE_ENUM_CLASS(TraceMotionNV);
    STRINGISE_ENUM_CLASS(TraceRayMotionNV);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionTriangleVertexPositionsKHR);
    STRINGISE_ENUM_CLASS(TypeAccelerationStructureKHR);
    STRINGISE_ENUM_CLASS(ExecuteCallableNV);
    STRINGISE_ENUM_CLASS(TypeCooperativeMatrixNV);
    STRINGISE_ENUM_CLASS(CooperativeMatrixLoadNV);
    STRINGISE_ENUM_CLASS(CooperativeMatrixStoreNV);
    STRINGISE_ENUM_CLASS(CooperativeMatrixMulAddNV);
    STRINGISE_ENUM_CLASS(CooperativeMatrixLengthNV);
    STRINGISE_ENUM_CLASS(BeginInvocationInterlockEXT);
    STRINGISE_ENUM_CLASS(EndInvocationInterlockEXT);
    STRINGISE_ENUM_CLASS(DemoteToHelperInvocation);
    STRINGISE_ENUM_CLASS(IsHelperInvocationEXT);
    STRINGISE_ENUM_CLASS(ConvertUToImageNV);
    STRINGISE_ENUM_CLASS(ConvertUToSamplerNV);
    STRINGISE_ENUM_CLASS(ConvertImageToUNV);
    STRINGISE_ENUM_CLASS(ConvertSamplerToUNV);
    STRINGISE_ENUM_CLASS(ConvertUToSampledImageNV);
    STRINGISE_ENUM_CLASS(ConvertSampledImageToUNV);
    STRINGISE_ENUM_CLASS(SamplerImageAddressingModeNV);
    STRINGISE_ENUM_CLASS(RawAccessChainNV);
    STRINGISE_ENUM_CLASS(SubgroupShuffleINTEL);
    STRINGISE_ENUM_CLASS(SubgroupShuffleDownINTEL);
    STRINGISE_ENUM_CLASS(SubgroupShuffleUpINTEL);
    STRINGISE_ENUM_CLASS(SubgroupShuffleXorINTEL);
    STRINGISE_ENUM_CLASS(SubgroupBlockReadINTEL);
    STRINGISE_ENUM_CLASS(SubgroupBlockWriteINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageBlockReadINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageBlockWriteINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageMediaBlockReadINTEL);
    STRINGISE_ENUM_CLASS(SubgroupImageMediaBlockWriteINTEL);
    STRINGISE_ENUM_CLASS(UCountLeadingZerosINTEL);
    STRINGISE_ENUM_CLASS(UCountTrailingZerosINTEL);
    STRINGISE_ENUM_CLASS(AbsISubINTEL);
    STRINGISE_ENUM_CLASS(AbsUSubINTEL);
    STRINGISE_ENUM_CLASS(IAddSatINTEL);
    STRINGISE_ENUM_CLASS(UAddSatINTEL);
    STRINGISE_ENUM_CLASS(IAverageINTEL);
    STRINGISE_ENUM_CLASS(UAverageINTEL);
    STRINGISE_ENUM_CLASS(IAverageRoundedINTEL);
    STRINGISE_ENUM_CLASS(UAverageRoundedINTEL);
    STRINGISE_ENUM_CLASS(ISubSatINTEL);
    STRINGISE_ENUM_CLASS(USubSatINTEL);
    STRINGISE_ENUM_CLASS(IMul32x16INTEL);
    STRINGISE_ENUM_CLASS(UMul32x16INTEL);
    STRINGISE_ENUM_CLASS(AtomicFMinEXT);
    STRINGISE_ENUM_CLASS(AtomicFMaxEXT);
    STRINGISE_ENUM_CLASS(AssumeTrueKHR);
    STRINGISE_ENUM_CLASS(ExpectKHR);
    STRINGISE_ENUM_CLASS(DecorateString);
    STRINGISE_ENUM_CLASS(MemberDecorateString);
    STRINGISE_ENUM_CLASS(LoopControlINTEL);
    STRINGISE_ENUM_CLASS(ReadPipeBlockingINTEL);
    STRINGISE_ENUM_CLASS(WritePipeBlockingINTEL);
    STRINGISE_ENUM_CLASS(FPGARegINTEL);
    STRINGISE_ENUM_CLASS(RayQueryGetRayTMinKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetRayFlagsKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionTKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionInstanceCustomIndexKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionInstanceIdKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionGeometryIndexKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionPrimitiveIndexKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionBarycentricsKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionFrontFaceKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionCandidateAABBOpaqueKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionObjectRayDirectionKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionObjectRayOriginKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetWorldRayDirectionKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetWorldRayOriginKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionObjectToWorldKHR);
    STRINGISE_ENUM_CLASS(RayQueryGetIntersectionWorldToObjectKHR);
    STRINGISE_ENUM_CLASS(AtomicFAddEXT);
    STRINGISE_ENUM_CLASS(TypeBufferSurfaceINTEL);
    STRINGISE_ENUM_CLASS(TypeStructContinuedINTEL);
    STRINGISE_ENUM_CLASS(ConstantCompositeContinuedINTEL);
    STRINGISE_ENUM_CLASS(SpecConstantCompositeContinuedINTEL);
    STRINGISE_ENUM_CLASS(CompositeConstructContinuedINTEL);
    STRINGISE_ENUM_CLASS(ConvertFToBF16INTEL);
    STRINGISE_ENUM_CLASS(ConvertBF16ToFINTEL);
    STRINGISE_ENUM_CLASS(ControlBarrierArriveINTEL);
    STRINGISE_ENUM_CLASS(ControlBarrierWaitINTEL);
    STRINGISE_ENUM_CLASS(GroupIMulKHR);
    STRINGISE_ENUM_CLASS(GroupFMulKHR);
    STRINGISE_ENUM_CLASS(GroupBitwiseAndKHR);
    STRINGISE_ENUM_CLASS(GroupBitwiseOrKHR);
    STRINGISE_ENUM_CLASS(GroupBitwiseXorKHR);
    STRINGISE_ENUM_CLASS(GroupLogicalAndKHR);
    STRINGISE_ENUM_CLASS(GroupLogicalOrKHR);
    STRINGISE_ENUM_CLASS(GroupLogicalXorKHR);
    STRINGISE_ENUM_CLASS(MaskedGatherINTEL);
    STRINGISE_ENUM_CLASS(MaskedScatterINTEL);
  }
  END_ENUM_STRINGISE();
}

namespace rdcspv
{

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const Id &el)
{
  return idName(el);
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcstr &el)
{
  return "\"" + el + "\"";
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const PairIdRefLiteralInteger &el)
{
  return StringFormat::Fmt("[%s, %u]", idName(el.first).c_str(), el.second);
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const PairIdRefIdRef &el)
{
  return StringFormat::Fmt("[%s, %s]", idName(el.first).c_str(), idName(el.second).c_str());
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcspv::ImageOperandsAndParamDatas &el)
{
  rdcstr ret;
  
  if(el.flags & ImageOperands::None)
    ret += "None" ", ";
  if(el.flags & ImageOperands::Bias)
    ret += "Bias" "(" + idName(el.bias) + ")" ", ";
  if(el.flags & ImageOperands::Lod)
    ret += "Lod" "(" + idName(el.lod) + ")" ", ";
  if(el.flags & ImageOperands::Grad)
    ret += "Grad" "(" + idName(el.grad.first) + ", "  + idName(el.grad.second) + ")" ", ";
  if(el.flags & ImageOperands::ConstOffset)
    ret += "ConstOffset" "(" + idName(el.constOffset) + ")" ", ";
  if(el.flags & ImageOperands::Offset)
    ret += "Offset" "(" + idName(el.offset) + ")" ", ";
  if(el.flags & ImageOperands::ConstOffsets)
    ret += "ConstOffsets" "(" + idName(el.constOffsets) + ")" ", ";
  if(el.flags & ImageOperands::Sample)
    ret += "Sample" "(" + idName(el.sample) + ")" ", ";
  if(el.flags & ImageOperands::MinLod)
    ret += "MinLod" "(" + idName(el.minLod) + ")" ", ";
  if(el.flags & ImageOperands::MakeTexelAvailable)
    ret += "MakeTexelAvailable" "(" + idName(el.makeTexelAvailable) + ")" ", ";
  if(el.flags & ImageOperands::MakeTexelVisible)
    ret += "MakeTexelVisible" "(" + idName(el.makeTexelVisible) + ")" ", ";
  if(el.flags & ImageOperands::NonPrivateTexel)
    ret += "NonPrivateTexel" ", ";
  if(el.flags & ImageOperands::VolatileTexel)
    ret += "VolatileTexel" ", ";
  if(el.flags & ImageOperands::SignExtend)
    ret += "SignExtend" ", ";
  if(el.flags & ImageOperands::ZeroExtend)
    ret += "ZeroExtend" ", ";
  if(el.flags & ImageOperands::Nontemporal)
    ret += "Nontemporal" ", ";
  if(el.flags & ImageOperands::Offsets)
    ret += "Offsets" "(" + idName(el.offsets) + ")" ", ";

  // remove trailing ", "
  if(ret.size() > 2)
    ret.erase(ret.size()-2, 2);

  return ret;
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcspv::LoopControlAndParamDatas &el)
{
  rdcstr ret;
  
  if(el.flags & LoopControl::None)
    ret += "None" ", ";
  if(el.flags & LoopControl::Unroll)
    ret += "Unroll" ", ";
  if(el.flags & LoopControl::DontUnroll)
    ret += "DontUnroll" ", ";
  if(el.flags & LoopControl::DependencyInfinite)
    ret += "DependencyInfinite" ", ";
  if(el.flags & LoopControl::DependencyLength)
    ret += "DependencyLength" "(" + ToStr(el.dependencyLength) + ")" ", ";
  if(el.flags & LoopControl::MinIterations)
    ret += "MinIterations" "(" + ToStr(el.minIterations) + ")" ", ";
  if(el.flags & LoopControl::MaxIterations)
    ret += "MaxIterations" "(" + ToStr(el.maxIterations) + ")" ", ";
  if(el.flags & LoopControl::IterationMultiple)
    ret += "IterationMultiple" "(" + ToStr(el.iterationMultiple) + ")" ", ";
  if(el.flags & LoopControl::PeelCount)
    ret += "PeelCount" "(" + ToStr(el.peelCount) + ")" ", ";
  if(el.flags & LoopControl::PartialCount)
    ret += "PartialCount" "(" + ToStr(el.partialCount) + ")" ", ";
  if(el.flags & LoopControl::InitiationIntervalINTEL)
    ret += "InitiationIntervalINTEL" "(" + ToStr(el.initiationIntervalINTEL) + ")" ", ";
  if(el.flags & LoopControl::MaxConcurrencyINTEL)
    ret += "MaxConcurrencyINTEL" "(" + ToStr(el.maxConcurrencyINTEL) + ")" ", ";
  if(el.flags & LoopControl::DependencyArrayINTEL)
    ret += "DependencyArrayINTEL" "(" + ToStr(el.dependencyArrayINTEL) + ")" ", ";
  if(el.flags & LoopControl::PipelineEnableINTEL)
    ret += "PipelineEnableINTEL" "(" + ToStr(el.pipelineEnableINTEL) + ")" ", ";
  if(el.flags & LoopControl::LoopCoalesceINTEL)
    ret += "LoopCoalesceINTEL" "(" + ToStr(el.loopCoalesceINTEL) + ")" ", ";
  if(el.flags & LoopControl::MaxInterleavingINTEL)
    ret += "MaxInterleavingINTEL" "(" + ToStr(el.maxInterleavingINTEL) + ")" ", ";
  if(el.flags & LoopControl::SpeculatedIterationsINTEL)
    ret += "SpeculatedIterationsINTEL" "(" + ToStr(el.speculatedIterationsINTEL) + ")" ", ";
  if(el.flags & LoopControl::NoFusionINTEL)
    ret += "NoFusionINTEL" ", ";
  if(el.flags & LoopControl::LoopCountINTEL)
    ret += "LoopCountINTEL" "(" + ToStr(el.loopCountINTEL) + ")" ", ";
  if(el.flags & LoopControl::MaxReinvocationDelayINTEL)
    ret += "MaxReinvocationDelayINTEL" "(" + ToStr(el.maxReinvocationDelayINTEL) + ")" ", ";

  // remove trailing ", "
  if(ret.size() > 2)
    ret.erase(ret.size()-2, 2);

  return ret;
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcspv::MemoryAccessAndParamDatas &el)
{
  rdcstr ret;
  
  if(el.flags & MemoryAccess::None)
    ret += "None" ", ";
  if(el.flags & MemoryAccess::Volatile)
    ret += "Volatile" ", ";
  if(el.flags & MemoryAccess::Aligned)
    ret += "Aligned" "(" + ToStr(el.aligned) + ")" ", ";
  if(el.flags & MemoryAccess::Nontemporal)
    ret += "Nontemporal" ", ";
  if(el.flags & MemoryAccess::MakePointerAvailable)
    ret += "MakePointerAvailable" "(" + idName(el.makePointerAvailable) + ")" ", ";
  if(el.flags & MemoryAccess::MakePointerVisible)
    ret += "MakePointerVisible" "(" + idName(el.makePointerVisible) + ")" ", ";
  if(el.flags & MemoryAccess::NonPrivatePointer)
    ret += "NonPrivatePointer" ", ";
  if(el.flags & MemoryAccess::AliasScopeINTELMask)
    ret += "AliasScopeINTELMask" "(" + idName(el.aliasScopeINTELMask) + ")" ", ";
  if(el.flags & MemoryAccess::NoAliasINTELMask)
    ret += "NoAliasINTELMask" "(" + idName(el.noAliasINTELMask) + ")" ", ";

  // remove trailing ", "
  if(ret.size() > 2)
    ret.erase(ret.size()-2, 2);

  return ret;
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcspv::ExecutionModeAndParamData &el)
{
  rdcstr ret = ToStr(el.value);

  switch(el.value)
  {
    case ExecutionMode::Invocations:
      ret +=  "(" + ToStr(el.invocations) + ")"; break;
    case ExecutionMode::LocalSize:
      ret +=  "(" + ToStr(el.localSize.xsize) + ", "  + ToStr(el.localSize.ysize) + ", "  + ToStr(el.localSize.zsize) + ")"; break;
    case ExecutionMode::LocalSizeHint:
      ret +=  "(" + ToStr(el.localSizeHint.xsize) + ", "  + ToStr(el.localSizeHint.ysize) + ", "  + ToStr(el.localSizeHint.zsize) + ")"; break;
    case ExecutionMode::OutputVertices:
      ret +=  "(" + ToStr(el.outputVertices) + ")"; break;
    case ExecutionMode::VecTypeHint:
      ret +=  "(" + ToStr(el.vecTypeHint) + ")"; break;
    case ExecutionMode::SubgroupSize:
      ret +=  "(" + ToStr(el.subgroupSize) + ")"; break;
    case ExecutionMode::SubgroupsPerWorkgroup:
      ret +=  "(" + ToStr(el.subgroupsPerWorkgroup) + ")"; break;
    case ExecutionMode::SubgroupsPerWorkgroupId:
      ret +=  "(" + idName(el.subgroupsPerWorkgroupId) + ")"; break;
    case ExecutionMode::LocalSizeId:
      ret +=  "(" + idName(el.localSizeId.xsize) + ", "  + idName(el.localSizeId.ysize) + ", "  + idName(el.localSizeId.zsize) + ")"; break;
    case ExecutionMode::LocalSizeHintId:
      ret +=  "(" + idName(el.localSizeHintId.xsizehint) + ", "  + idName(el.localSizeHintId.ysizehint) + ", "  + idName(el.localSizeHintId.zsizehint) + ")"; break;
    case ExecutionMode::DenormPreserve:
      ret +=  "(" + ToStr(el.denormPreserve) + ")"; break;
    case ExecutionMode::DenormFlushToZero:
      ret +=  "(" + ToStr(el.denormFlushToZero) + ")"; break;
    case ExecutionMode::SignedZeroInfNanPreserve:
      ret +=  "(" + ToStr(el.signedZeroInfNanPreserve) + ")"; break;
    case ExecutionMode::RoundingModeRTE:
      ret +=  "(" + ToStr(el.roundingModeRTE) + ")"; break;
    case ExecutionMode::RoundingModeRTZ:
      ret +=  "(" + ToStr(el.roundingModeRTZ) + ")"; break;
    case ExecutionMode::MaxNodeRecursionAMDX:
      ret +=  "(" + idName(el.maxNodeRecursionAMDX) + ")"; break;
    case ExecutionMode::StaticNumWorkgroupsAMDX:
      ret +=  "(" + idName(el.staticNumWorkgroupsAMDX.xsize) + ", "  + idName(el.staticNumWorkgroupsAMDX.ysize) + ", "  + idName(el.staticNumWorkgroupsAMDX.zsize) + ")"; break;
    case ExecutionMode::ShaderIndexAMDX:
      ret +=  "(" + idName(el.shaderIndexAMDX) + ")"; break;
    case ExecutionMode::MaxNumWorkgroupsAMDX:
      ret +=  "(" + idName(el.maxNumWorkgroupsAMDX.xsize) + ", "  + idName(el.maxNumWorkgroupsAMDX.ysize) + ", "  + idName(el.maxNumWorkgroupsAMDX.zsize) + ")"; break;
    case ExecutionMode::OutputPrimitivesEXT:
      ret +=  "(" + ToStr(el.outputPrimitivesEXT) + ")"; break;
    case ExecutionMode::SharedLocalMemorySizeINTEL:
      ret +=  "(" + ToStr(el.sharedLocalMemorySizeINTEL) + ")"; break;
    case ExecutionMode::RoundingModeRTPINTEL:
      ret +=  "(" + ToStr(el.roundingModeRTPINTEL) + ")"; break;
    case ExecutionMode::RoundingModeRTNINTEL:
      ret +=  "(" + ToStr(el.roundingModeRTNINTEL) + ")"; break;
    case ExecutionMode::FloatingPointModeALTINTEL:
      ret +=  "(" + ToStr(el.floatingPointModeALTINTEL) + ")"; break;
    case ExecutionMode::FloatingPointModeIEEEINTEL:
      ret +=  "(" + ToStr(el.floatingPointModeIEEEINTEL) + ")"; break;
    case ExecutionMode::MaxWorkgroupSizeINTEL:
      ret +=  "(" + ToStr(el.maxWorkgroupSizeINTEL.max_x_size) + ", "  + ToStr(el.maxWorkgroupSizeINTEL.max_y_size) + ", "  + ToStr(el.maxWorkgroupSizeINTEL.max_z_size) + ")"; break;
    case ExecutionMode::MaxWorkDimINTEL:
      ret +=  "(" + ToStr(el.maxWorkDimINTEL) + ")"; break;
    case ExecutionMode::NumSIMDWorkitemsINTEL:
      ret +=  "(" + ToStr(el.numSIMDWorkitemsINTEL) + ")"; break;
    case ExecutionMode::SchedulerTargetFmaxMhzINTEL:
      ret +=  "(" + ToStr(el.schedulerTargetFmaxMhzINTEL) + ")"; break;
    case ExecutionMode::FPFastMathDefault:
      ret +=  "(" + idName(el.fPFastMathDefault.targetType) + ", "  + idName(el.fPFastMathDefault.fastMathMode) + ")"; break;
    case ExecutionMode::StreamingInterfaceINTEL:
      ret +=  "(" + ToStr(el.streamingInterfaceINTEL) + ")"; break;
    case ExecutionMode::RegisterMapInterfaceINTEL:
      ret +=  "(" + ToStr(el.registerMapInterfaceINTEL) + ")"; break;
    case ExecutionMode::NamedBarrierCountINTEL:
      ret +=  "(" + ToStr(el.namedBarrierCountINTEL) + ")"; break;
    case ExecutionMode::MaximumRegistersINTEL:
      ret +=  "(" + ToStr(el.maximumRegistersINTEL) + ")"; break;
    case ExecutionMode::MaximumRegistersIdINTEL:
      ret +=  "(" + idName(el.maximumRegistersIdINTEL) + ")"; break;
    case ExecutionMode::NamedMaximumRegistersINTEL:
      ret +=  "(" + ToStr(el.namedMaximumRegistersINTEL) + ")"; break;
    default:
      break;
  }

  return ret;
}

template<>
rdcstr ParamToStr(const std::function<rdcstr(rdcspv::Id)> &idName, const rdcspv::DecorationAndParamData &el)
{
  rdcstr ret = ToStr(el.value);

  switch(el.value)
  {
    case Decoration::SpecId:
      ret +=  "(" + ToStr(el.specId) + ")"; break;
    case Decoration::ArrayStride:
      ret +=  "(" + ToStr(el.arrayStride) + ")"; break;
    case Decoration::MatrixStride:
      ret +=  "(" + ToStr(el.matrixStride) + ")"; break;
    case Decoration::BuiltIn:
      ret +=  "(" + ToStr(el.builtIn) + ")"; break;
    case Decoration::UniformId:
      ret +=  "(" + idName(el.uniformId) + ")"; break;
    case Decoration::Stream:
      ret +=  "(" + ToStr(el.stream) + ")"; break;
    case Decoration::Location:
      ret +=  "(" + ToStr(el.location) + ")"; break;
    case Decoration::Component:
      ret +=  "(" + ToStr(el.component) + ")"; break;
    case Decoration::Index:
      ret +=  "(" + ToStr(el.index) + ")"; break;
    case Decoration::Binding:
      ret +=  "(" + ToStr(el.binding) + ")"; break;
    case Decoration::DescriptorSet:
      ret +=  "(" + ToStr(el.descriptorSet) + ")"; break;
    case Decoration::Offset:
      ret +=  "(" + ToStr(el.offset) + ")"; break;
    case Decoration::XfbBuffer:
      ret +=  "(" + ToStr(el.xfbBuffer) + ")"; break;
    case Decoration::XfbStride:
      ret +=  "(" + ToStr(el.xfbStride) + ")"; break;
    case Decoration::FuncParamAttr:
      ret +=  "(" + ToStr(el.funcParamAttr) + ")"; break;
    case Decoration::FPRoundingMode:
      ret +=  "(" + ToStr(el.fPRoundingMode) + ")"; break;
    case Decoration::FPFastMathMode:
      ret +=  "(" + ToStr(el.fPFastMathMode) + ")"; break;
    case Decoration::InputAttachmentIndex:
      ret +=  "(" + ToStr(el.inputAttachmentIndex) + ")"; break;
    case Decoration::Alignment:
      ret +=  "(" + ToStr(el.alignment) + ")"; break;
    case Decoration::MaxByteOffset:
      ret +=  "(" + ToStr(el.maxByteOffset) + ")"; break;
    case Decoration::AlignmentId:
      ret +=  "(" + idName(el.alignmentId) + ")"; break;
    case Decoration::MaxByteOffsetId:
      ret +=  "(" + idName(el.maxByteOffsetId) + ")"; break;
    case Decoration::NodeSharesPayloadLimitsWithAMDX:
      ret +=  "(" + idName(el.nodeSharesPayloadLimitsWithAMDX) + ")"; break;
    case Decoration::NodeMaxPayloadsAMDX:
      ret +=  "(" + idName(el.nodeMaxPayloadsAMDX) + ")"; break;
    case Decoration::SecondaryViewportRelativeNV:
      ret +=  "(" + ToStr(el.secondaryViewportRelativeNV) + ")"; break;
    case Decoration::SIMTCallINTEL:
      ret +=  "(" + ToStr(el.sIMTCallINTEL) + ")"; break;
    case Decoration::FuncParamIOKindINTEL:
      ret +=  "(" + ToStr(el.funcParamIOKindINTEL) + ")"; break;
    case Decoration::GlobalVariableOffsetINTEL:
      ret +=  "(" + ToStr(el.globalVariableOffsetINTEL) + ")"; break;
    case Decoration::CounterBuffer:
      ret +=  "(" + idName(el.counterBuffer) + ")"; break;
    case Decoration::FunctionRoundingModeINTEL:
      ret +=  "(" + ToStr(el.functionRoundingModeINTEL.targetWidth) + ", "  + ToStr(el.functionRoundingModeINTEL.fPRoundingMode) + ")"; break;
    case Decoration::FunctionDenormModeINTEL:
      ret +=  "(" + ToStr(el.functionDenormModeINTEL.targetWidth) + ", "  + ToStr(el.functionDenormModeINTEL.fPDenormMode) + ")"; break;
    case Decoration::NumbanksINTEL:
      ret +=  "(" + ToStr(el.numbanksINTEL) + ")"; break;
    case Decoration::BankwidthINTEL:
      ret +=  "(" + ToStr(el.bankwidthINTEL) + ")"; break;
    case Decoration::MaxPrivateCopiesINTEL:
      ret +=  "(" + ToStr(el.maxPrivateCopiesINTEL) + ")"; break;
    case Decoration::MaxReplicatesINTEL:
      ret +=  "(" + ToStr(el.maxReplicatesINTEL) + ")"; break;
    case Decoration::BankBitsINTEL:
      ret +=  "(" + ToStr(el.bankBitsINTEL) + ")"; break;
    case Decoration::ForcePow2DepthINTEL:
      ret +=  "(" + ToStr(el.forcePow2DepthINTEL) + ")"; break;
    case Decoration::StridesizeINTEL:
      ret +=  "(" + ToStr(el.stridesizeINTEL) + ")"; break;
    case Decoration::WordsizeINTEL:
      ret +=  "(" + ToStr(el.wordsizeINTEL) + ")"; break;
    case Decoration::CacheSizeINTEL:
      ret +=  "(" + ToStr(el.cacheSizeINTEL) + ")"; break;
    case Decoration::PrefetchINTEL:
      ret +=  "(" + ToStr(el.prefetchINTEL) + ")"; break;
    case Decoration::MathOpDSPModeINTEL:
      ret +=  "(" + ToStr(el.mathOpDSPModeINTEL.mode) + ", "  + ToStr(el.mathOpDSPModeINTEL.propagate) + ")"; break;
    case Decoration::AliasScopeINTEL:
      ret +=  "(" + idName(el.aliasScopeINTEL) + ")"; break;
    case Decoration::NoAliasINTEL:
      ret +=  "(" + idName(el.noAliasINTEL) + ")"; break;
    case Decoration::InitiationIntervalINTEL:
      ret +=  "(" + ToStr(el.initiationIntervalINTEL) + ")"; break;
    case Decoration::MaxConcurrencyINTEL:
      ret +=  "(" + ToStr(el.maxConcurrencyINTEL) + ")"; break;
    case Decoration::PipelineEnableINTEL:
      ret +=  "(" + ToStr(el.pipelineEnableINTEL) + ")"; break;
    case Decoration::BufferLocationINTEL:
      ret +=  "(" + ToStr(el.bufferLocationINTEL) + ")"; break;
    case Decoration::IOPipeStorageINTEL:
      ret +=  "(" + ToStr(el.iOPipeStorageINTEL) + ")"; break;
    case Decoration::FunctionFloatingPointModeINTEL:
      ret +=  "(" + ToStr(el.functionFloatingPointModeINTEL.targetWidth) + ", "  + ToStr(el.functionFloatingPointModeINTEL.fPOperationMode) + ")"; break;
    case Decoration::FPMaxErrorDecorationINTEL:
      ret +=  "(" + ToStr(el.fPMaxErrorDecorationINTEL) + ")"; break;
    case Decoration::LatencyControlLabelINTEL:
      ret +=  "(" + ToStr(el.latencyControlLabelINTEL) + ")"; break;
    case Decoration::LatencyControlConstraintINTEL:
      ret +=  "(" + ToStr(el.latencyControlConstraintINTEL.relativeTo) + ", "  + ToStr(el.latencyControlConstraintINTEL.controlType) + ", "  + ToStr(el.latencyControlConstraintINTEL.relativeCycle) + ")"; break;
    case Decoration::MMHostInterfaceAddressWidthINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceAddressWidthINTEL) + ")"; break;
    case Decoration::MMHostInterfaceDataWidthINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceDataWidthINTEL) + ")"; break;
    case Decoration::MMHostInterfaceLatencyINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceLatencyINTEL) + ")"; break;
    case Decoration::MMHostInterfaceReadWriteModeINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceReadWriteModeINTEL) + ")"; break;
    case Decoration::MMHostInterfaceMaxBurstINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceMaxBurstINTEL) + ")"; break;
    case Decoration::MMHostInterfaceWaitRequestINTEL:
      ret +=  "(" + ToStr(el.mMHostInterfaceWaitRequestINTEL) + ")"; break;
    case Decoration::InitModeINTEL:
      ret +=  "(" + ToStr(el.initModeINTEL) + ")"; break;
    case Decoration::ImplementInRegisterMapINTEL:
      ret +=  "(" + ToStr(el.implementInRegisterMapINTEL) + ")"; break;
    case Decoration::CacheControlLoadINTEL:
      ret +=  "(" + ToStr(el.cacheControlLoadINTEL.cacheLevel) + ", "  + ToStr(el.cacheControlLoadINTEL.cacheControl) + ")"; break;
    case Decoration::CacheControlStoreINTEL:
      ret +=  "(" + ToStr(el.cacheControlStoreINTEL.cacheLevel) + ", "  + ToStr(el.cacheControlStoreINTEL.cacheControl) + ")"; break;
    default:
      break;
  }

  return ret;
}

void OpDecoder::ForEachID(const ConstIter &it, const std::function<void(Id,bool)> &callback)
{
  if (rdcspv::ManualForEachID(it, callback))
    return;
  size_t size = it.size();
  uint32_t word = 0;
  (void)word;
  switch(it.opcode())
  {
    case rdcspv::Op::Nop:
      break;
    case rdcspv::Op::Undef:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::SourceContinued:
      break;
    case rdcspv::Op::Source:
      if(3 < size) callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SourceExtension:
      break;
    case rdcspv::Op::Name:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::MemberName:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::String:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::Line:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::Extension:
      break;
    case rdcspv::Op::ExtInstImport:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::ExtInst:
      break;
    case rdcspv::Op::MemoryModel:
      break;
    case rdcspv::Op::EntryPoint:
      callback(Id::fromWord(it.word(2)), false);
      word = 3;
      (void)DecodeParam<rdcstr>(it, word);
      for(; word < size; word++) callback(Id::fromWord(it.word(word)), false);
      break;
    case rdcspv::Op::ExecutionMode:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::Capability:
      break;
    case rdcspv::Op::TypeVoid:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeBool:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeInt:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeFloat:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeVector:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeMatrix:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeImage:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeSampler:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeSampledImage:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeArray:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::TypeRuntimeArray:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeStruct:
      callback(Id::fromWord(it.word(1)), true);
      for(size_t i=0; i < size-2; i++) callback(Id::fromWord(it.word(2+i)), false);
      break;
    case rdcspv::Op::TypeOpaque:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypePointer:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::TypeFunction:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      for(size_t i=0; i < size-3; i++) callback(Id::fromWord(it.word(3+i)), false);
      break;
    case rdcspv::Op::TypeEvent:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeDeviceEvent:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeReserveId:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeQueue:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypePipe:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeForwardPointer:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::ConstantTrue:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::ConstantFalse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::Constant:
      break;
    case rdcspv::Op::ConstantComposite:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      for(size_t i=0; i < size-3; i++) callback(Id::fromWord(it.word(3+i)), false);
      break;
    case rdcspv::Op::ConstantSampler:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::ConstantNull:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::SpecConstantTrue:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::SpecConstantFalse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::SpecConstant:
      break;
    case rdcspv::Op::SpecConstantComposite:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      for(size_t i=0; i < size-3; i++) callback(Id::fromWord(it.word(3+i)), false);
      break;
    case rdcspv::Op::SpecConstantOp:
      break;
    case rdcspv::Op::Function:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FunctionParameter:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::FunctionEnd:
      break;
    case rdcspv::Op::FunctionCall:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      for(size_t i=0; i < size-4; i++) callback(Id::fromWord(it.word(4+i)), false);
      break;
    case rdcspv::Op::Variable:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      if(4 < size) callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageTexelPointer:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::Load:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Store:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::CopyMemory:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::CopyMemorySized:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::AccessChain:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      for(size_t i=0; i < size-4; i++) callback(Id::fromWord(it.word(4+i)), false);
      break;
    case rdcspv::Op::InBoundsAccessChain:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      for(size_t i=0; i < size-4; i++) callback(Id::fromWord(it.word(4+i)), false);
      break;
    case rdcspv::Op::PtrAccessChain:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      for(size_t i=0; i < size-5; i++) callback(Id::fromWord(it.word(5+i)), false);
      break;
    case rdcspv::Op::ArrayLength:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GenericPtrMemSemantics:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::InBoundsPtrAccessChain:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      for(size_t i=0; i < size-5; i++) callback(Id::fromWord(it.word(5+i)), false);
      break;
    case rdcspv::Op::Decorate:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::MemberDecorate:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::DecorationGroup:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::GroupDecorate:
      callback(Id::fromWord(it.word(1)), false);
      for(size_t i=0; i < size-2; i++) callback(Id::fromWord(it.word(2+i)), false);
      break;
    case rdcspv::Op::GroupMemberDecorate:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::VectorExtractDynamic:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::VectorInsertDynamic:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::VectorShuffle:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::CompositeConstruct:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      for(size_t i=0; i < size-3; i++) callback(Id::fromWord(it.word(3+i)), false);
      break;
    case rdcspv::Op::CompositeExtract:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::CompositeInsert:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::CopyObject:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Transpose:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SampledImage:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleDrefImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSampleDrefExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSampleProjImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleProjExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleProjDrefImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSampleProjDrefExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageFetch:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageGather:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageDrefGather:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageRead:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageWrite:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Image:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageQueryFormat:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageQueryOrder:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageQuerySizeLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageQuerySize:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageQueryLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageQueryLevels:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageQuerySamples:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertFToU:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertFToS:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertSToF:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertUToF:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::UConvert:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SConvert:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::FConvert:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::QuantizeToF16:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertPtrToU:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SatConvertSToU:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SatConvertUToS:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertUToPtr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::PtrCastToGeneric:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GenericCastToPtr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GenericCastToPtrExplicit:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Bitcast:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SNegate:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::FNegate:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ISub:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FSub:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IMul:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FMul:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UDiv:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SDiv:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FDiv:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UMod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SRem:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SMod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FRem:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FMod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::VectorTimesScalar:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::MatrixTimesScalar:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::VectorTimesMatrix:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::MatrixTimesVector:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::MatrixTimesMatrix:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::OuterProduct:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::Dot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IAddCarry:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ISubBorrow:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UMulExtended:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SMulExtended:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::Any:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::All:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IsNan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IsInf:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IsFinite:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IsNormal:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SignBitSet:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::LessOrGreater:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::Ordered:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::Unordered:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::LogicalEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::LogicalNotEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::LogicalOr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::LogicalAnd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::LogicalNot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Select:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::IEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::INotEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UGreaterThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SGreaterThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UGreaterThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SGreaterThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ULessThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SLessThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ULessThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SLessThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdNotEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordNotEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdLessThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordLessThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdGreaterThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordGreaterThan:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdLessThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordLessThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FOrdGreaterThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FUnordGreaterThanEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ShiftRightLogical:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ShiftRightArithmetic:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ShiftLeftLogical:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::BitwiseOr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::BitwiseXor:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::BitwiseAnd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::Not:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::BitFieldInsert:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::BitFieldSExtract:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::BitFieldUExtract:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::BitReverse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::BitCount:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdx:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdy:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Fwidth:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdxFine:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdyFine:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::FwidthFine:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdxCoarse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::DPdyCoarse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::FwidthCoarse:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::EmitVertex:
      break;
    case rdcspv::Op::EndPrimitive:
      break;
    case rdcspv::Op::EmitStreamVertex:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::EndStreamPrimitive:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::ControlBarrier:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::MemoryBarrier:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::AtomicLoad:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::AtomicStore:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::AtomicExchange:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicCompareExchange:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::AtomicCompareExchangeWeak:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::AtomicIIncrement:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::AtomicIDecrement:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::AtomicIAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicISub:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicSMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicUMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicSMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicUMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicAnd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicOr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicXor:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::Phi:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::LoopMerge:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::SelectionMerge:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::Label:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::Branch:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::BranchConditional:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::Switch:
      break;
    case rdcspv::Op::Kill:
      break;
    case rdcspv::Op::Return:
      break;
    case rdcspv::Op::ReturnValue:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::Unreachable:
      break;
    case rdcspv::Op::LifetimeStart:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::LifetimeStop:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::GroupAsyncCopy:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::GroupWaitEvents:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GroupAll:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupAny:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupBroadcast:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupIAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupUMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupSMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupUMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupSMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ReadPipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::WritePipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::ReservedReadPipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::ReservedWritePipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::ReserveReadPipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::ReserveWritePipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::CommitReadPipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::CommitWritePipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IsValidReserveId:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GetNumPipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GetMaxPipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupReserveReadPipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GroupReserveWritePipePackets:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GroupCommitReadPipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupCommitWritePipe:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::EnqueueMarker:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::EnqueueKernel:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      for(size_t i=0; i < size-13; i++) callback(Id::fromWord(it.word(13+i)), false);
      break;
    case rdcspv::Op::GetKernelNDrangeSubGroupCount:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GetKernelNDrangeMaxSubGroupSize:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GetKernelWorkGroupSize:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GetKernelPreferredWorkGroupSizeMultiple:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::RetainEvent:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::ReleaseEvent:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::CreateUserEvent:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::IsValidEvent:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SetUserEventStatus:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::CaptureEventProfilingInfo:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GetDefaultQueue:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::BuildNDRange:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseSampleImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSparseSampleExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSparseSampleDrefImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseSampleDrefExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseSampleProjImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSparseSampleProjExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSparseSampleProjDrefImplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseSampleProjDrefExplicitLod:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseFetch:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSparseGather:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseDrefGather:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageSparseTexelsResident:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::NoLine:
      break;
    case rdcspv::Op::AtomicFlagTestAndSet:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::AtomicFlagClear:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ImageSparseRead:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SizeOf:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::TypePipeStorage:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::ConstantPipeStorage:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::CreatePipeFromPipeStorage:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GetKernelLocalSizeForSubgroupCount:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GetKernelMaxNumSubgroups:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::TypeNamedBarrier:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::NamedBarrierInitialize:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::MemoryNamedBarrier:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ModuleProcessed:
      break;
    case rdcspv::Op::ExecutionModeId:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::DecorateId:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::GroupNonUniformElect:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GroupNonUniformAll:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformAny:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformAllEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformBroadcast:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformBroadcastFirst:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformBallot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformInverseBallot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformBallotBitExtract:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformBallotBitCount:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformBallotFindLSB:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformBallotFindMSB:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformShuffle:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformShuffleXor:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformShuffleUp:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformShuffleDown:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformIAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformFAdd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformIMul:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformFMul:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformSMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformUMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformFMin:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformSMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformUMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformFMax:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformBitwiseAnd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformBitwiseOr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformBitwiseXor:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformLogicalAnd:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformLogicalOr:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformLogicalXor:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::GroupNonUniformQuadBroadcast:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupNonUniformQuadSwap:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CopyLogical:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::PtrEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::PtrNotEqual:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::PtrDiff:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ColorAttachmentReadEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      if(4 < size) callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::DepthAttachmentReadEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      if(3 < size) callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::StencilAttachmentReadEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      if(3 < size) callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::TerminateInvocation:
      break;
    case rdcspv::Op::SubgroupBallotKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupFirstInvocationKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupAllKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupAnyKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupAllEqualKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GroupNonUniformRotateKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      if(6 < size) callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::SubgroupReadInvocationKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ExtInstWithForwardRefsKHR:
      break;
    case rdcspv::Op::TraceRayKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      break;
    case rdcspv::Op::ExecuteCallableKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::ConvertUToAccelerationStructureKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::IgnoreIntersectionKHR:
      break;
    case rdcspv::Op::TerminateRayKHR:
      break;
    case rdcspv::Op::SDot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UDot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SUDot:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SDotAccSat:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::UDotAccSat:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::SUDotAccSat:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::TypeCooperativeMatrixKHR:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::CooperativeMatrixLoadKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      if(5 < size) callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CooperativeMatrixStoreKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      if(4 < size) callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::CooperativeMatrixMulAddKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CooperativeMatrixLengthKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConstantCompositeReplicateEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SpecConstantCompositeReplicateEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::CompositeConstructReplicateEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::TypeRayQueryKHR:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::RayQueryInitializeKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      break;
    case rdcspv::Op::RayQueryTerminateKHR:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::RayQueryGenerateIntersectionKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::RayQueryConfirmIntersectionKHR:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::RayQueryProceedKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionTypeKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ImageSampleWeightedQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageBoxFilterQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ImageBlockMatchSSDQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ImageBlockMatchSADQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ImageBlockMatchWindowSSDQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ImageBlockMatchWindowSADQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ImageBlockMatchGatherSSDQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ImageBlockMatchGatherSADQCOM:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::GroupIAddNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFAddNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFMinNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupUMinNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupSMinNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFMaxNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupUMaxNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupSMaxNonUniformAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::FragmentMaskFetchAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FragmentFetchAMD:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::ReadClockKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::FinalizeNodePayloadsAMDX:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::FinishWritingNodePayloadAMDX:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::InitializeNodePayloadsAMDX:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::GroupNonUniformQuadAllKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GroupNonUniformQuadAnyKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectRecordHitMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      callback(Id::fromWord(it.word(13)), false);
      callback(Id::fromWord(it.word(14)), false);
      break;
    case rdcspv::Op::HitObjectRecordHitWithIndexMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      callback(Id::fromWord(it.word(13)), false);
      break;
    case rdcspv::Op::HitObjectRecordMissMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::HitObjectGetWorldToObjectNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetObjectToWorldNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetObjectRayDirectionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetObjectRayOriginNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectTraceRayMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      callback(Id::fromWord(it.word(13)), false);
      break;
    case rdcspv::Op::HitObjectGetShaderRecordBufferHandleNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetShaderBindingTableRecordIndexNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectRecordEmptyNV:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::HitObjectTraceRayNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      break;
    case rdcspv::Op::HitObjectRecordHitNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      callback(Id::fromWord(it.word(13)), false);
      break;
    case rdcspv::Op::HitObjectRecordHitWithIndexNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      break;
    case rdcspv::Op::HitObjectRecordMissNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::HitObjectExecuteShaderNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::HitObjectGetCurrentTimeNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetAttributesNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::HitObjectGetHitKindNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetPrimitiveIndexNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetGeometryIndexNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetInstanceIdNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetInstanceCustomIndexNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetWorldRayDirectionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetWorldRayOriginNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetRayTMaxNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectGetRayTMinNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectIsEmptyNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectIsHitNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::HitObjectIsMissNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ReorderThreadWithHitObjectNV:
      callback(Id::fromWord(it.word(1)), false);
      if(2 < size) callback(Id::fromWord(it.word(2)), false);
      if(3 < size) callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ReorderThreadWithHintNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeHitObjectNV:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::ImageSampleFootprintNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::EmitMeshTasksEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      if(4 < size) callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SetMeshOutputsEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::GroupNonUniformPartitionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::WritePackedPrimitiveIndices4x8NV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::FetchMicroTriangleVertexPositionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::FetchMicroTriangleVertexBarycentricNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      break;
    case rdcspv::Op::ReportIntersectionKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IgnoreIntersectionNV:
      break;
    case rdcspv::Op::TerminateRayNV:
      break;
    case rdcspv::Op::TraceNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      break;
    case rdcspv::Op::TraceMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      break;
    case rdcspv::Op::TraceRayMotionNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      callback(Id::fromWord(it.word(7)), false);
      callback(Id::fromWord(it.word(8)), false);
      callback(Id::fromWord(it.word(9)), false);
      callback(Id::fromWord(it.word(10)), false);
      callback(Id::fromWord(it.word(11)), false);
      callback(Id::fromWord(it.word(12)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionTriangleVertexPositionsKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::TypeAccelerationStructureKHR:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::ExecuteCallableNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::TypeCooperativeMatrixNV:
      callback(Id::fromWord(it.word(1)), true);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CooperativeMatrixLoadNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CooperativeMatrixStoreNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::CooperativeMatrixMulAddNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::CooperativeMatrixLengthNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::BeginInvocationInterlockEXT:
      break;
    case rdcspv::Op::EndInvocationInterlockEXT:
      break;
    case rdcspv::Op::DemoteToHelperInvocation:
      break;
    case rdcspv::Op::IsHelperInvocationEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      break;
    case rdcspv::Op::ConvertUToImageNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertUToSamplerNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertImageToUNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertSamplerToUNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertUToSampledImageNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertSampledImageToUNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SamplerImageAddressingModeNV:
      break;
    case rdcspv::Op::RawAccessChainNV:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::SubgroupShuffleINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SubgroupShuffleDownINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::SubgroupShuffleUpINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::SubgroupShuffleXorINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SubgroupBlockReadINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupBlockWriteINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      break;
    case rdcspv::Op::SubgroupImageBlockReadINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::SubgroupImageBlockWriteINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::SubgroupImageMediaBlockReadINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::SubgroupImageMediaBlockWriteINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::UCountLeadingZerosINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::UCountTrailingZerosINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::AbsISubINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::AbsUSubINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IAddSatINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UAddSatINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IAverageINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UAverageINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IAverageRoundedINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UAverageRoundedINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::ISubSatINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::USubSatINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::IMul32x16INTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::UMul32x16INTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::AtomicFMinEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AtomicFMaxEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::AssumeTrueKHR:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::ExpectKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::DecorateString:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::MemberDecorateString:
      callback(Id::fromWord(it.word(1)), false);
      break;
    case rdcspv::Op::LoopControlINTEL:
      break;
    case rdcspv::Op::ReadPipeBlockingINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::WritePipeBlockingINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::FPGARegINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetRayTMinKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetRayFlagsKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionTKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceCustomIndexKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceIdKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionGeometryIndexKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionPrimitiveIndexKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionBarycentricsKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionFrontFaceKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionCandidateAABBOpaqueKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionObjectRayDirectionKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionObjectRayOriginKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetWorldRayDirectionKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetWorldRayOriginKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionObjectToWorldKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::RayQueryGetIntersectionWorldToObjectKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case rdcspv::Op::AtomicFAddEXT:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(4)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::TypeBufferSurfaceINTEL:
      callback(Id::fromWord(it.word(1)), true);
      break;
    case rdcspv::Op::TypeStructContinuedINTEL:
      for(size_t i=0; i < size-1; i++) callback(Id::fromWord(it.word(1+i)), false);
      break;
    case rdcspv::Op::ConstantCompositeContinuedINTEL:
      for(size_t i=0; i < size-1; i++) callback(Id::fromWord(it.word(1+i)), false);
      break;
    case rdcspv::Op::SpecConstantCompositeContinuedINTEL:
      for(size_t i=0; i < size-1; i++) callback(Id::fromWord(it.word(1+i)), false);
      break;
    case rdcspv::Op::CompositeConstructContinuedINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      for(size_t i=0; i < size-3; i++) callback(Id::fromWord(it.word(3+i)), false);
      break;
    case rdcspv::Op::ConvertFToBF16INTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ConvertBF16ToFINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ControlBarrierArriveINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::ControlBarrierWaitINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(3)), false);
      break;
    case rdcspv::Op::GroupIMulKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupFMulKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupBitwiseAndKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupBitwiseOrKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupBitwiseXorKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupLogicalAndKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupLogicalOrKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::GroupLogicalXorKHR:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      break;
    case rdcspv::Op::MaskedGatherINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), true);
      callback(Id::fromWord(it.word(3)), false);
      callback(Id::fromWord(it.word(5)), false);
      callback(Id::fromWord(it.word(6)), false);
      break;
    case rdcspv::Op::MaskedScatterINTEL:
      callback(Id::fromWord(it.word(1)), false);
      callback(Id::fromWord(it.word(2)), false);
      callback(Id::fromWord(it.word(4)), false);
      break;
    case Op::Max: break;
  }
}

rdcstr OpDecoder::Disassemble(const ConstIter &it, const std::function<rdcstr(Id,Id)> &declName, const std::function<rdcstr(rdcspv::Id)> &idName, const std::function<uint32_t(Id)> &constIntVal)
{
  size_t size = it.size();
  rdcstr ret;
  switch(it.opcode())
  {
    case rdcspv::Op::Nop:
    {
      OpNop decoded(it);
      ret += rdcstr("Nop("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::Undef:
    {
      OpUndef decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Undef("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SourceContinued:
    {
      OpSourceContinued decoded(it);
      ret += rdcstr("SourceContinued("_lit)
           + ParamToStr(idName, decoded.continuedSource)
           + ")";
      break;
    }
    case rdcspv::Op::Source:
    {
      OpSource decoded(it);
      ret += rdcstr("Source("_lit)
           + ParamToStr(idName, decoded.sourceLanguage)
           + ", "
           + ParamToStr(idName, decoded.version)
           + (3 < size ? ", " + ParamToStr(idName, decoded.file) : "")
           + (4 < size ? ", " + ParamToStr(idName, decoded.source) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SourceExtension:
    {
      OpSourceExtension decoded(it);
      ret += rdcstr("SourceExtension("_lit)
           + ParamToStr(idName, decoded.extension)
           + ")";
      break;
    }
    case rdcspv::Op::Name:
    {
      OpName decoded(it);
      ret += rdcstr("Name("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.name)
           + ")";
      break;
    }
    case rdcspv::Op::MemberName:
    {
      OpMemberName decoded(it);
      ret += rdcstr("MemberName("_lit)
           + ParamToStr(idName, decoded.type)
           + ", "
           + ParamToStr(idName, decoded.member)
           + ", "
           + ParamToStr(idName, decoded.name)
           + ")";
      break;
    }
    case rdcspv::Op::String:
    {
      OpString decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("String("_lit)
           + ParamToStr(idName, decoded.string)
           + ")";
      break;
    }
    case rdcspv::Op::Line:
    {
      OpLine decoded(it);
      ret += rdcstr("Line("_lit)
           + ParamToStr(idName, decoded.file)
           + ", "
           + ParamToStr(idName, decoded.line)
           + ", "
           + ParamToStr(idName, decoded.column)
           + ")";
      break;
    }
    case rdcspv::Op::Extension:
    {
      OpExtension decoded(it);
      ret += rdcstr("Extension("_lit)
           + ParamToStr(idName, decoded.name)
           + ")";
      break;
    }
    case rdcspv::Op::ExtInstImport:
    {
      OpExtInstImport decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("ExtInstImport("_lit)
           + ParamToStr(idName, decoded.name)
           + ")";
      break;
    }
    case rdcspv::Op::ExtInst:
    {
      OpDecoder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += "ExtInst(...)";
      break;
    }
    case rdcspv::Op::MemoryModel:
    {
      OpMemoryModel decoded(it);
      ret += rdcstr("MemoryModel("_lit)
           + ParamToStr(idName, decoded.addressingModel)
           + ", "
           + ParamToStr(idName, decoded.memoryModel)
           + ")";
      break;
    }
    case rdcspv::Op::EntryPoint:
    {
      OpEntryPoint decoded(it);
      ret += rdcstr("EntryPoint("_lit)
           + ParamToStr(idName, decoded.executionModel)
           + ", "
           + ParamToStr(idName, decoded.entryPoint)
           + ", "
           + ParamToStr(idName, decoded.name)
           + ", "
           + ParamsToStr(idName, decoded.iface)
           + ")";
      break;
    }
    case rdcspv::Op::ExecutionMode:
    {
      OpExecutionMode decoded(it);
      ret += rdcstr("ExecutionMode("_lit)
           + ParamToStr(idName, decoded.entryPoint)
           + ", "
           + ParamToStr(idName, decoded.mode)
           + ")";
      break;
    }
    case rdcspv::Op::Capability:
    {
      OpCapability decoded(it);
      ret += rdcstr("Capability("_lit)
           + ParamToStr(idName, decoded.capability)
           + ")";
      break;
    }
    case rdcspv::Op::TypeVoid:
    {
      OpTypeVoid decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeVoid("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeBool:
    {
      OpTypeBool decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeBool("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeInt:
    {
      OpTypeInt decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeInt("_lit)
           + ParamToStr(idName, decoded.width)
           + ", "
           + ParamToStr(idName, decoded.signedness)
           + ")";
      break;
    }
    case rdcspv::Op::TypeFloat:
    {
      OpTypeFloat decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeFloat("_lit)
           + ParamToStr(idName, decoded.width)
           + ")";
      break;
    }
    case rdcspv::Op::TypeVector:
    {
      OpTypeVector decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeVector("_lit)
           + ParamToStr(idName, decoded.componentType)
           + ", "
           + ParamToStr(idName, decoded.componentCount)
           + ")";
      break;
    }
    case rdcspv::Op::TypeMatrix:
    {
      OpTypeMatrix decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeMatrix("_lit)
           + ParamToStr(idName, decoded.columnType)
           + ", "
           + ParamToStr(idName, decoded.columnCount)
           + ")";
      break;
    }
    case rdcspv::Op::TypeImage:
    {
      OpTypeImage decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeImage("_lit)
           + ParamToStr(idName, decoded.sampledType)
           + ", "
           + ParamToStr(idName, decoded.dim)
           + ", "
           + ParamToStr(idName, decoded.depth)
           + ", "
           + ParamToStr(idName, decoded.arrayed)
           + ", "
           + ParamToStr(idName, decoded.mS)
           + ", "
           + ParamToStr(idName, decoded.sampled)
           + ", "
           + ParamToStr(idName, decoded.imageFormat)
           + (9 < size ? ", " + ParamToStr(idName, decoded.accessQualifier) : "")
           + ")";
      break;
    }
    case rdcspv::Op::TypeSampler:
    {
      OpTypeSampler decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeSampler("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeSampledImage:
    {
      OpTypeSampledImage decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeSampledImage("_lit)
           + ParamToStr(idName, decoded.imageType)
           + ")";
      break;
    }
    case rdcspv::Op::TypeArray:
    {
      OpTypeArray decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeArray("_lit)
           + ParamToStr(idName, decoded.elementType)
           + ", "
           + ParamToStr(idName, decoded.length)
           + ")";
      break;
    }
    case rdcspv::Op::TypeRuntimeArray:
    {
      OpTypeRuntimeArray decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeRuntimeArray("_lit)
           + ParamToStr(idName, decoded.elementType)
           + ")";
      break;
    }
    case rdcspv::Op::TypeStruct:
    {
      OpTypeStruct decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeStruct("_lit)
           + ParamsToStr(idName, decoded.members)
           + ")";
      break;
    }
    case rdcspv::Op::TypeOpaque:
    {
      OpTypeOpaque decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeOpaque("_lit)
           + ParamToStr(idName, decoded.thenameoftheopaquetype)
           + ")";
      break;
    }
    case rdcspv::Op::TypePointer:
    {
      OpTypePointer decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypePointer("_lit)
           + ParamToStr(idName, decoded.storageClass)
           + ", "
           + ParamToStr(idName, decoded.type)
           + ")";
      break;
    }
    case rdcspv::Op::TypeFunction:
    {
      OpTypeFunction decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeFunction("_lit)
           + ParamToStr(idName, decoded.returnType)
           + ", "
           + ParamsToStr(idName, decoded.parameters)
           + ")";
      break;
    }
    case rdcspv::Op::TypeEvent:
    {
      OpTypeEvent decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeEvent("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeDeviceEvent:
    {
      OpTypeDeviceEvent decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeDeviceEvent("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeReserveId:
    {
      OpTypeReserveId decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeReserveId("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypeQueue:
    {
      OpTypeQueue decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeQueue("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TypePipe:
    {
      OpTypePipe decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypePipe("_lit)
           + ParamToStr(idName, decoded.qualifier)
           + ")";
      break;
    }
    case rdcspv::Op::TypeForwardPointer:
    {
      OpTypeForwardPointer decoded(it);
      ret += rdcstr("TypeForwardPointer("_lit)
           + ParamToStr(idName, decoded.pointerType)
           + ", "
           + ParamToStr(idName, decoded.storageClass)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantTrue:
    {
      OpConstantTrue decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantTrue("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantFalse:
    {
      OpConstantFalse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantFalse("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::Constant:
    {
      OpDecoder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += "Constant(...)";
      break;
    }
    case rdcspv::Op::ConstantComposite:
    {
      OpConstantComposite decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantComposite("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantSampler:
    {
      OpConstantSampler decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantSampler("_lit)
           + ParamToStr(idName, decoded.samplerAddressingMode)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.samplerFilterMode)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantNull:
    {
      OpConstantNull decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantNull("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstantTrue:
    {
      OpSpecConstantTrue decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SpecConstantTrue("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstantFalse:
    {
      OpSpecConstantFalse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SpecConstantFalse("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstant:
    {
      OpDecoder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += "SpecConstant(...)";
      break;
    }
    case rdcspv::Op::SpecConstantComposite:
    {
      OpSpecConstantComposite decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SpecConstantComposite("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstantOp:
    {
      OpDecoder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += "SpecConstantOp(...)";
      break;
    }
    case rdcspv::Op::Function:
    {
      OpFunction decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Function("_lit)
           + ParamToStr(idName, decoded.functionControl)
           + ", "
           + ParamToStr(idName, decoded.functionType)
           + ")";
      break;
    }
    case rdcspv::Op::FunctionParameter:
    {
      OpFunctionParameter decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FunctionParameter("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::FunctionEnd:
    {
      OpFunctionEnd decoded(it);
      ret += rdcstr("FunctionEnd("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::FunctionCall:
    {
      OpFunctionCall decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FunctionCall("_lit)
           + ParamToStr(idName, decoded.function)
           + ", "
           + ParamsToStr(idName, decoded.arguments)
           + ")";
      break;
    }
    case rdcspv::Op::Variable:
    {
      OpVariable decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Variable("_lit)
           + ParamToStr(idName, decoded.storageClass)
           + (4 < size ? ", " + ParamToStr(idName, decoded.initializer) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageTexelPointer:
    {
      OpImageTexelPointer decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageTexelPointer("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.sample)
           + ")";
      break;
    }
    case rdcspv::Op::Load:
    {
      OpLoad decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Load("_lit)
           + ParamToStr(idName, decoded.pointer)
           + (4 < size ? ", " + ParamToStr(idName, decoded.memoryAccess) : "")
           + ")";
      break;
    }
    case rdcspv::Op::Store:
    {
      OpStore decoded(it);
      ret += rdcstr("Store("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.object)
           + (3 < size ? ", " + ParamToStr(idName, decoded.memoryAccess) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CopyMemory:
    {
      OpCopyMemory decoded(it);
      ret += rdcstr("CopyMemory("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.source)
           + (3 < size ? ", " + ParamToStr(idName, decoded.memoryAccess0) : "")
           + (4 < size ? ", " + ParamToStr(idName, decoded.memoryAccess1) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CopyMemorySized:
    {
      OpCopyMemorySized decoded(it);
      ret += rdcstr("CopyMemorySized("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.source)
           + ", "
           + ParamToStr(idName, decoded.size)
           + (4 < size ? ", " + ParamToStr(idName, decoded.memoryAccess0) : "")
           + (5 < size ? ", " + ParamToStr(idName, decoded.memoryAccess1) : "")
           + ")";
      break;
    }
    case rdcspv::Op::AccessChain:
    {
      OpAccessChain decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AccessChain("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::InBoundsAccessChain:
    {
      OpInBoundsAccessChain decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("InBoundsAccessChain("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::PtrAccessChain:
    {
      OpPtrAccessChain decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("PtrAccessChain("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.element)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::ArrayLength:
    {
      OpArrayLength decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ArrayLength("_lit)
           + ParamToStr(idName, decoded.structure)
           + ", "
           + ParamToStr(idName, decoded.arraymember)
           + ")";
      break;
    }
    case rdcspv::Op::GenericPtrMemSemantics:
    {
      OpGenericPtrMemSemantics decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GenericPtrMemSemantics("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ")";
      break;
    }
    case rdcspv::Op::InBoundsPtrAccessChain:
    {
      OpInBoundsPtrAccessChain decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("InBoundsPtrAccessChain("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.element)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::Decorate:
    {
      OpDecorate decoded(it);
      ret += rdcstr("Decorate("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.decoration)
           + ")";
      break;
    }
    case rdcspv::Op::MemberDecorate:
    {
      OpMemberDecorate decoded(it);
      ret += rdcstr("MemberDecorate("_lit)
           + ParamToStr(idName, decoded.structureType)
           + ", "
           + ParamToStr(idName, decoded.member)
           + ", "
           + ParamToStr(idName, decoded.decoration)
           + ")";
      break;
    }
    case rdcspv::Op::DecorationGroup:
    {
      OpDecorationGroup decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("DecorationGroup("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::GroupDecorate:
    {
      OpGroupDecorate decoded(it);
      ret += rdcstr("GroupDecorate("_lit)
           + ParamToStr(idName, decoded.decorationGroup)
           + ", "
           + ParamsToStr(idName, decoded.targets)
           + ")";
      break;
    }
    case rdcspv::Op::GroupMemberDecorate:
    {
      OpGroupMemberDecorate decoded(it);
      ret += rdcstr("GroupMemberDecorate("_lit)
           + ParamToStr(idName, decoded.decorationGroup)
           + ", "
           + ParamsToStr(idName, decoded.targets)
           + ")";
      break;
    }
    case rdcspv::Op::VectorExtractDynamic:
    {
      OpVectorExtractDynamic decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("VectorExtractDynamic("_lit)
           + ParamToStr(idName, decoded.vector)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ")";
      break;
    }
    case rdcspv::Op::VectorInsertDynamic:
    {
      OpVectorInsertDynamic decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("VectorInsertDynamic("_lit)
           + ParamToStr(idName, decoded.vector)
           + ", "
           + ParamToStr(idName, decoded.component)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ")";
      break;
    }
    case rdcspv::Op::VectorShuffle:
    {
      OpVectorShuffle decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("VectorShuffle("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ", "
           + ParamsToStr(idName, decoded.components)
           + ")";
      break;
    }
    case rdcspv::Op::CompositeConstruct:
    {
      OpCompositeConstruct decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CompositeConstruct("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::CompositeExtract:
    {
      OpCompositeExtract decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CompositeExtract("_lit)
           + ParamToStr(idName, decoded.composite)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::CompositeInsert:
    {
      OpCompositeInsert decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CompositeInsert("_lit)
           + ParamToStr(idName, decoded.object)
           + ", "
           + ParamToStr(idName, decoded.composite)
           + ", "
           + ParamsToStr(idName, decoded.indexes)
           + ")";
      break;
    }
    case rdcspv::Op::CopyObject:
    {
      OpCopyObject decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CopyObject("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::Transpose:
    {
      OpTranspose decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Transpose("_lit)
           + ParamToStr(idName, decoded.matrix)
           + ")";
      break;
    }
    case rdcspv::Op::SampledImage:
    {
      OpSampledImage decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SampledImage("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.sampler)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleImplicitLod:
    {
      OpImageSampleImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleExplicitLod:
    {
      OpImageSampleExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleDrefImplicitLod:
    {
      OpImageSampleDrefImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleDrefImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleDrefExplicitLod:
    {
      OpImageSampleDrefExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleDrefExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleProjImplicitLod:
    {
      OpImageSampleProjImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleProjImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleProjExplicitLod:
    {
      OpImageSampleProjExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleProjExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleProjDrefImplicitLod:
    {
      OpImageSampleProjDrefImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleProjDrefImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleProjDrefExplicitLod:
    {
      OpImageSampleProjDrefExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleProjDrefExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageFetch:
    {
      OpImageFetch decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageFetch("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageGather:
    {
      OpImageGather decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageGather("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.component)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageDrefGather:
    {
      OpImageDrefGather decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageDrefGather("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageRead:
    {
      OpImageRead decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageRead("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageWrite:
    {
      OpImageWrite decoded(it);
      ret += rdcstr("ImageWrite("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.texel)
           + (4 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::Image:
    {
      OpImage decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Image("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQueryFormat:
    {
      OpImageQueryFormat decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQueryFormat("_lit)
           + ParamToStr(idName, decoded.image)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQueryOrder:
    {
      OpImageQueryOrder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQueryOrder("_lit)
           + ParamToStr(idName, decoded.image)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQuerySizeLod:
    {
      OpImageQuerySizeLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQuerySizeLod("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.levelofDetail)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQuerySize:
    {
      OpImageQuerySize decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQuerySize("_lit)
           + ParamToStr(idName, decoded.image)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQueryLod:
    {
      OpImageQueryLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQueryLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQueryLevels:
    {
      OpImageQueryLevels decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQueryLevels("_lit)
           + ParamToStr(idName, decoded.image)
           + ")";
      break;
    }
    case rdcspv::Op::ImageQuerySamples:
    {
      OpImageQuerySamples decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageQuerySamples("_lit)
           + ParamToStr(idName, decoded.image)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertFToU:
    {
      OpConvertFToU decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertFToU("_lit)
           + ParamToStr(idName, decoded.floatValue)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertFToS:
    {
      OpConvertFToS decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertFToS("_lit)
           + ParamToStr(idName, decoded.floatValue)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertSToF:
    {
      OpConvertSToF decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertSToF("_lit)
           + ParamToStr(idName, decoded.signedValue)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToF:
    {
      OpConvertUToF decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToF("_lit)
           + ParamToStr(idName, decoded.unsignedValue)
           + ")";
      break;
    }
    case rdcspv::Op::UConvert:
    {
      OpUConvert decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UConvert("_lit)
           + ParamToStr(idName, decoded.unsignedValue)
           + ")";
      break;
    }
    case rdcspv::Op::SConvert:
    {
      OpSConvert decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SConvert("_lit)
           + ParamToStr(idName, decoded.signedValue)
           + ")";
      break;
    }
    case rdcspv::Op::FConvert:
    {
      OpFConvert decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FConvert("_lit)
           + ParamToStr(idName, decoded.floatValue)
           + ")";
      break;
    }
    case rdcspv::Op::QuantizeToF16:
    {
      OpQuantizeToF16 decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("QuantizeToF16("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertPtrToU:
    {
      OpConvertPtrToU decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertPtrToU("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ")";
      break;
    }
    case rdcspv::Op::SatConvertSToU:
    {
      OpSatConvertSToU decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SatConvertSToU("_lit)
           + ParamToStr(idName, decoded.signedValue)
           + ")";
      break;
    }
    case rdcspv::Op::SatConvertUToS:
    {
      OpSatConvertUToS decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SatConvertUToS("_lit)
           + ParamToStr(idName, decoded.unsignedValue)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToPtr:
    {
      OpConvertUToPtr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToPtr("_lit)
           + ParamToStr(idName, decoded.integerValue)
           + ")";
      break;
    }
    case rdcspv::Op::PtrCastToGeneric:
    {
      OpPtrCastToGeneric decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("PtrCastToGeneric("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ")";
      break;
    }
    case rdcspv::Op::GenericCastToPtr:
    {
      OpGenericCastToPtr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GenericCastToPtr("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ")";
      break;
    }
    case rdcspv::Op::GenericCastToPtrExplicit:
    {
      OpGenericCastToPtrExplicit decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GenericCastToPtrExplicit("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.storage)
           + ")";
      break;
    }
    case rdcspv::Op::Bitcast:
    {
      OpBitcast decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Bitcast("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::SNegate:
    {
      OpSNegate decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SNegate("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::FNegate:
    {
      OpFNegate decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FNegate("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::IAdd:
    {
      OpIAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IAdd("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FAdd:
    {
      OpFAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FAdd("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ISub:
    {
      OpISub decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ISub("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FSub:
    {
      OpFSub decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FSub("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::IMul:
    {
      OpIMul decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IMul("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FMul:
    {
      OpFMul decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FMul("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UDiv:
    {
      OpUDiv decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UDiv("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SDiv:
    {
      OpSDiv decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SDiv("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FDiv:
    {
      OpFDiv decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FDiv("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UMod:
    {
      OpUMod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UMod("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SRem:
    {
      OpSRem decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SRem("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SMod:
    {
      OpSMod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SMod("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FRem:
    {
      OpFRem decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FRem("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FMod:
    {
      OpFMod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FMod("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::VectorTimesScalar:
    {
      OpVectorTimesScalar decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("VectorTimesScalar("_lit)
           + ParamToStr(idName, decoded.vector)
           + ", "
           + ParamToStr(idName, decoded.scalar)
           + ")";
      break;
    }
    case rdcspv::Op::MatrixTimesScalar:
    {
      OpMatrixTimesScalar decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("MatrixTimesScalar("_lit)
           + ParamToStr(idName, decoded.matrix)
           + ", "
           + ParamToStr(idName, decoded.scalar)
           + ")";
      break;
    }
    case rdcspv::Op::VectorTimesMatrix:
    {
      OpVectorTimesMatrix decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("VectorTimesMatrix("_lit)
           + ParamToStr(idName, decoded.vector)
           + ", "
           + ParamToStr(idName, decoded.matrix)
           + ")";
      break;
    }
    case rdcspv::Op::MatrixTimesVector:
    {
      OpMatrixTimesVector decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("MatrixTimesVector("_lit)
           + ParamToStr(idName, decoded.matrix)
           + ", "
           + ParamToStr(idName, decoded.vector)
           + ")";
      break;
    }
    case rdcspv::Op::MatrixTimesMatrix:
    {
      OpMatrixTimesMatrix decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("MatrixTimesMatrix("_lit)
           + ParamToStr(idName, decoded.leftMatrix)
           + ", "
           + ParamToStr(idName, decoded.rightMatrix)
           + ")";
      break;
    }
    case rdcspv::Op::OuterProduct:
    {
      OpOuterProduct decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("OuterProduct("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ")";
      break;
    }
    case rdcspv::Op::Dot:
    {
      OpDot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Dot("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ")";
      break;
    }
    case rdcspv::Op::IAddCarry:
    {
      OpIAddCarry decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IAddCarry("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ISubBorrow:
    {
      OpISubBorrow decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ISubBorrow("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UMulExtended:
    {
      OpUMulExtended decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UMulExtended("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SMulExtended:
    {
      OpSMulExtended decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SMulExtended("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::Any:
    {
      OpAny decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Any("_lit)
           + ParamToStr(idName, decoded.vector)
           + ")";
      break;
    }
    case rdcspv::Op::All:
    {
      OpAll decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("All("_lit)
           + ParamToStr(idName, decoded.vector)
           + ")";
      break;
    }
    case rdcspv::Op::IsNan:
    {
      OpIsNan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsNan("_lit)
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::IsInf:
    {
      OpIsInf decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsInf("_lit)
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::IsFinite:
    {
      OpIsFinite decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsFinite("_lit)
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::IsNormal:
    {
      OpIsNormal decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsNormal("_lit)
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::SignBitSet:
    {
      OpSignBitSet decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SignBitSet("_lit)
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::LessOrGreater:
    {
      OpLessOrGreater decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LessOrGreater("_lit)
           + ParamToStr(idName, decoded.x)
           + ", "
           + ParamToStr(idName, decoded.y)
           + ")";
      break;
    }
    case rdcspv::Op::Ordered:
    {
      OpOrdered decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Ordered("_lit)
           + ParamToStr(idName, decoded.x)
           + ", "
           + ParamToStr(idName, decoded.y)
           + ")";
      break;
    }
    case rdcspv::Op::Unordered:
    {
      OpUnordered decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Unordered("_lit)
           + ParamToStr(idName, decoded.x)
           + ", "
           + ParamToStr(idName, decoded.y)
           + ")";
      break;
    }
    case rdcspv::Op::LogicalEqual:
    {
      OpLogicalEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LogicalEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::LogicalNotEqual:
    {
      OpLogicalNotEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LogicalNotEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::LogicalOr:
    {
      OpLogicalOr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LogicalOr("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::LogicalAnd:
    {
      OpLogicalAnd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LogicalAnd("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::LogicalNot:
    {
      OpLogicalNot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("LogicalNot("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::Select:
    {
      OpSelect decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Select("_lit)
           + ParamToStr(idName, decoded.condition)
           + ", "
           + ParamToStr(idName, decoded.object1)
           + ", "
           + ParamToStr(idName, decoded.object2)
           + ")";
      break;
    }
    case rdcspv::Op::IEqual:
    {
      OpIEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::INotEqual:
    {
      OpINotEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("INotEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UGreaterThan:
    {
      OpUGreaterThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UGreaterThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SGreaterThan:
    {
      OpSGreaterThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SGreaterThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UGreaterThanEqual:
    {
      OpUGreaterThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UGreaterThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SGreaterThanEqual:
    {
      OpSGreaterThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SGreaterThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ULessThan:
    {
      OpULessThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ULessThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SLessThan:
    {
      OpSLessThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SLessThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ULessThanEqual:
    {
      OpULessThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ULessThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::SLessThanEqual:
    {
      OpSLessThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SLessThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdEqual:
    {
      OpFOrdEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordEqual:
    {
      OpFUnordEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdNotEqual:
    {
      OpFOrdNotEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdNotEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordNotEqual:
    {
      OpFUnordNotEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordNotEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdLessThan:
    {
      OpFOrdLessThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdLessThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordLessThan:
    {
      OpFUnordLessThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordLessThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdGreaterThan:
    {
      OpFOrdGreaterThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdGreaterThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordGreaterThan:
    {
      OpFUnordGreaterThan decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordGreaterThan("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdLessThanEqual:
    {
      OpFOrdLessThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdLessThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordLessThanEqual:
    {
      OpFUnordLessThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordLessThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FOrdGreaterThanEqual:
    {
      OpFOrdGreaterThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FOrdGreaterThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::FUnordGreaterThanEqual:
    {
      OpFUnordGreaterThanEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FUnordGreaterThanEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ShiftRightLogical:
    {
      OpShiftRightLogical decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ShiftRightLogical("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.shift)
           + ")";
      break;
    }
    case rdcspv::Op::ShiftRightArithmetic:
    {
      OpShiftRightArithmetic decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ShiftRightArithmetic("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.shift)
           + ")";
      break;
    }
    case rdcspv::Op::ShiftLeftLogical:
    {
      OpShiftLeftLogical decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ShiftLeftLogical("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.shift)
           + ")";
      break;
    }
    case rdcspv::Op::BitwiseOr:
    {
      OpBitwiseOr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitwiseOr("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::BitwiseXor:
    {
      OpBitwiseXor decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitwiseXor("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::BitwiseAnd:
    {
      OpBitwiseAnd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitwiseAnd("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::Not:
    {
      OpNot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Not("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::BitFieldInsert:
    {
      OpBitFieldInsert decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitFieldInsert("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.insert)
           + ", "
           + ParamToStr(idName, decoded.offset)
           + ", "
           + ParamToStr(idName, decoded.count)
           + ")";
      break;
    }
    case rdcspv::Op::BitFieldSExtract:
    {
      OpBitFieldSExtract decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitFieldSExtract("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.offset)
           + ", "
           + ParamToStr(idName, decoded.count)
           + ")";
      break;
    }
    case rdcspv::Op::BitFieldUExtract:
    {
      OpBitFieldUExtract decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitFieldUExtract("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.offset)
           + ", "
           + ParamToStr(idName, decoded.count)
           + ")";
      break;
    }
    case rdcspv::Op::BitReverse:
    {
      OpBitReverse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitReverse("_lit)
           + ParamToStr(idName, decoded.base)
           + ")";
      break;
    }
    case rdcspv::Op::BitCount:
    {
      OpBitCount decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BitCount("_lit)
           + ParamToStr(idName, decoded.base)
           + ")";
      break;
    }
    case rdcspv::Op::DPdx:
    {
      OpDPdx decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdx("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::DPdy:
    {
      OpDPdy decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdy("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::Fwidth:
    {
      OpFwidth decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Fwidth("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::DPdxFine:
    {
      OpDPdxFine decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdxFine("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::DPdyFine:
    {
      OpDPdyFine decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdyFine("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::FwidthFine:
    {
      OpFwidthFine decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FwidthFine("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::DPdxCoarse:
    {
      OpDPdxCoarse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdxCoarse("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::DPdyCoarse:
    {
      OpDPdyCoarse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DPdyCoarse("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::FwidthCoarse:
    {
      OpFwidthCoarse decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FwidthCoarse("_lit)
           + ParamToStr(idName, decoded.p)
           + ")";
      break;
    }
    case rdcspv::Op::EmitVertex:
    {
      OpEmitVertex decoded(it);
      ret += rdcstr("EmitVertex("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::EndPrimitive:
    {
      OpEndPrimitive decoded(it);
      ret += rdcstr("EndPrimitive("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::EmitStreamVertex:
    {
      OpEmitStreamVertex decoded(it);
      ret += rdcstr("EmitStreamVertex("_lit)
           + ParamToStr(idName, decoded.stream)
           + ")";
      break;
    }
    case rdcspv::Op::EndStreamPrimitive:
    {
      OpEndStreamPrimitive decoded(it);
      ret += rdcstr("EndStreamPrimitive("_lit)
           + ParamToStr(idName, decoded.stream)
           + ")";
      break;
    }
    case rdcspv::Op::ControlBarrier:
    {
      OpControlBarrier decoded(it);
      ret += rdcstr("ControlBarrier("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::MemoryBarrier:
    {
      OpMemoryBarrier decoded(it);
      ret += rdcstr("MemoryBarrier("_lit)
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::AtomicLoad:
    {
      OpAtomicLoad decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicLoad("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::AtomicStore:
    {
      OpAtomicStore decoded(it);
      ret += rdcstr("AtomicStore("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicExchange:
    {
      OpAtomicExchange decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicExchange("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicCompareExchange:
    {
      OpAtomicCompareExchange decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicCompareExchange("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.equal)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.unequal)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.comparator)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicCompareExchangeWeak:
    {
      OpAtomicCompareExchangeWeak decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicCompareExchangeWeak("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.equal)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.unequal)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.comparator)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicIIncrement:
    {
      OpAtomicIIncrement decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicIIncrement("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::AtomicIDecrement:
    {
      OpAtomicIDecrement decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicIDecrement("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::AtomicIAdd:
    {
      OpAtomicIAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicIAdd("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicISub:
    {
      OpAtomicISub decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicISub("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicSMin:
    {
      OpAtomicSMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicSMin("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicUMin:
    {
      OpAtomicUMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicUMin("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicSMax:
    {
      OpAtomicSMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicSMax("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicUMax:
    {
      OpAtomicUMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicUMax("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicAnd:
    {
      OpAtomicAnd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicAnd("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicOr:
    {
      OpAtomicOr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicOr("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicXor:
    {
      OpAtomicXor decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicXor("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::Phi:
    {
      OpPhi decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("Phi("_lit)
           + ParamsToStr(idName, decoded.parents)
           + ")";
      break;
    }
    case rdcspv::Op::LoopMerge:
    {
      OpLoopMerge decoded(it);
      ret += rdcstr("LoopMerge("_lit)
           + ParamToStr(idName, decoded.mergeBlock)
           + ", "
           + ParamToStr(idName, decoded.continueTarget)
           + ", "
           + ParamToStr(idName, decoded.loopControl)
           + ")";
      break;
    }
    case rdcspv::Op::SelectionMerge:
    {
      OpSelectionMerge decoded(it);
      ret += rdcstr("SelectionMerge("_lit)
           + ParamToStr(idName, decoded.mergeBlock)
           + ", "
           + ParamToStr(idName, decoded.selectionControl)
           + ")";
      break;
    }
    case rdcspv::Op::Label:
    {
      OpLabel decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("Label("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::Branch:
    {
      OpBranch decoded(it);
      ret += rdcstr("Branch("_lit)
           + ParamToStr(idName, decoded.targetLabel)
           + ")";
      break;
    }
    case rdcspv::Op::BranchConditional:
    {
      OpBranchConditional decoded(it);
      ret += rdcstr("BranchConditional("_lit)
           + ParamToStr(idName, decoded.condition)
           + ", "
           + ParamToStr(idName, decoded.trueLabel)
           + ", "
           + ParamToStr(idName, decoded.falseLabel)
           + ", "
           + ParamsToStr(idName, decoded.branchweights)
           + ")";
      break;
    }
    case rdcspv::Op::Switch:
    {
      OpDecoder decoded(it);
      ret += "Switch(...)";
      break;
    }
    case rdcspv::Op::Kill:
    {
      OpKill decoded(it);
      ret += rdcstr("Kill("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::Return:
    {
      OpReturn decoded(it);
      ret += rdcstr("Return("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ReturnValue:
    {
      OpReturnValue decoded(it);
      ret += rdcstr("ReturnValue("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::Unreachable:
    {
      OpUnreachable decoded(it);
      ret += rdcstr("Unreachable("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::LifetimeStart:
    {
      OpLifetimeStart decoded(it);
      ret += rdcstr("LifetimeStart("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.size)
           + ")";
      break;
    }
    case rdcspv::Op::LifetimeStop:
    {
      OpLifetimeStop decoded(it);
      ret += rdcstr("LifetimeStop("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.size)
           + ")";
      break;
    }
    case rdcspv::Op::GroupAsyncCopy:
    {
      OpGroupAsyncCopy decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupAsyncCopy("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.destination)
           + ", "
           + ParamToStr(idName, decoded.source)
           + ", "
           + ParamToStr(idName, decoded.numElements)
           + ", "
           + ParamToStr(idName, decoded.stride)
           + ", "
           + ParamToStr(idName, decoded.event)
           + ")";
      break;
    }
    case rdcspv::Op::GroupWaitEvents:
    {
      OpGroupWaitEvents decoded(it);
      ret += rdcstr("GroupWaitEvents("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.numEvents)
           + ", "
           + ParamToStr(idName, decoded.eventsList)
           + ")";
      break;
    }
    case rdcspv::Op::GroupAll:
    {
      OpGroupAll decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupAll("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupAny:
    {
      OpGroupAny decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupAny("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupBroadcast:
    {
      OpGroupBroadcast decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupBroadcast("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.localId)
           + ")";
      break;
    }
    case rdcspv::Op::GroupIAdd:
    {
      OpGroupIAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupIAdd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFAdd:
    {
      OpGroupFAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFAdd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFMin:
    {
      OpGroupFMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupUMin:
    {
      OpGroupUMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupUMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupSMin:
    {
      OpGroupSMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupSMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFMax:
    {
      OpGroupFMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupUMax:
    {
      OpGroupUMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupUMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupSMax:
    {
      OpGroupSMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupSMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::ReadPipe:
    {
      OpReadPipe decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReadPipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::WritePipe:
    {
      OpWritePipe decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("WritePipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::ReservedReadPipe:
    {
      OpReservedReadPipe decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReservedReadPipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ", "
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::ReservedWritePipe:
    {
      OpReservedWritePipe decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReservedWritePipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ", "
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::ReserveReadPipePackets:
    {
      OpReserveReadPipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReserveReadPipePackets("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.numPackets)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::ReserveWritePipePackets:
    {
      OpReserveWritePipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReserveWritePipePackets("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.numPackets)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::CommitReadPipe:
    {
      OpCommitReadPipe decoded(it);
      ret += rdcstr("CommitReadPipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::CommitWritePipe:
    {
      OpCommitWritePipe decoded(it);
      ret += rdcstr("CommitWritePipe("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::IsValidReserveId:
    {
      OpIsValidReserveId decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsValidReserveId("_lit)
           + ParamToStr(idName, decoded.reserveId)
           + ")";
      break;
    }
    case rdcspv::Op::GetNumPipePackets:
    {
      OpGetNumPipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetNumPipePackets("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::GetMaxPipePackets:
    {
      OpGetMaxPipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetMaxPipePackets("_lit)
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::GroupReserveReadPipePackets:
    {
      OpGroupReserveReadPipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupReserveReadPipePackets("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.numPackets)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::GroupReserveWritePipePackets:
    {
      OpGroupReserveWritePipePackets decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupReserveWritePipePackets("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.numPackets)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::GroupCommitReadPipe:
    {
      OpGroupCommitReadPipe decoded(it);
      ret += rdcstr("GroupCommitReadPipe("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::GroupCommitWritePipe:
    {
      OpGroupCommitWritePipe decoded(it);
      ret += rdcstr("GroupCommitWritePipe("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.pipe)
           + ", "
           + ParamToStr(idName, decoded.reserveId)
           + ", "
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::EnqueueMarker:
    {
      OpEnqueueMarker decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("EnqueueMarker("_lit)
           + ParamToStr(idName, decoded.queue)
           + ", "
           + ParamToStr(idName, decoded.numEvents)
           + ", "
           + ParamToStr(idName, decoded.waitEvents)
           + ", "
           + ParamToStr(idName, decoded.retEvent)
           + ")";
      break;
    }
    case rdcspv::Op::EnqueueKernel:
    {
      OpEnqueueKernel decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("EnqueueKernel("_lit)
           + ParamToStr(idName, decoded.queue)
           + ", "
           + ParamToStr(idName, decoded.flags)
           + ", "
           + ParamToStr(idName, decoded.nDRange)
           + ", "
           + ParamToStr(idName, decoded.numEvents)
           + ", "
           + ParamToStr(idName, decoded.waitEvents)
           + ", "
           + ParamToStr(idName, decoded.retEvent)
           + ", "
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ", "
           + ParamsToStr(idName, decoded.localSize)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelNDrangeSubGroupCount:
    {
      OpGetKernelNDrangeSubGroupCount decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelNDrangeSubGroupCount("_lit)
           + ParamToStr(idName, decoded.nDRange)
           + ", "
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelNDrangeMaxSubGroupSize:
    {
      OpGetKernelNDrangeMaxSubGroupSize decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelNDrangeMaxSubGroupSize("_lit)
           + ParamToStr(idName, decoded.nDRange)
           + ", "
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelWorkGroupSize:
    {
      OpGetKernelWorkGroupSize decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelWorkGroupSize("_lit)
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelPreferredWorkGroupSizeMultiple:
    {
      OpGetKernelPreferredWorkGroupSizeMultiple decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelPreferredWorkGroupSizeMultiple("_lit)
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::RetainEvent:
    {
      OpRetainEvent decoded(it);
      ret += rdcstr("RetainEvent("_lit)
           + ParamToStr(idName, decoded.event)
           + ")";
      break;
    }
    case rdcspv::Op::ReleaseEvent:
    {
      OpReleaseEvent decoded(it);
      ret += rdcstr("ReleaseEvent("_lit)
           + ParamToStr(idName, decoded.event)
           + ")";
      break;
    }
    case rdcspv::Op::CreateUserEvent:
    {
      OpCreateUserEvent decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CreateUserEvent("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::IsValidEvent:
    {
      OpIsValidEvent decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsValidEvent("_lit)
           + ParamToStr(idName, decoded.event)
           + ")";
      break;
    }
    case rdcspv::Op::SetUserEventStatus:
    {
      OpSetUserEventStatus decoded(it);
      ret += rdcstr("SetUserEventStatus("_lit)
           + ParamToStr(idName, decoded.event)
           + ", "
           + ParamToStr(idName, decoded.status)
           + ")";
      break;
    }
    case rdcspv::Op::CaptureEventProfilingInfo:
    {
      OpCaptureEventProfilingInfo decoded(it);
      ret += rdcstr("CaptureEventProfilingInfo("_lit)
           + ParamToStr(idName, decoded.event)
           + ", "
           + ParamToStr(idName, decoded.profilingInfo)
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GetDefaultQueue:
    {
      OpGetDefaultQueue decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetDefaultQueue("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::BuildNDRange:
    {
      OpBuildNDRange decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("BuildNDRange("_lit)
           + ParamToStr(idName, decoded.globalWorkSize)
           + ", "
           + ParamToStr(idName, decoded.localWorkSize)
           + ", "
           + ParamToStr(idName, decoded.globalWorkOffset)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleImplicitLod:
    {
      OpImageSparseSampleImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleExplicitLod:
    {
      OpImageSparseSampleExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleDrefImplicitLod:
    {
      OpImageSparseSampleDrefImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleDrefImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleDrefExplicitLod:
    {
      OpImageSparseSampleDrefExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleDrefExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleProjImplicitLod:
    {
      OpImageSparseSampleProjImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleProjImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleProjExplicitLod:
    {
      OpImageSparseSampleProjExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleProjExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleProjDrefImplicitLod:
    {
      OpImageSparseSampleProjDrefImplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleProjDrefImplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseSampleProjDrefExplicitLod:
    {
      OpImageSparseSampleProjDrefExplicitLod decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseSampleProjDrefExplicitLod("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + ", "
           + ParamToStr(idName, decoded.imageOperands)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseFetch:
    {
      OpImageSparseFetch decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseFetch("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseGather:
    {
      OpImageSparseGather decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseGather("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.component)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseDrefGather:
    {
      OpImageSparseDrefGather decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseDrefGather("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.dref)
           + (6 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseTexelsResident:
    {
      OpImageSparseTexelsResident decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseTexelsResident("_lit)
           + ParamToStr(idName, decoded.residentCode)
           + ")";
      break;
    }
    case rdcspv::Op::NoLine:
    {
      OpNoLine decoded(it);
      ret += rdcstr("NoLine("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicFlagTestAndSet:
    {
      OpAtomicFlagTestAndSet decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicFlagTestAndSet("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::AtomicFlagClear:
    {
      OpAtomicFlagClear decoded(it);
      ret += rdcstr("AtomicFlagClear("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::ImageSparseRead:
    {
      OpImageSparseRead decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSparseRead("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + (5 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SizeOf:
    {
      OpSizeOf decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SizeOf("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ")";
      break;
    }
    case rdcspv::Op::TypePipeStorage:
    {
      OpTypePipeStorage decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypePipeStorage("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantPipeStorage:
    {
      OpConstantPipeStorage decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantPipeStorage("_lit)
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ", "
           + ParamToStr(idName, decoded.capacity)
           + ")";
      break;
    }
    case rdcspv::Op::CreatePipeFromPipeStorage:
    {
      OpCreatePipeFromPipeStorage decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CreatePipeFromPipeStorage("_lit)
           + ParamToStr(idName, decoded.pipeStorage)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelLocalSizeForSubgroupCount:
    {
      OpGetKernelLocalSizeForSubgroupCount decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelLocalSizeForSubgroupCount("_lit)
           + ParamToStr(idName, decoded.subgroupCount)
           + ", "
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::GetKernelMaxNumSubgroups:
    {
      OpGetKernelMaxNumSubgroups decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GetKernelMaxNumSubgroups("_lit)
           + ParamToStr(idName, decoded.invoke)
           + ", "
           + ParamToStr(idName, decoded.param)
           + ", "
           + ParamToStr(idName, decoded.paramSize)
           + ", "
           + ParamToStr(idName, decoded.paramAlign)
           + ")";
      break;
    }
    case rdcspv::Op::TypeNamedBarrier:
    {
      OpTypeNamedBarrier decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeNamedBarrier("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::NamedBarrierInitialize:
    {
      OpNamedBarrierInitialize decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("NamedBarrierInitialize("_lit)
           + ParamToStr(idName, decoded.subgroupCount)
           + ")";
      break;
    }
    case rdcspv::Op::MemoryNamedBarrier:
    {
      OpMemoryNamedBarrier decoded(it);
      ret += rdcstr("MemoryNamedBarrier("_lit)
           + ParamToStr(idName, decoded.namedBarrier)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::ModuleProcessed:
    {
      OpModuleProcessed decoded(it);
      ret += rdcstr("ModuleProcessed("_lit)
           + ParamToStr(idName, decoded.process)
           + ")";
      break;
    }
    case rdcspv::Op::ExecutionModeId:
    {
      OpExecutionModeId decoded(it);
      ret += rdcstr("ExecutionModeId("_lit)
           + ParamToStr(idName, decoded.entryPoint)
           + ", "
           + ParamToStr(idName, decoded.mode)
           + ")";
      break;
    }
    case rdcspv::Op::DecorateId:
    {
      OpDecorateId decoded(it);
      ret += rdcstr("DecorateId("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.decoration)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformElect:
    {
      OpGroupNonUniformElect decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformElect("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformAll:
    {
      OpGroupNonUniformAll decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformAll("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformAny:
    {
      OpGroupNonUniformAny decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformAny("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformAllEqual:
    {
      OpGroupNonUniformAllEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformAllEqual("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBroadcast:
    {
      OpGroupNonUniformBroadcast decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBroadcast("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.id)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBroadcastFirst:
    {
      OpGroupNonUniformBroadcastFirst decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBroadcastFirst("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBallot:
    {
      OpGroupNonUniformBallot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBallot("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformInverseBallot:
    {
      OpGroupNonUniformInverseBallot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformInverseBallot("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBallotBitExtract:
    {
      OpGroupNonUniformBallotBitExtract decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBallotBitExtract("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBallotBitCount:
    {
      OpGroupNonUniformBallotBitCount decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBallotBitCount("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBallotFindLSB:
    {
      OpGroupNonUniformBallotFindLSB decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBallotFindLSB("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBallotFindMSB:
    {
      OpGroupNonUniformBallotFindMSB decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBallotFindMSB("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformShuffle:
    {
      OpGroupNonUniformShuffle decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformShuffle("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.id)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformShuffleXor:
    {
      OpGroupNonUniformShuffleXor decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformShuffleXor("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.mask)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformShuffleUp:
    {
      OpGroupNonUniformShuffleUp decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformShuffleUp("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.delta)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformShuffleDown:
    {
      OpGroupNonUniformShuffleDown decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformShuffleDown("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.delta)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformIAdd:
    {
      OpGroupNonUniformIAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformIAdd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformFAdd:
    {
      OpGroupNonUniformFAdd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformFAdd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformIMul:
    {
      OpGroupNonUniformIMul decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformIMul("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformFMul:
    {
      OpGroupNonUniformFMul decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformFMul("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformSMin:
    {
      OpGroupNonUniformSMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformSMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformUMin:
    {
      OpGroupNonUniformUMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformUMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformFMin:
    {
      OpGroupNonUniformFMin decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformFMin("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformSMax:
    {
      OpGroupNonUniformSMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformSMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformUMax:
    {
      OpGroupNonUniformUMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformUMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformFMax:
    {
      OpGroupNonUniformFMax decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformFMax("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBitwiseAnd:
    {
      OpGroupNonUniformBitwiseAnd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBitwiseAnd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBitwiseOr:
    {
      OpGroupNonUniformBitwiseOr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBitwiseOr("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformBitwiseXor:
    {
      OpGroupNonUniformBitwiseXor decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformBitwiseXor("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformLogicalAnd:
    {
      OpGroupNonUniformLogicalAnd decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformLogicalAnd("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformLogicalOr:
    {
      OpGroupNonUniformLogicalOr decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformLogicalOr("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformLogicalXor:
    {
      OpGroupNonUniformLogicalXor decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformLogicalXor("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.value)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformQuadBroadcast:
    {
      OpGroupNonUniformQuadBroadcast decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformQuadBroadcast("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformQuadSwap:
    {
      OpGroupNonUniformQuadSwap decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformQuadSwap("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ")";
      break;
    }
    case rdcspv::Op::CopyLogical:
    {
      OpCopyLogical decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CopyLogical("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::PtrEqual:
    {
      OpPtrEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("PtrEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::PtrNotEqual:
    {
      OpPtrNotEqual decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("PtrNotEqual("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::PtrDiff:
    {
      OpPtrDiff decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("PtrDiff("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ColorAttachmentReadEXT:
    {
      OpColorAttachmentReadEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ColorAttachmentReadEXT("_lit)
           + ParamToStr(idName, decoded.attachment)
           + (4 < size ? ", " + ParamToStr(idName, decoded.sample) : "")
           + ")";
      break;
    }
    case rdcspv::Op::DepthAttachmentReadEXT:
    {
      OpDepthAttachmentReadEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("DepthAttachmentReadEXT("_lit)
           + (3 < size ? ", " + ParamToStr(idName, decoded.sample) : "")
           + ")";
      break;
    }
    case rdcspv::Op::StencilAttachmentReadEXT:
    {
      OpStencilAttachmentReadEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("StencilAttachmentReadEXT("_lit)
           + (3 < size ? ", " + ParamToStr(idName, decoded.sample) : "")
           + ")";
      break;
    }
    case rdcspv::Op::TerminateInvocation:
    {
      OpTerminateInvocation decoded(it);
      ret += rdcstr("TerminateInvocation("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupBallotKHR:
    {
      OpSubgroupBallotKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupBallotKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupFirstInvocationKHR:
    {
      OpSubgroupFirstInvocationKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupFirstInvocationKHR("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupAllKHR:
    {
      OpSubgroupAllKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupAllKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupAnyKHR:
    {
      OpSubgroupAnyKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupAnyKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupAllEqualKHR:
    {
      OpSubgroupAllEqualKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupAllEqualKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformRotateKHR:
    {
      OpGroupNonUniformRotateKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformRotateKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.delta)
           + (6 < size ? ", " + ParamToStr(idName, decoded.clusterSize) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupReadInvocationKHR:
    {
      OpSubgroupReadInvocationKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupReadInvocationKHR("_lit)
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.index)
           + ")";
      break;
    }
    case rdcspv::Op::ExtInstWithForwardRefsKHR:
    {
      OpDecoder decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += "ExtInstWithForwardRefsKHR(...)";
      break;
    }
    case rdcspv::Op::TraceRayKHR:
    {
      OpTraceRayKHR decoded(it);
      ret += rdcstr("TraceRayKHR("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullMask)
           + ", "
           + ParamToStr(idName, decoded.sBTOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.rayOrigin)
           + ", "
           + ParamToStr(idName, decoded.rayTmin)
           + ", "
           + ParamToStr(idName, decoded.rayDirection)
           + ", "
           + ParamToStr(idName, decoded.rayTmax)
           + ", "
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::ExecuteCallableKHR:
    {
      OpExecuteCallableKHR decoded(it);
      ret += rdcstr("ExecuteCallableKHR("_lit)
           + ParamToStr(idName, decoded.sBTIndex)
           + ", "
           + ParamToStr(idName, decoded.callableData)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToAccelerationStructureKHR:
    {
      OpConvertUToAccelerationStructureKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToAccelerationStructureKHR("_lit)
           + ParamToStr(idName, decoded.accel)
           + ")";
      break;
    }
    case rdcspv::Op::IgnoreIntersectionKHR:
    {
      OpIgnoreIntersectionKHR decoded(it);
      ret += rdcstr("IgnoreIntersectionKHR("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TerminateRayKHR:
    {
      OpTerminateRayKHR decoded(it);
      ret += rdcstr("TerminateRayKHR("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::SDot:
    {
      OpSDot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SDot("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + (5 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::UDot:
    {
      OpUDot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UDot("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + (5 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SUDot:
    {
      OpSUDot decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SUDot("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + (5 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SDotAccSat:
    {
      OpSDotAccSat decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SDotAccSat("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ", "
           + ParamToStr(idName, decoded.accumulator)
           + (6 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::UDotAccSat:
    {
      OpUDotAccSat decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UDotAccSat("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ", "
           + ParamToStr(idName, decoded.accumulator)
           + (6 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SUDotAccSat:
    {
      OpSUDotAccSat decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SUDotAccSat("_lit)
           + ParamToStr(idName, decoded.vector1)
           + ", "
           + ParamToStr(idName, decoded.vector2)
           + ", "
           + ParamToStr(idName, decoded.accumulator)
           + (6 < size ? ", " + ParamToStr(idName, decoded.packedVectorFormat) : "")
           + ")";
      break;
    }
    case rdcspv::Op::TypeCooperativeMatrixKHR:
    {
      OpTypeCooperativeMatrixKHR decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeCooperativeMatrixKHR("_lit)
           + ParamToStr(idName, decoded.componentType)
           + ", "
           + ToStr(Scope(constIntVal(decoded.scope)))
           + ", "
           + ParamToStr(idName, decoded.rows)
           + ", "
           + ParamToStr(idName, decoded.columns)
           + ", "
           + ParamToStr(idName, decoded.use)
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixLoadKHR:
    {
      OpCooperativeMatrixLoadKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixLoadKHR("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.memoryLayout)
           + (5 < size ? ", " + ParamToStr(idName, decoded.stride) : "")
           + (6 < size ? ", " + ParamToStr(idName, decoded.memoryOperand) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixStoreKHR:
    {
      OpCooperativeMatrixStoreKHR decoded(it);
      ret += rdcstr("CooperativeMatrixStoreKHR("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.object)
           + ", "
           + ParamToStr(idName, decoded.memoryLayout)
           + (4 < size ? ", " + ParamToStr(idName, decoded.stride) : "")
           + (5 < size ? ", " + ParamToStr(idName, decoded.memoryOperand) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixMulAddKHR:
    {
      OpCooperativeMatrixMulAddKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixMulAddKHR("_lit)
           + ParamToStr(idName, decoded.a)
           + ", "
           + ParamToStr(idName, decoded.b)
           + ", "
           + ParamToStr(idName, decoded.c)
           + (6 < size ? ", " + ParamToStr(idName, decoded.cooperativeMatrixOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixLengthKHR:
    {
      OpCooperativeMatrixLengthKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixLengthKHR("_lit)
           + ParamToStr(idName, decoded.type)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantCompositeReplicateEXT:
    {
      OpConstantCompositeReplicateEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConstantCompositeReplicateEXT("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstantCompositeReplicateEXT:
    {
      OpSpecConstantCompositeReplicateEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SpecConstantCompositeReplicateEXT("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::CompositeConstructReplicateEXT:
    {
      OpCompositeConstructReplicateEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CompositeConstructReplicateEXT("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::TypeRayQueryKHR:
    {
      OpTypeRayQueryKHR decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeRayQueryKHR("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryInitializeKHR:
    {
      OpRayQueryInitializeKHR decoded(it);
      ret += rdcstr("RayQueryInitializeKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullMask)
           + ", "
           + ParamToStr(idName, decoded.rayOrigin)
           + ", "
           + ParamToStr(idName, decoded.rayTMin)
           + ", "
           + ParamToStr(idName, decoded.rayDirection)
           + ", "
           + ParamToStr(idName, decoded.rayTMax)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryTerminateKHR:
    {
      OpRayQueryTerminateKHR decoded(it);
      ret += rdcstr("RayQueryTerminateKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGenerateIntersectionKHR:
    {
      OpRayQueryGenerateIntersectionKHR decoded(it);
      ret += rdcstr("RayQueryGenerateIntersectionKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.hitT)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryConfirmIntersectionKHR:
    {
      OpRayQueryConfirmIntersectionKHR decoded(it);
      ret += rdcstr("RayQueryConfirmIntersectionKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryProceedKHR:
    {
      OpRayQueryProceedKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryProceedKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionTypeKHR:
    {
      OpRayQueryGetIntersectionTypeKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionTypeKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleWeightedQCOM:
    {
      OpImageSampleWeightedQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleWeightedQCOM("_lit)
           + ParamToStr(idName, decoded.texture)
           + ", "
           + ParamToStr(idName, decoded.coordinates)
           + ", "
           + ParamToStr(idName, decoded.weights)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBoxFilterQCOM:
    {
      OpImageBoxFilterQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBoxFilterQCOM("_lit)
           + ParamToStr(idName, decoded.texture)
           + ", "
           + ParamToStr(idName, decoded.coordinates)
           + ", "
           + ParamToStr(idName, decoded.boxSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchSSDQCOM:
    {
      OpImageBlockMatchSSDQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchSSDQCOM("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.reference)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchSADQCOM:
    {
      OpImageBlockMatchSADQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchSADQCOM("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.reference)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchWindowSSDQCOM:
    {
      OpImageBlockMatchWindowSSDQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchWindowSSDQCOM("_lit)
           + ParamToStr(idName, decoded.targetSampledImage)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.referenceSampledImage)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchWindowSADQCOM:
    {
      OpImageBlockMatchWindowSADQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchWindowSADQCOM("_lit)
           + ParamToStr(idName, decoded.targetSampledImage)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.referenceSampledImage)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchGatherSSDQCOM:
    {
      OpImageBlockMatchGatherSSDQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchGatherSSDQCOM("_lit)
           + ParamToStr(idName, decoded.targetSampledImage)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.referenceSampledImage)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::ImageBlockMatchGatherSADQCOM:
    {
      OpImageBlockMatchGatherSADQCOM decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageBlockMatchGatherSADQCOM("_lit)
           + ParamToStr(idName, decoded.targetSampledImage)
           + ", "
           + ParamToStr(idName, decoded.targetCoordinates)
           + ", "
           + ParamToStr(idName, decoded.referenceSampledImage)
           + ", "
           + ParamToStr(idName, decoded.referenceCoordinates)
           + ", "
           + ParamToStr(idName, decoded.blockSize)
           + ")";
      break;
    }
    case rdcspv::Op::GroupIAddNonUniformAMD:
    {
      OpGroupIAddNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupIAddNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFAddNonUniformAMD:
    {
      OpGroupFAddNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFAddNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFMinNonUniformAMD:
    {
      OpGroupFMinNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFMinNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupUMinNonUniformAMD:
    {
      OpGroupUMinNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupUMinNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupSMinNonUniformAMD:
    {
      OpGroupSMinNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupSMinNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFMaxNonUniformAMD:
    {
      OpGroupFMaxNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFMaxNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupUMaxNonUniformAMD:
    {
      OpGroupUMaxNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupUMaxNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupSMaxNonUniformAMD:
    {
      OpGroupSMaxNonUniformAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupSMaxNonUniformAMD("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::FragmentMaskFetchAMD:
    {
      OpFragmentMaskFetchAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FragmentMaskFetchAMD("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ")";
      break;
    }
    case rdcspv::Op::FragmentFetchAMD:
    {
      OpFragmentFetchAMD decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FragmentFetchAMD("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.fragmentIndex)
           + ")";
      break;
    }
    case rdcspv::Op::ReadClockKHR:
    {
      OpReadClockKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReadClockKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.scope)))
           + ")";
      break;
    }
    case rdcspv::Op::FinalizeNodePayloadsAMDX:
    {
      OpFinalizeNodePayloadsAMDX decoded(it);
      ret += rdcstr("FinalizeNodePayloadsAMDX("_lit)
           + ParamToStr(idName, decoded.payloadArray)
           + ")";
      break;
    }
    case rdcspv::Op::FinishWritingNodePayloadAMDX:
    {
      OpFinishWritingNodePayloadAMDX decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FinishWritingNodePayloadAMDX("_lit)
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::InitializeNodePayloadsAMDX:
    {
      OpInitializeNodePayloadsAMDX decoded(it);
      ret += rdcstr("InitializeNodePayloadsAMDX("_lit)
           + ParamToStr(idName, decoded.payloadArray)
           + ", "
           + ToStr(Scope(constIntVal(decoded.visibility)))
           + ", "
           + ParamToStr(idName, decoded.payloadCount)
           + ", "
           + ParamToStr(idName, decoded.nodeIndex)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformQuadAllKHR:
    {
      OpGroupNonUniformQuadAllKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformQuadAllKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformQuadAnyKHR:
    {
      OpGroupNonUniformQuadAnyKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformQuadAnyKHR("_lit)
           + ParamToStr(idName, decoded.predicate)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordHitMotionNV:
    {
      OpHitObjectRecordHitMotionNV decoded(it);
      ret += rdcstr("HitObjectRecordHitMotionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.primitiveId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.hitKind)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordStride)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.currentTime)
           + ", "
           + ParamToStr(idName, decoded.hitObjectAttributes)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordHitWithIndexMotionNV:
    {
      OpHitObjectRecordHitWithIndexMotionNV decoded(it);
      ret += rdcstr("HitObjectRecordHitWithIndexMotionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.primitiveId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.hitKind)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.currentTime)
           + ", "
           + ParamToStr(idName, decoded.hitObjectAttributes)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordMissMotionNV:
    {
      OpHitObjectRecordMissMotionNV decoded(it);
      ret += rdcstr("HitObjectRecordMissMotionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.sBTIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.currentTime)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetWorldToObjectNV:
    {
      OpHitObjectGetWorldToObjectNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetWorldToObjectNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetObjectToWorldNV:
    {
      OpHitObjectGetObjectToWorldNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetObjectToWorldNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetObjectRayDirectionNV:
    {
      OpHitObjectGetObjectRayDirectionNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetObjectRayDirectionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetObjectRayOriginNV:
    {
      OpHitObjectGetObjectRayOriginNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetObjectRayOriginNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectTraceRayMotionNV:
    {
      OpHitObjectTraceRayMotionNV decoded(it);
      ret += rdcstr("HitObjectTraceRayMotionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullmask)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.time)
           + ", "
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetShaderRecordBufferHandleNV:
    {
      OpHitObjectGetShaderRecordBufferHandleNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetShaderRecordBufferHandleNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetShaderBindingTableRecordIndexNV:
    {
      OpHitObjectGetShaderBindingTableRecordIndexNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetShaderBindingTableRecordIndexNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordEmptyNV:
    {
      OpHitObjectRecordEmptyNV decoded(it);
      ret += rdcstr("HitObjectRecordEmptyNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectTraceRayNV:
    {
      OpHitObjectTraceRayNV decoded(it);
      ret += rdcstr("HitObjectTraceRayNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullmask)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordHitNV:
    {
      OpHitObjectRecordHitNV decoded(it);
      ret += rdcstr("HitObjectRecordHitNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.primitiveId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.hitKind)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordStride)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.hitObjectAttributes)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordHitWithIndexNV:
    {
      OpHitObjectRecordHitWithIndexNV decoded(it);
      ret += rdcstr("HitObjectRecordHitWithIndexNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.accelerationStructure)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.primitiveId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.hitKind)
           + ", "
           + ParamToStr(idName, decoded.sBTRecordIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ", "
           + ParamToStr(idName, decoded.hitObjectAttributes)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectRecordMissNV:
    {
      OpHitObjectRecordMissNV decoded(it);
      ret += rdcstr("HitObjectRecordMissNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.sBTIndex)
           + ", "
           + ParamToStr(idName, decoded.origin)
           + ", "
           + ParamToStr(idName, decoded.tMin)
           + ", "
           + ParamToStr(idName, decoded.direction)
           + ", "
           + ParamToStr(idName, decoded.tMax)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectExecuteShaderNV:
    {
      OpHitObjectExecuteShaderNV decoded(it);
      ret += rdcstr("HitObjectExecuteShaderNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetCurrentTimeNV:
    {
      OpHitObjectGetCurrentTimeNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetCurrentTimeNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetAttributesNV:
    {
      OpHitObjectGetAttributesNV decoded(it);
      ret += rdcstr("HitObjectGetAttributesNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ", "
           + ParamToStr(idName, decoded.hitObjectAttribute)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetHitKindNV:
    {
      OpHitObjectGetHitKindNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetHitKindNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetPrimitiveIndexNV:
    {
      OpHitObjectGetPrimitiveIndexNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetPrimitiveIndexNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetGeometryIndexNV:
    {
      OpHitObjectGetGeometryIndexNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetGeometryIndexNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetInstanceIdNV:
    {
      OpHitObjectGetInstanceIdNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetInstanceIdNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetInstanceCustomIndexNV:
    {
      OpHitObjectGetInstanceCustomIndexNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetInstanceCustomIndexNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetWorldRayDirectionNV:
    {
      OpHitObjectGetWorldRayDirectionNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetWorldRayDirectionNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetWorldRayOriginNV:
    {
      OpHitObjectGetWorldRayOriginNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetWorldRayOriginNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetRayTMaxNV:
    {
      OpHitObjectGetRayTMaxNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetRayTMaxNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectGetRayTMinNV:
    {
      OpHitObjectGetRayTMinNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectGetRayTMinNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectIsEmptyNV:
    {
      OpHitObjectIsEmptyNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectIsEmptyNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectIsHitNV:
    {
      OpHitObjectIsHitNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectIsHitNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::HitObjectIsMissNV:
    {
      OpHitObjectIsMissNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("HitObjectIsMissNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + ")";
      break;
    }
    case rdcspv::Op::ReorderThreadWithHitObjectNV:
    {
      OpReorderThreadWithHitObjectNV decoded(it);
      ret += rdcstr("ReorderThreadWithHitObjectNV("_lit)
           + ParamToStr(idName, decoded.hitObject)
           + (2 < size ? ", " + ParamToStr(idName, decoded.hint) : "")
           + (3 < size ? ", " + ParamToStr(idName, decoded.bits) : "")
           + ")";
      break;
    }
    case rdcspv::Op::ReorderThreadWithHintNV:
    {
      OpReorderThreadWithHintNV decoded(it);
      ret += rdcstr("ReorderThreadWithHintNV("_lit)
           + ParamToStr(idName, decoded.hint)
           + ", "
           + ParamToStr(idName, decoded.bits)
           + ")";
      break;
    }
    case rdcspv::Op::TypeHitObjectNV:
    {
      OpTypeHitObjectNV decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeHitObjectNV("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ImageSampleFootprintNV:
    {
      OpImageSampleFootprintNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ImageSampleFootprintNV("_lit)
           + ParamToStr(idName, decoded.sampledImage)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.granularity)
           + ", "
           + ParamToStr(idName, decoded.coarse)
           + (7 < size ? ", " + ParamToStr(idName, decoded.imageOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::EmitMeshTasksEXT:
    {
      OpEmitMeshTasksEXT decoded(it);
      ret += rdcstr("EmitMeshTasksEXT("_lit)
           + ParamToStr(idName, decoded.groupCountX)
           + ", "
           + ParamToStr(idName, decoded.groupCountY)
           + ", "
           + ParamToStr(idName, decoded.groupCountZ)
           + (4 < size ? ", " + ParamToStr(idName, decoded.payload) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SetMeshOutputsEXT:
    {
      OpSetMeshOutputsEXT decoded(it);
      ret += rdcstr("SetMeshOutputsEXT("_lit)
           + ParamToStr(idName, decoded.vertexCount)
           + ", "
           + ParamToStr(idName, decoded.primitiveCount)
           + ")";
      break;
    }
    case rdcspv::Op::GroupNonUniformPartitionNV:
    {
      OpGroupNonUniformPartitionNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupNonUniformPartitionNV("_lit)
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::WritePackedPrimitiveIndices4x8NV:
    {
      OpWritePackedPrimitiveIndices4x8NV decoded(it);
      ret += rdcstr("WritePackedPrimitiveIndices4x8NV("_lit)
           + ParamToStr(idName, decoded.indexOffset)
           + ", "
           + ParamToStr(idName, decoded.packedIndices)
           + ")";
      break;
    }
    case rdcspv::Op::FetchMicroTriangleVertexPositionNV:
    {
      OpFetchMicroTriangleVertexPositionNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FetchMicroTriangleVertexPositionNV("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.primitiveIndex)
           + ", "
           + ParamToStr(idName, decoded.barycentric)
           + ")";
      break;
    }
    case rdcspv::Op::FetchMicroTriangleVertexBarycentricNV:
    {
      OpFetchMicroTriangleVertexBarycentricNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("FetchMicroTriangleVertexBarycentricNV("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.instanceId)
           + ", "
           + ParamToStr(idName, decoded.geometryIndex)
           + ", "
           + ParamToStr(idName, decoded.primitiveIndex)
           + ", "
           + ParamToStr(idName, decoded.barycentric)
           + ")";
      break;
    }
    case rdcspv::Op::ReportIntersectionKHR:
    {
      OpReportIntersectionKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReportIntersectionKHR("_lit)
           + ParamToStr(idName, decoded.hit)
           + ", "
           + ParamToStr(idName, decoded.hitKind)
           + ")";
      break;
    }
    case rdcspv::Op::IgnoreIntersectionNV:
    {
      OpIgnoreIntersectionNV decoded(it);
      ret += rdcstr("IgnoreIntersectionNV("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TerminateRayNV:
    {
      OpTerminateRayNV decoded(it);
      ret += rdcstr("TerminateRayNV("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::TraceNV:
    {
      OpTraceNV decoded(it);
      ret += rdcstr("TraceNV("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullMask)
           + ", "
           + ParamToStr(idName, decoded.sBTOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.rayOrigin)
           + ", "
           + ParamToStr(idName, decoded.rayTmin)
           + ", "
           + ParamToStr(idName, decoded.rayDirection)
           + ", "
           + ParamToStr(idName, decoded.rayTmax)
           + ", "
           + ParamToStr(idName, decoded.payloadId)
           + ")";
      break;
    }
    case rdcspv::Op::TraceMotionNV:
    {
      OpTraceMotionNV decoded(it);
      ret += rdcstr("TraceMotionNV("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullMask)
           + ", "
           + ParamToStr(idName, decoded.sBTOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.rayOrigin)
           + ", "
           + ParamToStr(idName, decoded.rayTmin)
           + ", "
           + ParamToStr(idName, decoded.rayDirection)
           + ", "
           + ParamToStr(idName, decoded.rayTmax)
           + ", "
           + ParamToStr(idName, decoded.time)
           + ", "
           + ParamToStr(idName, decoded.payloadId)
           + ")";
      break;
    }
    case rdcspv::Op::TraceRayMotionNV:
    {
      OpTraceRayMotionNV decoded(it);
      ret += rdcstr("TraceRayMotionNV("_lit)
           + ParamToStr(idName, decoded.accel)
           + ", "
           + ParamToStr(idName, decoded.rayFlags)
           + ", "
           + ParamToStr(idName, decoded.cullMask)
           + ", "
           + ParamToStr(idName, decoded.sBTOffset)
           + ", "
           + ParamToStr(idName, decoded.sBTStride)
           + ", "
           + ParamToStr(idName, decoded.missIndex)
           + ", "
           + ParamToStr(idName, decoded.rayOrigin)
           + ", "
           + ParamToStr(idName, decoded.rayTmin)
           + ", "
           + ParamToStr(idName, decoded.rayDirection)
           + ", "
           + ParamToStr(idName, decoded.rayTmax)
           + ", "
           + ParamToStr(idName, decoded.time)
           + ", "
           + ParamToStr(idName, decoded.payload)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionTriangleVertexPositionsKHR:
    {
      OpRayQueryGetIntersectionTriangleVertexPositionsKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionTriangleVertexPositionsKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::TypeAccelerationStructureKHR:
    {
      OpTypeAccelerationStructureKHR decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeAccelerationStructureKHR("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ExecuteCallableNV:
    {
      OpExecuteCallableNV decoded(it);
      ret += rdcstr("ExecuteCallableNV("_lit)
           + ParamToStr(idName, decoded.sBTIndex)
           + ", "
           + ParamToStr(idName, decoded.callableDataId)
           + ")";
      break;
    }
    case rdcspv::Op::TypeCooperativeMatrixNV:
    {
      OpTypeCooperativeMatrixNV decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeCooperativeMatrixNV("_lit)
           + ParamToStr(idName, decoded.componentType)
           + ", "
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.rows)
           + ", "
           + ParamToStr(idName, decoded.columns)
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixLoadNV:
    {
      OpCooperativeMatrixLoadNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixLoadNV("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.stride)
           + ", "
           + ParamToStr(idName, decoded.columnMajor)
           + (6 < size ? ", " + ParamToStr(idName, decoded.memoryAccess) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixStoreNV:
    {
      OpCooperativeMatrixStoreNV decoded(it);
      ret += rdcstr("CooperativeMatrixStoreNV("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ParamToStr(idName, decoded.object)
           + ", "
           + ParamToStr(idName, decoded.stride)
           + ", "
           + ParamToStr(idName, decoded.columnMajor)
           + (5 < size ? ", " + ParamToStr(idName, decoded.memoryAccess) : "")
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixMulAddNV:
    {
      OpCooperativeMatrixMulAddNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixMulAddNV("_lit)
           + ParamToStr(idName, decoded.a)
           + ", "
           + ParamToStr(idName, decoded.b)
           + ", "
           + ParamToStr(idName, decoded.c)
           + ")";
      break;
    }
    case rdcspv::Op::CooperativeMatrixLengthNV:
    {
      OpCooperativeMatrixLengthNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CooperativeMatrixLengthNV("_lit)
           + ParamToStr(idName, decoded.type)
           + ")";
      break;
    }
    case rdcspv::Op::BeginInvocationInterlockEXT:
    {
      OpBeginInvocationInterlockEXT decoded(it);
      ret += rdcstr("BeginInvocationInterlockEXT("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::EndInvocationInterlockEXT:
    {
      OpEndInvocationInterlockEXT decoded(it);
      ret += rdcstr("EndInvocationInterlockEXT("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::DemoteToHelperInvocation:
    {
      OpDemoteToHelperInvocation decoded(it);
      ret += rdcstr("DemoteToHelperInvocation("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::IsHelperInvocationEXT:
    {
      OpIsHelperInvocationEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IsHelperInvocationEXT("_lit)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToImageNV:
    {
      OpConvertUToImageNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToImageNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToSamplerNV:
    {
      OpConvertUToSamplerNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToSamplerNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertImageToUNV:
    {
      OpConvertImageToUNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertImageToUNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertSamplerToUNV:
    {
      OpConvertSamplerToUNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertSamplerToUNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertUToSampledImageNV:
    {
      OpConvertUToSampledImageNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertUToSampledImageNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertSampledImageToUNV:
    {
      OpConvertSampledImageToUNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertSampledImageToUNV("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::SamplerImageAddressingModeNV:
    {
      OpSamplerImageAddressingModeNV decoded(it);
      ret += rdcstr("SamplerImageAddressingModeNV("_lit)
           + ParamToStr(idName, decoded.bitWidth)
           + ")";
      break;
    }
    case rdcspv::Op::RawAccessChainNV:
    {
      OpRawAccessChainNV decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RawAccessChainNV("_lit)
           + ParamToStr(idName, decoded.base)
           + ", "
           + ParamToStr(idName, decoded.bytestride)
           + ", "
           + ParamToStr(idName, decoded.elementindex)
           + ", "
           + ParamToStr(idName, decoded.byteoffset)
           + (7 < size ? ", " + ParamToStr(idName, decoded.rawAccessChainOperands) : "")
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupShuffleINTEL:
    {
      OpSubgroupShuffleINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupShuffleINTEL("_lit)
           + ParamToStr(idName, decoded.data)
           + ", "
           + ParamToStr(idName, decoded.invocationId)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupShuffleDownINTEL:
    {
      OpSubgroupShuffleDownINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupShuffleDownINTEL("_lit)
           + ParamToStr(idName, decoded.current)
           + ", "
           + ParamToStr(idName, decoded.next)
           + ", "
           + ParamToStr(idName, decoded.delta)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupShuffleUpINTEL:
    {
      OpSubgroupShuffleUpINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupShuffleUpINTEL("_lit)
           + ParamToStr(idName, decoded.previous)
           + ", "
           + ParamToStr(idName, decoded.current)
           + ", "
           + ParamToStr(idName, decoded.delta)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupShuffleXorINTEL:
    {
      OpSubgroupShuffleXorINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupShuffleXorINTEL("_lit)
           + ParamToStr(idName, decoded.data)
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupBlockReadINTEL:
    {
      OpSubgroupBlockReadINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupBlockReadINTEL("_lit)
           + ParamToStr(idName, decoded.ptr)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupBlockWriteINTEL:
    {
      OpSubgroupBlockWriteINTEL decoded(it);
      ret += rdcstr("SubgroupBlockWriteINTEL("_lit)
           + ParamToStr(idName, decoded.ptr)
           + ", "
           + ParamToStr(idName, decoded.data)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupImageBlockReadINTEL:
    {
      OpSubgroupImageBlockReadINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupImageBlockReadINTEL("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupImageBlockWriteINTEL:
    {
      OpSubgroupImageBlockWriteINTEL decoded(it);
      ret += rdcstr("SubgroupImageBlockWriteINTEL("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.data)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupImageMediaBlockReadINTEL:
    {
      OpSubgroupImageMediaBlockReadINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("SubgroupImageMediaBlockReadINTEL("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.width)
           + ", "
           + ParamToStr(idName, decoded.height)
           + ")";
      break;
    }
    case rdcspv::Op::SubgroupImageMediaBlockWriteINTEL:
    {
      OpSubgroupImageMediaBlockWriteINTEL decoded(it);
      ret += rdcstr("SubgroupImageMediaBlockWriteINTEL("_lit)
           + ParamToStr(idName, decoded.image)
           + ", "
           + ParamToStr(idName, decoded.coordinate)
           + ", "
           + ParamToStr(idName, decoded.width)
           + ", "
           + ParamToStr(idName, decoded.height)
           + ", "
           + ParamToStr(idName, decoded.data)
           + ")";
      break;
    }
    case rdcspv::Op::UCountLeadingZerosINTEL:
    {
      OpUCountLeadingZerosINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UCountLeadingZerosINTEL("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::UCountTrailingZerosINTEL:
    {
      OpUCountTrailingZerosINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UCountTrailingZerosINTEL("_lit)
           + ParamToStr(idName, decoded.operand)
           + ")";
      break;
    }
    case rdcspv::Op::AbsISubINTEL:
    {
      OpAbsISubINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AbsISubINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::AbsUSubINTEL:
    {
      OpAbsUSubINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AbsUSubINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::IAddSatINTEL:
    {
      OpIAddSatINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IAddSatINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UAddSatINTEL:
    {
      OpUAddSatINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UAddSatINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::IAverageINTEL:
    {
      OpIAverageINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IAverageINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UAverageINTEL:
    {
      OpUAverageINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UAverageINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::IAverageRoundedINTEL:
    {
      OpIAverageRoundedINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IAverageRoundedINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UAverageRoundedINTEL:
    {
      OpUAverageRoundedINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UAverageRoundedINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::ISubSatINTEL:
    {
      OpISubSatINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ISubSatINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::USubSatINTEL:
    {
      OpUSubSatINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("USubSatINTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::IMul32x16INTEL:
    {
      OpIMul32x16INTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("IMul32x16INTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::UMul32x16INTEL:
    {
      OpUMul32x16INTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("UMul32x16INTEL("_lit)
           + ParamToStr(idName, decoded.operand1)
           + ", "
           + ParamToStr(idName, decoded.operand2)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicFMinEXT:
    {
      OpAtomicFMinEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicFMinEXT("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicFMaxEXT:
    {
      OpAtomicFMaxEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicFMaxEXT("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::AssumeTrueKHR:
    {
      OpAssumeTrueKHR decoded(it);
      ret += rdcstr("AssumeTrueKHR("_lit)
           + ParamToStr(idName, decoded.condition)
           + ")";
      break;
    }
    case rdcspv::Op::ExpectKHR:
    {
      OpExpectKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ExpectKHR("_lit)
           + ParamToStr(idName, decoded.value)
           + ", "
           + ParamToStr(idName, decoded.expectedValue)
           + ")";
      break;
    }
    case rdcspv::Op::DecorateString:
    {
      OpDecorateString decoded(it);
      ret += rdcstr("DecorateString("_lit)
           + ParamToStr(idName, decoded.target)
           + ", "
           + ParamToStr(idName, decoded.decoration)
           + ")";
      break;
    }
    case rdcspv::Op::MemberDecorateString:
    {
      OpMemberDecorateString decoded(it);
      ret += rdcstr("MemberDecorateString("_lit)
           + ParamToStr(idName, decoded.structType)
           + ", "
           + ParamToStr(idName, decoded.member)
           + ", "
           + ParamToStr(idName, decoded.decoration)
           + ")";
      break;
    }
    case rdcspv::Op::LoopControlINTEL:
    {
      OpLoopControlINTEL decoded(it);
      ret += rdcstr("LoopControlINTEL("_lit)
           + ParamsToStr(idName, decoded.loopControlParameters)
           + ")";
      break;
    }
    case rdcspv::Op::ReadPipeBlockingINTEL:
    {
      OpReadPipeBlockingINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ReadPipeBlockingINTEL("_lit)
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::WritePipeBlockingINTEL:
    {
      OpWritePipeBlockingINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("WritePipeBlockingINTEL("_lit)
           + ParamToStr(idName, decoded.packetSize)
           + ", "
           + ParamToStr(idName, decoded.packetAlignment)
           + ")";
      break;
    }
    case rdcspv::Op::FPGARegINTEL:
    {
      OpFPGARegINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result0) + ", " + idName(decoded.result1) + " = ";
      ret += rdcstr("FPGARegINTEL("_lit)
           + ParamToStr(idName, decoded.result1)
           + ", "
           + ParamToStr(idName, decoded.input)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetRayTMinKHR:
    {
      OpRayQueryGetRayTMinKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetRayTMinKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetRayFlagsKHR:
    {
      OpRayQueryGetRayFlagsKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetRayFlagsKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionTKHR:
    {
      OpRayQueryGetIntersectionTKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionTKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionInstanceCustomIndexKHR:
    {
      OpRayQueryGetIntersectionInstanceCustomIndexKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionInstanceCustomIndexKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionInstanceIdKHR:
    {
      OpRayQueryGetIntersectionInstanceIdKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionInstanceIdKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
    {
      OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionGeometryIndexKHR:
    {
      OpRayQueryGetIntersectionGeometryIndexKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionGeometryIndexKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionPrimitiveIndexKHR:
    {
      OpRayQueryGetIntersectionPrimitiveIndexKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionPrimitiveIndexKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionBarycentricsKHR:
    {
      OpRayQueryGetIntersectionBarycentricsKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionBarycentricsKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionFrontFaceKHR:
    {
      OpRayQueryGetIntersectionFrontFaceKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionFrontFaceKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionCandidateAABBOpaqueKHR:
    {
      OpRayQueryGetIntersectionCandidateAABBOpaqueKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionCandidateAABBOpaqueKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionObjectRayDirectionKHR:
    {
      OpRayQueryGetIntersectionObjectRayDirectionKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionObjectRayDirectionKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionObjectRayOriginKHR:
    {
      OpRayQueryGetIntersectionObjectRayOriginKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionObjectRayOriginKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetWorldRayDirectionKHR:
    {
      OpRayQueryGetWorldRayDirectionKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetWorldRayDirectionKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetWorldRayOriginKHR:
    {
      OpRayQueryGetWorldRayOriginKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetWorldRayOriginKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionObjectToWorldKHR:
    {
      OpRayQueryGetIntersectionObjectToWorldKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionObjectToWorldKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::RayQueryGetIntersectionWorldToObjectKHR:
    {
      OpRayQueryGetIntersectionWorldToObjectKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("RayQueryGetIntersectionWorldToObjectKHR("_lit)
           + ParamToStr(idName, decoded.rayQuery)
           + ", "
           + ParamToStr(idName, decoded.intersection)
           + ")";
      break;
    }
    case rdcspv::Op::AtomicFAddEXT:
    {
      OpAtomicFAddEXT decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("AtomicFAddEXT("_lit)
           + ParamToStr(idName, decoded.pointer)
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ", "
           + ParamToStr(idName, decoded.value)
           + ")";
      break;
    }
    case rdcspv::Op::TypeBufferSurfaceINTEL:
    {
      OpTypeBufferSurfaceINTEL decoded(it);
      ret += idName(decoded.result) + " = ";
      ret += rdcstr("TypeBufferSurfaceINTEL("_lit)
           + ParamToStr(idName, decoded.accessQualifier)
           + ")";
      break;
    }
    case rdcspv::Op::TypeStructContinuedINTEL:
    {
      OpTypeStructContinuedINTEL decoded(it);
      ret += rdcstr("TypeStructContinuedINTEL("_lit)
           + ParamsToStr(idName, decoded.members)
           + ")";
      break;
    }
    case rdcspv::Op::ConstantCompositeContinuedINTEL:
    {
      OpConstantCompositeContinuedINTEL decoded(it);
      ret += rdcstr("ConstantCompositeContinuedINTEL("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::SpecConstantCompositeContinuedINTEL:
    {
      OpSpecConstantCompositeContinuedINTEL decoded(it);
      ret += rdcstr("SpecConstantCompositeContinuedINTEL("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::CompositeConstructContinuedINTEL:
    {
      OpCompositeConstructContinuedINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("CompositeConstructContinuedINTEL("_lit)
           + ParamsToStr(idName, decoded.constituents)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertFToBF16INTEL:
    {
      OpConvertFToBF16INTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertFToBF16INTEL("_lit)
           + ParamToStr(idName, decoded.floatValue)
           + ")";
      break;
    }
    case rdcspv::Op::ConvertBF16ToFINTEL:
    {
      OpConvertBF16ToFINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("ConvertBF16ToFINTEL("_lit)
           + ParamToStr(idName, decoded.bFloat16Value)
           + ")";
      break;
    }
    case rdcspv::Op::ControlBarrierArriveINTEL:
    {
      OpControlBarrierArriveINTEL decoded(it);
      ret += rdcstr("ControlBarrierArriveINTEL("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::ControlBarrierWaitINTEL:
    {
      OpControlBarrierWaitINTEL decoded(it);
      ret += rdcstr("ControlBarrierWaitINTEL("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ToStr(Scope(constIntVal(decoded.memory)))
           + ", "
           + ToStr(MemorySemantics(constIntVal(decoded.semantics)))
           + ")";
      break;
    }
    case rdcspv::Op::GroupIMulKHR:
    {
      OpGroupIMulKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupIMulKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupFMulKHR:
    {
      OpGroupFMulKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupFMulKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupBitwiseAndKHR:
    {
      OpGroupBitwiseAndKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupBitwiseAndKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupBitwiseOrKHR:
    {
      OpGroupBitwiseOrKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupBitwiseOrKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupBitwiseXorKHR:
    {
      OpGroupBitwiseXorKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupBitwiseXorKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupLogicalAndKHR:
    {
      OpGroupLogicalAndKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupLogicalAndKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupLogicalOrKHR:
    {
      OpGroupLogicalOrKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupLogicalOrKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::GroupLogicalXorKHR:
    {
      OpGroupLogicalXorKHR decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("GroupLogicalXorKHR("_lit)
           + ToStr(Scope(constIntVal(decoded.execution)))
           + ", "
           + ParamToStr(idName, decoded.operation)
           + ", "
           + ParamToStr(idName, decoded.x)
           + ")";
      break;
    }
    case rdcspv::Op::MaskedGatherINTEL:
    {
      OpMaskedGatherINTEL decoded(it);
      ret += declName(decoded.resultType, decoded.result) + " = ";
      ret += rdcstr("MaskedGatherINTEL("_lit)
           + ParamToStr(idName, decoded.ptrVector)
           + ", "
           + ParamToStr(idName, decoded.alignment)
           + ", "
           + ParamToStr(idName, decoded.mask)
           + ", "
           + ParamToStr(idName, decoded.fillEmpty)
           + ")";
      break;
    }
    case rdcspv::Op::MaskedScatterINTEL:
    {
      OpMaskedScatterINTEL decoded(it);
      ret += rdcstr("MaskedScatterINTEL("_lit)
           + ParamToStr(idName, decoded.inputVector)
           + ", "
           + ParamToStr(idName, decoded.ptrVector)
           + ", "
           + ParamToStr(idName, decoded.alignment)
           + ", "
           + ParamToStr(idName, decoded.mask)
           + ")";
      break;
    }
    case Op::Max: break;
  }
  return ret;
}
  
OpDecoder::OpDecoder(const ConstIter &it)
{
  op = it.opcode();
  wordCount = (uint16_t)it.size();
  switch(op)
  {
    case rdcspv::Op::Nop: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Undef: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SourceContinued: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Source: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SourceExtension: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Name: result = Id(); resultType = Id(); break;
    case rdcspv::Op::MemberName: result = Id(); resultType = Id(); break;
    case rdcspv::Op::String: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::Line: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Extension: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ExtInstImport: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::ExtInst: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MemoryModel: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EntryPoint: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ExecutionMode: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Capability: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TypeVoid: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeBool: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeInt: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeFloat: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeVector: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeMatrix: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeImage: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeSampler: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeSampledImage: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeArray: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeRuntimeArray: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeStruct: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeOpaque: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypePointer: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeFunction: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeEvent: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeDeviceEvent: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeReserveId: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeQueue: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypePipe: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeForwardPointer: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ConstantTrue: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConstantFalse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Constant: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConstantComposite: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConstantSampler: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConstantNull: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstantTrue: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstantFalse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstant: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstantComposite: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstantOp: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Function: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FunctionParameter: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FunctionEnd: result = Id(); resultType = Id(); break;
    case rdcspv::Op::FunctionCall: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Variable: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageTexelPointer: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Load: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Store: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CopyMemory: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CopyMemorySized: result = Id(); resultType = Id(); break;
    case rdcspv::Op::AccessChain: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::InBoundsAccessChain: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::PtrAccessChain: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ArrayLength: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GenericPtrMemSemantics: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::InBoundsPtrAccessChain: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Decorate: result = Id(); resultType = Id(); break;
    case rdcspv::Op::MemberDecorate: result = Id(); resultType = Id(); break;
    case rdcspv::Op::DecorationGroup: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::GroupDecorate: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupMemberDecorate: result = Id(); resultType = Id(); break;
    case rdcspv::Op::VectorExtractDynamic: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::VectorInsertDynamic: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::VectorShuffle: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CompositeConstruct: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CompositeExtract: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CompositeInsert: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CopyObject: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Transpose: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SampledImage: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleDrefImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleDrefExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleProjImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleProjExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleProjDrefImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleProjDrefExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageFetch: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageGather: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageDrefGather: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageRead: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageWrite: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Image: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQueryFormat: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQueryOrder: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQuerySizeLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQuerySize: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQueryLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQueryLevels: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageQuerySamples: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertFToU: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertFToS: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertSToF: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertUToF: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UConvert: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SConvert: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FConvert: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::QuantizeToF16: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertPtrToU: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SatConvertSToU: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SatConvertUToS: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertUToPtr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::PtrCastToGeneric: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GenericCastToPtr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GenericCastToPtrExplicit: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Bitcast: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SNegate: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FNegate: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ISub: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FSub: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IMul: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FMul: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UDiv: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SDiv: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FDiv: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UMod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SRem: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SMod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FRem: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FMod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::VectorTimesScalar: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MatrixTimesScalar: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::VectorTimesMatrix: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MatrixTimesVector: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MatrixTimesMatrix: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::OuterProduct: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Dot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IAddCarry: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ISubBorrow: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UMulExtended: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SMulExtended: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Any: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::All: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IsNan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IsInf: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IsFinite: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IsNormal: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SignBitSet: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LessOrGreater: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Ordered: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Unordered: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LogicalEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LogicalNotEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LogicalOr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LogicalAnd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LogicalNot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Select: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::INotEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UGreaterThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SGreaterThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UGreaterThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SGreaterThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ULessThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SLessThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ULessThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SLessThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdNotEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordNotEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdLessThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordLessThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdGreaterThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordGreaterThan: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdLessThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordLessThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FOrdGreaterThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FUnordGreaterThanEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ShiftRightLogical: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ShiftRightArithmetic: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ShiftLeftLogical: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitwiseOr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitwiseXor: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitwiseAnd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Not: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitFieldInsert: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitFieldSExtract: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitFieldUExtract: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitReverse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BitCount: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdx: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdy: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Fwidth: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdxFine: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdyFine: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FwidthFine: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdxCoarse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DPdyCoarse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FwidthCoarse: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::EmitVertex: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EndPrimitive: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EmitStreamVertex: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EndStreamPrimitive: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ControlBarrier: result = Id(); resultType = Id(); break;
    case rdcspv::Op::MemoryBarrier: result = Id(); resultType = Id(); break;
    case rdcspv::Op::AtomicLoad: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicStore: result = Id(); resultType = Id(); break;
    case rdcspv::Op::AtomicExchange: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicCompareExchange: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicCompareExchangeWeak: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicIIncrement: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicIDecrement: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicIAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicISub: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicSMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicUMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicSMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicUMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicAnd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicOr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicXor: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::Phi: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::LoopMerge: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SelectionMerge: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Label: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::Branch: result = Id(); resultType = Id(); break;
    case rdcspv::Op::BranchConditional: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Switch: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Kill: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Return: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ReturnValue: result = Id(); resultType = Id(); break;
    case rdcspv::Op::Unreachable: result = Id(); resultType = Id(); break;
    case rdcspv::Op::LifetimeStart: result = Id(); resultType = Id(); break;
    case rdcspv::Op::LifetimeStop: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupAsyncCopy: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupWaitEvents: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupAll: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupAny: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupBroadcast: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupIAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupUMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupSMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupUMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupSMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReadPipe: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::WritePipe: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReservedReadPipe: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReservedWritePipe: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReserveReadPipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReserveWritePipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CommitReadPipe: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CommitWritePipe: result = Id(); resultType = Id(); break;
    case rdcspv::Op::IsValidReserveId: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetNumPipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetMaxPipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupReserveReadPipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupReserveWritePipePackets: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupCommitReadPipe: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupCommitWritePipe: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EnqueueMarker: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::EnqueueKernel: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelNDrangeSubGroupCount: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelNDrangeMaxSubGroupSize: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelWorkGroupSize: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelPreferredWorkGroupSizeMultiple: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RetainEvent: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ReleaseEvent: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CreateUserEvent: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IsValidEvent: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SetUserEventStatus: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CaptureEventProfilingInfo: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GetDefaultQueue: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BuildNDRange: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleDrefImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleDrefExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleProjImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleProjExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleProjDrefImplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseSampleProjDrefExplicitLod: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseFetch: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseGather: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseDrefGather: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSparseTexelsResident: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::NoLine: result = Id(); resultType = Id(); break;
    case rdcspv::Op::AtomicFlagTestAndSet: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicFlagClear: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ImageSparseRead: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SizeOf: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypePipeStorage: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::ConstantPipeStorage: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CreatePipeFromPipeStorage: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelLocalSizeForSubgroupCount: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GetKernelMaxNumSubgroups: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypeNamedBarrier: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::NamedBarrierInitialize: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MemoryNamedBarrier: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ModuleProcessed: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ExecutionModeId: result = Id(); resultType = Id(); break;
    case rdcspv::Op::DecorateId: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupNonUniformElect: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformAll: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformAny: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformAllEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBroadcast: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBroadcastFirst: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBallot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformInverseBallot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBallotBitExtract: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBallotBitCount: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBallotFindLSB: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBallotFindMSB: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformShuffle: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformShuffleXor: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformShuffleUp: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformShuffleDown: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformIAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformFAdd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformIMul: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformFMul: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformSMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformUMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformFMin: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformSMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformUMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformFMax: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBitwiseAnd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBitwiseOr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformBitwiseXor: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformLogicalAnd: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformLogicalOr: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformLogicalXor: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformQuadBroadcast: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformQuadSwap: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CopyLogical: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::PtrEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::PtrNotEqual: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::PtrDiff: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ColorAttachmentReadEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DepthAttachmentReadEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::StencilAttachmentReadEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TerminateInvocation: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SubgroupBallotKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupFirstInvocationKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupAllKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupAnyKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupAllEqualKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformRotateKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupReadInvocationKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ExtInstWithForwardRefsKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TraceRayKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ExecuteCallableKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ConvertUToAccelerationStructureKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IgnoreIntersectionKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TerminateRayKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SDot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UDot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SUDot: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SDotAccSat: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UDotAccSat: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SUDotAccSat: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypeCooperativeMatrixKHR: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::CooperativeMatrixLoadKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CooperativeMatrixStoreKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CooperativeMatrixMulAddKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CooperativeMatrixLengthKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConstantCompositeReplicateEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SpecConstantCompositeReplicateEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CompositeConstructReplicateEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypeRayQueryKHR: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::RayQueryInitializeKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RayQueryTerminateKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RayQueryGenerateIntersectionKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RayQueryConfirmIntersectionKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RayQueryProceedKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionTypeKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageSampleWeightedQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBoxFilterQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchSSDQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchSADQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchWindowSSDQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchWindowSADQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchGatherSSDQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ImageBlockMatchGatherSADQCOM: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupIAddNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFAddNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFMinNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupUMinNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupSMinNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFMaxNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupUMaxNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupSMaxNonUniformAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FragmentMaskFetchAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FragmentFetchAMD: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReadClockKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FinalizeNodePayloadsAMDX: result = Id(); resultType = Id(); break;
    case rdcspv::Op::FinishWritingNodePayloadAMDX: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::InitializeNodePayloadsAMDX: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupNonUniformQuadAllKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupNonUniformQuadAnyKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectRecordHitMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectRecordHitWithIndexMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectRecordMissMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectGetWorldToObjectNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetObjectToWorldNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetObjectRayDirectionNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetObjectRayOriginNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectTraceRayMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectGetShaderRecordBufferHandleNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetShaderBindingTableRecordIndexNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectRecordEmptyNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectTraceRayNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectRecordHitNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectRecordHitWithIndexNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectRecordMissNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectExecuteShaderNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectGetCurrentTimeNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetAttributesNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::HitObjectGetHitKindNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetPrimitiveIndexNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetGeometryIndexNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetInstanceIdNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetInstanceCustomIndexNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetWorldRayDirectionNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetWorldRayOriginNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetRayTMaxNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectGetRayTMinNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectIsEmptyNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectIsHitNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::HitObjectIsMissNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReorderThreadWithHitObjectNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ReorderThreadWithHintNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TypeHitObjectNV: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::ImageSampleFootprintNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::EmitMeshTasksEXT: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SetMeshOutputsEXT: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupNonUniformPartitionNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::WritePackedPrimitiveIndices4x8NV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::FetchMicroTriangleVertexPositionNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FetchMicroTriangleVertexBarycentricNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ReportIntersectionKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IgnoreIntersectionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TerminateRayNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TraceNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TraceMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TraceRayMotionNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RayQueryGetIntersectionTriangleVertexPositionsKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypeAccelerationStructureKHR: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::ExecuteCallableNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::TypeCooperativeMatrixNV: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::CooperativeMatrixLoadNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CooperativeMatrixStoreNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CooperativeMatrixMulAddNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::CooperativeMatrixLengthNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::BeginInvocationInterlockEXT: result = Id(); resultType = Id(); break;
    case rdcspv::Op::EndInvocationInterlockEXT: result = Id(); resultType = Id(); break;
    case rdcspv::Op::DemoteToHelperInvocation: result = Id(); resultType = Id(); break;
    case rdcspv::Op::IsHelperInvocationEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertUToImageNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertUToSamplerNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertImageToUNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertSamplerToUNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertUToSampledImageNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertSampledImageToUNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SamplerImageAddressingModeNV: result = Id(); resultType = Id(); break;
    case rdcspv::Op::RawAccessChainNV: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupShuffleINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupShuffleDownINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupShuffleUpINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupShuffleXorINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupBlockReadINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupBlockWriteINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SubgroupImageBlockReadINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupImageBlockWriteINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SubgroupImageMediaBlockReadINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::SubgroupImageMediaBlockWriteINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::UCountLeadingZerosINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UCountTrailingZerosINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AbsISubINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AbsUSubINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IAddSatINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UAddSatINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IAverageINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UAverageINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IAverageRoundedINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UAverageRoundedINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ISubSatINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::USubSatINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::IMul32x16INTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::UMul32x16INTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicFMinEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicFMaxEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AssumeTrueKHR: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ExpectKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::DecorateString: result = Id(); resultType = Id(); break;
    case rdcspv::Op::MemberDecorateString: result = Id(); resultType = Id(); break;
    case rdcspv::Op::LoopControlINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ReadPipeBlockingINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::WritePipeBlockingINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::FPGARegINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetRayTMinKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetRayFlagsKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionTKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceCustomIndexKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceIdKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionGeometryIndexKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionPrimitiveIndexKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionBarycentricsKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionFrontFaceKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionCandidateAABBOpaqueKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionObjectRayDirectionKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionObjectRayOriginKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetWorldRayDirectionKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetWorldRayOriginKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionObjectToWorldKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::RayQueryGetIntersectionWorldToObjectKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::AtomicFAddEXT: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::TypeBufferSurfaceINTEL: result = Id::fromWord(it.word(1)); resultType = Id(); break;
    case rdcspv::Op::TypeStructContinuedINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ConstantCompositeContinuedINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::SpecConstantCompositeContinuedINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::CompositeConstructContinuedINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertFToBF16INTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ConvertBF16ToFINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::ControlBarrierArriveINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::ControlBarrierWaitINTEL: result = Id(); resultType = Id(); break;
    case rdcspv::Op::GroupIMulKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupFMulKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupBitwiseAndKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupBitwiseOrKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupBitwiseXorKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupLogicalAndKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupLogicalOrKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::GroupLogicalXorKHR: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MaskedGatherINTEL: result = Id::fromWord(it.word(2)); resultType = Id::fromWord(it.word(1)); break;
    case rdcspv::Op::MaskedScatterINTEL: result = Id(); resultType = Id(); break;
    case Op::Max: break;
  }
}

}; // namespace rdcspv

template <>
rdcstr DoStringise(const rdcspv::GLSLstd450 &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::GLSLstd450);
  {
    STRINGISE_ENUM_CLASS(Round);
    STRINGISE_ENUM_CLASS(RoundEven);
    STRINGISE_ENUM_CLASS(Trunc);
    STRINGISE_ENUM_CLASS(FAbs);
    STRINGISE_ENUM_CLASS(SAbs);
    STRINGISE_ENUM_CLASS(FSign);
    STRINGISE_ENUM_CLASS(SSign);
    STRINGISE_ENUM_CLASS(Floor);
    STRINGISE_ENUM_CLASS(Ceil);
    STRINGISE_ENUM_CLASS(Fract);
    STRINGISE_ENUM_CLASS(Radians);
    STRINGISE_ENUM_CLASS(Degrees);
    STRINGISE_ENUM_CLASS(Sin);
    STRINGISE_ENUM_CLASS(Cos);
    STRINGISE_ENUM_CLASS(Tan);
    STRINGISE_ENUM_CLASS(Asin);
    STRINGISE_ENUM_CLASS(Acos);
    STRINGISE_ENUM_CLASS(Atan);
    STRINGISE_ENUM_CLASS(Sinh);
    STRINGISE_ENUM_CLASS(Cosh);
    STRINGISE_ENUM_CLASS(Tanh);
    STRINGISE_ENUM_CLASS(Asinh);
    STRINGISE_ENUM_CLASS(Acosh);
    STRINGISE_ENUM_CLASS(Atanh);
    STRINGISE_ENUM_CLASS(Atan2);
    STRINGISE_ENUM_CLASS(Pow);
    STRINGISE_ENUM_CLASS(Exp);
    STRINGISE_ENUM_CLASS(Log);
    STRINGISE_ENUM_CLASS(Exp2);
    STRINGISE_ENUM_CLASS(Log2);
    STRINGISE_ENUM_CLASS(Sqrt);
    STRINGISE_ENUM_CLASS(InverseSqrt);
    STRINGISE_ENUM_CLASS(Determinant);
    STRINGISE_ENUM_CLASS(MatrixInverse);
    STRINGISE_ENUM_CLASS(Modf);
    STRINGISE_ENUM_CLASS(ModfStruct);
    STRINGISE_ENUM_CLASS(FMin);
    STRINGISE_ENUM_CLASS(UMin);
    STRINGISE_ENUM_CLASS(SMin);
    STRINGISE_ENUM_CLASS(FMax);
    STRINGISE_ENUM_CLASS(UMax);
    STRINGISE_ENUM_CLASS(SMax);
    STRINGISE_ENUM_CLASS(FClamp);
    STRINGISE_ENUM_CLASS(UClamp);
    STRINGISE_ENUM_CLASS(SClamp);
    STRINGISE_ENUM_CLASS(FMix);
    STRINGISE_ENUM_CLASS(IMix);
    STRINGISE_ENUM_CLASS(Step);
    STRINGISE_ENUM_CLASS(SmoothStep);
    STRINGISE_ENUM_CLASS(Fma);
    STRINGISE_ENUM_CLASS(Frexp);
    STRINGISE_ENUM_CLASS(FrexpStruct);
    STRINGISE_ENUM_CLASS(Ldexp);
    STRINGISE_ENUM_CLASS(PackSnorm4x8);
    STRINGISE_ENUM_CLASS(PackUnorm4x8);
    STRINGISE_ENUM_CLASS(PackSnorm2x16);
    STRINGISE_ENUM_CLASS(PackUnorm2x16);
    STRINGISE_ENUM_CLASS(PackHalf2x16);
    STRINGISE_ENUM_CLASS(PackDouble2x32);
    STRINGISE_ENUM_CLASS(UnpackSnorm2x16);
    STRINGISE_ENUM_CLASS(UnpackUnorm2x16);
    STRINGISE_ENUM_CLASS(UnpackHalf2x16);
    STRINGISE_ENUM_CLASS(UnpackSnorm4x8);
    STRINGISE_ENUM_CLASS(UnpackUnorm4x8);
    STRINGISE_ENUM_CLASS(UnpackDouble2x32);
    STRINGISE_ENUM_CLASS(Length);
    STRINGISE_ENUM_CLASS(Distance);
    STRINGISE_ENUM_CLASS(Cross);
    STRINGISE_ENUM_CLASS(Normalize);
    STRINGISE_ENUM_CLASS(FaceForward);
    STRINGISE_ENUM_CLASS(Reflect);
    STRINGISE_ENUM_CLASS(Refract);
    STRINGISE_ENUM_CLASS(FindILsb);
    STRINGISE_ENUM_CLASS(FindSMsb);
    STRINGISE_ENUM_CLASS(FindUMsb);
    STRINGISE_ENUM_CLASS(InterpolateAtCentroid);
    STRINGISE_ENUM_CLASS(InterpolateAtSample);
    STRINGISE_ENUM_CLASS(InterpolateAtOffset);
    STRINGISE_ENUM_CLASS(NMin);
    STRINGISE_ENUM_CLASS(NMax);
    STRINGISE_ENUM_CLASS(NClamp);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::ShaderDbg &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::ShaderDbg);
  {
    STRINGISE_ENUM_CLASS(InfoNone);
    STRINGISE_ENUM_CLASS(CompilationUnit);
    STRINGISE_ENUM_CLASS(TypeBasic);
    STRINGISE_ENUM_CLASS(TypePointer);
    STRINGISE_ENUM_CLASS(TypeQualifier);
    STRINGISE_ENUM_CLASS(TypeArray);
    STRINGISE_ENUM_CLASS(TypeVector);
    STRINGISE_ENUM_CLASS(Typedef);
    STRINGISE_ENUM_CLASS(TypeFunction);
    STRINGISE_ENUM_CLASS(TypeEnum);
    STRINGISE_ENUM_CLASS(TypeComposite);
    STRINGISE_ENUM_CLASS(TypeMember);
    STRINGISE_ENUM_CLASS(TypeInheritance);
    STRINGISE_ENUM_CLASS(TypePtrToMember);
    STRINGISE_ENUM_CLASS(TypeTemplate);
    STRINGISE_ENUM_CLASS(TypeTemplateParameter);
    STRINGISE_ENUM_CLASS(TypeTemplateTemplateParameter);
    STRINGISE_ENUM_CLASS(TypeTemplateParameterPack);
    STRINGISE_ENUM_CLASS(GlobalVariable);
    STRINGISE_ENUM_CLASS(FunctionDeclaration);
    STRINGISE_ENUM_CLASS(Function);
    STRINGISE_ENUM_CLASS(LexicalBlock);
    STRINGISE_ENUM_CLASS(LexicalBlockDiscriminator);
    STRINGISE_ENUM_CLASS(Scope);
    STRINGISE_ENUM_CLASS(NoScope);
    STRINGISE_ENUM_CLASS(InlinedAt);
    STRINGISE_ENUM_CLASS(LocalVariable);
    STRINGISE_ENUM_CLASS(InlinedVariable);
    STRINGISE_ENUM_CLASS(Declare);
    STRINGISE_ENUM_CLASS(Value);
    STRINGISE_ENUM_CLASS(Operation);
    STRINGISE_ENUM_CLASS(Expression);
    STRINGISE_ENUM_CLASS(MacroDef);
    STRINGISE_ENUM_CLASS(MacroUndef);
    STRINGISE_ENUM_CLASS(ImportedEntity);
    STRINGISE_ENUM_CLASS(Source);
    STRINGISE_ENUM_CLASS(FunctionDefinition);
    STRINGISE_ENUM_CLASS(SourceContinued);
    STRINGISE_ENUM_CLASS(Line);
    STRINGISE_ENUM_CLASS(NoLine);
    STRINGISE_ENUM_CLASS(BuildIdentifier);
    STRINGISE_ENUM_CLASS(StoragePath);
    STRINGISE_ENUM_CLASS(EntryPoint);
    STRINGISE_ENUM_CLASS(TypeMatrix);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const rdcspv::Generator &el)
{
  BEGIN_ENUM_STRINGISE(rdcspv::Generator);
  {
    STRINGISE_ENUM_CLASS_NAMED(LLVMSPIRVTranslator, "LLVM/SPIR-V Translator from Khronos - Contact Yaxun (Sam) Liu, yaxun.liu@amd.com");
    STRINGISE_ENUM_CLASS_NAMED(SPIRVToolsAssembler, "SPIR-V Tools Assembler from Khronos - Contact David Neto, dneto@google.com");
    STRINGISE_ENUM_CLASS_NAMED(GlslangReferenceFrontEnd, "Glslang Reference Front End from Khronos - Contact John Kessenich, johnkessenich@google.com");
    STRINGISE_ENUM_CLASS_NAMED(ShadercoverGlslang, "Shaderc over Glslang from Google - Contact David Neto, dneto@google.com");
    STRINGISE_ENUM_CLASS_NAMED(spiregg, "spiregg from Google - Contact Lei Zhang, antiagainst@google.com");
    STRINGISE_ENUM_CLASS_NAMED(rspirv, "rspirv from Google - Contact Lei Zhang, antiagainst@gmail.com");
    STRINGISE_ENUM_CLASS_NAMED(MesaIRSPIRVTranslator, "Mesa-IR/SPIR-V Translator from X-LEGEND - Contact Metora Wang, github:metora/MesaGLSLCompiler");
    STRINGISE_ENUM_CLASS_NAMED(SPIRVToolsLinker, "SPIR-V Tools Linker from Khronos - Contact David Neto, dneto@google.com");
    STRINGISE_ENUM_CLASS_NAMED(VKD3DShaderCompiler, "VKD3D Shader Compiler from Wine - Contact wine-devel@winehq.org");
    STRINGISE_ENUM_CLASS_NAMED(ClayShaderCompiler, "Clay Shader Compiler from Tellusim - Contact info@tellusim.com");
    STRINGISE_ENUM_CLASS_NAMED(WHLSLShaderTranslator, "WHLSL Shader Translator from W3C WebGPU Group - https://github.com/gpuweb/WHLSL");
    STRINGISE_ENUM_CLASS_NAMED(Clspv, "Clspv from Google - Contact David Neto, dneto@google.com");
    STRINGISE_ENUM_CLASS_NAMED(MLIRSPIRVSerializer, "MLIR SPIR-V Serializer from Google - Contact Lei Zhang, antiagainst@google.com");
    STRINGISE_ENUM_CLASS_NAMED(TintCompiler, "Tint Compiler from Google - Contact David Neto, dneto@google.com");
    STRINGISE_ENUM_CLASS_NAMED(ANGLEShaderCompiler, "ANGLE Shader Compiler from Google - Contact Shahbaz Youssefi, syoussefi@google.com");
    STRINGISE_ENUM_CLASS_NAMED(MessiahShaderCompiler, "Messiah Shader Compiler from Netease Games - Contact Yuwen Wu, atyuwen@gmail.com");
    STRINGISE_ENUM_CLASS_NAMED(XeniaEmulatorMicrocodeTranslator, "Xenia Emulator Microcode Translator from Xenia - Contact Vitaliy Kuzmin, triang3l@yandex.ru, https://github.com/xenia-project/xenia");
    STRINGISE_ENUM_CLASS_NAMED(RustGPUCompilerBackend, "Rust GPU Compiler Backend from Embark Studios - https://github.com/embarkstudios/rust-gpu");
    STRINGISE_ENUM_CLASS_NAMED(Naga, "Naga from gfx-rs community - https://github.com/gfx-rs/naga");
    STRINGISE_ENUM_CLASS_NAMED(MSPShaderCompiler, "MSP Shader Compiler from Mikkosoft Productions - Contact Mikko Rasa, tdb@tdb.fi");
    STRINGISE_ENUM_CLASS_NAMED(SpvGenTwoSPIRVIRTools, "SpvGenTwo SPIR-V IR Tools from SpvGenTwo community - https://github.com/rAzoR8/SpvGenTwo");
    STRINGISE_ENUM_CLASS_NAMED(SkiaSkSL, "Skia SkSL from Google - Contact Ethan Nicholas, ethannicholas@google.com");
    STRINGISE_ENUM_CLASS_NAMED(BeehiveSPIRVToolkit, "Beehive SPIRV Toolkit from TornadoVM - https://github.com/beehive-lab/beehive-spirv-toolkit");
    STRINGISE_ENUM_CLASS_NAMED(ShaderWriter, "ShaderWriter from DragonJoker - Contact Sylvain Doremus, https://github.com/DragonJoker/ShaderWriter");
    STRINGISE_ENUM_CLASS_NAMED(SPIRVSmith, "SPIRVSmith from Rayan Hatout - Contact Rayan Hatout rayan.hatout@gmail.com, Repo https://github.com/rayanht/SPIRVSmith");
    STRINGISE_ENUM_CLASS_NAMED(Shady, "Shady from Saarland University - Contact Hugo Devillers devillers@uni-saarland.de, Repo https://github.com/Hugobros3/shady");
    STRINGISE_ENUM_CLASS_NAMED(Taichi, "Taichi from Taichi Graphics - Contact Rendong Liang rendongliang@taichi.graphics, Repo https://github.com/taichi-dev/taichi");
    STRINGISE_ENUM_CLASS_NAMED(HeroCCompiler, "Hero C Compiler from heroseh - https://github.com/heroseh/hcc");
    STRINGISE_ENUM_CLASS_NAMED(SparkSL, "SparkSL from Meta - Contact Dunfan Lu, dunfanlu@meta.com, https://sparkar.facebook.com/ar-studio/learn/sparksl/sparksl-overview");
    STRINGISE_ENUM_CLASS_NAMED(NazaraShaderLangCompiler, "Nazara ShaderLang Compiler from SirLynix - Contact Jérôme Leclercq, https://github.com/NazaraEngine/ShaderLang");
    STRINGISE_ENUM_CLASS_NAMED(SlangCompiler, "Slang Compiler from NVIDIA - Contact Theresa Foley, tfoley@nvidia.com, https://github.com/shader-slang/slang/");
    STRINGISE_ENUM_CLASS_NAMED(ZigCompiler, "Zig Compiler from Zig Software Foundation - Contact Robin Voetter, https://github.com/Snektron");
    STRINGISE_ENUM_CLASS_NAMED(spq, "spq from Rendong Liang - Contact Rendong Liang, admin@penguinliong.moe, https://github.com/PENGUINLIONG/spq-rs");
    STRINGISE_ENUM_CLASS_NAMED(LLVMSPIRVBackend, "LLVM SPIR-V Backend from LLVM - Contact Michal Paszkowski, michal.paszkowski@intel.com, https://github.com/llvm/llvm-project/tree/main/llvm/lib/Target/SPIRV");
  }
  END_ENUM_STRINGISE();
}
