/*
 * Decompiled with CFR 0.152.
 */
package sxr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.util.zip.GZIPInputStream;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class FileUtil$ {
    public static final FileUtil$ MODULE$;
    private final String DefaultEncoding;

    static {
        new FileUtil$();
    }

    public <T> T withReader(File source2, String sourceEncoding, Function1<BufferedReader, T> f) {
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source2), sourceEncoding));
        try {
            return (T)f.apply((Object)input);
        }
        finally {
            input.close();
        }
    }

    public <T> String withReader$default$2() {
        return this.DefaultEncoding();
    }

    public <T> T withWriter(File target, Function1<BufferedWriter, T> f) {
        target.getParentFile().mkdirs();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), this.DefaultEncoding()));
        try {
            return (T)f.apply((Object)output);
        }
        finally {
            output.close();
        }
    }

    public String DefaultEncoding() {
        return this.DefaultEncoding;
    }

    private <S> int commonPrefix(Object a, Object b) {
        return this.common$1(0, a, b);
    }

    private String[] toPathArray(File file) {
        return (String[])this.toPathList$1(file.getAbsoluteFile(), (List)Nil$.MODULE$).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String relativePath(File fromFile, File toFile) {
        String[] fromPath = this.toPathArray(fromFile);
        String[] toPath = this.toPathArray(toFile);
        int commonLength = this.commonPrefix(fromPath, toPath);
        String[] relativeTo = (String[])Predef$.MODULE$.refArrayOps((Object[])toPath).drop(commonLength);
        int parentsToCommon = fromPath.length - commonLength - 1;
        Predef$.MODULE$.require(parentsToCommon >= 0);
        String up = new StringOps(Predef$.MODULE$.augmentString("../")).$times(parentsToCommon);
        return Predef$.MODULE$.refArrayOps((Object[])relativeTo).mkString(up, "/", "");
    }

    public void writeResource(String resource, File to) {
        InputStream source2 = this.getClass().getResourceAsStream(resource);
        if (source2 == null) {
            throw package$.MODULE$.error(new StringBuilder().append((Object)"Could not find resource ").append((Object)resource).toString());
        }
        try {
            this.write(source2, to);
            return;
        }
        finally {
            source2.close();
        }
    }

    private void write(InputStream input, File to) {
        to.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(to);
        try {
            this.transfer(input, out);
            return;
        }
        finally {
            out.close();
        }
    }

    private void transfer(InputStream input, OutputStream out) {
        byte[] buffer = new byte[8192];
        this.transfer$1(input, out, buffer);
    }

    public Option<String> relativize(File baseFile, File file) {
        String pathString = file.getAbsolutePath();
        return this.baseFileString(baseFile).flatMap((Function1)new Serializable(pathString){
            public static final long serialVersionUID = 0L;
            private final String pathString$1;

            public final Option<String> apply(String baseString) {
                return this.pathString$1.startsWith(baseString) ? new Some((Object)this.pathString$1.substring(baseString.length())) : None$.MODULE$;
            }
            {
                this.pathString$1 = pathString$1;
            }
        });
    }

    private Option<String> baseFileString(File baseFile) {
        None$ none$;
        if (baseFile.isDirectory()) {
            String cp = baseFile.getAbsolutePath();
            Predef$.MODULE$.assert(cp.length() > 0);
            none$ = cp.charAt(cp.length() - 1) == File.separatorChar ? new Some((Object)cp) : new Some((Object)new StringBuilder().append((Object)cp).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <T> T readLines(File file, String encoding, T value, Function2<T, String, T> f) {
        return this.withReader(file, encoding, (Function1<BufferedReader, T>)new Serializable(value, f){
            public static final long serialVersionUID = 0L;
            private final Object value$1;
            private final Function2 f$2;

            public final T apply(BufferedReader reader) {
                return (T)FileUtil$.MODULE$.sxr$FileUtil$$readLines(reader, this.value$1, this.f$2);
            }
            {
                this.value$1 = value$1;
                this.f$2 = f$2;
            }
        });
    }

    public final <T> T sxr$FileUtil$$readLines(BufferedReader reader, T value, Function2<T, String, T> f) {
        String line;
        while ((line = reader.readLine()) != null) {
            Object object = f.apply(value, (Object)line);
            value = object;
        }
        return value;
    }

    public void readLines(File file, String encoding, Function1<String, BoxedUnit> f) {
        this.withReader(file, encoding, (Function1)new Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final void apply(BufferedReader reader) {
                FileUtil$.MODULE$.sxr$FileUtil$$readLines(reader, (Function1<String, BoxedUnit>)this.f$1);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public final void sxr$FileUtil$$readLines(BufferedReader reader, Function1<String, BoxedUnit> f) {
        String line;
        while ((line = reader.readLine()) != null) {
            f.apply((Object)line);
        }
    }

    public void download(URL url, File file) {
        this.download(url.openStream(), file);
    }

    public void downloadCompressed(URL url, File file) {
        this.download(new GZIPInputStream(url.openStream()), file);
    }

    public void download(InputStream in, File file) {
        try {
            this.write(in, file);
            return;
        }
        finally {
            in.close();
        }
    }

    public String quarterHash(String s) {
        return this.quarter(this.hash(s));
    }

    public String quarter(String s) {
        return s.length() > 7 ? s.substring(0, s.length() / 4) : s;
    }

    public String hash(String s) {
        return Predef$.MODULE$.charArrayOps((char[])Predef$.MODULE$.byteArrayOps(MessageDigest.getInstance("SHA").digest(s.getBytes())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(byte b) {
                return Predef$.MODULE$.charArrayOps(FileUtil$.MODULE$.sxr$FileUtil$$hashDigits(b));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()))).mkString();
    }

    public char[] sxr$FileUtil$$hashDigits(byte b) {
        int i = this.toInt(b);
        return new char[]{this.forDigit(i >> 4), this.forDigit(i & 0xF)};
    }

    private char forDigit(int i) {
        return Character.forDigit(i, 36);
    }

    private int toInt(byte b) {
        return b < 0 ? b + 256 : b;
    }

    private final int common$1(int count, Object a$1, Object b$1) {
        while (count < ScalaRunTime$.MODULE$.array_length(a$1) && count < ScalaRunTime$.MODULE$.array_length(b$1) && BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(a$1, count), (Object)ScalaRunTime$.MODULE$.array_apply(b$1, count))) {
            ++count;
        }
        return count;
    }

    private final List toPathList$1(File f, List current) {
        while (f != null) {
            String string = f.getName();
            current = current.$colon$colon((Object)string);
            f = f.getParentFile();
        }
        return current;
    }

    private final void transfer$1(InputStream input$1, OutputStream out$1, byte[] buffer$1) {
        int read2;
        while ((read2 = input$1.read(buffer$1)) >= 0) {
            out$1.write(buffer$1, 0, read2);
        }
    }

    private FileUtil$() {
        MODULE$ = this;
        this.DefaultEncoding = "UTF-8";
    }
}

