/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CheckArgsArrayArityInstr
extends Instr {
    public final int required;
    public final int opt;
    public final int rest;
    private Operand argsArray;

    public CheckArgsArrayArityInstr(Operand argsArray, int required, int opt, int rest2) {
        super(Operation.CHECK_ARGS_ARRAY_ARITY);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
        this.argsArray = argsArray;
    }

    public Operand getArgsArray() {
        return this.argsArray;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.argsArray};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.argsArray = this.argsArray.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.argsArray + ", " + this.required + ", " + this.opt + ", " + this.rest + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CheckArgsArrayArityInstr(this.argsArray.cloneForInlining(ii), this.required, this.opt, this.rest);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        RubyArray args2 = (RubyArray)this.argsArray.retrieve(context, self2, currDynScope, temp);
        Helpers.irCheckArgsArrayArity(context, args2, this.required, this.opt, this.rest);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArgsArrayArityInstr(this);
    }
}

