/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKey$signatures$;
import com.jsuereth.pgp.PublicKey$userIDs$;
import com.jsuereth.pgp.PublicKeyLike;
import com.jsuereth.pgp.PublicKeyLike$class;
import com.jsuereth.pgp.Signature;
import com.jsuereth.pgp.Signature$;
import com.jsuereth.pgp.StreamingSaveable;
import com.jsuereth.pgp.StreamingSaveable$class;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableView;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u0001%\u0011\u0011\u0002U;cY&\u001c7*Z=\u000b\u0005\r!\u0011a\u00019ha*\u0011QAB\u0001\tUN,XM]3uQ*\tq!A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0015A!\u0002CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\ti\u0001+\u001e2mS\u000e\\U-\u001f'jW\u0016\u0004\"!E\u000b\n\u0005Y\u0011!!E*ue\u0016\fW.\u001b8h'\u00064X-\u00192mK\"A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011$\u0001\u0004oKN$X\rZ\u000b\u00025A\u00111DI\u0007\u00029)\u0011QDH\u0001\b_B,g\u000e]4q\u0015\ty\u0002%\u0001\u0007c_Vt7-_2bgRdWMC\u0001\"\u0003\ry'oZ\u0005\u0003Gq\u0011A\u0002U$Q!V\u0014G.[2LKfD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAG\u0001\b]\u0016\u001cH/\u001a3!\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003#\u0001AQ\u0001\u0007\u0014A\u0002iAQ\u0001\f\u0001\u0005\u00025\nQa[3z\u0013\u0012+\u0012A\f\t\u0003\u0017=J!\u0001\r\u0007\u0003\t1{gn\u001a\u0005\u0006e\u0001!\taM\u0001\fE&$8\u000b\u001e:f]\u001e$\b.F\u00015!\tYQ'\u0003\u00027\u0019\t\u0019\u0011J\u001c;\t\u000ba\u0002A\u0011A\u001d\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\tU$\u0018\u000e\u001c\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0003ECR,\u0007\"B\"\u0001\t\u0003!\u0015a\u00034j]\u001e,'\u000f\u001d:j]R,\u0012!\u0012\t\u0004\u0017\u0019C\u0015BA$\r\u0005\u0015\t%O]1z!\tY\u0011*\u0003\u0002K\u0019\t!!)\u001f;f\u0011\u0015a\u0005\u0001\"\u0001N\u0003%I7OU3w_.,G-F\u0001O!\tYq*\u0003\u0002Q\u0019\t9!i\\8mK\u0006t\u0007\"\u0002*\u0001\t\u0003\u0019\u0014!C1mO>\u0014\u0018\u000e\u001e5n\u0011\u0015!\u0006\u0001\"\u0001V\u00035\tGnZ8sSRDWNT1nKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z}\u0005!A.\u00198h\u0013\tY\u0006L\u0001\u0004TiJLgnZ\u0004\u0006;\u0002A\tAX\u0001\bkN,'/\u0013#t!\ty\u0006-D\u0001\u0001\r\u0015\t\u0007\u0001#\u0001c\u0005\u001d)8/\u001a:J\tN\u001c2\u0001\u0019\u0006d!\r!Gn\u001c\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001\u001b\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA6\r\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001c8\u0003\u0017Q\u0013\u0018M^3sg\u0006\u0014G.\u001a\u0006\u0003W2\u0001\"\u0001]:\u000f\u0005-\t\u0018B\u0001:\r\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u001e\u0006\u0003e2AQa\n1\u0005\u0002Y$\u0012A\u0018\u0005\u0006q\u0002$\t!_\u0001\bM>\u0014X-Y2i+\rQ\u00181\u0002\u000b\u0003wz\u0004\"a\u0003?\n\u0005ud!\u0001B+oSRDaa`<A\u0002\u0005\u0005\u0011!\u00014\u0011\r-\t\u0019a\\A\u0004\u0013\r\t)\u0001\u0004\u0002\n\rVt7\r^5p]F\u0002B!!\u0003\u0002\f1\u0001AaBA\u0007o\n\u0007\u0011q\u0002\u0002\u0002+F!\u0011\u0011CA\f!\rY\u00111C\u0005\u0004\u0003+a!a\u0002(pi\"Lgn\u001a\t\u0004\u0017\u0005e\u0011bAA\u000e\u0019\t\u0019\u0011I\\=\b\u000f\u0005}\u0001\u0001#\u0001\u0002\"\u0005Q1/[4oCR,(/Z:\u0011\u0007}\u000b\u0019CB\u0004\u0002&\u0001A\t!a\n\u0003\u0015MLwM\\1ukJ,7oE\u0003\u0002$)\tI\u0003\u0005\u0003eY\u0006-\u0002cA\t\u0002.%\u0019\u0011q\u0006\u0002\u0003\u0013MKwM\\1ukJ,\u0007bB\u0014\u0002$\u0011\u0005\u00111\u0007\u000b\u0003\u0003CAq\u0001_A\u0012\t\u0003\n9$\u0006\u0003\u0002:\u0005\u0005CcA>\u0002<!9q0!\u000eA\u0002\u0005u\u0002cB\u0006\u0002\u0004\u0005-\u0012q\b\t\u0005\u0003\u0013\t\t\u0005\u0002\u0005\u0002\u000e\u0005U\"\u0019AA\b\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nqb]5h]\u0006$XO]3t\r>\u0014\u0018\n\u001a\u000b\u0005\u0003S\tI\u0005C\u0004\u0002L\u0005\r\u0003\u0019A8\u0002\u0005%$\u0007bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0014I&\u0014Xm\u0019;LKf\u001c\u0016n\u001a8biV\u0014Xm]\u000b\u0003\u0003SAq!!\u0016\u0001\t\u0003\t9&A\nwKJLg-_'fgN\fw-Z*ue\u0016\fW\u000eF\u0003O\u00033\nI\u0007\u0003\u0005\u0002\\\u0005M\u0003\u0019AA/\u0003\u0015Ig\u000e];u!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2}\u0005\u0011\u0011n\\\u0005\u0005\u0003O\n\tGA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0002CA6\u0003'\u0002\r!!\u001c\u0002\r=,H\u000f];u!\u0011\ty&a\u001c\n\t\u0005E\u0014\u0011\r\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003k\u0002A\u0011AA<\u0003Y1XM]5gsNKwM\\1ukJ,7\u000b\u001e:fC6\u001cH#\u0002(\u0002z\u0005u\u0004\u0002CA>\u0003g\u0002\r!!\u0018\u0002\u00075\u001cx\r\u0003\u0005\u0002\u0000\u0005M\u0004\u0019AA/\u0003%\u0019\u0018n\u001a8biV\u0014X\rC\u0004\u0002\u0004\u0002!\t!!\"\u0002\u0017\u0015t7M]=qi\u001aKG.\u001a\u000b\u0006w\u0006\u001d\u0015q\u0012\u0005\t\u00037\n\t\t1\u0001\u0002\nB!\u0011qLAF\u0013\u0011\ti)!\u0019\u0003\t\u0019KG.\u001a\u0005\t\u0003W\n\t\t1\u0001\u0002\n\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015!D3oGJL\b\u000f^*ue&tw\rF\u0002p\u0003/Cq!a\u0017\u0002\u0012\u0002\u0007q\u000eC\u0004\u0002\u001c\u0002!\t!!(\u0002\u000f\u0015t7M]=qiRY10a(\u0002$\u0006\u0015\u0016\u0011VAW\u0011!\t\t+!'A\u0002\u0005u\u0013\u0001\u00023bi\u0006D\u0001\"a\u001b\u0002\u001a\u0002\u0007\u0011Q\u000e\u0005\b\u0003O\u000bI\n1\u0001p\u0003!1\u0017\u000e\\3OC6,\u0007bBAV\u00033\u0003\rAL\u0001\u0005g&TX\rC\u0005\u00020\u0006e\u0005\u0013!a\u0001u\u00059A.Y:u\u001b>$\u0007bBAZ\u0001\u0011\u0005\u0011QW\u0001\u0007g\u00064X\rV8\u0015\u0007m\f9\f\u0003\u0005\u0002l\u0005E\u0006\u0019AA7\u0011)\tY\f\u0001EC\u0002\u0013\u0005\u0013QX\u0001\ti>\u001cFO]5oOV\tq\u000eC\u0005\u0002B\u0002A\t\u0011)Q\u0005_\u0006IAo\\*ue&tw\r\t\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u000f\f\u0011#\u001a8def\u0004H\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tIMK\u0002;\u0003\u0017\\#!!4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/d\u0011AC1o]>$\u0018\r^5p]&!\u00111\\Ai\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\b\u0003?\u0014\u0001\u0012AAq\u0003%\u0001VO\u00197jG.+\u0017\u0010E\u0002\u0012\u0003G4a!\u0001\u0002\t\u0002\u0005\u00158cAAr\u0015!9q%a9\u0005\u0002\u0005%HCAAq\u0011!\ti/a9\u0005\u0002\u0005=\u0018!B1qa2LHcA\u0015\u0002r\"1\u0001$a;A\u0002iA\u0001\"!>\u0002d\u0012\r\u0011q_\u0001\u0007k:<(/\u00199\u0015\u0007i\tI\u0010C\u0004\u0002|\u0006M\b\u0019A\u0015\u0002\u0007-,\u0017\u0010")
public class PublicKey
implements PublicKeyLike,
StreamingSaveable {
    private final PGPPublicKey nested;
    private String toString;
    private volatile PublicKey$userIDs$ userIDs$module;
    private volatile PublicKey$signatures$ signatures$module;
    private volatile boolean bitmap$0;

    public static PGPPublicKey unwrap(PublicKey publicKey) {
        return PublicKey$.MODULE$.unwrap(publicKey);
    }

    public static PublicKey apply(PGPPublicKey pGPPublicKey) {
        return PublicKey$.MODULE$.apply(pGPPublicKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicKey$userIDs$ userIDs$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.userIDs$module != null) return this.userIDs$module;
            this.userIDs$module = new PublicKey$userIDs$(this);
            return this.userIDs$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicKey$signatures$ signatures$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (this.signatures$module != null) return this.signatures$module;
            this.signatures$module = new PublicKey$signatures$(this);
            return this.signatures$module;
        }
    }

    private String toString$lzycompute() {
        PublicKey publicKey = this;
        synchronized (publicKey) {
            if (!this.bitmap$0) {
                this.toString = new StringOps(Predef$.MODULE$.augmentString("PublicKey(%x, %s, %s@%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.keyID()), this.userIDs().mkString(","), this.algorithmName(), BoxesRunTime.boxToInteger((int)this.bitStrength())}));
                this.bitmap$0 = true;
            }
            return this.toString;
        }
    }

    @Override
    public void saveToFile(File file) {
        StreamingSaveable$class.saveToFile(this, file);
    }

    @Override
    public String saveToString() {
        return StreamingSaveable$class.saveToString(this);
    }

    @Override
    public final boolean verifyMessageFile(File input, File output) {
        return PublicKeyLike$class.verifyMessageFile(this, input, output);
    }

    @Override
    public final String verifyMessageString(String input) {
        return PublicKeyLike$class.verifyMessageString(this, input);
    }

    @Override
    public final boolean verifySignatureFile(File raw, File signature) {
        return PublicKeyLike$class.verifySignatureFile(this, raw, signature);
    }

    @Override
    public final boolean verifySignatureString(String msg, String signature) {
        return PublicKeyLike$class.verifySignatureString(this, msg, signature);
    }

    @Override
    public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey2) {
        return PublicKeyLike$class.verifyMessageStreamHelper(this, input, output, getKey2);
    }

    @Override
    public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey2) {
        return PublicKeyLike$class.verifySignatureStreamsHelper(this, msg, signature, getKey2);
    }

    public PGPPublicKey nested() {
        return this.nested;
    }

    public long keyID() {
        return this.nested().getKeyID();
    }

    public int bitStrength() {
        return this.nested().getBitStrength();
    }

    public Date creationTime() {
        return this.nested().getCreationTime();
    }

    public byte[] fingerprint() {
        return this.nested().getFingerprint();
    }

    public boolean isRevoked() {
        return this.nested().isRevoked();
    }

    public int algorithm() {
        return this.nested().getAlgorithm();
    }

    public String algorithmName() {
        String string;
        int n = this.nested().getAlgorithm();
        switch (n) {
            default: {
                string = "Unknown";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 18: {
                string = "EC";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "RSA";
            }
        }
        return string;
    }

    public PublicKey$userIDs$ userIDs() {
        return this.userIDs$module == null ? this.userIDs$lzycompute() : this.userIDs$module;
    }

    public PublicKey$signatures$ signatures() {
        return this.signatures$module == null ? this.signatures$lzycompute() : this.signatures$module;
    }

    public Traversable<Signature> signaturesForId(String id) {
        return new Traversable<Signature>(this, id){
            private final /* synthetic */ PublicKey $outer;
            private final String id$1;

            public GenericCompanion<Traversable> companion() {
                return Traversable.class.companion((Traversable)this);
            }

            public Traversable<Signature> seq() {
                return Traversable.class.seq((Traversable)this);
            }

            public Builder<Signature, Traversable<Signature>> newBuilder() {
                return GenericTraversableTemplate.class.newBuilder((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, Traversable<B>> genericBuilder() {
                return GenericTraversableTemplate.class.genericBuilder((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<Traversable<A1>, Traversable<A2>> unzip(Function1<Signature, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.class.unzip((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Traversable<A1>, Traversable<A2>, Traversable<A3>> unzip3(Function1<Signature, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.class.unzip3((GenericTraversableTemplate)this, asTriple);
            }

            public <B> Traversable<B> flatten(Function1<Signature, GenTraversableOnce<B>> asTraversable) {
                return GenericTraversableTemplate.class.flatten((GenericTraversableTemplate)this, asTraversable);
            }

            public <B> Traversable<Traversable<B>> transpose(Function1<Signature, GenTraversableOnce<B>> asTraversable) {
                return GenericTraversableTemplate.class.transpose((GenericTraversableTemplate)this, asTraversable);
            }

            public Traversable<Signature> repr() {
                return TraversableLike.class.repr((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.class.isTraversableAgain((TraversableLike)this);
            }

            public Traversable<Signature> thisCollection() {
                return TraversableLike.class.thisCollection((TraversableLike)this);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Traversable toCollection(Object repr) {
                return TraversableLike.class.toCollection((TraversableLike)this, (Object)repr);
            }

            public Combiner<Signature, ParIterable<Signature>> parCombiner() {
                return TraversableLike.class.parCombiner((TraversableLike)this);
            }

            public boolean isEmpty() {
                return TraversableLike.class.isEmpty((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.class.hasDefiniteSize((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<Signature, B> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.map((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<Signature, GenTraversableOnce<B>> f, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.flatMap((TraversableLike)this, f, bf);
            }

            public Traversable<Signature> filter(Function1<Signature, Object> p) {
                return TraversableLike.class.filter((TraversableLike)this, p);
            }

            public Traversable<Signature> filterNot(Function1<Signature, Object> p) {
                return TraversableLike.class.filterNot((TraversableLike)this, p);
            }

            public <B, That> That collect(PartialFunction<Signature, B> pf, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.collect((TraversableLike)this, pf, bf);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> partition(Function1<Signature, Object> p) {
                return TraversableLike.class.partition((TraversableLike)this, p);
            }

            public <K> Map<K, Traversable<Signature>> groupBy(Function1<Signature, K> f) {
                return TraversableLike.class.groupBy((TraversableLike)this, f);
            }

            public boolean forall(Function1<Signature, Object> p) {
                return TraversableLike.class.forall((TraversableLike)this, p);
            }

            public boolean exists(Function1<Signature, Object> p) {
                return TraversableLike.class.exists((TraversableLike)this, p);
            }

            public Option<Signature> find(Function1<Signature, Object> p) {
                return TraversableLike.class.find((TraversableLike)this, p);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> cbf) {
                return (That)TraversableLike.class.scan((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, Signature, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.scanLeft((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<Signature, B, B> op, CanBuildFrom<Traversable<Signature>, B, That> bf) {
                return (That)TraversableLike.class.scanRight((TraversableLike)this, z, op, bf);
            }

            public Object head() {
                return TraversableLike.class.head((TraversableLike)this);
            }

            public Option<Signature> headOption() {
                return TraversableLike.class.headOption((TraversableLike)this);
            }

            public Traversable<Signature> tail() {
                return TraversableLike.class.tail((TraversableLike)this);
            }

            public Object last() {
                return TraversableLike.class.last((TraversableLike)this);
            }

            public Option<Signature> lastOption() {
                return TraversableLike.class.lastOption((TraversableLike)this);
            }

            public Traversable<Signature> init() {
                return TraversableLike.class.init((TraversableLike)this);
            }

            public Traversable<Signature> take(int n) {
                return TraversableLike.class.take((TraversableLike)this, (int)n);
            }

            public Traversable<Signature> drop(int n) {
                return TraversableLike.class.drop((TraversableLike)this, (int)n);
            }

            public Traversable<Signature> slice(int from, int until) {
                return TraversableLike.class.slice((TraversableLike)this, (int)from, (int)until);
            }

            public Traversable<Signature> sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.class.sliceWithKnownDelta((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Traversable<Signature> sliceWithKnownBound(int from, int until) {
                return TraversableLike.class.sliceWithKnownBound((TraversableLike)this, (int)from, (int)until);
            }

            public Traversable<Signature> takeWhile(Function1<Signature, Object> p) {
                return TraversableLike.class.takeWhile((TraversableLike)this, p);
            }

            public Traversable<Signature> dropWhile(Function1<Signature, Object> p) {
                return TraversableLike.class.dropWhile((TraversableLike)this, p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> span(Function1<Signature, Object> p) {
                return TraversableLike.class.span((TraversableLike)this, p);
            }

            public Tuple2<Traversable<Signature>, Traversable<Signature>> splitAt(int n) {
                return TraversableLike.class.splitAt((TraversableLike)this, (int)n);
            }

            public Iterator<Traversable<Signature>> tails() {
                return TraversableLike.class.tails((TraversableLike)this);
            }

            public Iterator<Traversable<Signature>> inits() {
                return TraversableLike.class.inits((TraversableLike)this);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                TraversableLike.class.copyToArray((TraversableLike)this, (Object)xs, (int)start, (int)len);
            }

            public Traversable<Signature> toTraversable() {
                return TraversableLike.class.toTraversable((TraversableLike)this);
            }

            public Iterator<Signature> toIterator() {
                return TraversableLike.class.toIterator((TraversableLike)this);
            }

            public Stream<Signature> toStream() {
                return TraversableLike.class.toStream((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Signature, Col> cbf) {
                return (Col)TraversableLike.class.to((TraversableLike)this, cbf);
            }

            public String toString() {
                return TraversableLike.class.toString((TraversableLike)this);
            }

            public String stringPrefix() {
                return TraversableLike.class.stringPrefix((TraversableLike)this);
            }

            public Object view() {
                return TraversableLike.class.view((TraversableLike)this);
            }

            public TraversableView<Signature, Traversable<Signature>> view(int from, int until) {
                return TraversableLike.class.view((TraversableLike)this, (int)from, (int)until);
            }

            public FilterMonadic<Signature, Traversable<Signature>> withFilter(Function1<Signature, Object> p) {
                return TraversableLike.class.withFilter((TraversableLike)this, p);
            }

            public ParIterable<Signature> par() {
                return Parallelizable.class.par((Parallelizable)this);
            }

            public List<Signature> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<Signature, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Signature, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Signature, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Signature, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Signature, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Signature, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Signature, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Signature, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, Signature, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> Signature min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> Signature max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> Signature maxBy(Function1<Signature, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> Signature minBy(Function1<Signature, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<Signature> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<Signature> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<Signature> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<Signature> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<Signature> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Signature, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            public <U> void foreach(Function1<Signature, U> f) {
                java.util.Iterator i = this.$outer.nested().getSignaturesForID(this.id$1);
                while (i.hasNext()) {
                    f.apply((Object)Signature$.MODULE$.apply((PGPSignature)i.next()));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.id$1 = id$1;
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Parallelizable.class.$init$((Parallelizable)this);
                TraversableLike.class.$init$((TraversableLike)this);
                GenericTraversableTemplate.class.$init$((GenericTraversableTemplate)this);
                GenTraversable.class.$init$((GenTraversable)this);
                Traversable.class.$init$((Traversable)this);
            }
        };
    }

    public Traversable<Signature> directKeySignatures() {
        return this.signatures().view().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Signature x$1) {
                return x$1.signatureType() == 31;
            }
        });
    }

    @Override
    public boolean verifyMessageStream(InputStream input, OutputStream output) {
        return this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PublicKey $outer;

            public final PGPPublicKey apply(long id) {
                Predef$.MODULE$.assert(id == this.$outer.keyID());
                return this.$outer.nested();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean verifySignatureStreams(InputStream msg, InputStream signature) {
        return this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PublicKey $outer;

            public final PGPPublicKey apply(long id) {
                if (this.$outer.keyID() != id) {
                    throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Signature is not for this key.  %x != %x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), BoxesRunTime.boxToLong((long)this.$outer.keyID())})));
                }
                return this.$outer.nested();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void encryptFile(File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            this.encrypt(in, out, input.getName(), input.length(), new Date(input.lastModified()));
            return;
        }
        finally {
            in.close();
            out.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String encryptString(String input) {
        byte[] bytes = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encrypt(in, out, "", bytes.length, new Date());
        }
        catch (Throwable throwable) {
            void var4_4;
            void var3_3;
            var3_3.close();
            var4_4.close();
            throw throwable;
        }
        in.close();
        out.close();
        return out.toString(Charset.defaultCharset().name());
    }

    public void encrypt(InputStream data, OutputStream output, String fileName, long size, Date lastMod) {
        ArmoredOutputStream aout = new ArmoredOutputStream(output);
        byte[] bytes = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        SecureRandom rand = new SecureRandom();
        Provider provider = Security.getProvider("BC");
        int encAlgorithm = 3;
        boolean withIntegrityPacket = true;
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(encAlgorithm).setWithIntegrityPacket(withIntegrityPacket).setSecureRandom(rand).setProvider(provider);
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.nested()).setProvider(provider).setSecureRandom(rand));
        OutputStream cOut = encGen.open((OutputStream)aout, new byte[1024]);
        PGPLiteralDataGenerator lit = new PGPLiteralDataGenerator();
        OutputStream lOut = lit.open(cOut, 'b', fileName, size, lastMod);
        byte[] buffer = new byte[1024];
        this.read$1(data, lOut, buffer);
        lit.close();
        cOut.close();
        aout.close();
        data.close();
    }

    public Date encrypt$default$5() {
        return new Date();
    }

    @Override
    public void saveTo(OutputStream output) {
        ArmoredOutputStream armoredOut = new ArmoredOutputStream(output);
        this.nested().encode((OutputStream)armoredOut);
        armoredOut.close();
    }

    public String toString() {
        return this.bitmap$0 ? this.toString : this.toString$lzycompute();
    }

    private final void read$1(InputStream data$1, OutputStream lOut$1, byte[] buffer$1) {
        while (true) {
            int n = data$1.read(buffer$1);
            switch (n) {
                default: 
            }
            if (n <= 0) break;
            lOut$1.write(buffer$1, 0, n);
        }
    }

    public PublicKey(PGPPublicKey nested) {
        this.nested = nested;
        PublicKeyLike$class.$init$(this);
        StreamingSaveable$class.$init$(this);
    }
}

