/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LongestCommonSubsequenceDistanceTest {
    private static LongestCommonSubsequenceDistance subject;

    @BeforeAll
    public static void setup() {
        subject = new LongestCommonSubsequenceDistance();
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistance() {
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)4, (Integer)subject.apply((CharSequence)"left", (CharSequence)""));
        Assertions.assertEquals((int)5, (Integer)subject.apply((CharSequence)"", (CharSequence)"right"));
        Assertions.assertEquals((int)1, (Integer)subject.apply((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((int)6, (Integer)subject.apply((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((int)11, (Integer)subject.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((int)7, (Integer)subject.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        Assertions.assertEquals((int)4, (Integer)subject.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        Assertions.assertEquals((int)9, (Integer)subject.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        Assertions.assertEquals((int)3, (Integer)subject.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        Assertions.assertEquals((int)7, (Integer)subject.apply((CharSequence)"left", (CharSequence)"right"));
        Assertions.assertEquals((int)9, (Integer)subject.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        Assertions.assertEquals((int)0, (Integer)subject.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply(null, null));
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply(null, (CharSequence)"right"));
    }

    @Test
    public void testGettingLongestCommonSubsequenceDistanceStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> subject.apply((CharSequence)" ", null));
    }
}

