/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;

public class AuthorizationHandler {
    static final String F_KEYRING = ".keyring";
    private static AuthorizationDatabase keyring = null;
    private static long keyringTimeStamp;
    private static String keyringFile;
    private static String password;

    static {
        keyringFile = null;
        password = "";
    }

    private static void loadKeyring() throws CoreException {
        if (keyring != null && new File(keyringFile).lastModified() == keyringTimeStamp) {
            return;
        }
        if (keyringFile == null) {
            File file = new File(String.valueOf(InternalPlatform.getDefault().getConfigurationLocation().getURL().getPath()) + '/' + "org.eclipse.core.runtime");
            file = new File(file, F_KEYRING);
            keyringFile = file.getAbsolutePath();
        }
        try {
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        catch (CoreException e) {
            InternalPlatform.getDefault().log(e.getStatus());
        }
        if (keyring == null) {
            new File(keyringFile).delete();
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    public static void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addAuthorizationInfo(serverUrl, realm, authScheme, new HashMap(info));
        keyring.save();
    }

    public static void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addProtectionSpace(resourceUrl, realm);
        keyring.save();
    }

    public static void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.flushAuthorizationInfo(serverUrl, realm, authScheme);
        keyring.save();
    }

    public static Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Map info = null;
        try {
            AuthorizationHandler.loadKeyring();
            info = keyring.getAuthorizationInfo(serverUrl, realm, authScheme);
        }
        catch (CoreException coreException) {}
        return info == null ? null : new HashMap(info);
    }

    public static String getProtectionSpace(URL resourceUrl) {
        try {
            AuthorizationHandler.loadKeyring();
        }
        catch (CoreException coreException) {
            return null;
        }
        return keyring.getProtectionSpace(resourceUrl);
    }

    public static void setKeyringFile(String file) {
        if (keyringFile != null) {
            throw new IllegalStateException(Policy.bind("meta.keyringFileAlreadySpecified", keyringFile));
        }
        keyringFile = file;
    }

    public static void setPassword(String keyringPassword) {
        password = keyringPassword;
    }
}

