/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.statics;

import org.aspectj.apache.bcel.classfile.AnnotationDefault;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFieldref;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantMethodref;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Deprecated;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.InnerClass;
import org.aspectj.apache.bcel.classfile.InnerClasses;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.LineNumber;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTypeTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.StackMap;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.verifier.EmptyClassVisitor;
import org.aspectj.apache.bcel.verifier.exc.AssertionViolatedException;

public class StringRepresentation
extends EmptyClassVisitor {
    private String tostring;
    private Node n;

    public StringRepresentation(Node n) {
        this.n = n;
        n.accept((ClassVisitor)this);
    }

    public String toString() {
        if (this.tostring == null) {
            throw new AssertionViolatedException("Please adapt '" + this.getClass() + "' to deal with objects of class '" + this.n.getClass() + "'.");
        }
        return this.tostring;
    }

    private String toString(Node obj) {
        String ret;
        try {
            ret = obj.toString();
        }
        catch (RuntimeException e) {
            String s = obj.getClass().getName();
            s = s.substring(s.lastIndexOf(".") + 1);
            ret = "<<" + s + ">>";
        }
        catch (ClassFormatError e) {
            String s = obj.getClass().getName();
            s = s.substring(s.lastIndexOf(".") + 1);
            ret = "<<" + s + ">>";
        }
        return ret;
    }

    @Override
    public void visitCode(Code obj) {
        this.tostring = "<CODE>";
    }

    @Override
    public void visitCodeException(CodeException obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantClass(ConstantClass obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantDouble(ConstantDouble obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantFloat(ConstantFloat obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantInteger(ConstantInteger obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantLong(ConstantLong obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantPool(ConstantPool obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantString(ConstantString obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitConstantValue(ConstantValue obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitDeprecated(Deprecated obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitExceptionTable(ExceptionTable obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitField(Field obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitInnerClass(InnerClass obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitInnerClasses(InnerClasses obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitJavaClass(JavaClass obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitLineNumber(LineNumber obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitLineNumberTable(LineNumberTable obj) {
        this.tostring = "<LineNumberTable: " + this.toString((Node)obj) + ">";
    }

    @Override
    public void visitLocalVariable(LocalVariable obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable obj) {
        this.tostring = "<LocalVariableTable: " + this.toString((Node)obj) + ">";
    }

    @Override
    public void visitMethod(Method obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitSignature(Signature obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitSourceFile(SourceFile obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitStackMap(StackMap obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitSynthetic(Synthetic obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitUnknown(Unknown obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitRuntimeVisibleAnnotations(RuntimeVisAnnos obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitRuntimeInvisibleAnnotations(RuntimeInvisAnnos obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotations(RuntimeVisParamAnnos obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisParamAnnos obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault obj) {
        this.tostring = this.toString((Node)obj);
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable obj) {
        this.tostring = this.toString((Node)obj);
    }
}

