#
# Execute task commands which are not reports...
#
# $Id: exec.tcl,v 1.20 2011/02/17 16:01:29 rader Exp $
#

###############################################################################
## A wrapper for executing prompted commands...

proc ExecPromptedCommand { } {
  global prompt default_task_cmd cur_task_cmd prev_task_cmd task_id
  global display_mode bug_624_workaround help_filter debug

  set s [.t.ent get]
  if { $debug } { puts "ExecPromptedCommand: prompt=\"$prompt\" command=\"$s\"" }
  .t.ent delete 0 end 
  set p $prompt
  set prompt "" 

  # undo...
  if { $display_mode == "undo" } {
    if { $s == "y" } { 
      ExecUndo
    } else  {
      Feedback "task undo ... no changes made" 
      ReturnToPrevMode
    }
    return
  }

  # ab-ends...
  if { [regexp {^ *[0-9]+ edit} $s] || [regexp {^ *edit} $s] } {
    Feedback "task $s ... aborted ... edit is not supported ... use vi!" 
    Bell
    return
  }
  if { [regexp {^ *ti} $s] } {
    Feedback "task $s ... aborted ... timesheet not supported"
    Bell
    return
  }

  # 'a' add...
  if { $p == "add:" } {
    ExecCommand "add $s"
    focus .t.lb
    return
  }

  # 'A' annotate...
  if { [regexp {^annotate [0-9]+:} $p] } {
    ExecCommand "annotate $task_id $s"
    focus .t.lb
    return
  }

  # 'c' change description...
  if { [regexp {^description [0-9]+:} $p] } {
    ExecCommand "rc.confirmation=no $task_id -- $s"
    focus .t.lb
    return
  }

  # 'C' depends aka child...
  if { [regexp {^depends [0-9]+:} $p] } {
    ExecCommand "$task_id depends:$s"
    focus .t.lb
    return
  }

  # 'D' due date...
  if { [regexp {^due-date [0-9]+:} $p] } {
    ExecCommand "$task_id due:$s"
    focus .t.lb
    return
  }

  # 'f' filter or 'g' grep...
  if { $p == "filter:" || $p == "grep:" } {
    set prev_task_cmd $cur_task_cmd
    set cur_task_cmd "$cur_task_cmd $s"
    Refresh "new-report"
    focus .t.lb
    return
  }

  # 'N' denotate...
  if { [regexp {^denotate [0-9]+:} $p] } {
    ExecCommand "denotate $task_id $s"
    focus .t.lb
    return
  }

  # 'o' log...
  if { $p == "log:" } {
    ExecCommand "log $s"
    focus .t.lb
    return
  }

  # 'p' project...
  if { [regexp {^project [0-9]+:} $p] } {
    ExecCommand "$task_id project:$s"
    focus .t.lb
    return
  }

  # 'q' quit...
  if { $s == "q" || $s == "quit" } {
    exit
  }

  # 't' tag...
  if { [regexp {^tag [0-9]+:} $p] } {
    # should !~ /^\+\S+$/ || /^\-\S+$/ be disallowed here?
    # it would be if this was perl!  carry on...
    ExecCommand "$task_id $s"
    focus .t.lb
    return
  }
  # 'w' wait...
  if { [regexp {^wait [0-9]+:} $p] } {
    ExecCommand "$task_id wait:$s"
    focus .t.lb
    return
  }

  # colon commands...
  if { $p == ":" } { 

    # "\n" refresh...
    if { $s == "" } {
      set cur_task_cmd $default_task_cmd
      Refresh "new-report"
      focus .t.lb
      return
    }

    # ":help FILTER"...
    if { [regexp {^h (.*)} $s junk help_filter] ||
         [regexp {^he (.*)} $s junk help_filter] ||
         [regexp {^hel (.*)} $s junk help_filter] ||
         [regexp {^help (.*)} $s junk help_filter] } { 
      HelpScreen
      focus .t.lb
      return
    }

    # ":help"...
    if { $s == "h" || $s == "he" || $s == "hel" || $s == "help" } { 
      set help_filter ""
      HelpScreen
      focus .t.lb
      return
    }

    # ":quit"...
    if { $s == "q" || $s == "qu" || $s == "qui" || $s == "quit" } { 
      exit
    }

    # ":s/OLD/NEW/" 
    if { [regexp {^s/(.*)/(.*)/$} $s junk old new] } { 
      ExecCommand "$task_id /$old/$new/"
      focus .t.lb
      return
    }
    # ":s/OLD/NEW/g"...
    if { [regexp {^s/(.*)/(.*)/g$} $s junk old new] } { 
      ExecCommand "$task_id /$old/$new/g"
      focus .t.lb
      return
    }

    # ":N" info...
    if { [regexp {(^[0-9]+)$} $s junk t] || 
         [regexp {(^[0-9]+) info$} $s junk t] ||
         [regexp {(^info [0-9]+)$} $s junk t] } { 
      set task_id $t
      DisplayInfo
      focus .t.lb
      return
    }

    # ":undo"...
    if { [regexp {^und} $s] } {
      StartUndo
      return
    }

    # ":N something"... 
    if { [regexp {^[0-9]+ } $s] } {
      ExecCommand "rc.confirmation=no $s"
      focus .t.lb
      return
    }

  }

  # default... assume/hope it's a report...
  set prev_task_cmd $cur_task_cmd
  set cur_task_cmd $s
  Refresh "new-report"
  focus .t.lb
}

###############################################################################
## Execute commands...

proc ExecCommand { cmd } {
  global task task_args task_id bug_624_workaround debug display_mode

  if { $debug } { puts "ExecCommand: display_mode=$display_mode cmd=$task $task_args $cmd" }

  if { $display_mode == "help" || $display_mode == "info" } {
    Bell
    return
  }

  if { [regexp {<} $cmd] } { 
    Feedback "task $cmd ... aborted ... '<' not allowed" 
    return
  }
  if { [regexp {>} $cmd] } { 
    Feedback "task $cmd ... aborted ... '>' not allowed" 
    return
  }
  if { [regexp {\|} $cmd] } { 
    Feedback "task $cmd ... aborted ... '|' not allowed"  
    return
  }

  set refresh 1
  array unset output
  set result ""
  regsub -all {"} $cmd {\"} cmd
  regsub -all {'} $cmd {\'} cmd
  regsub -all {\(} $cmd {\(} cmd
  regsub -all {\)} $cmd {\)} cmd

  # /^!/ confirmation=off/...
  set conf ""
  if { [regsub {^\!} $cmd {} cmd] } {
    set conf " rc.confirmation=off"
  }

  if { [regexp {task-startstop} $cmd] } { 
    Audit "$cmd"
    #if { $debug } { puts "ExecCommand: $cmd" }
    set FD [open "|$cmd"]
  } else { 
    Audit "task$conf $cmd"
    #if { $debug } { puts "ExecCommand: exec $task$conf $task_args rc._forcecolor=off $cmd" }
    set FD [open "|$task$conf $task_args rc._forcecolor=off $cmd"]
  }

  set i 1
  while { [gets $FD l] >= 0 } {
    if { [regexp {^Configuration override} $l] || [regexp {^Using alternate} $l] } { 
      continue
    }
    if { [regexp {will be changed from } $l] ||
         [regexp {will be deleted.} $l] ||
         [regexp {will be set to } $l] ||
         [regexp {The last modification was made} $l] } { 
      set result "task $cmd ... aborted ... confirmation required" 
      flush $FD
      break
    }
    # no longer reached?
    if { [regexp {No command - assuming 'info'} $l] } { 
      set result "task $cmd ... aborted ... info via 'no command' not allowed" 
    }
    set output($i) $l
    incr i
  }
  catch {close $FD} err

  if { $result != "" } { 
    if { $debug } { puts "ExecCommand: result=$result" }
    Feedback $result
    return
  }

  for { set i 1 } { $i <= [array size output] } { incr i } {
    if { $output($i) == "" } { continue; }
    if { [regexp {Usage:} $output($i)] } {
      set result "task $cmd ... usage error"
      break 
    }
    set result "$result $output($i)"
  }

  # munge...
  regsub -all {The project .* has changed.} $result "" result
  regsub -all {Project .* is .* complete .* of .* tasks remaining\).} $result "" result
  regsub -all {^ +} $result "" result
  regsub -all { +$} $result "" result
  regsub -all {  +} $result " " result

  if { [regexp {^add} $cmd] && $bug_624_workaround } {
    Feedback "please wait ... workaround for bug 624 in effect"
  }

  if { [regexp {^Waiting for file lock} $result] } { 
    set result "task $cmd ... failed ... data file is locked"
    set refresh 0
  }
  if { $result == "" } { 
    set result "task $cmd"
  }
  if { $debug } { puts "ExecCommand: result=\"$result\" (pre-munge)" }

  regsub {rc.confirmation=no +} $result {} result
  regsub {rc.confirmation=off +} $result {} result

  Feedback $result
  if { $refresh } { Refresh "new-report" }

}

