#
# Global variables...
#
# $Id: vars.tcl,v 1.19 2011/02/17 14:58:11 rader Exp $
#

# These are Xwindows color specifications which are meant to nicely match
# the default Taskwarrior color scheme when using a green on black terminal...

set color_fg #00cd00               ;# green
set color_bg #000000               ;# black
set color_fg_header #d7d700        ;# dim orange, task color rgb440
set color_fg_footer #d7d700        ;# dim orange, task color rgb440
set color_fg_command_line #cdcd00  ;# dim orange, task color rgb440
set selection_fg_brightness 51     ;# 20% brighter (256*.2 = ~51)
set selection_bg #303030           ;# dark gray, task color gray4
set color_fg_entry_text #dadada    ;# very light gray, task color gray21
set color_fg_feedback #dadada      ;# very light gray, task color gray21
set color_fg_error #d70000         ;# dim red, task color rgb400

# Do alternate colorization of :help lines in #00d700d on #121212...
# dim green on gray, task colors rgb040 on color233... read the "Caveats" 
# file for more information...

set alt_prefix "\x1b\[38;5;2m\x1b\[48;5;233m"
set alt_suffix "\x1b\[0m"

set cols 100         ;# characters
set rows 30          ;# lines
set line_padding 0   ;# pixels
set feedback_wait 8  ;# seconds
set swipe 25         ;# ms
set resize_thres 50  ;# ms
set feedback_centering_fudge 2 ;# characters
set bug_624_workaround 1
set bell 1
set debug 0

#--------------------
# The variables below this line probably shouldn't be changed...

set defaultwidth [expr $cols - 2]
set task_args "rc.verbose=on rc._forcecolor=on rc.defaultwidth=$defaultwidth rc.nag= rc.indent=0"
set win_size [expr $rows - 6]
set win_cur 1
set win_start 1
set prompt ""
set after_id "after#0"
set entered_num ""
set prev_k ""
set feedback ""
set display_mode "report"
set prev_display_mode "report"
set default_task_cmd $system_task_cmd 
set cur_task_cmd $system_task_cmd
set prev_task_cmd $system_task_cmd
set pre_info_task_cmd $cur_task_cmd
set pre_info_win_cur 1
set pre_info_win_start 1
set help_view ""
set help_filter ""
set ignore_exit_status 0
set rc(bind.f1) ""; set rc(bind.f2) "";  set rc(bind.f3) "";  set rc(bind.f4) "";
set rc(bind.f5) ""; set rc(bind.f6) "";  set rc(bind.f7) "";  set rc(bind.f8) "";
set rc(bind.f9) ""; set rc(bind.f10) ""; set rc(bind.f11) ""; set rc(bind.f12) "";
set pid [pid]
set os $tcl_platform(os)
set whoami $env(USER)
if { $whoami == "" } { set whoami $env(user) }
set audit_log "/tmp/vittk-$whoami.log"
set first_resize 1
set last_resize_event [clock clicks -milliseconds]

