/* bindingcommon.c generated by valac 0.56.16, the Vala compiler
 * generated from bindingcommon.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2018 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2018-2024 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */
/* This file depends on keybindingmanager.vala */

#include <glib-object.h>
#include <gdk/gdkx.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BINDING_COMMON (binding_common_get_type ())
#define BINDING_COMMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING_COMMON, BindingCommon))
#define BINDING_COMMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING_COMMON, BindingCommonClass))
#define IS_BINDING_COMMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING_COMMON))
#define IS_BINDING_COMMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING_COMMON))
#define BINDING_COMMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING_COMMON, BindingCommonClass))

typedef struct _BindingCommon BindingCommon;
typedef struct _BindingCommonClass BindingCommonClass;
typedef struct _BindingCommonPrivate BindingCommonPrivate;
typedef enum  {
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING
} BindingCommonKeyEventFuncType;

#define BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE (binding_common_key_event_func_type_get_type ())

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;

#define BINDING_COMMON_TYPE_KEYBINDING (binding_common_keybinding_get_type ())
#define BINDING_COMMON_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding))
#define BINDING_COMMON_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))
#define BINDING_COMMON_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))

typedef struct _BindingCommonKeybinding BindingCommonKeybinding;
typedef struct _BindingCommonKeybindingClass BindingCommonKeybindingClass;
typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _BindingCommonKeybindingPrivate BindingCommonKeybindingPrivate;
enum  {
	BINDING_COMMON_KEYBINDING_0_PROPERTY,
	BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY,
	BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY,
	BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY,
	BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY,
	BINDING_COMMON_KEYBINDING_NUM_PROPERTIES
};
static GParamSpec* binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_NUM_PROPERTIES];
typedef void (*BindingCommonKeybindingFuncHandlerFunc) (GdkEvent* event, gpointer user_data);
typedef struct _ParamSpecBindingCommon ParamSpecBindingCommon;

struct _BindingCommon {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BindingCommonPrivate * priv;
};

struct _BindingCommonClass {
	GTypeClass parent_class;
	void (*finalize) (BindingCommon *self);
};

struct _BindingCommonKeybinding {
	GObject parent_instance;
	BindingCommonKeybindingPrivate * priv;
};

struct _BindingCommonKeybindingClass {
	GObjectClass parent_class;
};

struct _BindingCommonKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	gboolean _reverse;
	BindingCommonKeyEventFuncType _ftype;
};

struct _ParamSpecBindingCommon {
	GParamSpec parent_instance;
};

static gpointer binding_common_parent_class = NULL;
VALA_EXTERN GdkX11Display* binding_common_m_xdisplay;
GdkX11Display* binding_common_m_xdisplay = NULL;
VALA_EXTERN gboolean binding_common_m_default_is_xdisplay;
gboolean binding_common_m_default_is_xdisplay = FALSE;
static gint BindingCommonKeybinding_private_offset;
static gpointer binding_common_keybinding_parent_class = NULL;

VALA_EXTERN gpointer binding_common_ref (gpointer instance);
VALA_EXTERN void binding_common_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_binding_common (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_binding_common (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_binding_common (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_binding_common (const GValue* value);
VALA_EXTERN GType binding_common_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BindingCommon, binding_common_unref)
VALA_EXTERN GType binding_common_key_event_func_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType keybinding_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (KeybindingManager, g_object_unref)
VALA_EXTERN GType binding_common_keybinding_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BindingCommonKeybinding, g_object_unref)
VALA_EXTERN void binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                             GList** keybindings,
                                             const gchar* accelerator,
                                             BindingCommonKeyEventFuncType ftype,
                                             KeybindingManagerKeybindingHandlerFunc handler_normal,
                                             gpointer handler_normal_target,
                                             KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                             gpointer handler_reverse_target);
VALA_EXTERN BindingCommonKeybinding* binding_common_keybinding_new (guint keysym,
                                                        GdkModifierType modifiers,
                                                        gboolean reverse,
                                                        BindingCommonKeyEventFuncType ftype);
VALA_EXTERN BindingCommonKeybinding* binding_common_keybinding_construct (GType object_type,
                                                              guint keysym,
                                                              GdkModifierType modifiers,
                                                              gboolean reverse,
                                                              BindingCommonKeyEventFuncType ftype);
VALA_EXTERN gboolean binding_common_default_is_xdisplay (void);
VALA_EXTERN gboolean keybinding_manager_bind (KeybindingManager* self,
                                  guint keysym,
                                  GdkModifierType modifiers,
                                  KeybindingManagerKeybindingHandlerFunc handler,
                                  gpointer handler_target);
VALA_EXTERN void binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                            GList* keybindings);
VALA_EXTERN KeybindingManager* keybinding_manager_get_instance (void);
VALA_EXTERN BindingCommonKeyEventFuncType binding_common_keybinding_get_ftype (BindingCommonKeybinding* self);
VALA_EXTERN void keybinding_manager_unbind (KeybindingManager* self,
                                guint keysym,
                                GdkModifierType modifiers);
VALA_EXTERN guint binding_common_keybinding_get_keysym (BindingCommonKeybinding* self);
VALA_EXTERN GdkModifierType binding_common_keybinding_get_modifiers (BindingCommonKeybinding* self);
VALA_EXTERN void binding_common_set_custom_font (GSettings* settings_panel,
                                     GSettings* settings_emoji,
                                     GtkCssProvider** css_provider);
VALA_EXTERN void ibus_emojier_set_emoji_font (const gchar* emoji_font);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void binding_common_set_custom_theme (GSettings* settings_panel);
VALA_EXTERN void binding_common_set_custom_icon (GSettings* settings_panel);
VALA_EXTERN GdkX11Display* binding_common_get_xdisplay (void);
VALA_EXTERN BindingCommon* binding_common_new (void);
VALA_EXTERN BindingCommon* binding_common_construct (GType object_type);
VALA_EXTERN void binding_common_keybinding_set_keysym (BindingCommonKeybinding* self,
                                           guint value);
VALA_EXTERN void binding_common_keybinding_set_modifiers (BindingCommonKeybinding* self,
                                              GdkModifierType value);
VALA_EXTERN void binding_common_keybinding_set_reverse (BindingCommonKeybinding* self,
                                            gboolean value);
VALA_EXTERN void binding_common_keybinding_set_ftype (BindingCommonKeybinding* self,
                                          BindingCommonKeyEventFuncType value);
VALA_EXTERN gboolean binding_common_keybinding_get_reverse (BindingCommonKeybinding* self);
static void binding_common_keybinding_finalize (GObject * obj);
static GType binding_common_keybinding_get_type_once (void);
static void _vala_binding_common_keybinding_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_binding_common_keybinding_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void binding_common_finalize (BindingCommon * obj);
static GType binding_common_get_type_once (void);

static GType
binding_common_key_event_func_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY", "any"}, {BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER", "ime-switcher"}, {BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING", "emoji-typing"}, {0, NULL, NULL}};
	GType binding_common_key_event_func_type_type_id;
	binding_common_key_event_func_type_type_id = g_enum_register_static ("BindingCommonKeyEventFuncType", values);
	return binding_common_key_event_func_type_type_id;
}

GType
binding_common_key_event_func_type_get_type (void)
{
	static volatile gsize binding_common_key_event_func_type_type_id__once = 0;
	if (g_once_init_enter (&binding_common_key_event_func_type_type_id__once)) {
		GType binding_common_key_event_func_type_type_id;
		binding_common_key_event_func_type_type_id = binding_common_key_event_func_type_get_type_once ();
		g_once_init_leave (&binding_common_key_event_func_type_type_id__once, binding_common_key_event_func_type_type_id);
	}
	return binding_common_key_event_func_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                        GList** keybindings,
                                        const gchar* accelerator,
                                        BindingCommonKeyEventFuncType ftype,
                                        KeybindingManagerKeybindingHandlerFunc handler_normal,
                                        gpointer handler_normal_target,
                                        KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                        gpointer handler_reverse_target)
{
	guint switch_keysym = 0U;
	GdkModifierType switch_modifiers = 0U;
	GdkModifierType reverse_modifier = 0U;
	BindingCommonKeybinding* keybinding = NULL;
	guint _tmp0_ = 0U;
	GdkModifierType _tmp1_ = 0U;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	gboolean _tmp4_ = FALSE;
	BindingCommonKeybinding* _tmp5_;
	BindingCommonKeybinding* _tmp6_;
	BindingCommonKeybinding* _tmp7_;
	gboolean is_wayland = FALSE;
	BindingCommonKeybinding* _tmp8_;
	BindingCommonKeybinding* _tmp9_;
	BindingCommonKeybinding* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (keybinding_manager != NULL);
	switch_keysym = (guint) 0;
	switch_modifiers = 0;
	reverse_modifier = GDK_SHIFT_MASK;
	gtk_accelerator_parse (accelerator, &_tmp0_, &_tmp1_);
	switch_keysym = _tmp0_;
	switch_modifiers = _tmp1_;
	if ((switch_modifiers & VIRTUAL_MODIFIERS) != 0) {
		GdkDisplay* _tmp2_;
		GdkKeymap* _tmp3_;
		_tmp2_ = gdk_display_get_default ();
		_tmp3_ = gdk_keymap_get_for_display (_tmp2_);
		gdk_keymap_map_virtual_modifiers (_tmp3_, &switch_modifiers);
		switch_modifiers &= ~VIRTUAL_MODIFIERS;
	}
	if (switch_keysym == ((guint) 0)) {
		_tmp4_ = switch_modifiers == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		g_warning ("bindingcommon.vala:92: Parse accelerator '%s' failed!", accelerator);
		_g_object_unref0 (keybinding);
		return;
	}
	_tmp5_ = binding_common_keybinding_new (switch_keysym, switch_modifiers, FALSE, ftype);
	_g_object_unref0 (keybinding);
	keybinding = _tmp5_;
	_tmp6_ = keybinding;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	*keybindings = g_list_append (*keybindings, _tmp7_);
	is_wayland = FALSE;
	if (!binding_common_default_is_xdisplay ()) {
		is_wayland = TRUE;
	}
	if (!is_wayland) {
		keybinding_manager_bind (keybinding_manager, switch_keysym, switch_modifiers, handler_normal, handler_normal_target);
	}
	if (ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING) {
		_g_object_unref0 (keybinding);
		return;
	}
	if ((switch_modifiers & reverse_modifier) != 0) {
		_g_object_unref0 (keybinding);
		return;
	}
	switch_modifiers |= reverse_modifier;
	_tmp8_ = binding_common_keybinding_new (switch_keysym, switch_modifiers, TRUE, ftype);
	_g_object_unref0 (keybinding);
	keybinding = _tmp8_;
	_tmp9_ = keybinding;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	*keybindings = g_list_append (*keybindings, _tmp10_);
	if (!is_wayland) {
		_tmp11_ = ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		keybinding_manager_bind (keybinding_manager, switch_keysym, switch_modifiers, handler_reverse, handler_reverse_target);
	}
	_g_object_unref0 (keybinding);
	return;
}

void
binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                       GList* keybindings)
{
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp0_;
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	while (TRUE) {
		BindingCommonKeybinding* keybinding = NULL;
		gconstpointer _tmp1_;
		BindingCommonKeybinding* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GList* _tmp14_;
		if (!(keybindings != NULL)) {
			break;
		}
		_tmp1_ = keybindings->data;
		_tmp2_ = _g_object_ref0 ((BindingCommonKeybinding*) _tmp1_);
		keybinding = _tmp2_;
		if (ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY) {
			_tmp3_ = TRUE;
		} else {
			BindingCommonKeybinding* _tmp4_;
			BindingCommonKeyEventFuncType _tmp5_;
			BindingCommonKeyEventFuncType _tmp6_;
			_tmp4_ = keybinding;
			_tmp5_ = binding_common_keybinding_get_ftype (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = ftype == _tmp6_;
		}
		if (_tmp3_) {
			KeybindingManager* _tmp7_;
			BindingCommonKeybinding* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			BindingCommonKeybinding* _tmp11_;
			GdkModifierType _tmp12_;
			GdkModifierType _tmp13_;
			_tmp7_ = keybinding_manager;
			_tmp8_ = keybinding;
			_tmp9_ = binding_common_keybinding_get_keysym (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = keybinding;
			_tmp12_ = binding_common_keybinding_get_modifiers (_tmp11_);
			_tmp13_ = _tmp12_;
			keybinding_manager_unbind (_tmp7_, _tmp10_, _tmp13_);
		}
		_tmp14_ = keybindings->next;
		keybindings = _tmp14_;
		_g_object_unref0 (keybinding);
	}
	_g_object_unref0 (keybinding_manager);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
binding_common_set_custom_font (GSettings* settings_panel,
                                GSettings* settings_emoji,
                                GtkCssProvider** css_provider)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	gboolean use_custom_font = FALSE;
	gchar* custom_font = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	PangoFontDescription* font_desc = NULL;
	const gchar* _tmp14_;
	PangoFontDescription* _tmp15_;
	gchar* font_family = NULL;
	PangoFontDescription* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gint font_size = 0;
	PangoFontDescription* _tmp19_;
	gchar* data = NULL;
	gboolean _tmp20_ = FALSE;
	GtkCssProvider* _tmp26_;
	GdkScreen* _tmp31_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	screen = _tmp6_;
	_tmp7_ = screen;
	if (_tmp7_ == NULL) {
		g_warning ("bindingcommon.vala:160: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	if (settings_emoji != NULL) {
		gchar* emoji_font = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = g_settings_get_string (settings_emoji, "font");
		emoji_font = _tmp8_;
		_tmp9_ = emoji_font;
		if (_tmp9_ == NULL) {
			g_warning ("bindingcommon.vala:167: No config emoji:font.");
			_g_free0 (emoji_font);
			_g_object_unref0 (screen);
			_g_object_unref0 (display);
			return;
		}
		_tmp10_ = emoji_font;
		ibus_emojier_set_emoji_font (_tmp10_);
		_g_free0 (emoji_font);
	}
	if (settings_panel == NULL) {
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	use_custom_font = g_settings_get_boolean (settings_panel, "use-custom-font");
	if ((*css_provider) != NULL) {
		GdkScreen* _tmp11_;
		_tmp11_ = screen;
		gtk_style_context_remove_provider_for_screen (_tmp11_, (GtkStyleProvider*) (*css_provider));
		_g_object_unref0 (*css_provider);
		*css_provider = NULL;
	}
	if (use_custom_font == FALSE) {
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp12_ = g_settings_get_string (settings_panel, "custom-font");
	custom_font = _tmp12_;
	_tmp13_ = custom_font;
	if (_tmp13_ == NULL) {
		g_warning ("bindingcommon.vala:190: No config panel:custom-font.");
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp14_ = custom_font;
	_tmp15_ = pango_font_description_from_string (_tmp14_);
	font_desc = _tmp15_;
	_tmp16_ = font_desc;
	_tmp17_ = pango_font_description_get_family (_tmp16_);
	_tmp18_ = g_strdup (_tmp17_);
	font_family = _tmp18_;
	_tmp19_ = font_desc;
	font_size = pango_font_description_get_size (_tmp19_) / PANGO_SCALE;
	if (GTK_MAJOR_VERSION < 3) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		if (GTK_MAJOR_VERSION == 3) {
			_tmp21_ = GTK_MINOR_VERSION < 20;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp20_ = _tmp21_;
	}
	if (_tmp20_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = custom_font;
		_tmp23_ = g_strdup_printf ("GtkLabel { font: %s; }", _tmp22_);
		_g_free0 (data);
		data = _tmp23_;
	} else {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp24_ = font_family;
		_tmp25_ = g_strdup_printf ("label { font-family: %s; font-size: %dpt; }", _tmp24_, font_size);
		_g_free0 (data);
		data = _tmp25_;
	}
	_tmp26_ = gtk_css_provider_new ();
	_g_object_unref0 (*css_provider);
	*css_provider = _tmp26_;
	{
		const gchar* _tmp27_;
		_tmp27_ = data;
		gtk_css_provider_load_from_data (*css_provider, _tmp27_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = custom_font;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("bindingcommon.vala:213: Failed css_provider_from_data: %s: %s", _tmp28_, _tmp30_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp31_ = screen;
	gtk_style_context_add_provider_for_screen (_tmp31_, (GtkStyleProvider*) (*css_provider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (font_family);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_free0 (custom_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}

void
binding_common_set_custom_theme (GSettings* settings_panel)
{
	gboolean use_custom_theme = FALSE;
	gchar* custom_theme = NULL;
	gchar* _tmp0_;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	if (settings_panel == NULL) {
		return;
	}
	use_custom_theme = g_settings_get_boolean (settings_panel, "use-custom-theme");
	_tmp0_ = g_settings_get_string (settings_panel, "custom-theme");
	custom_theme = _tmp0_;
	_tmp1_ = gtk_settings_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_settings = _tmp2_;
	if (use_custom_theme == FALSE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (custom_theme);
		custom_theme = _tmp3_;
	}
	_tmp5_ = custom_theme;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = custom_theme;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp4_) {
		GtkSettings* _tmp7_;
		_tmp7_ = gtk_settings;
		gtk_settings_reset_property (_tmp7_, "gtk-theme-name");
	} else {
		GtkSettings* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = gtk_settings;
		_tmp9_ = custom_theme;
		g_object_set (_tmp8_, "gtk-theme-name", _tmp9_, NULL);
	}
	_g_object_unref0 (gtk_settings);
	_g_free0 (custom_theme);
}

void
binding_common_set_custom_icon (GSettings* settings_panel)
{
	gboolean use_custom_icon = FALSE;
	gchar* custom_icon = NULL;
	gchar* _tmp0_;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	if (settings_panel == NULL) {
		return;
	}
	use_custom_icon = g_settings_get_boolean (settings_panel, "use-custom-icon");
	_tmp0_ = g_settings_get_string (settings_panel, "custom-icon");
	custom_icon = _tmp0_;
	_tmp1_ = gtk_settings_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_settings = _tmp2_;
	if (use_custom_icon == FALSE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (custom_icon);
		custom_icon = _tmp3_;
	}
	_tmp5_ = custom_icon;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = custom_icon;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp4_) {
		GtkSettings* _tmp7_;
		_tmp7_ = gtk_settings;
		gtk_settings_reset_property (_tmp7_, "gtk-icon-theme-name");
	} else {
		GtkSettings* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = gtk_settings;
		_tmp9_ = custom_icon;
		g_object_set (_tmp8_, "gtk-icon-theme-name", _tmp9_, NULL);
	}
	_g_object_unref0 (gtk_settings);
	_g_free0 (custom_icon);
}

gboolean
binding_common_default_is_xdisplay (void)
{
	GdkX11Display* _tmp0_;
	gboolean result;
	_tmp0_ = binding_common_m_xdisplay;
	if (_tmp0_ == NULL) {
		GdkX11Display* _tmp1_;
		GdkX11Display* _tmp2_;
		_tmp1_ = binding_common_get_xdisplay ();
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
	}
	result = binding_common_m_default_is_xdisplay;
	return result;
}

GdkX11Display*
binding_common_get_xdisplay (void)
{
	GdkX11Display* _tmp0_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkDisplay* _tmp5_;
	GType instance_type = 0UL;
	GdkDisplay* _tmp6_;
	GType x11_type = 0UL;
	GdkDisplayManager* _tmp11_;
	GdkDisplay* _tmp12_;
	GdkX11Display* _tmp13_;
	GdkX11Display* _tmp14_;
	GdkX11Display* _tmp15_;
	GdkX11Display* result;
	_tmp0_ = binding_common_m_xdisplay;
	if (_tmp0_ != NULL) {
		GdkX11Display* _tmp1_;
		GdkX11Display* _tmp2_;
		_tmp1_ = binding_common_m_xdisplay;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	display = _tmp4_;
	_tmp5_ = display;
	if (_tmp5_ == NULL) {
		g_error ("bindingcommon.vala:271: You should open a display for IBus panel.");
	}
	_tmp6_ = display;
	instance_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp6_);
	x11_type = gdk_x11_display_get_type ();
	if (g_type_is_a (instance_type, x11_type)) {
		GdkDisplay* _tmp7_;
		GdkX11Display* _tmp8_;
		GdkX11Display* _tmp9_;
		GdkX11Display* _tmp10_;
		binding_common_m_default_is_xdisplay = TRUE;
		_tmp7_ = display;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gdk_x11_display_get_type (), GdkX11Display));
		_g_object_unref0 (binding_common_m_xdisplay);
		binding_common_m_xdisplay = _tmp8_;
		_tmp9_ = binding_common_m_xdisplay;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (display);
		return result;
	}
	gdk_set_allowed_backends ("x11");
	_tmp11_ = gdk_display_manager_get ();
	_tmp12_ = gdk_display_manager_open_display (_tmp11_, NULL);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gdk_x11_display_get_type (), GdkX11Display));
	_g_object_unref0 (binding_common_m_xdisplay);
	binding_common_m_xdisplay = _tmp13_;
	gdk_set_allowed_backends ("*");
	_tmp14_ = binding_common_m_xdisplay;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (display);
	return result;
}

BindingCommon*
binding_common_construct (GType object_type)
{
	BindingCommon* self = NULL;
	self = (BindingCommon*) g_type_create_instance (object_type);
	return self;
}

BindingCommon*
binding_common_new (void)
{
	return binding_common_construct (TYPE_BINDING_COMMON);
}

static inline gpointer
binding_common_keybinding_get_instance_private (BindingCommonKeybinding* self)
{
	return G_STRUCT_MEMBER_P (self, BindingCommonKeybinding_private_offset);
}

BindingCommonKeybinding*
binding_common_keybinding_construct (GType object_type,
                                     guint keysym,
                                     GdkModifierType modifiers,
                                     gboolean reverse,
                                     BindingCommonKeyEventFuncType ftype)
{
	BindingCommonKeybinding * self = NULL;
	self = (BindingCommonKeybinding*) g_object_new (object_type, NULL);
	binding_common_keybinding_set_keysym (self, keysym);
	binding_common_keybinding_set_modifiers (self, modifiers);
	binding_common_keybinding_set_reverse (self, reverse);
	binding_common_keybinding_set_ftype (self, ftype);
	return self;
}

BindingCommonKeybinding*
binding_common_keybinding_new (guint keysym,
                               GdkModifierType modifiers,
                               gboolean reverse,
                               BindingCommonKeyEventFuncType ftype)
{
	return binding_common_keybinding_construct (BINDING_COMMON_TYPE_KEYBINDING, keysym, modifiers, reverse, ftype);
}

guint
binding_common_keybinding_get_keysym (BindingCommonKeybinding* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_keysym;
	return result;
}

void
binding_common_keybinding_set_keysym (BindingCommonKeybinding* self,
                                      guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = binding_common_keybinding_get_keysym (self);
	if (old_value != value) {
		self->priv->_keysym = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY]);
	}
}

GdkModifierType
binding_common_keybinding_get_modifiers (BindingCommonKeybinding* self)
{
	GdkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_modifiers;
	return result;
}

void
binding_common_keybinding_set_modifiers (BindingCommonKeybinding* self,
                                         GdkModifierType value)
{
	GdkModifierType old_value;
	g_return_if_fail (self != NULL);
	old_value = binding_common_keybinding_get_modifiers (self);
	if (old_value != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY]);
	}
}

gboolean
binding_common_keybinding_get_reverse (BindingCommonKeybinding* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reverse;
	return result;
}

void
binding_common_keybinding_set_reverse (BindingCommonKeybinding* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = binding_common_keybinding_get_reverse (self);
	if (old_value != value) {
		self->priv->_reverse = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY]);
	}
}

BindingCommonKeyEventFuncType
binding_common_keybinding_get_ftype (BindingCommonKeybinding* self)
{
	BindingCommonKeyEventFuncType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ftype;
	return result;
}

void
binding_common_keybinding_set_ftype (BindingCommonKeybinding* self,
                                     BindingCommonKeyEventFuncType value)
{
	BindingCommonKeyEventFuncType old_value;
	g_return_if_fail (self != NULL);
	old_value = binding_common_keybinding_get_ftype (self);
	if (old_value != value) {
		self->priv->_ftype = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY]);
	}
}

static void
binding_common_keybinding_class_init (BindingCommonKeybindingClass * klass,
                                      gpointer klass_data)
{
	binding_common_keybinding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BindingCommonKeybinding_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_binding_common_keybinding_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_binding_common_keybinding_set_property;
	G_OBJECT_CLASS (klass)->finalize = binding_common_keybinding_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY] = g_param_spec_uint ("keysym", "keysym", "keysym", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", gdk_modifier_type_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY] = g_param_spec_boolean ("reverse", "reverse", "reverse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY] = g_param_spec_enum ("ftype", "ftype", "ftype", BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
binding_common_keybinding_instance_init (BindingCommonKeybinding * self,
                                         gpointer klass)
{
	self->priv = binding_common_keybinding_get_instance_private (self);
}

static void
binding_common_keybinding_finalize (GObject * obj)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	G_OBJECT_CLASS (binding_common_keybinding_parent_class)->finalize (obj);
}

static GType
binding_common_keybinding_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BindingCommonKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_common_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingCommonKeybinding), 0, (GInstanceInitFunc) binding_common_keybinding_instance_init, NULL };
	GType binding_common_keybinding_type_id;
	binding_common_keybinding_type_id = g_type_register_static (G_TYPE_OBJECT, "BindingCommonKeybinding", &g_define_type_info, 0);
	BindingCommonKeybinding_private_offset = g_type_add_instance_private (binding_common_keybinding_type_id, sizeof (BindingCommonKeybindingPrivate));
	return binding_common_keybinding_type_id;
}

GType
binding_common_keybinding_get_type (void)
{
	static volatile gsize binding_common_keybinding_type_id__once = 0;
	if (g_once_init_enter (&binding_common_keybinding_type_id__once)) {
		GType binding_common_keybinding_type_id;
		binding_common_keybinding_type_id = binding_common_keybinding_get_type_once ();
		g_once_init_leave (&binding_common_keybinding_type_id__once, binding_common_keybinding_type_id);
	}
	return binding_common_keybinding_type_id__once;
}

static void
_vala_binding_common_keybinding_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	switch (property_id) {
		case BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY:
		g_value_set_uint (value, binding_common_keybinding_get_keysym (self));
		break;
		case BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY:
		g_value_set_flags (value, binding_common_keybinding_get_modifiers (self));
		break;
		case BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY:
		g_value_set_boolean (value, binding_common_keybinding_get_reverse (self));
		break;
		case BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY:
		g_value_set_enum (value, binding_common_keybinding_get_ftype (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_binding_common_keybinding_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	switch (property_id) {
		case BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY:
		binding_common_keybinding_set_keysym (self, g_value_get_uint (value));
		break;
		case BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY:
		binding_common_keybinding_set_modifiers (self, g_value_get_flags (value));
		break;
		case BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY:
		binding_common_keybinding_set_reverse (self, g_value_get_boolean (value));
		break;
		case BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY:
		binding_common_keybinding_set_ftype (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
value_binding_common_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_binding_common_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		binding_common_unref (value->data[0].v_pointer);
	}
}

static void
value_binding_common_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = binding_common_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_binding_common_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_binding_common_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BindingCommon * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = binding_common_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_binding_common_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	BindingCommon ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = binding_common_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_binding_common (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecBindingCommon* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BINDING_COMMON), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_binding_common (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON), NULL);
	return value->data[0].v_pointer;
}

void
value_set_binding_common (GValue* value,
                          gpointer v_object)
{
	BindingCommon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING_COMMON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		binding_common_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		binding_common_unref (old);
	}
}

void
value_take_binding_common (GValue* value,
                           gpointer v_object)
{
	BindingCommon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING_COMMON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		binding_common_unref (old);
	}
}

static void
binding_common_class_init (BindingCommonClass * klass,
                           gpointer klass_data)
{
	binding_common_parent_class = g_type_class_peek_parent (klass);
	((BindingCommonClass *) klass)->finalize = binding_common_finalize;
}

static void
binding_common_instance_init (BindingCommon * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
binding_common_finalize (BindingCommon * obj)
{
	BindingCommon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BINDING_COMMON, BindingCommon);
	g_signal_handlers_destroy (self);
}

static GType
binding_common_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_binding_common_init, value_binding_common_free_value, value_binding_common_copy_value, value_binding_common_peek_pointer, "p", value_binding_common_collect_value, "p", value_binding_common_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BindingCommonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_common_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingCommon), 0, (GInstanceInitFunc) binding_common_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType binding_common_type_id;
	binding_common_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BindingCommon", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return binding_common_type_id;
}

GType
binding_common_get_type (void)
{
	static volatile gsize binding_common_type_id__once = 0;
	if (g_once_init_enter (&binding_common_type_id__once)) {
		GType binding_common_type_id;
		binding_common_type_id = binding_common_get_type_once ();
		g_once_init_leave (&binding_common_type_id__once, binding_common_type_id);
	}
	return binding_common_type_id__once;
}

gpointer
binding_common_ref (gpointer instance)
{
	BindingCommon * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
binding_common_unref (gpointer instance)
{
	BindingCommon * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BINDING_COMMON_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

