/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.kotlin.commonNative.debugger.KonanDebugBundle;
import com.jetbrains.kotlin.commonNative.debugger.KonanInstallerKt;
import com.jetbrains.kotlin.commonNative.debugger.KonanRemoteDebugProcess;
import com.jetbrains.kotlin.commonNative.debugger.UtilsKt;
import com.jetbrains.kotlin.commonNative.debugger.runconfig.AttachmentStrategy;
import com.jetbrains.kotlin.commonNative.debugger.runconfig.BinaryRunConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@InternalIgnoreDependencyViolation
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J3\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/BinaryDebugRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "doStartDebugProcess", "starter", "Lkotlin/Function1;", "Lcom/intellij/xdebugger/XDebugSession;", "Lkotlin/ParameterName;", "name", "session", "Lcom/intellij/xdebugger/XDebugProcess;", "createConsoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "kotlin-ultimate.native-debugger"})
@SourceDebugExtension(value={"SMAP\nBinaryDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryDebugRunner.kt\ncom/jetbrains/kotlin/commonNative/debugger/BinaryDebugRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class BinaryDebugRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return KonanDebugBundle.message("id.runner", new Object[0]);
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)"Debug") && profile instanceof BinaryRunConfiguration && ((BinaryRunConfiguration)profile).getAttachmentStrategy() != null && ((BinaryRunConfiguration)profile).getExecutable() != null;
    }

    public void execute(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfile runProfile = environment.getRunProfile();
        BinaryRunConfiguration binaryRunConfiguration = runProfile instanceof BinaryRunConfiguration ? (BinaryRunConfiguration)runProfile : null;
        if (binaryRunConfiguration == null) {
            return;
        }
        BinaryRunConfiguration runConfig = binaryRunConfiguration;
        AttachmentStrategy attachmentStrategy = runConfig.getAttachmentStrategy();
        if (attachmentStrategy == null) {
            return;
        }
        AttachmentStrategy strategy = attachmentStrategy;
        FileDocumentManager.getInstance().saveAllDocuments();
        this.doStartDebugProcess(environment, (Function1<? super XDebugSession, ? extends XDebugProcess>)((Function1)arg_0 -> BinaryDebugRunner.execute$lambda$0(runConfig, this, environment, strategy, arg_0)));
    }

    private final void doStartDebugProcess(ExecutionEnvironment environment, Function1<? super XDebugSession, ? extends XDebugProcess> starter) {
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, () -> BinaryDebugRunner.doStartDebugProcess$lambda$0(environment, starter));
    }

    private final TextConsoleBuilder createConsoleBuilder(ExecutionEnvironment environment) {
        GlobalSearchScope globalSearchScope = ExecutionSearchScopes.executionScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"executionScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(environment.getProject(), searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"createBuilder(...)");
        return textConsoleBuilder;
    }

    private static final XDebugProcess execute$lambda$0(BinaryRunConfiguration $runConfig, BinaryDebugRunner this$0, ExecutionEnvironment $environment, AttachmentStrategy $strategy, XDebugSession session2) {
        KonanRemoteDebugProcess konanRemoteDebugProcess;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        RunParameters runParameters = (RunParameters)KonanInstallerKt.createRunParameters($runConfig);
        TextConsoleBuilder textConsoleBuilder = this$0.createConsoleBuilder($environment);
        RunProfile runProfile = $environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.jetbrains.kotlin.commonNative.debugger.runconfig.BinaryRunConfiguration");
        File file = ((BinaryRunConfiguration)runProfile).getExecutable();
        Intrinsics.checkNotNull((Object)file);
        KonanRemoteDebugProcess $this$execute_u24lambda_u240_u240 = konanRemoteDebugProcess = new KonanRemoteDebugProcess(runParameters, session2, textConsoleBuilder, file, $strategy);
        boolean bl = false;
        $this$execute_u24lambda_u240_u240.start();
        return (XDebugProcess)konanRemoteDebugProcess;
    }

    private static final Promise doStartDebugProcess$lambda$0(ExecutionEnvironment $environment, Function1 $starter) {
        return Promises.resolvedPromise((Object)UtilsKt.showDebugContent($environment, false, (Function1<? super XDebugSession, ? extends XDebugProcess>)$starter));
    }
}

