/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinLineBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "xBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "processClassPrepare", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "classType", "Lcom/sun/jdi/ReferenceType;", "canHaveTargetLine", "", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "computeMethodName", "", "intellij.kotlin.jvm.debugger.core"})
public final class KotlinLineBreakpoint
extends LineBreakpoint<JavaLineBreakpointProperties> {
    public KotlinLineBreakpoint(@Nullable Project project, @Nullable XBreakpoint<? extends XBreakpointProperties<?>> xBreakpoint) {
        super(project, xBreakpoint, false);
    }

    public void processClassPrepare(@Nullable DebugProcess debugProcess, @Nullable ReferenceType classType) {
        XSourcePosition sourcePosition = (XSourcePosition)ActionsKt.runReadAction(() -> KotlinLineBreakpoint.processClassPrepare$lambda$0(this));
        if (classType != null && sourcePosition != null && !this.canHaveTargetLine(classType, sourcePosition)) {
            return;
        }
        super.processClassPrepare(debugProcess, classType);
    }

    private final boolean canHaveTargetLine(ReferenceType classType, XSourcePosition sourcePosition) {
        List list2 = DebuggerUtilsEx.allLineLocations((ReferenceType)classType);
        if (list2 == null) {
            return false;
        }
        List allLineLocations = list2;
        String string = sourcePosition.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        int lineNumber = sourcePosition.getLine() + 1;
        for (Location location : allLineLocations) {
            Intrinsics.checkNotNull((Object)location);
            String kotlinFileName = SafeUtilKt.safeSourceName(location, "Kotlin");
            int kotlinLineNumber = location.lineNumber("Kotlin");
            if (!(kotlinFileName != null ? Intrinsics.areEqual((Object)kotlinFileName, (Object)fileName) && kotlinLineNumber == lineNumber : Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(location), (Object)fileName) && location.lineNumber() == lineNumber)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected String computeMethodName() {
        String string = (String)ActionsKt.runReadAction(() -> KotlinLineBreakpoint.computeMethodName$lambda$0(this));
        if (string == null) {
            string = super.computeMethodName();
        }
        return string;
    }

    private static final XSourcePosition processClassPrepare$lambda$0(KotlinLineBreakpoint this$0) {
        XBreakpoint xBreakpoint = this$0.getXBreakpoint();
        return xBreakpoint != null ? xBreakpoint.getSourcePosition() : null;
    }

    private static final String computeMethodName$lambda$0(KotlinLineBreakpoint this$0) {
        SourcePosition sourcePosition = this$0.getSourcePosition();
        return sourcePosition != null && (sourcePosition = sourcePosition.getElementAt()) != null && (sourcePosition = KotlinPositionManagerKt.getContainingMethod$default((PsiElement)sourcePosition, false, 1, null)) != null ? sourcePosition.getName() : null;
    }
}

