/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.AddRequiresDirectiveFacilityKt;
import org.jetbrains.kotlin.idea.configuration.ChangedConfiguratorFiles;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016JJ\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinWithGradleConfigurator;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "presentableText", "getPresentableText", "kotlinPluginName", "getKotlinPluginName", "getKotlinPluginExpression", "forKotlinDsl", "", "getJvmTarget", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "canRunAutoConfig", "isAutoConfigurationEnabled", "configureModule", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "ideKotlinVersion", "jvmTarget", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "changedFiles", "Lorg/jetbrains/kotlin/idea/configuration/ChangedConfiguratorFiles;", "addVersion", "Companion", "kotlin.gradle.gradle-java"})
public final class KotlinGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    public static final String NAME = "gradle";
    @NonNls
    @NotNull
    public static final String KOTLIN = "kotlin";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinIdeaGradleBundle.message("presentable.text.java.with.gradle", new Object[0]);
    }

    @Override
    @NotNull
    protected String getKotlinPluginName() {
        return KOTLIN;
    }

    @Override
    @NotNull
    protected String getKotlinPluginExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"jvm\")" : "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @Nullable
    protected String getJvmTarget(@Nullable Sdk sdk2, @NotNull IdeKotlinVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JvmTarget jvmTarget = KotlinProjectConfigurationUtils.getDefaultJvmTarget(sdk2, version);
        return jvmTarget != null ? jvmTarget.getDescription() : null;
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return super.isApplicable(module) && !ProjectStructureUtils.isAndroidModule$default(module, null, 1, null);
    }

    @Override
    public boolean canRunAutoConfig() {
        return this.isAutoConfigurationEnabled();
    }

    @Override
    public boolean isAutoConfigurationEnabled() {
        return Registry.Companion.is("kotlin.configuration.gradle.autoConfig.enabled", true);
    }

    @Override
    public boolean configureModule(@NotNull Module module, @NotNull PsiFile file, boolean isTopLevelProjectFile, @NotNull IdeKotlinVersion ideKotlinVersion, @Nullable String jvmTarget, @NotNull NotificationMessageCollector collector2, @NotNull ChangedConfiguratorFiles changedFiles, boolean addVersion) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ideKotlinVersion, (String)"ideKotlinVersion");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        boolean configured = super.configureModule(module, file, isTopLevelProjectFile, ideKotlinVersion, jvmTarget, collector2, changedFiles, addVersion);
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootGroupUtils.getWholeModuleGroup(module);
        for (Module sourceModule : ModuleSourceRootGroupUtils.allModules(moduleGroup)) {
            if (AddRequiresDirectiveFacilityKt.addStdlibToJavaModuleInfo(sourceModule, collector2)) break;
        }
        return configured;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleModuleConfigurator$Companion;", "", "<init>", "()V", "NAME", "", "KOTLIN", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

