/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import de.plushnikov.intellij.plugin.processor.CleanupProcessor;
import de.plushnikov.intellij.plugin.processor.JacksonizedProcessor;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.SynchronizedProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.DataProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.EqualsAndHashCodeProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.GetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.SetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.StandardExceptionProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.UtilityClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ValueProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.WithByProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.WitherProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.BuilderClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.BuilderPreDefinedInnerClassFieldProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.BuilderPreDefinedInnerClassMethodProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.BuilderProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.SuperBuilderClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.SuperBuilderPreDefinedInnerClassFieldProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.SuperBuilderPreDefinedInnerClassMethodProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.builder.SuperBuilderProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AllArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.RequiredArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants.FieldNameConstantsOldProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants.FieldNameConstantsPredefinedInnerClassFieldProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants.FieldNameConstantsProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.CommonsLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.CustomLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.FloggerProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.JBossLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Log4j2Processor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Log4jProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.LogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Slf4jProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.XSlf4jProcessor;
import de.plushnikov.intellij.plugin.processor.field.DelegateFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.FieldNameConstantsFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.GetterFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.SetterFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.WithByFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.WitherFieldProcessor;
import de.plushnikov.intellij.plugin.processor.method.BuilderClassMethodProcessor;
import de.plushnikov.intellij.plugin.processor.method.BuilderMethodProcessor;
import de.plushnikov.intellij.plugin.processor.method.DelegateMethodProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.FieldDefaultsModifierProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.ModifierProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.UtilityClassModifierProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.ValModifierProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.ValueModifierProcessor;
import de.plushnikov.intellij.plugin.util.DumbIncompleteModeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@Service
public final class LombokProcessorManager {
    private final Map<String, Collection<Processor>> PROCESSOR_CACHE = new ConcurrentHashMap<String, Collection<Processor>>();
    private final AllArgsConstructorProcessor myAllArgsConstructorProcessor = new AllArgsConstructorProcessor();
    private final NoArgsConstructorProcessor myNoArgsConstructorProcessor = new NoArgsConstructorProcessor();
    private final RequiredArgsConstructorProcessor myRequiredArgsConstructorProcessor = new RequiredArgsConstructorProcessor();
    private final LogProcessor myLogProcessor = new LogProcessor();
    private final Log4jProcessor myLog4jProcessor = new Log4jProcessor();
    private final Log4j2Processor myLog4j2Processor = new Log4j2Processor();
    private final Slf4jProcessor mySlf4jProcessor = new Slf4jProcessor();
    private final XSlf4jProcessor myXSlf4jProcessor = new XSlf4jProcessor();
    private final CommonsLogProcessor myCommonsLogProcessor = new CommonsLogProcessor();
    private final JBossLogProcessor myJBossLogProcessor = new JBossLogProcessor();
    private final FloggerProcessor myFloggerProcessor = new FloggerProcessor();
    private final CustomLogProcessor myCustomLogProcessor = new CustomLogProcessor();
    private final DataProcessor myDataProcessor = new DataProcessor();
    private final EqualsAndHashCodeProcessor myEqualsAndHashCodeProcessor = new EqualsAndHashCodeProcessor();
    private final GetterProcessor myGetterProcessor = new GetterProcessor();
    private final SetterProcessor mySetterProcessor = new SetterProcessor();
    private final ToStringProcessor myToStringProcessor = new ToStringProcessor();
    private final WitherProcessor myWitherProcessor = new WitherProcessor();
    private final WithByProcessor myWithByProcessor = new WithByProcessor();
    private final WithByFieldProcessor myWithByFieldProcessor = new WithByFieldProcessor();
    private final BuilderPreDefinedInnerClassFieldProcessor myBuilderPreDefinedInnerClassFieldProcessor = new BuilderPreDefinedInnerClassFieldProcessor();
    private final BuilderPreDefinedInnerClassMethodProcessor myBuilderPreDefinedInnerClassMethodProcessor = new BuilderPreDefinedInnerClassMethodProcessor();
    private final BuilderClassProcessor myBuilderClassProcessor = new BuilderClassProcessor();
    private final BuilderProcessor myBuilderProcessor = new BuilderProcessor();
    private final BuilderClassMethodProcessor myBuilderClassMethodProcessor = new BuilderClassMethodProcessor();
    private final BuilderMethodProcessor myBuilderMethodProcessor = new BuilderMethodProcessor();
    private final SuperBuilderPreDefinedInnerClassFieldProcessor mySuperBuilderPreDefinedInnerClassFieldProcessor = new SuperBuilderPreDefinedInnerClassFieldProcessor();
    private final SuperBuilderPreDefinedInnerClassMethodProcessor mySuperBuilderPreDefinedInnerClassMethodProcessor = new SuperBuilderPreDefinedInnerClassMethodProcessor();
    private final SuperBuilderClassProcessor mySuperBuilderClassProcessor = new SuperBuilderClassProcessor();
    private final SuperBuilderProcessor mySuperBuilderProcessor = new SuperBuilderProcessor();
    private final ValueProcessor myValueProcessor = new ValueProcessor();
    private final UtilityClassProcessor myUtilityClassProcessor = new UtilityClassProcessor();
    private final StandardExceptionProcessor myStandardExceptionProcessor = new StandardExceptionProcessor();
    private final FieldNameConstantsOldProcessor myFieldNameConstantsOldProcessor = new FieldNameConstantsOldProcessor();
    private final FieldNameConstantsFieldProcessor myFieldNameConstantsFieldProcessor = new FieldNameConstantsFieldProcessor();
    private final FieldNameConstantsProcessor myFieldNameConstantsProcessor = new FieldNameConstantsProcessor();
    private final FieldNameConstantsPredefinedInnerClassFieldProcessor myFieldNameConstantsPredefinedInnerClassFieldProcessor = new FieldNameConstantsPredefinedInnerClassFieldProcessor();
    private final DelegateFieldProcessor myDelegateFieldProcessor = new DelegateFieldProcessor();
    private final GetterFieldProcessor myGetterFieldProcessor = new GetterFieldProcessor();
    private final SetterFieldProcessor mySetterFieldProcessor = new SetterFieldProcessor();
    private final WitherFieldProcessor myWitherFieldProcessor = new WitherFieldProcessor();
    private final DelegateMethodProcessor myDelegateMethodProcessor = new DelegateMethodProcessor();
    private final CleanupProcessor myCleanupProcessor = new CleanupProcessor();
    private final SynchronizedProcessor mySynchronizedProcessor = new SynchronizedProcessor();
    private final JacksonizedProcessor myJacksonizedProcessor = new JacksonizedProcessor();
    private final MultiMap<String, String> ourSupportedShortNames = this.createSupportedShortNames();

    private Collection<Processor> getWithCache(String key, Supplier<Collection<Processor>> function) {
        return this.PROCESSOR_CACHE.computeIfAbsent(key, s -> (Collection)function.get());
    }

    @NotNull
    private MultiMap<String, String> createSupportedShortNames() {
        MultiMap map = new MultiMap();
        for (Processor processor : this.getAllProcessors()) {
            for (String annotationClass : processor.getSupportedAnnotationClasses()) {
                map.putValue((Object)StringUtil.getShortName((String)annotationClass), (Object)annotationClass);
            }
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            LombokProcessorManager.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    public WithByFieldProcessor getWithByFieldProcessor() {
        return this.myWithByFieldProcessor;
    }

    public static LombokProcessorManager getInstance() {
        return (LombokProcessorManager)ApplicationManager.getApplication().getService(LombokProcessorManager.class);
    }

    public AllArgsConstructorProcessor getAllArgsConstructorProcessor() {
        return this.myAllArgsConstructorProcessor;
    }

    public NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return this.myNoArgsConstructorProcessor;
    }

    public RequiredArgsConstructorProcessor getRequiredArgsConstructorProcessor() {
        return this.myRequiredArgsConstructorProcessor;
    }

    public LogProcessor getLogProcessor() {
        return this.myLogProcessor;
    }

    public Log4jProcessor getLog4jProcessor() {
        return this.myLog4jProcessor;
    }

    public Log4j2Processor getLog4j2Processor() {
        return this.myLog4j2Processor;
    }

    public Slf4jProcessor getSlf4jProcessor() {
        return this.mySlf4jProcessor;
    }

    public XSlf4jProcessor getXSlf4jProcessor() {
        return this.myXSlf4jProcessor;
    }

    public CommonsLogProcessor getCommonsLogProcessor() {
        return this.myCommonsLogProcessor;
    }

    public JBossLogProcessor getJBossLogProcessor() {
        return this.myJBossLogProcessor;
    }

    public FloggerProcessor getFloggerProcessor() {
        return this.myFloggerProcessor;
    }

    public CustomLogProcessor getCustomLogProcessor() {
        return this.myCustomLogProcessor;
    }

    public DataProcessor getDataProcessor() {
        return this.myDataProcessor;
    }

    public EqualsAndHashCodeProcessor getEqualsAndHashCodeProcessor() {
        return this.myEqualsAndHashCodeProcessor;
    }

    public GetterProcessor getGetterProcessor() {
        return this.myGetterProcessor;
    }

    public SetterProcessor getSetterProcessor() {
        return this.mySetterProcessor;
    }

    public ToStringProcessor getToStringProcessor() {
        return this.myToStringProcessor;
    }

    public WitherProcessor getWitherProcessor() {
        return this.myWitherProcessor;
    }

    public BuilderPreDefinedInnerClassFieldProcessor getBuilderPreDefinedInnerClassFieldProcessor() {
        return this.myBuilderPreDefinedInnerClassFieldProcessor;
    }

    public BuilderPreDefinedInnerClassMethodProcessor getBuilderPreDefinedInnerClassMethodProcessor() {
        return this.myBuilderPreDefinedInnerClassMethodProcessor;
    }

    public BuilderClassProcessor getBuilderClassProcessor() {
        return this.myBuilderClassProcessor;
    }

    public BuilderProcessor getBuilderProcessor() {
        return this.myBuilderProcessor;
    }

    public BuilderClassMethodProcessor getBuilderClassMethodProcessor() {
        return this.myBuilderClassMethodProcessor;
    }

    public BuilderMethodProcessor getBuilderMethodProcessor() {
        return this.myBuilderMethodProcessor;
    }

    public SuperBuilderPreDefinedInnerClassFieldProcessor getSuperBuilderPreDefinedInnerClassFieldProcessor() {
        return this.mySuperBuilderPreDefinedInnerClassFieldProcessor;
    }

    public SuperBuilderPreDefinedInnerClassMethodProcessor getSuperBuilderPreDefinedInnerClassMethodProcessor() {
        return this.mySuperBuilderPreDefinedInnerClassMethodProcessor;
    }

    public SuperBuilderClassProcessor getSuperBuilderClassProcessor() {
        return this.mySuperBuilderClassProcessor;
    }

    public SuperBuilderProcessor getSuperBuilderProcessor() {
        return this.mySuperBuilderProcessor;
    }

    public ValueProcessor getValueProcessor() {
        return this.myValueProcessor;
    }

    public UtilityClassProcessor getUtilityClassProcessor() {
        return this.myUtilityClassProcessor;
    }

    public StandardExceptionProcessor getStandardExceptionProcessor() {
        return this.myStandardExceptionProcessor;
    }

    public FieldNameConstantsOldProcessor getFieldNameConstantsOldProcessor() {
        return this.myFieldNameConstantsOldProcessor;
    }

    public FieldNameConstantsFieldProcessor getFieldNameConstantsFieldProcessor() {
        return this.myFieldNameConstantsFieldProcessor;
    }

    public FieldNameConstantsProcessor getFieldNameConstantsProcessor() {
        return this.myFieldNameConstantsProcessor;
    }

    public FieldNameConstantsPredefinedInnerClassFieldProcessor getFieldNameConstantsPredefinedInnerClassFieldProcessor() {
        return this.myFieldNameConstantsPredefinedInnerClassFieldProcessor;
    }

    public DelegateFieldProcessor getDelegateFieldProcessor() {
        return this.myDelegateFieldProcessor;
    }

    public GetterFieldProcessor getGetterFieldProcessor() {
        return this.myGetterFieldProcessor;
    }

    public SetterFieldProcessor getSetterFieldProcessor() {
        return this.mySetterFieldProcessor;
    }

    public WitherFieldProcessor getWitherFieldProcessor() {
        return this.myWitherFieldProcessor;
    }

    public DelegateMethodProcessor getDelegateMethodProcessor() {
        return this.myDelegateMethodProcessor;
    }

    public WithByProcessor getWithByProcessor() {
        return this.myWithByProcessor;
    }

    public CleanupProcessor getCleanupProcessor() {
        return this.myCleanupProcessor;
    }

    public SynchronizedProcessor getSynchronizedProcessor() {
        return this.mySynchronizedProcessor;
    }

    public JacksonizedProcessor getJacksonizedProcessor() {
        return this.myJacksonizedProcessor;
    }

    public MultiMap<String, String> getOurSupportedShortNames() {
        return this.ourSupportedShortNames;
    }

    @NotNull
    private Collection<Processor> getAllProcessors() {
        List<Processor> list = Arrays.asList(this.myAllArgsConstructorProcessor, this.myNoArgsConstructorProcessor, this.myRequiredArgsConstructorProcessor, this.myLogProcessor, this.myLog4jProcessor, this.myLog4j2Processor, this.mySlf4jProcessor, this.myXSlf4jProcessor, this.myCommonsLogProcessor, this.myJBossLogProcessor, this.myFloggerProcessor, this.myCustomLogProcessor, this.myDataProcessor, this.myEqualsAndHashCodeProcessor, this.myGetterProcessor, this.mySetterProcessor, this.myToStringProcessor, this.myWitherProcessor, this.myWithByProcessor, this.myBuilderPreDefinedInnerClassFieldProcessor, this.myBuilderPreDefinedInnerClassMethodProcessor, this.myBuilderClassProcessor, this.myBuilderProcessor, this.myBuilderClassMethodProcessor, this.myBuilderMethodProcessor, this.mySuperBuilderPreDefinedInnerClassFieldProcessor, this.mySuperBuilderPreDefinedInnerClassMethodProcessor, this.mySuperBuilderClassProcessor, this.mySuperBuilderProcessor, this.myValueProcessor, this.myUtilityClassProcessor, this.myStandardExceptionProcessor, this.myFieldNameConstantsOldProcessor, this.myFieldNameConstantsFieldProcessor, this.myFieldNameConstantsProcessor, this.myFieldNameConstantsPredefinedInnerClassFieldProcessor, this.myDelegateFieldProcessor, this.myGetterFieldProcessor, this.mySetterFieldProcessor, this.myWitherFieldProcessor, this.myWithByFieldProcessor, this.myDelegateMethodProcessor, this.myCleanupProcessor, this.mySynchronizedProcessor, this.myJacksonizedProcessor);
        if (list == null) {
            LombokProcessorManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static Collection<ModifierProcessor> getLombokModifierProcessors() {
        List<ModifierProcessor> list = Arrays.asList(new FieldDefaultsModifierProcessor(), new UtilityClassModifierProcessor(), new ValModifierProcessor(), new ValueModifierProcessor());
        if (list == null) {
            LombokProcessorManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static Collection<Processor> getProcessors(@NotNull Class<? extends PsiElement> supportedClass) {
        if (supportedClass == null) {
            LombokProcessorManager.$$$reportNull$$$0(3);
        }
        LombokProcessorManager manager = LombokProcessorManager.getInstance();
        Collection<Processor> collection = manager.getWithCache("bySupportedClass_" + supportedClass.getName(), () -> ContainerUtil.filter(manager.getAllProcessors(), p -> p.isSupportedClass(supportedClass)));
        if (collection == null) {
            LombokProcessorManager.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<Processor> getProcessors(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            LombokProcessorManager.$$$reportNull$$$0(5);
        }
        LombokProcessorManager manager = LombokProcessorManager.getInstance();
        PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
        if (nameReferenceElement == null) {
            List<Processor> list = Collections.emptyList();
            if (list == null) {
                LombokProcessorManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        String referenceName = nameReferenceElement.getReferenceName();
        if (referenceName == null || !manager.ourSupportedShortNames.containsKey((Object)referenceName)) {
            List<Processor> list = Collections.emptyList();
            if (list == null) {
                LombokProcessorManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        String qualifiedName = psiAnnotation.getQualifiedName();
        if (DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiAnnotation)) {
            qualifiedName = DumbIncompleteModeUtil.findLombokAnnotationQualifiedNameInDumbIncompleteMode(psiAnnotation);
        }
        if (StringUtil.isEmpty((String)qualifiedName) || !qualifiedName.contains("lombok")) {
            List<Processor> list = Collections.emptyList();
            if (list == null) {
                LombokProcessorManager.$$$reportNull$$$0(8);
            }
            return list;
        }
        String finalQualifiedName = qualifiedName;
        Collection<Processor> collection = manager.getWithCache("byAnnotationFQN_" + qualifiedName, () -> ContainerUtil.filter(manager.getAllProcessors(), p -> p.isSupportedAnnotationFQN(finalQualifiedName)));
        if (collection == null) {
            LombokProcessorManager.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/LombokProcessorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSupportedShortNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProcessors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLombokModifierProcessors";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/LombokProcessorManager";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcessors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

