/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage;

import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.storage.ProvenanceDatabaseService;
import com.intellij.code.provenance.core.events.storage.VfsTimestampMonitor;
import com.intellij.code.provenance.core.events.storage.VfsTimestampMonitorState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="VfsTimestampMonitor", storages={@Storage(value="provenance.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00192\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0019B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u000e\u0010\u0015\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/code/provenance/core/events/storage/VfsTimestampMonitorState;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "state", "job", "Lkotlinx/coroutines/Job;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "timestampCheckFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getState", "loadState", "newState", "checkTimestampMismatch", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleVfsRebuild", "dispose", "Companion", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nVfsTimestampMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsTimestampMonitor.kt\ncom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n116#2,11:120\n13#3:131\n*S KotlinDebug\n*F\n+ 1 VfsTimestampMonitor.kt\ncom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor\n*L\n88#1:120,11\n40#1:131\n*E\n"})
public final class VfsTimestampMonitor
implements Disposable,
PersistentStateComponent<VfsTimestampMonitorState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final VfsTimestampMonitorState state;
    @Nullable
    private Job job;
    @NotNull
    private final Mutex mutex;
    @NotNull
    private final MutableSharedFlow<Unit> timestampCheckFlow;
    @NotNull
    private static final Logger log;
    private static final long POLL_INTERVAL_MS = 10000L;

    public VfsTimestampMonitor(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.state = new VfsTimestampMonitorState(0L, 1, null);
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.timestampCheckFlow = SharedFlowKt.MutableSharedFlow((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_LATEST);
        if (ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ VfsTimestampMonitor this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$launch;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.label = 1;
                            Object object2 = this.this$0.timestampCheckFlow.collect(new FlowCollector(){

                                public final Object emit(Unit unit, Continuation<? super Unit> $completion) {
                                    Object object = this$0.checkTimestampMismatch((Continuation<? super Unit>)$completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    public VfsTimestampMonitorState getState() {
        return this.state;
    }

    public void loadState(@NotNull VfsTimestampMonitorState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Ref.BooleanRef shouldCheck = new Ref.BooleanRef();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, shouldCheck, newState, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            final /* synthetic */ VfsTimestampMonitor this$0;
            final /* synthetic */ Ref.BooleanRef $shouldCheck;
            final /* synthetic */ VfsTimestampMonitorState $newState;
            {
                this.this$0 = $receiver;
                this.$shouldCheck = $shouldCheck;
                this.$newState = $newState;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = VfsTimestampMonitor.access$getMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$newState;
                        var6_6 = this.$shouldCheck;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var6_6 = (Ref.BooleanRef)this.L$3;
                        var5_5 = (VfsTimestampMonitorState)this.L$2;
                        var4_4 = (VfsTimestampMonitor)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-VfsTimestampMonitor$loadState$1$1 = false;
                            old = VfsTimestampMonitor.access$getState$p(var4_4).getLastKnownVfsTimestamp();
                            VfsTimestampMonitor.access$getState$p(var4_4).setLastKnownVfsTimestamp(var5_5.getLastKnownVfsTimestamp());
                            var6_6.element = old != var5_5.getLastKnownVfsTimestamp();
                            var11_12 = Unit.INSTANCE;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        if (this.$shouldCheck.element) {
                            VfsTimestampMonitor.access$getTimestampCheckFlow$p(this.this$0).tryEmit((Object)Unit.INSTANCE);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkTimestampMismatch(Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkTimestampMismatch.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ VfsTimestampMonitor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VfsTimestampMonitor.access$checkTimestampMismatch(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                action = new Ref.ObjectRef();
                oldTs = new Ref.LongRef();
                newTs = ManagingFS.getInstance().getCreationTimestamp();
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = action;
                $continuation.L$1 = oldTs;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.J$0 = newTs;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                newTs = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                oldTs = (Ref.LongRef)$continuation.L$1;
                action = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                try {
                    $i$a$-withLock$default-VfsTimestampMonitor$checkTimestampMismatch$2 = false;
                    oldTs.element = this.state.getLastKnownVfsTimestamp();
                    if (oldTs.element == -1L) {
                        this.state.setLastKnownVfsTimestamp(newTs);
                    } else if (newTs != oldTs.element) {
                        this.state.setLastKnownVfsTimestamp(newTs);
                        action.element = new Function1<Continuation<? super Unit>, Object>(oldTs, newTs, this, null){
                            int label;
                            final /* synthetic */ Ref.LongRef $oldTs;
                            final /* synthetic */ long $newTs;
                            final /* synthetic */ VfsTimestampMonitor this$0;
                            {
                                this.$oldTs = $oldTs;
                                this.$newTs = $newTs;
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        VfsTimestampMonitor.access$getLog$cp().warn("VFS timestamp mismatch detected on startup: VFS timestamp changed from " + this.$oldTs.element + " to " + this.$newTs + ". Resetting provenance database.");
                                        this.label = 1;
                                        Object object2 = VfsTimestampMonitor.access$handleVfsRebuild(this.this$0, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                    }
                    var10_16 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                v1 = (Function1)action.element;
                if (v1 == null) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)action);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oldTs);
                $continuation.L$2 = null;
                $continuation.J$0 = newTs;
                $continuation.label = 2;
                v2 = v1.invoke((Object)$continuation);
                if (v2 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl70
            }
            case 2: {
                newTs = $continuation.J$0;
                oldTs = (Ref.LongRef)$continuation.L$1;
                action = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl70:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleVfsRebuild(Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleVfsRebuild.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ VfsTimestampMonitor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VfsTimestampMonitor.access$handleVfsRebuild(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ProvenanceDatabaseService.Companion.getInstance(this.project).resetDatabaseAfterLvcsCorruption((Continuation<? super Unit>)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    VfsTimestampMonitor.log.info("Successfully reset provenance database after LVCS corruption");
                }
                catch (Exception e) {
                    VfsTimestampMonitor.log.error("Failed to reset provenance database after LVCS corruption", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
        block0: {
            Job job = this.job;
            if (job == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    public static final /* synthetic */ Mutex access$getMutex$p(VfsTimestampMonitor $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ VfsTimestampMonitorState access$getState$p(VfsTimestampMonitor $this) {
        return $this.state;
    }

    public static final /* synthetic */ Object access$handleVfsRebuild(VfsTimestampMonitor $this, Continuation $completion) {
        return $this.handleVfsRebuild((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsTimestampMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "POLL_INTERVAL_MS", "", "getInstance", "Lcom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core"})
    @SourceDebugExtension(value={"SMAP\nVfsTimestampMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsTimestampMonitor.kt\ncom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n30#2,2:120\n*S KotlinDebug\n*F\n+ 1 VfsTimestampMonitor.kt\ncom/intellij/code/provenance/core/events/storage/VfsTimestampMonitor$Companion\n*L\n43#1:120,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VfsTimestampMonitor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VfsTimestampMonitor> serviceClass$iv = VfsTimestampMonitor.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VfsTimestampMonitor)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

