/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.jetbrains.annotations.NotNull;

public final class LocalFileRandomAccessContent
extends AbstractRandomAccessContent {
    private final RandomAccessFile raf;
    private final InputStream rafis;
    private static final int BYTE_VALUE_MASK = 255;

    public LocalFileRandomAccessContent(File localFile, RandomAccessMode mode) throws FileSystemException {
        try {
            this.raf = new RandomAccessFile(localFile, mode.getModeString());
            this.rafis = new InputStream(){

                @Override
                public int read() throws IOException {
                    try {
                        return LocalFileRandomAccessContent.this.raf.readByte() & 0xFF;
                    }
                    catch (EOFException e) {
                        return -1;
                    }
                }

                @Override
                public long skip(long n) throws IOException {
                    LocalFileRandomAccessContent.this.raf.seek(LocalFileRandomAccessContent.this.raf.getFilePointer() + n);
                    return n;
                }

                @Override
                public void close() throws IOException {
                    LocalFileRandomAccessContent.this.raf.close();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return LocalFileRandomAccessContent.this.raf.read(b, off, len);
                }

                @Override
                public int available() throws IOException {
                    long available = LocalFileRandomAccessContent.this.raf.length() - LocalFileRandomAccessContent.this.raf.getFilePointer();
                    if (available > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)available;
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", (Object)localFile);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.raf.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.raf.readFully(b, off, len);
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.raf.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.raf.writeFloat(v);
    }

    @Override
    public void write(int b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.raf.writeByte(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.raf.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.raf.writeInt(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.raf.writeShort(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.raf.writeLong(v);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.raf.writeBoolean(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    @Override
    public void writeBytes(@NotNull String s) throws IOException {
        this.raf.writeBytes(s);
    }

    @Override
    public void writeChars(@NotNull String s) throws IOException {
        this.raf.writeChars(s);
    }

    @Override
    public void writeUTF(@NotNull String str) throws IOException {
        this.raf.writeUTF(str);
    }

    @Override
    public InputStream getInputStream() {
        return this.rafis;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.raf.setLength(newLength);
    }
}

