/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.hints;

import com.intellij.micronaut.MicronautBundle;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/config/hints/MnDurationHintReferenceProvider;", "Lcom/intellij/microservices/jvm/config/hints/HintReferenceProviderBase;", "<init>", "()V", "createReference", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/util/ProcessingContext;", "Companion", "intellij.micronaut"})
public final class MnDurationHintReferenceProvider
extends HintReferenceProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern ISO8601 = Pattern.compile("^[+\\-]?P.*$");
    private static final Pattern UNIT_PATTERN = Pattern.compile("^([+\\-]?\\d+)(ns|us|ms|s|m|h|d)$");

    @NotNull
    protected PsiReference createReference(@Nullable PsiElement element, @Nullable TextRange textRange, @Nullable ProcessingContext context) {
        PsiElement psiElement = element;
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement psiElement2 = psiElement;
        return (PsiReference)new HintReferenceBase(textRange, psiElement2){

            protected PsiElement doResolve() {
                String string = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                String value = string;
                if (MnDurationHintReferenceProvider.access$getISO8601$cp().matcher(value).matches()) {
                    PsiElement psiElement;
                    try {
                        Duration.parse(value);
                        psiElement = this.getElement();
                    }
                    catch (DateTimeParseException e) {
                        psiElement = null;
                    }
                    return psiElement;
                }
                return MnDurationHintReferenceProvider.access$getUNIT_PATTERN$cp().matcher(value).matches() ? this.getElement() : null;
            }

            public String getUnresolvedMessagePattern() {
                return MicronautBundle.message("micronaut.config.unresolved.duration.value", new Object[0]);
            }
        };
    }

    public static final /* synthetic */ Pattern access$getISO8601$cp() {
        return ISO8601;
    }

    public static final /* synthetic */ Pattern access$getUNIT_PATTERN$cp() {
        return UNIT_PATTERN;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/config/hints/MnDurationHintReferenceProvider$Companion;", "", "<init>", "()V", "ISO8601", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "UNIT_PATTERN", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

