/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "element", "Lcom/intellij/psi/PsiElement;", "isMyContext", "", "intellij.micronaut"})
public final class MnPropertiesSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    @NotNull
    public Tokenizer<?> getTokenizer(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        return tokenizer;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PropertyKeyImpl)) {
            return false;
        }
        Project project = ((PropertyKeyImpl)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MicronautUtils.hasMicronautLibrary(project)) {
            return false;
        }
        PsiFile file = ((PropertyKeyImpl)element).getContainingFile();
        return file instanceof PropertiesFile && MnConfigUtilsKt.isMicronautConfigFile(file);
    }
}

