/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.descriptor;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.descriptor.api.DeclaredVariableSourcePositionProvider;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructurePerFileTracker;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructureTrackerService;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/descriptor/NotebookVariableDescriptorPositionResolver;", "Lcom/intellij/kotlin/jupyter/core/debug/descriptor/api/DeclaredVariableSourcePositionProvider;", "<init>", "()V", "resolveTo", "Lcom/intellij/debugger/SourcePosition;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "descriptor", "Lcom/intellij/debugger/ui/tree/FieldDescriptor;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookVariableDescriptorPositionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVariableDescriptorPositionResolver.kt\ncom/intellij/kotlin/jupyter/core/debug/descriptor/NotebookVariableDescriptorPositionResolver\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n455#2:37\n295#3,2:38\n*S KotlinDebug\n*F\n+ 1 NotebookVariableDescriptorPositionResolver.kt\ncom/intellij/kotlin/jupyter/core/debug/descriptor/NotebookVariableDescriptorPositionResolver\n*L\n26#1:37\n27#1:38,2\n*E\n"})
public final class NotebookVariableDescriptorPositionResolver
implements DeclaredVariableSourcePositionProvider {
    @NotNull
    public static final NotebookVariableDescriptorPositionResolver INSTANCE = new NotebookVariableDescriptorPositionResolver();

    private NotebookVariableDescriptorPositionResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public SourcePosition resolveTo(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @NotNull FieldDescriptor descriptor) {
        KtDeclaration ktDeclaration;
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!IsKotlinNotebookKt.isKotlinNotebook(virtualFile.getFile())) {
            return null;
        }
        String containingClass = descriptor.getObject().referenceType().name();
        NotebookStructurePerFileTracker notebookStructurePerFileTracker = NotebookStructureTrackerService.Companion.getForFile(project, virtualFile);
        Intrinsics.checkNotNull((Object)containingClass);
        JupyterPsiCell jupyterPsiCell = notebookStructurePerFileTracker.findPsiCellByClassName(containingClass);
        if (jupyterPsiCell == null) {
            return null;
        }
        JupyterPsiCell psiCell = jupyterPsiCell;
        PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiCell;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
        KtFile ktFile = (KtFile)CollectionsKt.firstOrNull(UtilKt.getInjectedKtFiles(psiLanguageInjectionHost, injectedLanguageManager));
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        PsiElement $this$childrenOfType$iv = (PsiElement)ktFile2;
        boolean $i$f$childrenOfType2 = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, KtScript.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        KtScript ktScript = (KtScript)CollectionsKt.firstOrNull((List)list2);
        if (ktScript != null && (list = ktScript.getDeclarations()) != null) {
            Object v6;
            block8: {
                void $this$firstOrNull$iv;
                Iterable $i$f$childrenOfType2 = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)descriptor.getName()))) continue;
                    v6 = element$iv;
                    break block8;
                }
                v6 = null;
            }
            ktDeclaration = v6;
        } else {
            ktDeclaration = null;
        }
        KtDeclaration ktDeclaration2 = ktDeclaration;
        KtProperty ktProperty = ktDeclaration2 instanceof KtProperty ? (KtProperty)ktDeclaration2 : null;
        if (ktProperty == null) {
            return null;
        }
        KtProperty knownTargetDeclaration = ktProperty;
        PsiElement psiElement = knownTargetDeclaration.getNameIdentifier();
        if (psiElement == null) {
            PsiElement psiElement2 = knownTargetDeclaration.getNavigationElement();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNavigationElement(...)");
        }
        return SourcePosition.createFromElement((PsiElement)psiElement);
    }
}

