/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

public class InjectionPointDescriptor {
    private final PsiAnchor myOwner;

    @Nullable
    public static InjectionPointDescriptor of(@NotNull PsiModifierListOwner owner) {
        UElement uElement;
        PsiElement sourcePsiElement;
        if (owner == null) {
            InjectionPointDescriptor.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = sourcePsiElement = (uElement = UastContextKt.toUElement((PsiElement)owner)) != null ? uElement.getSourcePsi() : null;
        if (sourcePsiElement == null) {
            return null;
        }
        return new InjectionPointDescriptor(sourcePsiElement);
    }

    private InjectionPointDescriptor(@NotNull PsiElement sourcePsiElement) {
        if (sourcePsiElement == null) {
            InjectionPointDescriptor.$$$reportNull$$$0(1);
        }
        this.myOwner = PsiAnchor.create((PsiElement)sourcePsiElement);
    }

    @NotNull
    private PsiModifierListOwner retrieveOwner() {
        PsiElement psiElement = this.myOwner.retrieveOrThrow();
        UElement uElement = UastContextKt.toUElement((PsiElement)psiElement);
        PsiElement javaPsi = uElement != null ? uElement.getJavaPsi() : psiElement;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)Objects.requireNonNull(javaPsi);
        if (psiModifierListOwner == null) {
            InjectionPointDescriptor.$$$reportNull$$$0(2);
        }
        return psiModifierListOwner;
    }

    @Nullable
    public PsiType getType() {
        PsiModifierListOwner owner = this.retrieveOwner();
        if (owner instanceof PsiField) {
            return ((PsiField)owner).getType();
        }
        if (owner instanceof PsiParameter) {
            return ((PsiParameter)owner).getType();
        }
        return null;
    }

    public PsiAnnotation[] getQualifierAnnotations() {
        return CdiCommonUtils.getQualifierAnnotations(this.retrieveOwner());
    }

    @NotNull
    public PsiModifierListOwner getOwner() {
        return this.retrieveOwner();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InjectionPointDescriptor)) {
            return false;
        }
        InjectionPointDescriptor that = (InjectionPointDescriptor)o;
        return Objects.equals(this.myOwner, that.myOwner);
    }

    public int hashCode() {
        return this.myOwner != null ? this.myOwner.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePsiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/InjectionPointDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/InjectionPointDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

