/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CdiInterceptorInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiClass == null) {
            CdiInterceptorInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiInterceptorInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiInterceptorInspection.$$$reportNull$$$0(2);
        }
        if (CdiCommonUtils.isInterceptor(psiClass)) {
            CdiInterceptorInspection.checkInterceptorHasBindingTypes(psiClass, module, holder);
        }
    }

    private static void checkInterceptorHasBindingTypes(PsiClass psiClass, Module module, ProblemsHolder holder) {
        Set<PsiClass> classes = CdiCommonUtils.getInterceptorBindingTypesClasses((PsiModifierListOwner)psiClass, module);
        if (classes.isEmpty()) {
            CdiInterceptorInspection.registerProblem(holder, CdiInterceptorInspection.getIdentifyingElement((PsiModifierListOwner)psiClass), CdiInspectionBundle.message("CdiInterceptorInspection.no.binding.type", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiInterceptorInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

