/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.converter.HttpEnvResult;
import com.intellij.httpClient.postman.converter.PostmanCollectionConverterKt;
import com.intellij.httpClient.postman.converter.PostmanEnvironmentConversionResult;
import com.intellij.httpClient.postman.converter.PostmanFileCheckerKt;
import com.intellij.httpClient.postman.converter.action.HttpEnvironmentFiles;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpAuthEnv;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpEnvItem;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpPostmanCollectionEnv;
import com.intellij.httpClient.postman.converter.dto.postman.environment.PostmanEnvItem;
import com.intellij.httpClient.postman.converter.dto.postman.environment.PostmanEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J&\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002JD\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u001a\b\u0002\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u001aH\u0002J0\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/postman/converter/PostmanEnvironmentConverter;", "", "<init>", "()V", "convertEnvironment", "Lcom/intellij/httpClient/postman/converter/PostmanEnvironmentConversionResult;", "project", "Lcom/intellij/openapi/project/Project;", "additionalEnv", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpPostmanCollectionEnv;", "postmanEnvFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "httpEnvFiles", "Lcom/intellij/httpClient/postman/converter/action/HttpEnvironmentFiles;", "getPrivateEnv", "Lcom/intellij/httpClient/postman/converter/HttpEnvResult;", "name", "", "privateHttpEnvFile", "buildEnvironmentNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "existingFile", "items", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpEnvItem;", "securityItems", "", "getPublicEnv", "httpEnvFile", "postmanEnv", "Lcom/intellij/httpClient/postman/converter/dto/postman/environment/PostmanEnvironment;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanEnvironmentConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanEnvironmentConverter.kt\ncom/intellij/httpClient/postman/converter/PostmanEnvironmentConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PostmanMapper.kt\ncom/intellij/httpClient/postman/PostmanMapperKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n1#2:129\n14#3,5:130\n774#4:135\n865#4,2:136\n1374#4:138\n1460#4,2:139\n774#4:141\n865#4,2:142\n1462#4,3:144\n1869#4,2:149\n1869#4,2:152\n1563#4:155\n1634#4,3:156\n827#4:159\n855#4,2:160\n1193#4,2:162\n1267#4,2:164\n827#4:166\n855#4,2:167\n1270#4:169\n1321#5,2:147\n216#6:151\n217#6:154\n536#7:170\n521#7,6:171\n*S KotlinDebug\n*F\n+ 1 PostmanEnvironmentConverter.kt\ncom/intellij/httpClient/postman/converter/PostmanEnvironmentConverter\n*L\n31#1:130,5\n47#1:135\n47#1:136,2\n48#1:138\n48#1:139,2\n48#1:141\n48#1:142,2\n48#1:144,3\n76#1:149,2\n85#1:152,2\n100#1:155\n100#1:156,3\n103#1:159\n103#1:160,2\n107#1:162,2\n107#1:164,2\n107#1:166\n107#1:167,2\n107#1:169\n73#1:147,2\n83#1:151\n83#1:154\n108#1:170\n108#1:171,6\n*E\n"})
public final class PostmanEnvironmentConverter {
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final PostmanEnvironmentConversionResult convertEnvironment(@NotNull Project project, @Nullable HttpPostmanCollectionEnv additionalEnv, @Nullable VirtualFile postmanEnvFile, @Nullable HttpEnvironmentFiles httpEnvFiles) {
        PostmanEnvironment postmanEnv;
        Object object;
        PostmanEnvironment postmanEnvironment;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = postmanEnvFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            if (!PostmanFileCheckerKt.isPostmanEnvironmentFile(project, postmanEnvFile)) {
                return null;
            }
        }
        VirtualFile virtualFile2 = postmanEnvFile;
        if (virtualFile2 != null) {
            Object object2;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            Path path = postmanEnvFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            String value$iv = PathsKt.readText$default((Path)path, null, (int)1, null);
            boolean $i$f$readValueSafely = false;
            try {
                object2 = PostmanMapperKt.getPostmanMapper().readValue(value$iv, PostmanEnvironment.class);
            }
            catch (Exception exception$iv) {
                PostmanCollectionConverterKt.getPostmanConverterLogger().warning("Could not read value, " + exception$iv);
                object2 = null;
            }
            postmanEnvironment = (PostmanEnvironment)object2;
        } else {
            postmanEnvironment = null;
        }
        if ((object = (postmanEnv = postmanEnvironment)) == null || (object = ((PostmanEnvironment)object).getName()) == null) {
            HttpPostmanCollectionEnv httpPostmanCollectionEnv = additionalEnv;
            if (httpPostmanCollectionEnv != null) {
                object = httpPostmanCollectionEnv.getName();
            } else {
                return null;
            }
        }
        Object envName = object;
        HttpEnvironmentFiles httpEnvironmentFiles = httpEnvFiles;
        HttpEnvResult httpEnvResult = this.getPublicEnv((String)envName, (VirtualFile)(httpEnvironmentFiles != null ? httpEnvironmentFiles.getPublic() : null), postmanEnv, additionalEnv);
        HttpEnvironmentFiles httpEnvironmentFiles2 = httpEnvFiles;
        HttpEnvResult httpEnvResult2 = this.getPrivateEnv((String)envName, (VirtualFile)(httpEnvironmentFiles2 != null ? httpEnvironmentFiles2.getPrivate() : null), additionalEnv);
        if (httpEnvResult2 == null && httpEnvResult == null) {
            return null;
        }
        return new PostmanEnvironmentConversionResult((String)envName, httpEnvResult, httpEnvResult2);
    }

    public static /* synthetic */ PostmanEnvironmentConversionResult convertEnvironment$default(PostmanEnvironmentConverter postmanEnvironmentConverter, Project project, HttpPostmanCollectionEnv httpPostmanCollectionEnv, VirtualFile virtualFile, HttpEnvironmentFiles httpEnvironmentFiles, int n, Object object) {
        if ((n & 2) != 0) {
            httpPostmanCollectionEnv = null;
        }
        return postmanEnvironmentConverter.convertEnvironment(project, httpPostmanCollectionEnv, virtualFile, httpEnvironmentFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpEnvResult getPrivateEnv(String name, VirtualFile privateHttpEnvFile, HttpPostmanCollectionEnv additionalEnv) {
        List list2;
        Object object;
        List privateItems;
        Iterable destination$iv$iv;
        Iterable $this$filter$iv;
        Object object2 = additionalEnv;
        if (object2 != null && (object2 = ((HttpPostmanCollectionEnv)object2).getEnvItems()) != null) {
            void $this$filterTo$iv$iv;
            $this$filter$iv = (Iterable)object2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HttpEnvItem it = (HttpEnvItem)element$iv$iv;
                boolean bl = false;
                if (!it.isSecure()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = privateItems = null;
        }
        if ((object = additionalEnv) != null && (object = ((HttpPostmanCollectionEnv)object).getAuthItems()) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                HttpAuthEnv authItem = (HttpAuthEnv)element$iv$iv;
                boolean bl = false;
                Iterable $this$filter$iv2 = authItem.getItems();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    HttpEnvItem httpEnv = (HttpEnvItem)element$iv$iv2;
                    boolean bl2 = false;
                    if (!httpEnv.isSecure()) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = null;
        }
        List privateAuthItems = list2;
        $this$filter$iv = privateItems;
        if (($this$filter$iv == null || $this$filter$iv.isEmpty()) && (($this$filter$iv = (Collection)privateAuthItems) == null || $this$filter$iv.isEmpty())) {
            return null;
        }
        List items = new ArrayList();
        List list3 = privateItems;
        if (list3 != null) {
            List it = list3;
            boolean bl = false;
            CollectionsKt.addAll((Collection)items, (Iterable)it);
        }
        List list4 = privateAuthItems;
        if (list4 != null) {
            List it = list4;
            boolean bl = false;
            CollectionsKt.addAll((Collection)items, (Iterable)it);
        }
        ObjectNode node = PostmanEnvironmentConverter.buildEnvironmentNode$default(this, name, privateHttpEnvFile, items, null, 8, null);
        String string = PostmanMapperKt.getPostmanMapper().writeValueAsString((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return new HttpEnvResult(privateHttpEnvFile, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ObjectNode buildEnvironmentNode(String name, VirtualFile existingFile, List<HttpEnvItem> items, Map<String, ? extends List<HttpEnvItem>> securityItems) {
        Sequence sequence2;
        Set set2;
        Object existingEnvFromHttpFile;
        Object object;
        Object it;
        Object object2;
        VirtualFile it2;
        ObjectNode envNode = PostmanMapperKt.getPostmanMapper().createObjectNode();
        VirtualFile virtualFile = existingFile;
        if (virtualFile != null) {
            it2 = virtualFile;
            boolean sequence2 = false;
            Path path = existingFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            object2 = path;
            Object object3 = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream((Path)object2, Arrays.copyOf(object3, ((OpenOption[])object3).length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            object2 = inputStream;
            object3 = null;
            try {
                it = (InputStream)object2;
                boolean bl = false;
                it = PostmanMapperKt.getPostmanMapper().readTree((InputStream)it);
                object = it;
            }
            catch (Throwable bl) {
                object3 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
        } else {
            object = null;
        }
        if ((existingEnvFromHttpFile = object) != null && (set2 = existingEnvFromHttpFile.properties()) != null && (it2 = CollectionsKt.asSequence((Iterable)set2)) != null && (sequence2 = SequencesKt.filterNot((Sequence)it2, arg_0 -> PostmanEnvironmentConverter.buildEnvironmentNode$lambda$1(name, arg_0))) != null) {
            Iterator $this$forEach$iv;
            object2 = sequence2;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv.iterator();
            while (it.hasNext()) {
                Object element$iv = it.next();
                Map.Entry it3 = (Map.Entry)element$iv;
                boolean bl = false;
                envNode.set((String)it3.getKey(), (JsonNode)it3.getValue());
            }
        }
        ObjectNode envValuesNode = envNode.putObject(name);
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpEnvItem envItem = (HttpEnvItem)element$iv;
            boolean bl = false;
            envValuesNode.put(envItem.getKey(), envItem.getValue());
        }
        if (!securityItems.isEmpty()) {
            ObjectNode securityNode = envValuesNode.putObject("Security").putObject("Auth");
            Map<String, ? extends List<HttpEnvItem>> $this$forEach$iv2 = securityItems;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, ? extends List<HttpEnvItem>>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends List<HttpEnvItem>> element$iv;
                Map.Entry<String, ? extends List<HttpEnvItem>> entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = entry.getKey();
                List<HttpEnvItem> envItems = entry.getValue();
                ObjectNode node = securityNode.putObject(name2);
                Iterable $this$forEach$iv3 = envItems;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    HttpEnvItem envItem = (HttpEnvItem)element$iv2;
                    boolean bl2 = false;
                    node.put(envItem.getKey(), envItem.getValue());
                }
            }
        }
        Intrinsics.checkNotNull((Object)envNode);
        return envNode;
    }

    static /* synthetic */ ObjectNode buildEnvironmentNode$default(PostmanEnvironmentConverter postmanEnvironmentConverter, String string, VirtualFile virtualFile, List list2, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return postmanEnvironmentConverter.buildEnvironmentNode(string, virtualFile, list2, map2);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpEnvResult getPublicEnv(String name, VirtualFile httpEnvFile, PostmanEnvironment postmanEnv, HttpPostmanCollectionEnv additionalEnv) {
        Map notEmptySecurityItems;
        List it;
        List publicAdditionalEnv;
        List list2;
        Object object;
        HttpEnvItem it2;
        Collection destination$iv$iv;
        List<PostmanEnvItem> list3;
        List allEnvItems = new ArrayList();
        if (postmanEnv != null && (list3 = postmanEnv.getValues()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            boolean $i$f$map = false;
            void var10_12 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PostmanEnvItem postmanEnvItem = (PostmanEnvItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HttpEnvItem(((PostmanEnvItem)((Object)it2)).getKey(), ((PostmanEnvItem)((Object)it2)).getValue(), false, 4, null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            allEnvItems.addAll(it3);
        }
        if ((object = additionalEnv) != null && (object = ((HttpPostmanCollectionEnv)object).getEnvItems()) != null) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = (Iterable)object;
            boolean $i$f$filterNot = false;
            Iterable bl = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it2 = (HttpEnvItem)element$iv$iv;
                boolean bl2 = false;
                if (it2.isSecure()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List list4 = publicAdditionalEnv = list2;
        if (list4 != null) {
            it = list4;
            boolean bl = false;
            CollectionsKt.addAll((Collection)allEnvItems, (Iterable)publicAdditionalEnv);
        }
        if (additionalEnv != null && (it = additionalEnv.getAuthItems()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Iterable $this$filterNotTo$iv$iv = it;
            boolean $i$f$associate22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterator iterator = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void $this$filterNotTo$iv$iv2;
                void $this$filterNot$iv;
                Map map2 = destination$iv$iv2;
                HttpAuthEnv authItem = (HttpAuthEnv)element$iv$iv;
                boolean bl = false;
                Iterable iterable = authItem.getItems();
                String string = authItem.getName();
                boolean $i$f$filterNot = false;
                void var24_35 = $this$filterNot$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv2 : $this$filterNotTo$iv$iv2) {
                    HttpEnvItem it4 = (HttpEnvItem)element$iv$iv2;
                    boolean bl3 = false;
                    if (it4.isSecure()) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                authItem = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv3));
                map2.put(authItem.getFirst(), authItem.getSecond());
            }
            Map $i$f$associate22 = destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$associateTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it5 = element$iv$iv = (Map.Entry)iterator2.next();
                boolean bl = false;
                boolean bl4 = !((Collection)it5.getValue()).isEmpty();
                if (!bl4) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            v4 = destination$iv$iv2;
        } else {
            v4 = notEmptySecurityItems = MapsKt.emptyMap();
        }
        if (allEnvItems.isEmpty() && notEmptySecurityItems.isEmpty()) {
            return null;
        }
        ObjectNode node = this.buildEnvironmentNode(name, httpEnvFile, allEnvItems, notEmptySecurityItems);
        String string = PostmanMapperKt.getPostmanMapper().writeValueAsString((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return new HttpEnvResult(httpEnvFile, string);
    }

    private static final boolean buildEnvironmentNode$lambda$1(String $name, Map.Entry it) {
        return Intrinsics.areEqual(it.getKey(), (Object)$name);
    }
}

