/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.base.introspector.BaseAffectedObjectAnalyzer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectedObjectAnalyzer;", "Lcom/intellij/database/dialects/base/introspector/BaseAffectedObjectAnalyzer;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/openapi/diagnostic/Logger;)V", "schemaMinor", "", "Lcom/intellij/database/model/ObjectKind;", "getSchemaMinor", "()Ljava/util/Set;", "serverAuxiliaryDetailKinds", "getServerAuxiliaryDetailKinds", "intellij.database.dialects.oracle"})
public final class OraAffectedObjectAnalyzer
extends BaseAffectedObjectAnalyzer {
    @NotNull
    private final Set<ObjectKind> schemaMinor;
    @NotNull
    private final Set<ObjectKind> serverAuxiliaryDetailKinds;

    public OraAffectedObjectAnalyzer(@NotNull BasicModel model, @Nullable Logger log) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model, log);
        Object[] objectArray = new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER};
        this.schemaMinor = SetsKt.setOf((Object[])objectArray);
        this.serverAuxiliaryDetailKinds = SetsKt.setOf((Object)ObjectKind.DATA_FILE);
    }

    public /* synthetic */ OraAffectedObjectAnalyzer(BasicModel basicModel, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = null;
        }
        this(basicModel, logger);
    }

    @NotNull
    protected Set<ObjectKind> getSchemaMinor() {
        return this.schemaMinor;
    }

    @NotNull
    protected Set<ObjectKind> getServerAuxiliaryDetailKinds() {
        return this.serverAuxiliaryDetailKinds;
    }
}

