/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DataSourceInfo {
    @NotNull
    private NameVersion databaseVersion = NameVersion.UNKNOWN;
    @NotNull
    private NameVersion driverVersion = NameVersion.UNKNOWN;
    @NotNull
    private String jdbcVersion = DasUtil.NO_NAME;
    @Nullable
    private String identifierQuoteString;
    @Nullable
    private String extraNameCharacters;
    @NotNull
    private Casing casing = DasUtil.CASING_MIXED;
    @Nullable
    private Dbms dbms;
    @NotNull
    private Version exactVersion = Version.ZERO;
    private Version exactDriverVersion;
    private boolean jdbcCatalogIsSchema;

    @TestOnly
    public void setDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(0);
        }
        this.dbms = dbms;
    }

    public void setDatabaseVersion(@NotNull Version version) {
        if (version == null) {
            DataSourceInfo.$$$reportNull$$$0(1);
        }
        if (this.databaseVersion != NameVersion.UNKNOWN) {
            this.databaseVersion = new NameVersion(this.databaseVersion.name, null);
        }
        this.exactVersion = version;
    }

    public void copyFrom(@NotNull DataSourceInfo info) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(2);
        }
        this.databaseVersion = info.databaseVersion;
        this.driverVersion = info.driverVersion;
        this.jdbcVersion = info.jdbcVersion;
        this.identifierQuoteString = info.identifierQuoteString;
        this.extraNameCharacters = info.extraNameCharacters;
        this.casing = info.casing;
        this.dbms = info.dbms;
        this.exactVersion = info.exactVersion;
        this.exactDriverVersion = info.exactDriverVersion;
        this.jdbcCatalogIsSchema = info.jdbcCatalogIsSchema;
    }

    public DataSourceInfo copy() {
        DataSourceInfo res = new DataSourceInfo();
        res.copyFrom(this);
        return res;
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = this.databaseVersion;
        if (nameVersion == null) {
            DataSourceInfo.$$$reportNull$$$0(3);
        }
        return nameVersion;
    }

    @NotNull
    public NameVersion getDriverVersion() {
        NameVersion nameVersion = this.driverVersion;
        if (nameVersion == null) {
            DataSourceInfo.$$$reportNull$$$0(4);
        }
        return nameVersion;
    }

    @NotNull
    public String getJdbcVersion() {
        String string = this.jdbcVersion;
        if (string == null) {
            DataSourceInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Nullable
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @NotNull
    public Casing getCasing() {
        Casing casing = this.casing;
        if (casing == null) {
            DataSourceInfo.$$$reportNull$$$0(6);
        }
        return casing;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.dbms == null ? Dbms.UNKNOWN : this.dbms;
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(7);
        }
        return dbms;
    }

    @NotNull
    public Version getExactVersion() {
        Version version = this.exactVersion;
        if (version == null) {
            DataSourceInfo.$$$reportNull$$$0(8);
        }
        return version;
    }

    public Version getExactDriverVersion() {
        return this.exactDriverVersion;
    }

    public boolean isJdbcCatalogIsSchema() {
        return this.jdbcCatalogIsSchema;
    }

    public static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource, @Nullable DatabaseConnectionCore connection) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            return;
        }
        DataSourceInfo.resetDatabaseInfo(dataSource.getInfo(), connection);
    }

    private static void resetDatabaseInfo(@NotNull DataSourceInfo info, @NotNull DatabaseConnectionCore connection) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(10);
        }
        if (connection == null) {
            DataSourceInfo.$$$reportNull$$$0(11);
        }
        RemoteDatabaseMetaData metaData = (RemoteDatabaseMetaData)JdbcNativeUtil.computeSafe(connection::getRemoteMetaData);
        info.dbms = connection.getDbms();
        info.exactVersion = connection.getVersion();
        info.exactDriverVersion = connection.getDriverVersion();
        if (metaData == null) {
            info.copyFrom(new DataSourceInfo());
            return;
        }
        info.databaseVersion = new NameVersion((String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDatabaseProductName()), (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDatabaseProductVersion()));
        info.driverVersion = new NameVersion((String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDriverName()), (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDriverVersion()));
        try {
            info.jdbcVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                info.jdbcVersion = "2.1";
            }
            catch (Throwable e1) {
                info.jdbcVersion = "1.2";
            }
        }
        info.identifierQuoteString = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getIdentifierQuoteString());
        info.extraNameCharacters = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getExtraNameCharacters());
        info.jdbcCatalogIsSchema = (Boolean)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getJdbcCatalogIsSchema());
        if (StringUtil.isEmptyOrSpaces((String)info.identifierQuoteString)) {
            info.identifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)info.extraNameCharacters)) {
            info.extraNameCharacters = null;
        }
        try {
            info.casing = DataSourceInfo.getCasing(info.dbms, metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static DetectedDbms getDetected(@NotNull RemoteConnection connection) {
        if (connection == null) {
            DataSourceInfo.$$$reportNull$$$0(12);
        }
        String dbms = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection).getDetectedDbmsName());
        String ver = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection).getDetectedDbmsVersion());
        String driverVersion = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection).getDriverVersion());
        return new DetectedDbms(Dbms.fromString((String)dbms), (Version)ObjectUtils.notNull((Object)Version.parse((String)ver), (Object)Version.ZERO), (Version)ObjectUtils.notNull((Object)Version.parse((String)driverVersion), (Object)Version.ZERO));
    }

    public static void initDbmsFromJdbcIfNeeded(@NotNull LocalDataSource dataSource, @NotNull DataSourceInfo info) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(13);
        }
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(14);
        }
        if (info.dbms != null) {
            return;
        }
        info.dbms = Dbms.UNKNOWN;
        DataSourceInfo.initDbmsFromJdbc(dataSource, info);
    }

    private static void initDbmsFromJdbc(@NotNull LocalDataSource dataSource, @NotNull DataSourceInfo info) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(15);
        }
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(16);
        }
        info.dbms = DataSourceInfo.forDataSource((DasDataSource)dataSource);
        JdbcHelper helper = DbImplUtilCore.getJdbcHelper(info.dbms);
        Version v = Version.parse((String)helper.parseVersion(info.databaseVersion.version));
        info.exactVersion = v == null ? Version.ZERO : v;
        info.exactDriverVersion = Version.ZERO;
    }

    @TestOnly
    public static void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(17);
        }
        dataSource.getInfo().copyFrom(new DataSourceInfo());
    }

    @NotNull
    public static Dbms forDataSource(@NotNull DasDataSource o) {
        DasModel model;
        Dbms result;
        if (o == null) {
            DataSourceInfo.$$$reportNull$$$0(18);
        }
        if ((result = DataSourceInfo.fromJdbcData(o)) == Dbms.UNKNOWN) {
            DatabaseDriver driver;
            DatabaseDriver databaseDriver = driver = o instanceof DatabaseConnectionPoint ? ((DatabaseConnectionPoint)o).getDatabaseDriver() : null;
            if (driver != null) {
                result = DbImplUtilCore.getDbms(driver);
            }
        }
        if (result == Dbms.UNKNOWN && o instanceof RawConnectionConfig) {
            result = Dbms.forConnection((RawConnectionConfig)((RawConnectionConfig)o));
        }
        if (result == Dbms.UNKNOWN && (model = o.getModel()) instanceof BasicModel) {
            result = ((BasicModel)model).getDbms();
        }
        Dbms dbms = result;
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(19);
        }
        return dbms;
    }

    private static Dbms fromJdbcData(@NotNull DasDataSource o) {
        if (o == null) {
            DataSourceInfo.$$$reportNull$$$0(20);
        }
        NameVersion p = o.getDatabaseVersion();
        Dbms result = Dbms.fromString((String)p.version);
        if (result == Dbms.UNKNOWN) {
            result = Dbms.fromString((String)p.name);
        }
        if (result == Dbms.POSTGRES) {
            String driverId;
            DatabaseDriver driver = o instanceof DatabaseConnectionPoint ? ((DatabaseConnectionPoint)o).getDatabaseDriver() : null;
            String string = driverId = driver == null ? null : driver.getId();
            if (driverId != null && StringUtil.containsIgnoreCase((String)driverId, (String)Dbms.GREENPLUM.getName())) {
                result = Dbms.GREENPLUM;
            } else {
                com.intellij.openapi.util.Version version;
                com.intellij.openapi.util.Version version2 = version = p.version != null && p.version.contains("8") ? com.intellij.openapi.util.Version.parseVersion((String)p.version) : null;
                if (version != null && version.major == 8 && version.bugfix == 2) {
                    result = Dbms.REDSHIFT;
                }
            }
        }
        return result;
    }

    @NotNull
    public static Casing getCasing(@NotNull Dbms dbms, @NotNull RemoteDatabaseMetaData metaData) {
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(21);
        }
        if (metaData == null) {
            DataSourceInfo.$$$reportNull$$$0(22);
        }
        boolean supportsMixedCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).supportsMixedCaseIdentifiers());
        boolean storesUpperCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesUpperCaseIdentifiers());
        boolean storesLowerCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesLowerCaseIdentifiers());
        boolean storesMixedCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesMixedCaseIdentifiers());
        boolean supportsMixedCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).supportsMixedCaseQuotedIdentifiers());
        boolean storesUpperCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesUpperCaseQuotedIdentifiers());
        boolean storesLowerCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesLowerCaseQuotedIdentifiers());
        boolean storesMixedCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesMixedCaseQuotedIdentifiers());
        Case plain = DataSourceInfo.getCaseMode(dbms, supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
        Case quoted = DataSourceInfo.getCaseMode(dbms, supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
        Casing casing = Casing.create((Case)plain, (Case)quoted);
        if (casing == null) {
            DataSourceInfo.$$$reportNull$$$0(23);
        }
        return casing;
    }

    @NotNull
    public static Case getCaseMode(@NotNull Dbms dbms, boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        JdbcHelper helper;
        JdbcHelper.Case mode;
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(24);
        }
        Case case_ = (mode = (helper = DbImplUtilCore.getJdbcHelper(dbms)).getCaseMode(sensitive, forceLower, forceUpper, asIs)) == JdbcHelper.Case.EXACT ? Case.EXACT : (mode == JdbcHelper.Case.LOWER ? Case.LOWER : (mode == JdbcHelper.Case.UPPER ? Case.UPPER : Case.MIXED));
        if (case_ == null) {
            DataSourceInfo.$$$reportNull$$$0(25);
        }
        return case_;
    }

    public void serializeDatabaseInfo(HierarchicalStreamWriter serializer) {
        serializer.startNode("database-info");
        serializer.addAttribute("product", this.databaseVersion.name);
        serializer.addAttribute("version", this.databaseVersion.version);
        serializer.addAttribute("jdbc-version", StringUtil.notNullize((String)this.jdbcVersion));
        serializer.addAttribute("driver-name", this.driverVersion.name);
        serializer.addAttribute("driver-version", this.driverVersion.version);
        if (this.dbms != null) {
            serializer.addAttribute("dbms", this.dbms.getName());
        }
        if (this.exactVersion != Version.ZERO) {
            serializer.addAttribute("exact-version", this.exactVersion.toString(1, Integer.MAX_VALUE));
        }
        if (this.exactDriverVersion != null && this.exactDriverVersion != Version.ZERO) {
            serializer.addAttribute("exact-driver-version", this.exactDriverVersion.toString(1, Integer.MAX_VALUE));
        }
        if (this.extraNameCharacters != null) {
            LocalDataSourceSerialization.writeTag(serializer, "extra-name-characters", this.extraNameCharacters);
        }
        if (this.identifierQuoteString != null) {
            LocalDataSourceSerialization.writeTag(serializer, "identifier-quote-string", this.identifierQuoteString);
        }
        if (this.jdbcCatalogIsSchema) {
            LocalDataSourceSerialization.writeTag(serializer, "jdbc-catalog-is-schema", Boolean.toString(this.jdbcCatalogIsSchema));
        }
        serializer.endNode();
        if (this.casing.plain != DasUtil.CASING_MIXED.plain || this.casing.quoted != DasUtil.CASING_MIXED.quoted) {
            serializer.startNode("case-sensitivity");
            serializer.addAttribute("plain-identifiers", StringUtil.toLowerCase((String)this.casing.plain.name()));
            serializer.addAttribute("quoted-identifiers", StringUtil.toLowerCase((String)this.casing.quoted.name()));
            serializer.endNode();
        }
    }

    public boolean deserializeDatabaseInfo(@NotNull HierarchicalStreamReader reader) {
        String nodeName;
        if (reader == null) {
            DataSourceInfo.$$$reportNull$$$0(26);
        }
        if ((nodeName = reader.getNodeName()).equals("database-info")) {
            this.deserializeDatabaseInfo(reader, false);
        } else if (nodeName.equals("case-sensitivity")) {
            Case plain = Case.fromString((String)reader.getAttribute("plain-identifiers"), (Case)DasUtil.CASING_MIXED.plain);
            Case quoted = Case.fromString((String)reader.getAttribute("quoted-identifiers"), (Case)DasUtil.CASING_MIXED.quoted);
            this.casing = Casing.create((Case)plain, (Case)quoted);
        } else if (nodeName.equals("extra-name-characters")) {
            this.extraNameCharacters = reader.getValue();
        } else if (nodeName.equals("identifier-quote-string")) {
            this.identifierQuoteString = reader.getValue();
        } else if (nodeName.equals("jdbc-catalog-is-schema")) {
            this.jdbcCatalogIsSchema = "true".equals(reader.getValue());
        } else {
            return false;
        }
        return true;
    }

    public void deserializeDatabaseInfo(@NotNull HierarchicalStreamReader xmlReader, boolean skipChildren) {
        if (xmlReader == null) {
            DataSourceInfo.$$$reportNull$$$0(27);
        }
        this.databaseVersion = new NameVersion(xmlReader.getAttribute("product"), xmlReader.getAttribute("version"));
        this.jdbcVersion = xmlReader.getAttribute("jdbc-version");
        this.driverVersion = new NameVersion(xmlReader.getAttribute("driver-name"), xmlReader.getAttribute("driver-version"));
        String family = (String)ObjectUtils.coalesce((Object)xmlReader.getAttribute("dbms"), (Object)xmlReader.getAttribute("family"));
        this.dbms = family == null ? null : Dbms.byName((String)family);
        String version = xmlReader.getAttribute("exact-version");
        try {
            this.exactVersion = Objects.requireNonNullElse(version == null ? null : Version.parse((String)version), Version.ZERO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String driverVersion = xmlReader.getAttribute("exact-driver-version");
        try {
            this.exactDriverVersion = driverVersion == null ? null : Version.parse((String)driverVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (skipChildren) {
            return;
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (nodeName.equals("extra-name-characters")) {
                this.extraNameCharacters = xmlReader.getValue();
            } else if (nodeName.equals("identifier-quote-string")) {
                this.identifierQuoteString = xmlReader.getValue();
            }
            xmlReader.moveUp();
        }
        if (this.dbms != null && this.exactVersion == Version.ZERO && this.databaseVersion == NameVersion.UNKNOWN && this.driverVersion == NameVersion.UNKNOWN) {
            this.dbms = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 19, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcVersion";
                break;
            }
            case 6: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactVersion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataSource";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDbms";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDatabaseVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 23: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshDatabaseInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetDatabaseInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDetected";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initDbmsFromJdbcIfNeeded";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initDbmsFromJdbc";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "forDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fromJdbcData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCaseMode";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deserializeDatabaseInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 19, 23, 25 -> new IllegalStateException(string);
        };
    }

    public static final class DetectedDbms {
        public final Dbms dbms;
        public final Version version;
        public final Version driverVersion;

        private DetectedDbms(@NotNull Dbms dbms, @NotNull Version version, @NotNull Version driverVersion) {
            if (dbms == null) {
                DetectedDbms.$$$reportNull$$$0(0);
            }
            if (version == null) {
                DetectedDbms.$$$reportNull$$$0(1);
            }
            if (driverVersion == null) {
                DetectedDbms.$$$reportNull$$$0(2);
            }
            this.dbms = dbms;
            this.version = version;
            this.driverVersion = driverVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "driverVersion";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DataSourceInfo$DetectedDbms";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

