/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.JdbcUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNameColumnDescriptor
implements ColumnDescriptor,
SizeProvider {
    private final String myName;
    private final String myTypeName;
    private final int myPrecision;
    private final int myScale;

    public TypeNameColumnDescriptor(@NotNull String typeName) {
        if (typeName == null) {
            TypeNameColumnDescriptor.$$$reportNull$$$0(0);
        }
        this(null, typeName);
    }

    public TypeNameColumnDescriptor(@Nullable String name, @NotNull String typeName) {
        if (typeName == null) {
            TypeNameColumnDescriptor.$$$reportNull$$$0(1);
        }
        this(name, typeName, -1, -1);
    }

    public TypeNameColumnDescriptor(@Nullable String name, @NotNull String typeName, int precision, int scale) {
        if (typeName == null) {
            TypeNameColumnDescriptor.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myTypeName = typeName;
        this.myPrecision = precision;
        this.myScale = scale;
    }

    public int getScale() {
        return this.myScale;
    }

    public int getSize() {
        return this.myPrecision;
    }

    public int getType() {
        return JdbcUtil.guessJdbcTypeByName((String)this.myTypeName);
    }

    public String getName() {
        return this.myName;
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/util/TypeNameColumnDescriptor", "<init>"));
    }
}

