/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;

public class GaussProjection
extends Projection {
    private static final int MAX_ITER = 20;
    private static final double DEL_TOL = 1.0E-14;
    private double C;
    private double K;
    protected double rc;
    protected double phic0;
    private double ratexp;

    @Override
    public ProjCoordinate project(double x, double y, ProjCoordinate out) {
        out.y = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * y + 0.7853981633974483), this.C) * GaussProjection.srat(this.e * Math.sin(y), this.ratexp)) - 1.5707963267948966;
        out.x = this.C * x;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate out) {
        int i2;
        double lon = x / this.C;
        double lat = y;
        double num = Math.pow(Math.tan(0.5 * lat + 0.7853981633974483) / this.K, 1.0 / this.C);
        for (i2 = 20; i2 > 0 && !(Math.abs((lat = 2.0 * Math.atan(num * GaussProjection.srat(this.e * Math.sin(y), -0.5 * this.e)) - 1.5707963267948966) - y) < 1.0E-14); --i2) {
            y = lat;
        }
        if (i2 <= 0) {
            throw new ProjectionException(this, ProjectionException.ERR_17);
        }
        out.x = lon;
        out.y = lat;
        return out;
    }

    @Override
    public void initialize() {
        super.initialize();
        double sphi = Math.sin(this.projectionLatitude);
        double cphi = Math.cos(this.projectionLatitude);
        cphi *= cphi;
        this.rc = Math.sqrt(1.0 - this.es) / (1.0 - this.es * sphi * sphi);
        this.C = Math.sqrt(1.0 + this.es * cphi * cphi / (1.0 - this.es));
        this.phic0 = Math.asin(sphi / this.C);
        this.ratexp = 0.5 * this.C * this.e;
        this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.projectionLatitude + 0.7853981633974483), this.C) * GaussProjection.srat(this.e * sphi, this.ratexp));
    }

    private static double srat(double esinp, double exp) {
        return Math.pow((1.0 - esinp) / (1.0 + esinp), exp);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Gauss";
    }
}

