/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.parameterInfo;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpDisabled;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.parameterInfo.LspParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u001a\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/lsp/impl/parameterInfo/LspParameterInfoHandler;", "Lcom/intellij/lang/parameterInfo/ParameterInfoHandler;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/platform/lsp/impl/parameterInfo/LspParameterInfoContext;", "Lcom/intellij/openapi/project/DumbAware;", "LspParameterInfoHandler", "()V", "findElementForParameterInfo", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "findElementForUpdatingParameterInfo", "Lcom/intellij/lang/parameterInfo/UpdateParameterInfoContext;", "showParameterInfo", "", "element", "updateParameterInfo", "parameterOwner", "updateUI", "infoContext", "Lcom/intellij/lang/parameterInfo/ParameterInfoUIContext;", "P", "", "signature", "Lorg/eclipse/lsp4j/SignatureInformation;", "P", "", "signatureHelp", "Lorg/eclipse/lsp4j/SignatureHelp;", "offset", "file", "Lcom/intellij/psi/PsiFile;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspParameterInfoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspParameterInfoHandler.kt\ncom/intellij/platform/lsp/impl/parameterInfo/LspParameterInfoHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class LspParameterInfoHandler
implements ParameterInfoHandler<PsiElement, LspParameterInfoContext>,
DumbAware {
    @Nullable
    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Object[] objectArray;
        Object[] objectArray2;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (context.getFile().getProject().isDefault()) {
                    return null;
                }
                objectArray2 = context.getFile().getVirtualFile();
                if (objectArray2 == null) break block6;
                objectArray = objectArray2;
                boolean bl2 = false;
                VirtualFileWindow virtualFileWindow = objectArray instanceof VirtualFileWindow ? (VirtualFileWindow)objectArray : null;
                if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
                    virtualFileWindow = objectArray;
                }
                objectArray2 = virtualFileWindow;
                if (virtualFileWindow != null) break block7;
            }
            return null;
        }
        Object[] objectArray3 = objectArray2;
        Project project = context.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (LspServerImpl lspServerImpl : LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl((VirtualFile)objectArray3)) {
            SignatureHelp signatureHelp;
            if (lspServerImpl.getDescriptor().getLspCustomization().getSignatureHelpCustomizer() instanceof LspSignatureHelpDisabled || !lspServerImpl.supportsSignatureHelp$intellij_platform_lsp_impl((VirtualFile)objectArray3) || lspServerImpl.getRequestExecutor().getSignatureHelp((VirtualFile)objectArray3, context.getOffset()) == null) continue;
            List list = signatureHelp.getSignatures();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSignatures(...)");
            if (!(!((Collection)list).isEmpty())) continue;
            objectArray = new Object[]{new LspParameterInfoContext(signatureHelp, lspServerImpl)};
            context.setItemsToShow(objectArray);
            return (PsiElement)context.getFile();
        }
        return null;
    }

    @Nullable
    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = context.getObjectsToView();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getObjectsToView(...)");
        return !(objectArray.length == 0) ? (PsiElement)context.getFile() : null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.showHint(element, context.getOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        VirtualFile virtualFile;
        LspParameterInfoContext lspParameterInfoContext;
        Object object;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)parameterOwner, (String)"parameterOwner");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!Intrinsics.areEqual((Object)context.getParameterOwner(), (Object)parameterOwner)) {
                    context.removeHint();
                    return;
                }
                Object[] objectArray = context.getObjectsToView();
                object = objectArray != null ? ArraysKt.firstOrNull((Object[])objectArray) : null;
                LspParameterInfoContext lspParameterInfoContext2 = object instanceof LspParameterInfoContext ? (LspParameterInfoContext)object : null;
                if (lspParameterInfoContext2 == null) {
                    return;
                }
                lspParameterInfoContext = lspParameterInfoContext2;
                virtualFile = context.getFile().getVirtualFile();
                if (virtualFile == null) break block7;
                VirtualFile virtualFile2 = virtualFile;
                boolean bl2 = false;
                VirtualFileWindow virtualFileWindow = virtualFile2 instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile2 : null;
                if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
                    virtualFileWindow = virtualFile2;
                }
                virtualFile = virtualFileWindow;
                if (virtualFileWindow != null) break block8;
            }
            return;
        }
        VirtualFile virtualFile3 = virtualFile;
        object = lspParameterInfoContext.getServer().getRequestExecutor().getSignatureHelp(virtualFile3, context.getOffset());
        if (object == null || object.getSignatures().isEmpty()) {
            context.removeHint();
            return;
        }
        int n2 = context.getOffset();
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        int n3 = this.P((SignatureHelp)object, n2, psiFile);
        context.setCurrentParameter(n3);
    }

    public void updateUI(@Nullable LspParameterInfoContext infoContext, @NotNull ParameterInfoUIContext context) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (infoContext == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        SignatureHelp signatureHelp = infoContext.getSignatureHelp();
        Integer n3 = signatureHelp.getActiveSignature();
        int n4 = n2 = n3 != null ? n3 : 0;
        if (n2 >= signatureHelp.getSignatures().size()) {
            context.setUIComponentEnabled(false);
            return;
        }
        SignatureInformation signatureInformation = (SignatureInformation)signatureHelp.getSignatures().get(n2);
        int n5 = context.getCurrentParameterIndex();
        String string = signatureInformation.getLabel();
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() == 0) {
            context.setUIComponentEnabled(false);
            return;
        }
        Intrinsics.checkNotNull((Object)signatureInformation);
        int[] nArray = this.P(signatureInformation);
        boolean bl2 = nArray.length >= 2 && n5 >= 0 && n5 * 2 + 1 < nArray.length;
        int n6 = bl2 ? nArray[n5 * 2] : -1;
        int n7 = bl2 ? nArray[n5 * 2 + 1] : -1;
        context.setupUIComponentPresentation(string, n6, n7, false, false, false, context.getDefaultParameterColor());
    }

    private final int[] P(SignatureInformation signatureInformation) {
        List list = signatureInformation.getParameters();
        if (list == null) {
            return new int[0];
        }
        List list2 = list;
        List list3 = new ArrayList();
        for (ParameterInformation parameterInformation : list2) {
            String string;
            Either either = parameterInformation.getLabel();
            if (either.isLeft()) {
                string = (String)either.getLeft();
                String string2 = signatureInformation.getLabel();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabel(...)");
                CharSequence charSequence = string2;
                Intrinsics.checkNotNull((Object)string);
                int n2 = StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null);
                if (n2 < 0) continue;
                list3.add(n2);
                list3.add(n2 + string.length());
                continue;
            }
            if (!either.isRight()) continue;
            string = (Tuple.Two)either.getRight();
            Object object = string.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
            list3.add(object);
            Object object2 = string.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSecond(...)");
            list3.add(object2);
        }
        return CollectionsKt.toIntArray((Collection)list3);
    }

    private final int P(SignatureHelp signatureHelp, int n2, PsiFile psiFile) {
        Integer n3 = signatureHelp.getActiveParameter();
        return n3 != null ? n3 : 0;
    }
}

