/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.extensions.PersistenceFacetProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacetType;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistenceCommonUtil {
    private static final SimpleModificationTracker dropCacheModificationTracker = new SimpleModificationTracker();

    private PersistenceCommonUtil() {
    }

    public static SimpleModificationTracker getDropCacheModificationTracker() {
        return dropCacheModificationTracker;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(0);
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArrayList<PersistenceFacet> result = new ArrayList<PersistenceFacet>();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                result.addAll(PersistenceCommonUtil.getAllPersistenceFacets(module));
            }
            return CachedValueProvider.Result.create(result, (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies(project));
        });
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static Object[] getPersistenceModificationTrackerDependencies(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(2);
        }
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
        dependencies.add(JavaLibraryModificationTracker.getInstance((Project)project));
        dependencies.add(DumbService.getInstance((Project)project).getModificationTracker());
        dependencies.addAll(Arrays.asList(PersistenceCommonUtil.getFacetCacheDependencies(project)));
        dependencies.add(PersistenceCommonUtil.getDropCacheModificationTracker());
        return ArrayUtil.toObjectArray(dependencies);
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Module module) {
        if (module == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<PersistenceFacet> facets = new LinkedHashSet<PersistenceFacet>();
        for (PersistenceFacetProvider facetProvider : PersistenceFacetProvider.EP_NAME.getExtensionList()) {
            PersistenceFacet configuration = facetProvider.getFacet(module);
            if (configuration == null) continue;
            facets.add(configuration);
        }
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet instanceof PersistenceFacet)) continue;
            facets.add((PersistenceFacet)facet);
        }
        List<PersistenceFacet> list = List.copyOf(facets);
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacetsWithDependencies(@NotNull Module module) {
        if (module == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(5);
        }
        if (module.isDisposed()) {
            List<PersistenceFacet> list = Collections.emptyList();
            if (list == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<PersistenceFacet> facets = new HashSet<PersistenceFacet>();
            for (Module dependentModule : JamCommonUtil.getAllDependentModules((Module)module)) {
                facets.addAll(PersistenceCommonUtil.getAllPersistenceFacets(dependentModule));
            }
            for (Module dependencyModule : JamCommonUtil.getAllModuleDependencies((Module)module)) {
                facets.addAll(PersistenceCommonUtil.getAllPersistenceFacets(dependencyModule));
            }
            return new CachedValueProvider.Result(List.copyOf(facets), PersistenceCommonUtil.getFacetCacheDependencies(module.getProject()));
        });
        if (list == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static Object[] getFacetCacheDependencies(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(8);
        }
        HashSet<ModificationTracker> dependencies = new HashSet<ModificationTracker>();
        dependencies.add(JavaLibraryModificationTracker.getInstance((Project)project));
        FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
        for (FacetType facetType : FacetType.EP_NAME.getExtensionList()) {
            if (!(facetType instanceof PersistenceFacetType)) continue;
            dependencies.add(facetFinder.getAllFacetsOfTypeModificationTracker(facetType.getId()));
        }
        return dependencies.toArray();
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable PsiElement sourceElement) {
        PsiClass sourceClass;
        Set unitSet = sourceElement == null || (sourceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiClass.class, (boolean)false)) == null ? null : (Set)PersistenceCommonUtil.getAllPersistenceUnits(sourceClass, new HashSet());
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable DomElement sourceDom) {
        DomElement rootElement;
        HashSet<PersistencePackage> unitSet = sourceDom == null || !((rootElement = DomUtil.getFileElement((DomElement)sourceDom).getRootElement()) instanceof PersistenceMappings) ? null : new HashSet<PersistencePackage>(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)rootElement));
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createUnitsAndTypeMapper(@Nullable Set<PersistencePackage> unitSet) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter((Condition<? super PersistenceClassRole>)((Condition)role -> {
            PersistentObject object = role.getPersistentObject();
            PersistenceClassRoleEnum roleType = role.getType();
            return roleType != PersistenceClassRoleEnum.ENTITY_LISTENER && object != null && (unitSet == null || unitSet.contains(role.getPersistenceUnit()));
        }));
    }

    public static PersistenceModelBrowser createFacetAndUnitModelBrowser(PersistenceFacet facet, PersistencePackage unit, @Nullable PersistenceClassRoleEnum type) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter((Condition<? super PersistenceClassRole>)((Condition)role -> {
            PersistentObject object = role.getPersistentObject();
            return object != null && (type == null || role.getType() == type);
        }));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiMember psiMember) {
        return PersistenceCommonUtil.getTargetEntityType(PropertyUtilBase.getPropertyType((PsiMember)psiMember));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiType type) {
        return PersistenceCommonUtil.getTypeInfo(type).getValueType();
    }

    public static <T extends Collection<PersistencePackage>> T getAllPersistenceUnits(@Nullable PsiClass sourceClass, @NotNull T result) {
        if (result == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(9);
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(sourceClass)) {
            ContainerUtil.addIfNotNull(result, (Object)role.getPersistenceUnit());
        }
        return result;
    }

    @NotNull
    public static <V extends PersistenceMappings> Collection<V> getDomEntityMappings(Class<V> mappingsClass, PersistencePackage unit, PersistenceFacet facet) {
        HashSet<PersistenceMappings> result = new HashSet<PersistenceMappings>();
        for (PersistenceMappings persistenceMappings : facet.getDefaultEntityMappings(unit)) {
            if (!ReflectionUtil.isAssignable(mappingsClass, persistenceMappings.getClass())) continue;
            result.add((PersistenceMappings)mappingsClass.cast(persistenceMappings));
        }
        for (GenericValue genericValue : unit.getModelHelper().getMappingFiles(mappingsClass)) {
            ContainerUtil.addIfNotNull(result, (Object)((PersistenceMappings)genericValue.getValue()));
        }
        HashSet<PersistenceMappings> hashSet = result;
        if (hashSet == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public static boolean isSameTable(TableInfoProvider table1, TableInfoProvider table2) {
        if (table1 == null || table2 == null) {
            return false;
        }
        String name1 = (String)table1.getTableName().getValue();
        return StringUtil.isNotEmpty((String)name1) && Objects.equals(name1, table2.getTableName().getValue()) && Objects.equals(table1.getSchema().getValue(), table2.getSchema().getValue()) && Objects.equals(table1.getCatalog().getValue(), table2.getCatalog().getValue());
    }

    public static String getUniqueId(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement == null ? null : PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        return virtualFile == null ? "" : virtualFile.getUrl();
    }

    public static String getMultiplicityString(boolean optional, boolean many) {
        String first = optional ? "0" : "1";
        String last = many ? "*" : "1";
        return first.equals(last) ? first : first + ".." + last;
    }

    public static <T, V extends Collection<T>> V mapPersistenceRoles(V result, Project project, PersistenceFacet facet, PersistencePackage unit, Function<? super PersistenceClassRole, ? extends T> mapper) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(project)) {
            if (facet != null && facet != role.getFacet() || unit != null && unit != role.getPersistenceUnit()) continue;
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)role));
        }
        return result;
    }

    public static boolean haveCorrespondingMultiplicity(PersistentRelationshipAttribute a1, PersistentRelationshipAttribute a2) {
        return a1.getAttributeModelHelper().getRelationshipType().corresponds(a2.getAttributeModelHelper().getRelationshipType());
    }

    @NotNull
    public static JavaTypeInfo getTypeInfo(PsiType type) {
        return PersistenceCommonUtil.getTypeInfo(type, null);
    }

    @NotNull
    public static JavaTypeInfo getTypeInfo(PsiType type, @Nullable PsiClass convertClass) {
        PsiClass psiClass;
        if (type instanceof PsiArrayType) {
            return new JavaTypeInfo(JavaContainerType.ARRAY, type, convertClass, ((PsiArrayType)type).getComponentType());
        }
        PsiClassType.ClassResolveResult classResolveResult = type instanceof PsiClassType ? ((PsiClassType)type).resolveGenerics() : null;
        PsiClass psiClass2 = psiClass = classResolveResult == null ? null : classResolveResult.getElement();
        if (psiClass == null) {
            return new JavaTypeInfo(null, type, convertClass, new PsiType[0]);
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)manager.getProject());
        for (JavaContainerType collectionType : JavaContainerType.values()) {
            PsiClass aClass;
            if (collectionType == JavaContainerType.ARRAY || (aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(collectionType.getJavaBaseClassName(), scope)) == null || !manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)psiClass) && !psiClass.isInheritor(aClass, true)) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)psiClass, (PsiSubstitutor)classResolveResult.getSubstitutor());
            JavaTypeInfo result = new JavaTypeInfo(collectionType, type, convertClass, (PsiType[])ArrayUtil.reverseArray((Object[])((PsiType[])ContainerUtil.map2Array((Object[])aClass.getTypeParameters(), PsiType.class, psiTypeParameter -> superClassSubstitutor.substitute(psiTypeParameter)))));
            if (result.containerType == JavaContainerType.MAP && result.parameters.length != 2 || JavaContainerType.isCollection(result.containerType) && result.parameters.length != 1) {
                return new JavaTypeInfo(null, type, new PsiType[0]);
            }
            JavaTypeInfo javaTypeInfo = result;
            if (javaTypeInfo == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(11);
            }
            return javaTypeInfo;
        }
        return new JavaTypeInfo(null, type, convertClass, new PsiType[0]);
    }

    public static Query<PersistentObject> queryPersistentObjects(PersistenceMappings mappings) {
        return new ExecutorsQuery((Object)mappings, Collections.singletonList((queryParameters, consumer) -> {
            if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentEntities(), (Processor)consumer)) {
                return false;
            }
            if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentSuperclasses(), (Processor)consumer)) {
                return false;
            }
            return ContainerUtil.process(queryParameters.getModelHelper().getPersistentEmbeddables(), (Processor)consumer);
        }));
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentRelationshipAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEntityClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PersistenceCommonUtil.getTargetEntityType(attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentEmbeddedAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEmbeddableClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PropertyUtilBase.getPropertyType((PsiMember)attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiType getPrimaryKeyClass(@NotNull PersistentEntityBase persistentObject, PersistenceModelBrowser browser) {
        if (persistentObject == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(12);
        }
        ArrayList<PersistentAttribute> idAttrs = new ArrayList<PersistentAttribute>();
        for (PersistentObject object : browser.queryPersistentObjectHierarchy(persistentObject).asIterable()) {
            if (!(object instanceof PersistentEntityBase)) continue;
            PsiClass idClass = (PsiClass)((PersistentEntityBase)object).getIdClassValue().getValue();
            if (idClass != null) {
                return JavaPsiFacade.getElementFactory((Project)idClass.getProject()).createType(idClass);
            }
            for (PersistentAttribute persistentAttribute : object.getObjectModelHelper().getAttributes()) {
                if (!persistentAttribute.getAttributeModelHelper().isIdAttribute()) continue;
                idAttrs.add(persistentAttribute);
            }
        }
        return idAttrs.size() == 1 ? ((PersistentAttribute)idAttrs.get(0)).getPsiType() : null;
    }

    public static PersistenceClassRole @NotNull [] getPersistenceRoles(@Nullable PsiClass psiClass) {
        if (psiClass == null || PersistenceCommonUtil.isJdkClass(psiClass)) {
            if (PersistenceClassRole.EMPTY_ARRAY == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(13);
            }
            return PersistenceClassRole.EMPTY_ARRAY;
        }
        PersistenceClassRole[] persistenceClassRoleArray = (PersistenceClassRole[])CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)PersistenceCommonUtil.calculatePersistenceRoles(psiClass), (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies(psiClass.getProject())));
        if (persistenceClassRoleArray == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(14);
        }
        return persistenceClassRoleArray;
    }

    private static boolean isJdkClass(PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.");
    }

    public static PersistenceClassRole[] getPersistenceRoles(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(15);
        }
        return (PersistenceClassRole[])CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)PersistenceCommonUtil.calculatePersistenceRoles(project), (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies(project)));
    }

    private static PersistenceClassRole[] calculatePersistenceRoles(PsiClass psiClass) {
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            PersistenceRoleHolder.getInstance(psiClass.getProject()).processModuleRoles(module, psiClass, (Processor<? super PersistenceClassRole>)collectProcessor);
        } else {
            PersistenceRoleHolder.getInstance(psiClass.getProject()).processAllRoles(psiClass, (Processor<? super PersistenceClassRole>)collectProcessor);
        }
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }

    private static PersistenceClassRole[] calculatePersistenceRoles(@NotNull Project project) {
        if (project == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(16);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        PersistenceRoleHolder.getInstance(project).processAllRoles((Processor<? super PersistenceClassRole>)collectProcessor);
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }

    @NotNull
    public static Collection<? extends PsiMember> getAttributePsiMembers(PersistentAttribute attributeBase) {
        PsiCodeBlock body;
        String name = (String)attributeBase.getName().getValue();
        if (StringUtil.isEmpty((String)name)) {
            List list = Collections.emptyList();
            if (list == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        PsiMember member = attributeBase.getPsiMember();
        if (member == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PersistenceCommonUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false);
        PsiField field = psiClass.findFieldByName(name, true);
        if (member == getter && field == null && (field = PropertyUtilBase.findPropertyField((PsiClass)psiClass, (String)name, (boolean)false)) == null && (body = getter.getBody()) != null) {
            for (PsiStatement statement : body.getStatements()) {
                PsiReferenceExpression referenceExpression;
                PsiElement psiElement;
                PsiReturnStatement returnStatement;
                PsiExpression returnExpression;
                if (!(statement instanceof PsiReturnStatement) || !((returnExpression = (returnStatement = (PsiReturnStatement)statement).getReturnValue()) instanceof PsiReferenceExpression) || !((psiElement = (referenceExpression = (PsiReferenceExpression)returnExpression).resolve()) instanceof PsiField)) continue;
                field = (PsiField)psiElement;
            }
        }
        ArrayList result = new ArrayList(3);
        ContainerUtil.addIfNotNull(result, (Object)field);
        ContainerUtil.addIfNotNull(result, (Object)setter);
        ContainerUtil.addIfNotNull(result, (Object)getter);
        ArrayList arrayList = result;
        if (arrayList == null) {
            PersistenceCommonUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 10, 11, 13, 14, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/util/PersistenceCommonUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/util/PersistenceCommonUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistenceFacets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistenceFacetsWithDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomEntityMappings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceRoles";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributePsiMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceFacets";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceModificationTrackerDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceFacetsWithDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFacetCacheDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllPersistenceUnits";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrimaryKeyClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceRoles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculatePersistenceRoles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 10, 11, 13, 14, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

